/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-11-22 18:29:02 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=3736 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=9638 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=11872 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gla_attribute_mapping_rules` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attribute` varchar(255) NOT NULL,
  `source` varchar(100) NOT NULL,
  `category_condition_type` varchar(10) NOT NULL,
  `categories` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gla_budget_recommendations` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `currency` varchar(3) NOT NULL,
  `country` varchar(2) NOT NULL,
  `daily_budget` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_currency` (`country`,`currency`)
) ENGINE=InnoDB AUTO_INCREMENT=4231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gla_merchant_issues` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) NOT NULL,
  `issue` varchar(200) NOT NULL,
  `code` varchar(100) NOT NULL,
  `severity` varchar(20) NOT NULL DEFAULT 'warning',
  `product` varchar(100) NOT NULL,
  `action` text NOT NULL,
  `action_url` varchar(1024) NOT NULL,
  `applicable_countries` text NOT NULL,
  `source` varchar(10) NOT NULL DEFAULT 'mc',
  `type` varchar(10) NOT NULL DEFAULT 'product',
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gla_shipping_rates` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `country` varchar(2) NOT NULL,
  `currency` varchar(3) NOT NULL,
  `rate` double NOT NULL DEFAULT 0,
  `options` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `country` (`country`),
  KEY `currency` (`currency`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gla_shipping_times` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `country` varchar(2) NOT NULL,
  `time` bigint(20) NOT NULL DEFAULT 0,
  `max_time` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `country` (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_run_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int(11) unsigned NOT NULL,
  `step_id` varchar(191) NOT NULL,
  `step_type` varchar(255) NOT NULL,
  `step_key` varchar(255) NOT NULL,
  `status` varchar(191) NOT NULL,
  `started_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `run_number` int(11) NOT NULL,
  `data` longtext NOT NULL,
  `error` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `automation_run_id_step_id` (`automation_run_id`,`step_id`),
  KEY `status` (`status`),
  KEY `step_id` (`step_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_run_subjects` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int(11) unsigned NOT NULL,
  `key` varchar(191) DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `hash` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_run_id` (`automation_run_id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_runs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int(11) unsigned NOT NULL,
  `version_id` int(11) unsigned NOT NULL,
  `trigger_key` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `next_step_id` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`,`status`),
  KEY `created_at` (`created_at`),
  KEY `version_id` (`version_id`),
  KEY `status` (`status`),
  KEY `next_step_id` (`next_step_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_triggers` (
  `automation_id` int(11) unsigned NOT NULL,
  `trigger_key` varchar(191) NOT NULL,
  PRIMARY KEY (`automation_id`,`trigger_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_versions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int(11) unsigned NOT NULL,
  `steps` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `author` bigint(20) NOT NULL,
  `status` varchar(191) NOT NULL,
  `meta` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `activated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_custom_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `type` varchar(90) NOT NULL,
  `params` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_dynamic_segment_filters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `filter_data` longblob DEFAULT NULL,
  `filter_type` varchar(255) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_feature_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `value` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'enabled',
  `body` longtext DEFAULT NULL,
  `settings` longtext DEFAULT NULL,
  `styles` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `level` int(11) DEFAULT NULL,
  `message` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `raw_message` longtext DEFAULT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `started_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `completed_at` timestamp NULL DEFAULT NULL,
  `retries` int(11) unsigned NOT NULL DEFAULT 0,
  `error` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `url` varchar(2083) NOT NULL,
  `hash` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `url` (`url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_option` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `option_field_id` int(11) unsigned NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_option_field_id` (`newsletter_id`,`option_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_option_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `newsletter_type` varchar(90) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_newsletter_type` (`newsletter_type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_posts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `post_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_segment` (`newsletter_id`,`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_templates` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) DEFAULT 0,
  `name` varchar(250) NOT NULL,
  `categories` varchar(250) NOT NULL DEFAULT '[]',
  `description` varchar(255) NOT NULL DEFAULT '',
  `body` longtext DEFAULT NULL,
  `thumbnail` longtext DEFAULT NULL,
  `thumbnail_data` longtext DEFAULT NULL,
  `readonly` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(150) DEFAULT NULL,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `subject` varchar(250) NOT NULL DEFAULT '',
  `type` varchar(150) NOT NULL DEFAULT 'standard',
  `sender_address` varchar(150) NOT NULL DEFAULT '',
  `sender_name` varchar(150) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT 'draft',
  `reply_to_address` varchar(150) NOT NULL DEFAULT '',
  `reply_to_name` varchar(150) NOT NULL DEFAULT '',
  `preheader` varchar(250) NOT NULL DEFAULT '',
  `body` longtext DEFAULT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unsubscribe_token` char(15) DEFAULT NULL,
  `ga_campaign` varchar(250) NOT NULL DEFAULT '',
  `wp_post_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `type_status` (`type`,`status`),
  KEY `wp_post_id` (`wp_post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_scheduled_task_subscribers` (
  `task_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `processed` int(1) NOT NULL,
  `failed` smallint(1) NOT NULL DEFAULT 0,
  `error` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`task_id`,`subscriber_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_scheduled_tasks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(90) DEFAULT NULL,
  `status` varchar(12) DEFAULT NULL,
  `priority` mediumint(9) NOT NULL DEFAULT 0,
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `in_progress` int(1) DEFAULT NULL,
  `reschedule_count` int(11) NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  `cancelled_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_segments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `type` varchar(90) NOT NULL DEFAULT 'default',
  `description` varchar(250) NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `average_engagement_score` float unsigned DEFAULT NULL,
  `average_engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `display_in_manage_subscription_page` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `average_engagement_score_updated_at` (`average_engagement_score_updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_sending_queues` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(11) unsigned NOT NULL,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `newsletter_rendered_body` longtext DEFAULT NULL,
  `newsletter_rendered_subject` varchar(250) DEFAULT NULL,
  `subscribers` longtext DEFAULT NULL,
  `count_total` int(11) unsigned NOT NULL DEFAULT 0,
  `count_processed` int(11) unsigned NOT NULL DEFAULT 0,
  `count_to_process` int(11) unsigned NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_bounces` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_clicks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `link_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT 0,
  `count` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_subscriber` (`form_id`,`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `sent_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_opens` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `created_at` (`created_at`),
  KEY `subscriber_id_created_at` (`subscriber_id`,`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_unsubscribes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `source` varchar(255) DEFAULT 'unknown',
  `meta` varchar(255) DEFAULT NULL,
  `method` varchar(40) NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id` (`newsletter_id`,`subscriber_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_woocommerce_purchases` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `click_id` int(11) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `order_currency` char(3) NOT NULL,
  `order_price_total` float NOT NULL COMMENT 'With shipping and taxes in order_currency',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` varchar(40) NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  UNIQUE KEY `click_id_order_id` (`click_id`,`order_id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_stats_notifications` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `task_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_task_id` (`newsletter_id`,`task_id`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_custom_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `custom_field_id` int(11) unsigned NOT NULL,
  `value` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_id_custom_field_id` (`subscriber_id`,`custom_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_ips` (
  `ip` varchar(45) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`created_at`,`ip`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `status` varchar(12) NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_segment` (`subscriber_id`,`segment_id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_tag` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `tag_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_tag` (`subscriber_id`,`tag_id`),
  KEY `tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscribers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `wp_user_id` bigint(20) DEFAULT NULL,
  `is_woocommerce_user` int(1) NOT NULL DEFAULT 0,
  `first_name` varchar(255) NOT NULL DEFAULT '',
  `last_name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(150) NOT NULL,
  `status` varchar(12) NOT NULL DEFAULT 'unconfirmed',
  `subscribed_ip` varchar(45) DEFAULT NULL,
  `confirmed_ip` varchar(45) DEFAULT NULL,
  `confirmed_at` timestamp NULL DEFAULT NULL,
  `last_subscribed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unconfirmed_data` longtext DEFAULT NULL,
  `source` enum('form','imported','administrator','api','wordpress_user','woocommerce_user','woocommerce_checkout','unknown') DEFAULT 'unknown',
  `count_confirmations` int(11) unsigned NOT NULL DEFAULT 0,
  `unsubscribe_token` char(15) DEFAULT NULL,
  `link_token` char(32) DEFAULT NULL,
  `engagement_score` float unsigned DEFAULT NULL,
  `engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `last_engagement_at` timestamp NULL DEFAULT NULL,
  `woocommerce_synced_at` timestamp NULL DEFAULT NULL,
  `email_count` int(11) unsigned NOT NULL DEFAULT 0,
  `last_sending_at` timestamp NULL DEFAULT NULL,
  `last_open_at` timestamp NULL DEFAULT NULL,
  `last_click_at` timestamp NULL DEFAULT NULL,
  `last_purchase_at` timestamp NULL DEFAULT NULL,
  `last_page_view_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `wp_user_id` (`wp_user_id`),
  KEY `updated_at` (`updated_at`),
  KEY `status_deleted_at` (`status`,`deleted_at`),
  KEY `last_subscribed_at` (`last_subscribed_at`),
  KEY `engagement_score_updated_at` (`engagement_score_updated_at`),
  KEY `link_token` (`link_token`),
  KEY `first_name` (`first_name`(10)),
  KEY `last_name` (`last_name`(10)),
  KEY `last_sending_at` (`last_sending_at`),
  KEY `last_open_at` (`last_open_at`),
  KEY `last_click_at` (`last_click_at`),
  KEY `last_purchase_at` (`last_purchase_at`),
  KEY `last_page_view_at` (`last_page_view_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_tags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_user_agents` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) NOT NULL,
  `user_agent` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_user_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_name` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_nextend2_image_storage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) NOT NULL,
  `image` text NOT NULL,
  `value` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_nextend2_section_storage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application` varchar(20) NOT NULL,
  `section` varchar(128) NOT NULL,
  `referencekey` varchar(128) NOT NULL,
  `value` mediumtext NOT NULL,
  `isSystem` int(11) NOT NULL DEFAULT 0,
  `editable` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `isSystem` (`isSystem`),
  KEY `editable` (`editable`),
  KEY `application` (`application`,`section`(50),`referencekey`(50)),
  KEY `application_2` (`application`,`section`(50))
) ENGINE=InnoDB AUTO_INCREMENT=10418 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_nextend2_smartslider3_generators` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group` varchar(254) NOT NULL,
  `type` varchar(254) NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_nextend2_smartslider3_sliders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alias` text DEFAULT NULL,
  `title` text NOT NULL,
  `type` varchar(30) NOT NULL,
  `params` mediumtext NOT NULL,
  `slider_status` varchar(50) NOT NULL DEFAULT 'published',
  `time` datetime NOT NULL,
  `thumbnail` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `slider_status` (`slider_status`),
  KEY `time` (`time`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_nextend2_smartslider3_sliders_xref` (
  `group_id` int(11) NOT NULL,
  `slider_id` int(11) NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`group_id`,`slider_id`),
  KEY `ordering` (`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_nextend2_smartslider3_slides` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text DEFAULT NULL,
  `slider` int(11) NOT NULL,
  `publish_up` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `published` tinyint(1) NOT NULL,
  `first` int(11) NOT NULL,
  `slide` longtext DEFAULT NULL,
  `description` text NOT NULL,
  `thumbnail` text DEFAULT NULL,
  `params` text NOT NULL,
  `ordering` int(11) NOT NULL,
  `generator_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`),
  KEY `publish_up` (`publish_up`),
  KEY `publish_down` (`publish_down`),
  KEY `generator_id` (`generator_id`),
  KEY `ordering` (`ordering`),
  KEY `slider` (`slider`),
  KEY `thumbnail` (`thumbnail`(100))
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=422141 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11244 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=3183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=253 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8918 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=266 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `message` longtext NOT NULL,
  `types` varchar(255) NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint(20) DEFAULT NULL,
  `entry_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payment_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `discount_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `total_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `currency` varchar(3) NOT NULL DEFAULT '',
  `entry_id` bigint(20) NOT NULL DEFAULT 0,
  `gateway` varchar(20) NOT NULL DEFAULT '',
  `type` varchar(12) NOT NULL DEFAULT '',
  `mode` varchar(4) NOT NULL DEFAULT '',
  `transaction_id` varchar(40) NOT NULL DEFAULT '',
  `customer_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_status` varchar(10) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("175", "wcpay_update_compatibility_data", "failed", "2025-03-26 22:22:43", "2025-03-26 22:22:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1743027763;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1743027763;}", "7", "1", "2025-03-26 22:23:01", "2025-03-26 22:23:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("176", "wcpay_update_compatibility_data", "failed", "2025-03-26 22:22:44", "2025-03-26 22:22:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1743027764;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1743027764;}", "7", "1", "2025-03-26 22:23:01", "2025-03-26 22:23:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("707", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2025-04-04 22:46:01", "2025-04-04 22:46:01", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-04-04 22:46:05", "2025-04-04 22:46:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1629", "mailpoet/cron/daemon-trigger", "failed", "2025-05-09 22:36:14", "2025-05-09 22:36:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746830174;s:18:\"\0*\0first_timestamp\";i:1743027492;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746830174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-05-09 22:36:32", "2025-05-09 22:36:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1646", "mailpoet/cron/daemon-trigger", "failed", "2025-05-09 23:27:57", "2025-05-09 23:27:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746833277;s:18:\"\0*\0first_timestamp\";i:1746830496;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746833277;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-05-09 23:28:12", "2025-05-09 23:28:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1674", "mailpoet/cron/daemon-trigger", "failed", "2025-05-11 22:32:35", "2025-05-11 22:32:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747002755;s:18:\"\0*\0first_timestamp\";i:1747000567;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747002755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-05-11 22:32:35", "2025-05-11 22:32:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1679", "mailpoet/cron/daemon-trigger", "failed", "2025-05-11 23:00:06", "2025-05-11 23:00:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747004406;s:18:\"\0*\0first_timestamp\";i:1747003214;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747004406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-05-11 23:13:31", "2025-05-11 23:13:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1686", "mailpoet/cron/daemon-trigger", "failed", "2025-05-12 00:19:28", "2025-05-12 00:19:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747009168;s:18:\"\0*\0first_timestamp\";i:1747008111;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747009168;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-05-12 00:19:30", "2025-05-12 00:19:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1715", "mailpoet/cron/daemon-trigger", "failed", "2025-05-12 23:04:18", "2025-05-12 23:04:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747091058;s:18:\"\0*\0first_timestamp\";i:1747087450;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747091058;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-05-12 23:04:33", "2025-05-12 23:04:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1716", "mailpoet/cron/daemon-trigger", "failed", "2025-05-12 23:58:09", "2025-05-12 23:58:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747094289;s:18:\"\0*\0first_timestamp\";i:1747094289;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747094289;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-05-12 23:58:13", "2025-05-12 23:58:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2782", "wpforms_admin_addons_cache_update", "failed", "2025-08-02 16:38:00", "2025-08-02 16:38:00", "10", "{\"tasks_meta_id\":3}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754152680;s:18:\"\0*\0first_timestamp\";i:1743629275;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754152680;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-08-07 22:33:29", "2025-08-07 22:33:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2783", "wpforms_builder_help_cache_update", "failed", "2025-08-02 16:38:00", "2025-08-02 16:38:00", "10", "{\"tasks_meta_id\":5}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754152680;s:18:\"\0*\0first_timestamp\";i:1743629303;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754152680;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-08-07 22:33:29", "2025-08-07 22:33:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2784", "wpforms_admin_builder_templates_cache_update", "failed", "2025-08-02 16:38:00", "2025-08-02 16:38:00", "10", "{\"tasks_meta_id\":6}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754152680;s:18:\"\0*\0first_timestamp\";i:1743629303;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754152680;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-08-07 22:33:29", "2025-08-07 22:33:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3175", "wpforms_admin_addons_cache_update", "failed", "2025-08-26 17:19:13", "2025-08-26 17:19:13", "10", "{\"tasks_meta_id\":3}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756228753;s:18:\"\0*\0first_timestamp\";i:1743629275;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756228753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-09-05 17:26:26", "2025-09-05 17:26:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3176", "wpforms_builder_help_cache_update", "failed", "2025-08-26 17:19:13", "2025-08-26 17:19:13", "10", "{\"tasks_meta_id\":5}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756228753;s:18:\"\0*\0first_timestamp\";i:1743629303;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756228753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-09-05 17:26:26", "2025-09-05 17:26:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3177", "wpforms_admin_builder_templates_cache_update", "failed", "2025-08-26 17:19:14", "2025-08-26 17:19:14", "10", "{\"tasks_meta_id\":6}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756228754;s:18:\"\0*\0first_timestamp\";i:1743629303;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756228754;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-09-05 17:26:26", "2025-09-05 17:26:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3520", "mailpoet/cron/daemon-trigger", "failed", "2025-09-28 12:36:00", "2025-09-28 12:36:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759062960;s:18:\"\0*\0first_timestamp\";i:1747175224;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759062960;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-09-28 12:36:35", "2025-09-28 12:36:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3533", "mailpoet/cron/daemon-trigger", "failed", "2025-09-28 13:12:33", "2025-09-28 13:12:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759065153;s:18:\"\0*\0first_timestamp\";i:1759063316;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759065153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-09-28 13:13:32", "2025-09-28 13:13:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3534", "mailpoet/cron/daemon-trigger", "failed", "2025-09-28 13:18:37", "2025-09-28 13:18:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759065517;s:18:\"\0*\0first_timestamp\";i:1759065517;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759065517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-09-28 13:19:51", "2025-09-28 13:19:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3538", "mailpoet/cron/daemon-trigger", "failed", "2025-09-28 13:37:05", "2025-09-28 13:37:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759066625;s:18:\"\0*\0first_timestamp\";i:1759066161;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759066625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-09-28 13:38:17", "2025-09-28 13:38:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3570", "mailpoet/cron/daemon-trigger", "failed", "2025-10-04 14:01:04", "2025-10-04 14:01:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759586464;s:18:\"\0*\0first_timestamp\";i:1759486566;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759586464;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-10-04 14:01:33", "2025-10-04 14:01:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3576", "mailpoet/cron/daemon-trigger", "failed", "2025-10-05 13:11:33", "2025-10-05 13:11:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759669893;s:18:\"\0*\0first_timestamp\";i:1759586807;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759669893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-10-05 13:12:32", "2025-10-05 13:12:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3607", "mailpoet/cron/daemon-trigger", "failed", "2025-10-07 09:44:45", "2025-10-07 09:44:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759830285;s:18:\"\0*\0first_timestamp\";i:1759670262;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759830285;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-10-07 09:44:45", "2025-10-07 09:44:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3616", "mailpoet/cron/daemon-trigger", "failed", "2025-10-07 10:10:42", "2025-10-07 10:10:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759831842;s:18:\"\0*\0first_timestamp\";i:1759830634;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759831842;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-10-07 10:11:32", "2025-10-07 10:11:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3622", "wpforms_admin_addons_cache_update", "complete", "2025-10-17 14:42:27", "2025-10-17 14:42:27", "10", "{\"tasks_meta_id\":3}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760712147;s:18:\"\0*\0first_timestamp\";i:1743629275;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760712147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-11-18 06:51:56", "2025-11-18 06:51:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3623", "wpforms_builder_help_cache_update", "complete", "2025-10-17 14:42:27", "2025-10-17 14:42:27", "10", "{\"tasks_meta_id\":5}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760712147;s:18:\"\0*\0first_timestamp\";i:1743629303;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760712147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-11-18 06:51:57", "2025-11-18 06:51:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3624", "wpforms_admin_builder_templates_cache_update", "complete", "2025-10-17 14:42:28", "2025-10-17 14:42:28", "10", "{\"tasks_meta_id\":6}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760712148;s:18:\"\0*\0first_timestamp\";i:1743629303;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760712148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-11-18 06:51:57", "2025-11-18 06:51:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3625", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-10-17 14:42:28", "2025-10-17 14:42:28", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760712148;s:18:\"\0*\0first_timestamp\";i:1742912200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760712148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-11-18 06:51:58", "2025-11-18 06:51:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3636", "mailpoet/cron/daemon-trigger", "failed", "2025-10-10 15:04:33", "2025-10-10 15:04:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760108673;s:18:\"\0*\0first_timestamp\";i:1760107366;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760108673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-10-10 15:04:33", "2025-10-10 15:04:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3638", "wpforms_process_forms_locator_scan", "complete", "2025-10-13 13:25:08", "2025-10-13 13:25:08", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760361908;s:18:\"\0*\0first_timestamp\";i:1743024475;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760361908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-11-18 06:51:55", "2025-11-18 06:51:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3639", "wpforms_process_purge_spam", "complete", "2025-10-13 13:25:08", "2025-10-13 13:25:08", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760361908;s:18:\"\0*\0first_timestamp\";i:1743024475;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760361908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-11-18 06:51:55", "2025-11-18 06:51:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3640", "woocommerce_cleanup_draft_orders", "complete", "2025-10-13 13:25:08", "2025-10-13 13:25:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760361908;s:18:\"\0*\0first_timestamp\";i:1743027381;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760361908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-18 06:51:55", "2025-11-18 06:51:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3641", "wc_gla_cron_daily_notes", "complete", "2025-10-13 13:25:08", "2025-10-13 13:25:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760361908;s:18:\"\0*\0first_timestamp\";i:1743027483;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760361908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-18 06:51:55", "2025-11-18 06:51:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3672", "mailpoet/cron/daemon-trigger", "complete", "2025-10-12 17:58:35", "2025-10-12 17:58:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760291915;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760291915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-18 06:51:55", "2025-11-18 06:51:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3673", "mailpoet/cron/daemon-trigger", "complete", "2025-11-18 06:53:55", "2025-11-18 06:53:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763448835;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763448835;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:29:30", "2025-11-21 04:29:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3674", "wpforms_process_forms_locator_save", "complete", "2025-11-18 06:51:55", "2025-11-18 06:51:55", "10", "{\"tasks_meta_id\":142}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-11-18 06:51:58", "2025-11-18 06:51:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3675", "wpforms_process_forms_locator_scan", "complete", "2025-11-19 06:51:55", "2025-11-19 06:51:55", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763535115;s:18:\"\0*\0first_timestamp\";i:1743024475;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763535115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-11-21 04:29:30", "2025-11-21 04:29:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3676", "wpforms_process_purge_spam", "complete", "2025-11-19 06:51:55", "2025-11-19 06:51:55", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763535115;s:18:\"\0*\0first_timestamp\";i:1743024475;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763535115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-11-21 04:29:30", "2025-11-21 04:29:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3677", "woocommerce_cleanup_draft_orders", "complete", "2025-11-19 06:51:55", "2025-11-19 06:51:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763535115;s:18:\"\0*\0first_timestamp\";i:1743027381;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763535115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-21 04:29:30", "2025-11-21 04:29:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3678", "wc_gla_cron_daily_notes", "complete", "2025-11-19 06:51:55", "2025-11-19 06:51:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763535115;s:18:\"\0*\0first_timestamp\";i:1743027483;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763535115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-21 04:29:30", "2025-11-21 04:29:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3679", "wpforms_admin_addons_cache_update", "pending", "2025-11-25 06:51:56", "2025-11-25 06:51:56", "10", "{\"tasks_meta_id\":3}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764053516;s:18:\"\0*\0first_timestamp\";i:1743629275;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764053516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3680", "wpforms_builder_help_cache_update", "pending", "2025-11-25 06:51:57", "2025-11-25 06:51:57", "10", "{\"tasks_meta_id\":5}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764053517;s:18:\"\0*\0first_timestamp\";i:1743629303;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764053517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3681", "wpforms_admin_builder_templates_cache_update", "pending", "2025-11-25 06:51:57", "2025-11-25 06:51:57", "10", "{\"tasks_meta_id\":6}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764053517;s:18:\"\0*\0first_timestamp\";i:1743629303;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764053517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3682", "wpforms_email_summaries_fetch_info_blocks", "pending", "2025-11-25 06:51:58", "2025-11-25 06:51:58", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764053518;s:18:\"\0*\0first_timestamp\";i:1742912200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764053518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3683", "wpforms_admin_notifications_update", "complete", "2025-11-18 06:52:05", "2025-11-18 06:52:05", "10", "{\"tasks_meta_id\":143}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-11-18 06:52:08", "2025-11-18 06:52:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3684", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 04:31:30", "2025-11-21 04:31:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763699490;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763699490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:31:53", "2025-11-21 04:31:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3685", "wpforms_process_forms_locator_save", "complete", "2025-11-21 04:29:30", "2025-11-21 04:29:30", "10", "{\"tasks_meta_id\":144}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-11-21 04:29:30", "2025-11-21 04:29:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3686", "wpforms_process_forms_locator_scan", "complete", "2025-11-22 04:29:30", "2025-11-22 04:29:30", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763785770;s:18:\"\0*\0first_timestamp\";i:1743024475;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763785770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-11-22 16:41:07", "2025-11-22 16:41:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3687", "wpforms_process_purge_spam", "complete", "2025-11-22 04:29:30", "2025-11-22 04:29:30", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763785770;s:18:\"\0*\0first_timestamp\";i:1743024475;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763785770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-11-22 16:41:07", "2025-11-22 16:41:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3688", "woocommerce_cleanup_draft_orders", "complete", "2025-11-22 04:29:30", "2025-11-22 04:29:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763785770;s:18:\"\0*\0first_timestamp\";i:1743027381;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763785770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-22 16:41:07", "2025-11-22 16:41:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3689", "wc_gla_cron_daily_notes", "complete", "2025-11-22 04:29:30", "2025-11-22 04:29:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763785770;s:18:\"\0*\0first_timestamp\";i:1743027483;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763785770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-22 16:41:07", "2025-11-22 16:41:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3690", "wpforms_admin_notifications_update", "complete", "2025-11-21 04:29:41", "2025-11-21 04:29:41", "10", "{\"tasks_meta_id\":145}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-11-21 04:29:45", "2025-11-21 04:29:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3691", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 04:33:53", "2025-11-21 04:33:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763699633;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763699633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:33:57", "2025-11-21 04:33:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3692", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 04:35:57", "2025-11-21 04:35:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763699757;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763699757;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:36:10", "2025-11-21 04:36:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3693", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 04:38:10", "2025-11-21 04:38:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763699890;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763699890;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:39:12", "2025-11-21 04:39:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3694", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 04:41:12", "2025-11-21 04:41:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763700072;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763700072;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:41:40", "2025-11-21 04:41:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3695", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 04:43:40", "2025-11-21 04:43:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763700220;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763700220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:43:40", "2025-11-21 04:43:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3696", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 04:45:40", "2025-11-21 04:45:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763700340;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763700340;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:46:25", "2025-11-21 04:46:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3697", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 04:48:25", "2025-11-21 04:48:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763700505;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763700505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:48:36", "2025-11-21 04:48:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3698", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 04:50:36", "2025-11-21 04:50:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763700636;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763700636;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:52:17", "2025-11-21 04:52:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3699", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 04:54:17", "2025-11-21 04:54:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763700857;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763700857;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:55:55", "2025-11-21 04:55:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3700", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 04:57:55", "2025-11-21 04:57:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763701075;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763701075;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 04:58:57", "2025-11-21 04:58:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3701", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 05:00:57", "2025-11-21 05:00:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763701257;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763701257;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 05:01:45", "2025-11-21 05:01:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3702", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 05:03:45", "2025-11-21 05:03:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763701425;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763701425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-21 05:03:46", "2025-11-21 05:03:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3703", "mailpoet/cron/daemon-trigger", "complete", "2025-11-21 05:05:46", "2025-11-21 05:05:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763701546;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763701546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 16:41:07", "2025-11-22 16:41:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3704", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 16:43:07", "2025-11-22 16:43:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763829787;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763829787;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 16:43:10", "2025-11-22 16:43:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3705", "wpforms_process_forms_locator_save", "complete", "2025-11-22 16:41:07", "2025-11-22 16:41:07", "10", "{\"tasks_meta_id\":146}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-11-22 16:41:07", "2025-11-22 16:41:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3706", "wpforms_process_forms_locator_scan", "pending", "2025-11-23 16:41:07", "2025-11-23 16:41:07", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763916067;s:18:\"\0*\0first_timestamp\";i:1743024475;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763916067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3707", "wpforms_process_purge_spam", "pending", "2025-11-23 16:41:07", "2025-11-23 16:41:07", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763916067;s:18:\"\0*\0first_timestamp\";i:1743024475;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763916067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3708", "woocommerce_cleanup_draft_orders", "pending", "2025-11-23 16:41:07", "2025-11-23 16:41:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763916067;s:18:\"\0*\0first_timestamp\";i:1743027381;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763916067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3709", "wc_gla_cron_daily_notes", "pending", "2025-11-23 16:41:07", "2025-11-23 16:41:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763916067;s:18:\"\0*\0first_timestamp\";i:1743027483;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763916067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3710", "wpforms_admin_notifications_update", "complete", "2025-11-22 16:41:17", "2025-11-22 16:41:17", "10", "{\"tasks_meta_id\":147}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-11-22 16:41:21", "2025-11-22 16:41:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3711", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 16:45:10", "2025-11-22 16:45:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763829910;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763829910;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 16:54:40", "2025-11-22 16:54:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3712", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 16:56:40", "2025-11-22 16:56:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763830600;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763830600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 16:57:39", "2025-11-22 16:57:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3713", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 16:59:39", "2025-11-22 16:59:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763830779;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763830779;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 17:00:32", "2025-11-22 17:00:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3714", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 17:02:32", "2025-11-22 17:02:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763830952;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763830952;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 17:03:26", "2025-11-22 17:03:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3715", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 17:05:26", "2025-11-22 17:05:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763831126;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763831126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 17:05:40", "2025-11-22 17:05:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3716", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 17:07:40", "2025-11-22 17:07:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763831260;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763831260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 17:08:38", "2025-11-22 17:08:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3717", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 17:10:38", "2025-11-22 17:10:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763831438;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763831438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 17:11:39", "2025-11-22 17:11:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3718", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 17:13:39", "2025-11-22 17:13:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763831619;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763831619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 17:13:47", "2025-11-22 17:13:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3719", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 17:15:47", "2025-11-22 17:15:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763831747;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763831747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 17:16:24", "2025-11-22 17:16:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3720", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 17:18:24", "2025-11-22 17:18:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763831904;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763831904;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 17:18:24", "2025-11-22 17:18:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3721", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 17:20:24", "2025-11-22 17:20:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763832024;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763832024;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 17:28:16", "2025-11-22 17:28:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3722", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 17:30:16", "2025-11-22 17:30:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763832616;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763832616;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 17:30:27", "2025-11-22 17:30:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3723", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 17:32:27", "2025-11-22 17:32:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763832747;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763832747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 17:33:21", "2025-11-22 17:33:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3724", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 17:35:21", "2025-11-22 17:35:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763832921;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763832921;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 18:03:53", "2025-11-22 18:03:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3725", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 18:05:53", "2025-11-22 18:05:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763834753;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763834753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 18:06:26", "2025-11-22 18:06:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3726", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 18:08:26", "2025-11-22 18:08:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763834906;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763834906;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 18:09:07", "2025-11-22 18:09:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3727", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 18:11:07", "2025-11-22 18:11:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763835067;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763835067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 18:11:09", "2025-11-22 18:11:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3728", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 18:13:09", "2025-11-22 18:13:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763835189;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763835189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 18:13:09", "2025-11-22 18:13:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3729", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 18:15:09", "2025-11-22 18:15:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763835309;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763835309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 18:15:25", "2025-11-22 18:15:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3730", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 18:17:25", "2025-11-22 18:17:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763835445;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763835445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 18:18:00", "2025-11-22 18:18:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3731", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 18:20:00", "2025-11-22 18:20:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763835600;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763835600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 18:20:00", "2025-11-22 18:20:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3732", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 18:22:00", "2025-11-22 18:22:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763835720;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763835720;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 18:22:02", "2025-11-22 18:22:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3733", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 18:24:02", "2025-11-22 18:24:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763835842;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763835842;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 18:26:15", "2025-11-22 18:26:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3734", "mailpoet/cron/daemon-trigger", "complete", "2025-11-22 18:28:15", "2025-11-22 18:28:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763836095;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763836095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2025-11-22 18:28:40", "2025-11-22 18:28:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("3735", "mailpoet/cron/daemon-trigger", "pending", "2025-11-22 18:30:40", "2025-11-22 18:30:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763836240;s:18:\"\0*\0first_timestamp\";i:1760275509;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763836240;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "image-optimization/migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wpforms");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "gla");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "mailpoet-cron");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "woocommerce_payments");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "wc-admin-data");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("63", "175", "action created", "2025-03-26 22:20:43", "2025-03-26 22:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("65", "176", "action created", "2025-03-26 22:20:44", "2025-03-26 22:20:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("87", "175", "action started via Async Request", "2025-03-26 22:23:01", "2025-03-26 22:23:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("88", "175", "action failed via Async Request: Le site n’est pas connecté à WordPress.com", "2025-03-26 22:23:01", "2025-03-26 22:23:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("89", "176", "action started via Async Request", "2025-03-26 22:23:01", "2025-03-26 22:23:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("90", "176", "action failed via Async Request: Le site n’est pas connecté à WordPress.com", "2025-03-26 22:23:01", "2025-03-26 22:23:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1660", "707", "action created", "2025-04-04 22:46:01", "2025-04-04 22:46:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1662", "707", "action started via Async Request", "2025-04-04 22:46:05", "2025-04-04 22:46:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1663", "707", "action failed via Async Request: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2025-04-04 22:46:05", "2025-04-04 22:46:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4428", "1629", "action created", "2025-05-09 22:34:14", "2025-05-09 22:34:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4429", "1629", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-05-09 22:41:32", "2025-05-09 22:41:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4478", "1646", "action created", "2025-05-09 23:25:57", "2025-05-09 23:25:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4479", "1646", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-05-11 21:56:00", "2025-05-11 21:56:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4561", "1674", "action created", "2025-05-11 22:30:35", "2025-05-11 22:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4574", "1679", "action created", "2025-05-11 22:58:06", "2025-05-11 22:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4575", "1679", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-05-12 00:01:50", "2025-05-12 00:01:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4591", "176", "action ignored via WP Cron", "2025-05-12 00:12:38", "2025-05-12 00:12:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4592", "707", "action ignored via WP Cron", "2025-05-12 00:12:39", "2025-05-12 00:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5380", "1629", "action ignored via WP Cron", "2025-05-12 00:12:40", "2025-05-12 00:12:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5397", "1646", "action ignored via WP Cron", "2025-05-12 00:12:40", "2025-05-12 00:12:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5425", "1674", "action ignored via WP Cron", "2025-05-12 00:12:40", "2025-05-12 00:12:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5430", "1679", "action ignored via WP Cron", "2025-05-12 00:12:40", "2025-05-12 00:12:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5438", "1686", "action created", "2025-05-12 00:17:28", "2025-05-12 00:17:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5439", "1686", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-05-12 21:50:03", "2025-05-12 21:50:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("5524", "1715", "action created", "2025-05-12 23:02:18", "2025-05-12 23:02:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("5525", "1715", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-05-12 23:18:07", "2025-05-12 23:18:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5526", "1716", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-05-13 22:26:59", "2025-05-13 22:26:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8720", "2782", "action created", "2025-07-26 16:38:00", "2025-07-26 16:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("8723", "2783", "action created", "2025-07-26 16:38:00", "2025-07-26 16:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("8726", "2784", "action created", "2025-07-26 16:38:00", "2025-07-26 16:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("8749", "2782", "action started via Async Request", "2025-08-07 22:33:29", "2025-08-07 22:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("8750", "2782", "action failed via Async Request: Scheduled action for wpforms_admin_addons_cache_update will not be executed as no callbacks are registered.", "2025-08-07 22:33:29", "2025-08-07 22:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("8752", "2783", "action started via Async Request", "2025-08-07 22:33:29", "2025-08-07 22:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("8753", "2783", "action failed via Async Request: Scheduled action for wpforms_builder_help_cache_update will not be executed as no callbacks are registered.", "2025-08-07 22:33:29", "2025-08-07 22:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("8755", "2784", "action started via Async Request", "2025-08-07 22:33:29", "2025-08-07 22:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("8756", "2784", "action failed via Async Request: Scheduled action for wpforms_admin_builder_templates_cache_update will not be executed as no callbacks are registered.", "2025-08-07 22:33:29", "2025-08-07 22:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("9899", "3175", "action created", "2025-08-19 17:19:13", "2025-08-19 17:19:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("9902", "3176", "action created", "2025-08-19 17:19:13", "2025-08-19 17:19:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("9905", "3177", "action created", "2025-08-19 17:19:14", "2025-08-19 17:19:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("10068", "3175", "action started via Async Request", "2025-09-05 17:26:26", "2025-09-05 17:26:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("10069", "3175", "action failed via Async Request: Scheduled action for wpforms_admin_addons_cache_update will not be executed as no callbacks are registered.", "2025-09-05 17:26:26", "2025-09-05 17:26:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("10071", "3176", "action started via Async Request", "2025-09-05 17:26:26", "2025-09-05 17:26:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("10072", "3176", "action failed via Async Request: Scheduled action for wpforms_builder_help_cache_update will not be executed as no callbacks are registered.", "2025-09-05 17:26:26", "2025-09-05 17:26:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("10074", "3177", "action started via Async Request", "2025-09-05 17:26:26", "2025-09-05 17:26:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("10075", "3177", "action failed via Async Request: Scheduled action for wpforms_admin_builder_templates_cache_update will not be executed as no callbacks are registered.", "2025-09-05 17:26:26", "2025-09-05 17:26:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("10936", "3520", "action created", "2025-09-28 12:34:00", "2025-09-28 12:34:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("10937", "2783", "action ignored via WP Cron", "2025-09-28 12:39:55", "2025-09-28 12:39:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("10938", "2784", "action ignored via WP Cron", "2025-09-28 12:39:55", "2025-09-28 12:39:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("10945", "3175", "action ignored via WP Cron", "2025-09-28 12:39:55", "2025-09-28 12:39:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("10946", "3176", "action ignored via WP Cron", "2025-09-28 12:39:55", "2025-09-28 12:39:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("10947", "3177", "action ignored via WP Cron", "2025-09-28 12:39:55", "2025-09-28 12:39:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11235", "3520", "action ignored via WP Cron", "2025-09-28 12:39:55", "2025-09-28 12:39:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11236", "3520", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-09-28 12:41:55", "2025-09-28 12:41:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11273", "3533", "action created", "2025-09-28 13:10:33", "2025-09-28 13:10:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("11274", "3533", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-09-28 13:18:33", "2025-09-28 13:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("11275", "3534", "action created", "2025-09-28 13:18:37", "2025-09-28 13:18:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("11276", "3534", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-09-28 13:29:17", "2025-09-28 13:29:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("11286", "3538", "action created", "2025-09-28 13:35:05", "2025-09-28 13:35:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("11287", "3538", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-10-03 10:16:01", "2025-10-03 10:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("11381", "3570", "action created", "2025-10-04 13:59:04", "2025-10-04 13:59:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11382", "3570", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-10-04 14:06:46", "2025-10-04 14:06:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("11398", "3576", "action created", "2025-10-05 13:09:33", "2025-10-05 13:09:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("11399", "3576", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-10-05 13:17:41", "2025-10-05 13:17:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("11490", "3607", "action created", "2025-10-07 09:42:45", "2025-10-07 09:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("11491", "3607", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-10-07 09:50:32", "2025-10-07 09:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("11516", "3616", "action created", "2025-10-07 10:08:42", "2025-10-07 10:08:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("11517", "3616", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-10-10 14:42:26", "2025-10-10 14:42:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("11533", "3622", "action created", "2025-10-10 14:42:27", "2025-10-10 14:42:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("11536", "3623", "action created", "2025-10-10 14:42:27", "2025-10-10 14:42:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("11539", "3624", "action created", "2025-10-10 14:42:28", "2025-10-10 14:42:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("11542", "3625", "action created", "2025-10-10 14:42:28", "2025-10-10 14:42:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("11575", "3636", "action created", "2025-10-10 15:02:33", "2025-10-10 15:02:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("11576", "3636", "action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.", "2025-10-12 13:25:08", "2025-10-12 13:25:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("11580", "3638", "action created", "2025-10-12 13:25:08", "2025-10-12 13:25:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("11583", "3639", "action created", "2025-10-12 13:25:08", "2025-10-12 13:25:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("11586", "3640", "action created", "2025-10-12 13:25:08", "2025-10-12 13:25:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("11589", "3641", "action created", "2025-10-12 13:25:08", "2025-10-12 13:25:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("11682", "3672", "action created", "2025-10-12 17:56:35", "2025-10-12 17:56:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("11683", "3672", "action started via WP Cron", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11684", "3672", "action complete via WP Cron", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11685", "3673", "action created", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11686", "3638", "action started via WP Cron", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11687", "3674", "action created", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11688", "3638", "action complete via WP Cron", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11689", "3675", "action created", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11690", "3639", "action started via WP Cron", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11691", "3639", "action complete via WP Cron", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11692", "3676", "action created", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11693", "3640", "action started via WP Cron", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11694", "3640", "action complete via WP Cron", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11695", "3677", "action created", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11696", "3641", "action started via WP Cron", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11697", "3641", "action complete via WP Cron", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11698", "3678", "action created", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11699", "3622", "action started via WP Cron", "2025-11-18 06:51:55", "2025-11-18 06:51:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11700", "3622", "action complete via WP Cron", "2025-11-18 06:51:56", "2025-11-18 06:51:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("11701", "3679", "action created", "2025-11-18 06:51:56", "2025-11-18 06:51:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("11702", "3623", "action started via WP Cron", "2025-11-18 06:51:56", "2025-11-18 06:51:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("11703", "3623", "action complete via WP Cron", "2025-11-18 06:51:57", "2025-11-18 06:51:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11704", "3680", "action created", "2025-11-18 06:51:57", "2025-11-18 06:51:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11705", "3624", "action started via WP Cron", "2025-11-18 06:51:57", "2025-11-18 06:51:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11706", "3624", "action complete via WP Cron", "2025-11-18 06:51:57", "2025-11-18 06:51:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11707", "3681", "action created", "2025-11-18 06:51:57", "2025-11-18 06:51:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11708", "3625", "action started via WP Cron", "2025-11-18 06:51:57", "2025-11-18 06:51:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11709", "3625", "action complete via WP Cron", "2025-11-18 06:51:58", "2025-11-18 06:51:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("11710", "3682", "action created", "2025-11-18 06:51:58", "2025-11-18 06:51:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("11711", "3674", "action started via WP Cron", "2025-11-18 06:51:58", "2025-11-18 06:51:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("11712", "3674", "action complete via WP Cron", "2025-11-18 06:51:58", "2025-11-18 06:51:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("11713", "3683", "action created", "2025-11-18 06:52:05", "2025-11-18 06:52:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("11714", "3683", "action started via Async Request", "2025-11-18 06:52:08", "2025-11-18 06:52:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("11715", "3683", "action complete via Async Request", "2025-11-18 06:52:08", "2025-11-18 06:52:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("11716", "3673", "action started via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11717", "3673", "action complete via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11718", "3684", "action created", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11719", "3675", "action started via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11720", "3685", "action created", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11721", "3675", "action complete via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11722", "3686", "action created", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11723", "3676", "action started via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11724", "3676", "action complete via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11725", "3687", "action created", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11726", "3677", "action started via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11727", "3677", "action complete via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11728", "3688", "action created", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11729", "3678", "action started via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11730", "3678", "action complete via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11731", "3689", "action created", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11732", "3685", "action started via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11733", "3685", "action complete via WP Cron", "2025-11-21 04:29:30", "2025-11-21 04:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("11734", "3690", "action created", "2025-11-21 04:29:41", "2025-11-21 04:29:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("11735", "3690", "action started via Async Request", "2025-11-21 04:29:44", "2025-11-21 04:29:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("11736", "3690", "action complete via Async Request", "2025-11-21 04:29:45", "2025-11-21 04:29:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("11737", "3684", "action started via WP Cron", "2025-11-21 04:31:53", "2025-11-21 04:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("11738", "3684", "action complete via WP Cron", "2025-11-21 04:31:53", "2025-11-21 04:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("11739", "3691", "action created", "2025-11-21 04:31:53", "2025-11-21 04:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("11740", "3691", "action started via WP Cron", "2025-11-21 04:33:57", "2025-11-21 04:33:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11741", "3691", "action complete via WP Cron", "2025-11-21 04:33:57", "2025-11-21 04:33:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11742", "3692", "action created", "2025-11-21 04:33:57", "2025-11-21 04:33:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11743", "3692", "action started via Async Request", "2025-11-21 04:36:10", "2025-11-21 04:36:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11744", "3692", "action complete via Async Request", "2025-11-21 04:36:10", "2025-11-21 04:36:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11745", "3693", "action created", "2025-11-21 04:36:10", "2025-11-21 04:36:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11746", "3693", "action started via WP Cron", "2025-11-21 04:39:12", "2025-11-21 04:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11747", "3693", "action complete via WP Cron", "2025-11-21 04:39:12", "2025-11-21 04:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11748", "3694", "action created", "2025-11-21 04:39:12", "2025-11-21 04:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11749", "3694", "action started via WP Cron", "2025-11-21 04:41:40", "2025-11-21 04:41:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11750", "3694", "action complete via WP Cron", "2025-11-21 04:41:40", "2025-11-21 04:41:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11751", "3695", "action created", "2025-11-21 04:41:40", "2025-11-21 04:41:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11752", "3695", "action started via WP Cron", "2025-11-21 04:43:40", "2025-11-21 04:43:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11753", "3695", "action complete via WP Cron", "2025-11-21 04:43:40", "2025-11-21 04:43:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11754", "3696", "action created", "2025-11-21 04:43:40", "2025-11-21 04:43:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11755", "3696", "action started via WP Cron", "2025-11-21 04:46:25", "2025-11-21 04:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("11756", "3696", "action complete via WP Cron", "2025-11-21 04:46:25", "2025-11-21 04:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("11757", "3697", "action created", "2025-11-21 04:46:25", "2025-11-21 04:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("11758", "3697", "action started via WP Cron", "2025-11-21 04:48:36", "2025-11-21 04:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("11759", "3697", "action complete via WP Cron", "2025-11-21 04:48:36", "2025-11-21 04:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("11760", "3698", "action created", "2025-11-21 04:48:36", "2025-11-21 04:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("11761", "3698", "action started via WP Cron", "2025-11-21 04:52:17", "2025-11-21 04:52:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("11762", "3698", "action complete via WP Cron", "2025-11-21 04:52:17", "2025-11-21 04:52:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("11763", "3699", "action created", "2025-11-21 04:52:17", "2025-11-21 04:52:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("11764", "3699", "action started via WP Cron", "2025-11-21 04:55:55", "2025-11-21 04:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11765", "3699", "action complete via WP Cron", "2025-11-21 04:55:55", "2025-11-21 04:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11766", "3700", "action created", "2025-11-21 04:55:55", "2025-11-21 04:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("11767", "3700", "action started via WP Cron", "2025-11-21 04:58:57", "2025-11-21 04:58:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11768", "3700", "action complete via WP Cron", "2025-11-21 04:58:57", "2025-11-21 04:58:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11769", "3701", "action created", "2025-11-21 04:58:57", "2025-11-21 04:58:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("11770", "3701", "action started via WP Cron", "2025-11-21 05:01:45", "2025-11-21 05:01:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("11771", "3701", "action complete via WP Cron", "2025-11-21 05:01:45", "2025-11-21 05:01:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("11772", "3702", "action created", "2025-11-21 05:01:45", "2025-11-21 05:01:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("11773", "3702", "action started via WP Cron", "2025-11-21 05:03:46", "2025-11-21 05:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("11774", "3702", "action complete via WP Cron", "2025-11-21 05:03:46", "2025-11-21 05:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("11775", "3703", "action created", "2025-11-21 05:03:46", "2025-11-21 05:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("11776", "3703", "action started via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11777", "3703", "action complete via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11778", "3704", "action created", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11779", "3686", "action started via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11780", "3705", "action created", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11781", "3686", "action complete via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11782", "3706", "action created", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11783", "3687", "action started via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11784", "3687", "action complete via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11785", "3707", "action created", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11786", "3688", "action started via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11787", "3688", "action complete via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11788", "3708", "action created", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11789", "3689", "action started via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11790", "3689", "action complete via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11791", "3709", "action created", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11792", "3705", "action started via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11793", "3705", "action complete via WP Cron", "2025-11-22 16:41:07", "2025-11-22 16:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11794", "3710", "action created", "2025-11-22 16:41:17", "2025-11-22 16:41:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("11795", "3710", "action started via Async Request", "2025-11-22 16:41:20", "2025-11-22 16:41:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("11796", "3710", "action complete via Async Request", "2025-11-22 16:41:21", "2025-11-22 16:41:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("11797", "3704", "action started via Async Request", "2025-11-22 16:43:09", "2025-11-22 16:43:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11798", "3704", "action complete via Async Request", "2025-11-22 16:43:10", "2025-11-22 16:43:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11799", "3711", "action created", "2025-11-22 16:43:10", "2025-11-22 16:43:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11800", "3711", "action started via WP Cron", "2025-11-22 16:54:40", "2025-11-22 16:54:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11801", "3711", "action complete via WP Cron", "2025-11-22 16:54:40", "2025-11-22 16:54:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11802", "3712", "action created", "2025-11-22 16:54:40", "2025-11-22 16:54:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11803", "3712", "action started via WP Cron", "2025-11-22 16:57:39", "2025-11-22 16:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("11804", "3712", "action complete via WP Cron", "2025-11-22 16:57:39", "2025-11-22 16:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("11805", "3713", "action created", "2025-11-22 16:57:39", "2025-11-22 16:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("11806", "3713", "action started via WP Cron", "2025-11-22 17:00:32", "2025-11-22 17:00:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("11807", "3713", "action complete via WP Cron", "2025-11-22 17:00:32", "2025-11-22 17:00:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("11808", "3714", "action created", "2025-11-22 17:00:32", "2025-11-22 17:00:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("11809", "3714", "action started via WP Cron", "2025-11-22 17:03:26", "2025-11-22 17:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("11810", "3714", "action complete via WP Cron", "2025-11-22 17:03:26", "2025-11-22 17:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("11811", "3715", "action created", "2025-11-22 17:03:26", "2025-11-22 17:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("11812", "3715", "action started via WP Cron", "2025-11-22 17:05:40", "2025-11-22 17:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11813", "3715", "action complete via WP Cron", "2025-11-22 17:05:40", "2025-11-22 17:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11814", "3716", "action created", "2025-11-22 17:05:40", "2025-11-22 17:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11815", "3716", "action started via WP Cron", "2025-11-22 17:08:38", "2025-11-22 17:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("11816", "3716", "action complete via WP Cron", "2025-11-22 17:08:38", "2025-11-22 17:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("11817", "3717", "action created", "2025-11-22 17:08:38", "2025-11-22 17:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("11818", "3717", "action started via WP Cron", "2025-11-22 17:11:39", "2025-11-22 17:11:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("11819", "3717", "action complete via WP Cron", "2025-11-22 17:11:39", "2025-11-22 17:11:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("11820", "3718", "action created", "2025-11-22 17:11:39", "2025-11-22 17:11:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("11821", "3718", "action started via WP Cron", "2025-11-22 17:13:47", "2025-11-22 17:13:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("11822", "3718", "action complete via WP Cron", "2025-11-22 17:13:47", "2025-11-22 17:13:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("11823", "3719", "action created", "2025-11-22 17:13:47", "2025-11-22 17:13:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("11824", "3719", "action started via WP Cron", "2025-11-22 17:16:24", "2025-11-22 17:16:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("11825", "3719", "action complete via WP Cron", "2025-11-22 17:16:24", "2025-11-22 17:16:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("11826", "3720", "action created", "2025-11-22 17:16:24", "2025-11-22 17:16:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("11827", "3720", "action started via WP Cron", "2025-11-22 17:18:24", "2025-11-22 17:18:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("11828", "3720", "action complete via WP Cron", "2025-11-22 17:18:24", "2025-11-22 17:18:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("11829", "3721", "action created", "2025-11-22 17:18:24", "2025-11-22 17:18:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("11830", "3721", "action started via WP Cron", "2025-11-22 17:28:16", "2025-11-22 17:28:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("11831", "3721", "action complete via WP Cron", "2025-11-22 17:28:16", "2025-11-22 17:28:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("11832", "3722", "action created", "2025-11-22 17:28:16", "2025-11-22 17:28:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("11833", "3722", "action started via WP Cron", "2025-11-22 17:30:27", "2025-11-22 17:30:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("11834", "3722", "action complete via WP Cron", "2025-11-22 17:30:27", "2025-11-22 17:30:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("11835", "3723", "action created", "2025-11-22 17:30:27", "2025-11-22 17:30:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("11836", "3723", "action started via WP Cron", "2025-11-22 17:33:21", "2025-11-22 17:33:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("11837", "3723", "action complete via WP Cron", "2025-11-22 17:33:21", "2025-11-22 17:33:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("11838", "3724", "action created", "2025-11-22 17:33:21", "2025-11-22 17:33:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("11839", "3724", "action started via WP Cron", "2025-11-22 18:03:53", "2025-11-22 18:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("11840", "3724", "action complete via WP Cron", "2025-11-22 18:03:53", "2025-11-22 18:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("11841", "3725", "action created", "2025-11-22 18:03:53", "2025-11-22 18:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("11842", "3725", "action started via Async Request", "2025-11-22 18:06:26", "2025-11-22 18:06:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("11843", "3725", "action complete via Async Request", "2025-11-22 18:06:26", "2025-11-22 18:06:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("11844", "3726", "action created", "2025-11-22 18:06:26", "2025-11-22 18:06:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("11845", "3726", "action started via WP Cron", "2025-11-22 18:09:07", "2025-11-22 18:09:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11846", "3726", "action complete via WP Cron", "2025-11-22 18:09:07", "2025-11-22 18:09:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11847", "3727", "action created", "2025-11-22 18:09:07", "2025-11-22 18:09:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("11848", "3727", "action started via WP Cron", "2025-11-22 18:11:09", "2025-11-22 18:11:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11849", "3727", "action complete via WP Cron", "2025-11-22 18:11:09", "2025-11-22 18:11:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11850", "3728", "action created", "2025-11-22 18:11:09", "2025-11-22 18:11:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11851", "3728", "action started via WP Cron", "2025-11-22 18:13:09", "2025-11-22 18:13:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11852", "3728", "action complete via WP Cron", "2025-11-22 18:13:09", "2025-11-22 18:13:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11853", "3729", "action created", "2025-11-22 18:13:09", "2025-11-22 18:13:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11854", "3729", "action started via WP Cron", "2025-11-22 18:15:25", "2025-11-22 18:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("11855", "3729", "action complete via WP Cron", "2025-11-22 18:15:25", "2025-11-22 18:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("11856", "3730", "action created", "2025-11-22 18:15:25", "2025-11-22 18:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("11857", "3730", "action started via WP Cron", "2025-11-22 18:18:00", "2025-11-22 18:18:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("11858", "3730", "action complete via WP Cron", "2025-11-22 18:18:00", "2025-11-22 18:18:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("11859", "3731", "action created", "2025-11-22 18:18:00", "2025-11-22 18:18:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("11860", "3731", "action started via WP Cron", "2025-11-22 18:20:00", "2025-11-22 18:20:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("11861", "3731", "action complete via WP Cron", "2025-11-22 18:20:00", "2025-11-22 18:20:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("11862", "3732", "action created", "2025-11-22 18:20:00", "2025-11-22 18:20:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("11863", "3732", "action started via WP Cron", "2025-11-22 18:22:02", "2025-11-22 18:22:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11864", "3732", "action complete via WP Cron", "2025-11-22 18:22:02", "2025-11-22 18:22:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11865", "3733", "action created", "2025-11-22 18:22:02", "2025-11-22 18:22:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11866", "3733", "action started via WP Cron", "2025-11-22 18:26:15", "2025-11-22 18:26:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("11867", "3733", "action complete via WP Cron", "2025-11-22 18:26:15", "2025-11-22 18:26:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("11868", "3734", "action created", "2025-11-22 18:26:15", "2025-11-22 18:26:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("11869", "3734", "action started via WP Cron", "2025-11-22 18:28:40", "2025-11-22 18:28:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11870", "3734", "action complete via WP Cron", "2025-11-22 18:28:40", "2025-11-22 18:28:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("11871", "3735", "action created", "2025-11-22 18:28:40", "2025-11-22 18:28:40");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20251122_demoiselleenvadrouille", "440c2385ce2aff544808_20251122180638", "-1", "2025-11-22 18:07:01", "nellb", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-22 18:06:38\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:7:\"10.4.28\";s:10:\"VersionPHP\";s:6:\"8.0.28\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:31:\"20251122_demoiselleenvadrouille\";s:4:\"Hash\";s:35:\"440c2385ce2aff544808_20251122180638\";s:8:\"NameHash\";s:67:\"20251122_demoiselleenvadrouille_440c2385ce2aff544808_20251122180638\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:77:\"20251122_demoiselleenvadrouille_440c2385ce2aff544808_20251122180638_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"-1.0\";s:6:\"WPUser\";s:5:\"nellb\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:79:\"20251122_demoiselleenvadrouille_440c2385ce2aff544808_20251122180638_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:51:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger\";s:4:\"Size\";i:6030840489;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:5672;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:44422;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:50093;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:60:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-admin\";i:1;s:63:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-includes\";i:2;s:72:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:51:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger\";i:1;s:51:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger\";i:2;s:62:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content\";i:3;s:70:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/uploads\";i:4;s:70:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/plugins\";i:5;s:73:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/mu-plugins\";i:6;s:69:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:83:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:85:\"20251122_demoiselleenvadrouille_440c2385ce2aff544808_20251122180638_installer.php.bak\";s:4:\"Size\";i:75268;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:135:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/backups-dup-lite/tmp/original_files_440c238-22180638/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:115:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/backups-dup-lite/tmp/original_files_440c238-22180638\";s:20:\"\0*\0origFolderEntries\";a:1:{s:8:\"wpconfig\";a:5:{s:8:\"baseName\";s:20:\"source_site_wpconfig\";s:6:\"source\";s:13:\"wp-config.php\";s:6:\"stored\";s:20:\"source_site_wpconfig\";s:4:\"mode\";s:4:\"copy\";s:10:\"isRelative\";b:1;}}s:11:\"\0*\0rootPath\";s:51:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:65:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3239:\"<?php\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the website, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * Database settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/\n *\n * @package WordPress\n */\n\n// ** Database settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'nellboulanger\' );\n\n/** Database username */\ndefine( \'DB_USER\', \'root\' );\n\n/** Database password */\ndefine( \'DB_PASSWORD\', \'\' );\n\n/** Database hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',         \'put your unique phrase here\' );\ndefine( \'SECURE_AUTH_KEY\',  \'put your unique phrase here\' );\ndefine( \'LOGGED_IN_KEY\',    \'put your unique phrase here\' );\ndefine( \'NONCE_KEY\',        \'put your unique phrase here\' );\ndefine( \'AUTH_SALT\',        \'put your unique phrase here\' );\ndefine( \'SECURE_AUTH_SALT\', \'put your unique phrase here\' );\ndefine( \'LOGGED_IN_SALT\',   \'put your unique phrase here\' );\ndefine( \'NONCE_SALT\',       \'put your unique phrase here\' );\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n *\n * At the installation time, database tables are created with the specified prefix.\n * Changing this value after WordPress is installed will make your site think\n * it has not been installed.\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/#table-prefix\n */\n$table_prefix = \'wp_\';\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://developer.wordpress.org/advanced-administration/debug/debug-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\ndefine( \'FS_METHOD\',\'direct\' );\n\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:17:{s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:37:\"define( \'DB_NAME\', \'nellboulanger\' );\";s:5:\"value\";s:15:\"\'nellboulanger\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:18:\", \'nellboulanger\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:28:\"define( \'DB_USER\', \'root\' );\";s:5:\"value\";s:6:\"\'root\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:9:\", \'root\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:28:\"define( \'DB_PASSWORD\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:31:\"define( \'DB_CHARSET\', \'utf8\' );\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:9:\", \'utf8\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:60:\"define( \'AUTH_KEY\',         \'put your unique phrase here\' );\";s:5:\"value\";s:29:\"\'put your unique phrase here\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:40:\",         \'put your unique phrase here\' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:60:\"define( \'SECURE_AUTH_KEY\',  \'put your unique phrase here\' );\";s:5:\"value\";s:29:\"\'put your unique phrase here\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:33:\",  \'put your unique phrase here\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:60:\"define( \'LOGGED_IN_KEY\',    \'put your unique phrase here\' );\";s:5:\"value\";s:29:\"\'put your unique phrase here\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:35:\",    \'put your unique phrase here\' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:60:\"define( \'NONCE_KEY\',        \'put your unique phrase here\' );\";s:5:\"value\";s:29:\"\'put your unique phrase here\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:39:\",        \'put your unique phrase here\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:60:\"define( \'AUTH_SALT\',        \'put your unique phrase here\' );\";s:5:\"value\";s:29:\"\'put your unique phrase here\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:39:\",        \'put your unique phrase here\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:60:\"define( \'SECURE_AUTH_SALT\', \'put your unique phrase here\' );\";s:5:\"value\";s:29:\"\'put your unique phrase here\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:32:\", \'put your unique phrase here\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:60:\"define( \'LOGGED_IN_SALT\',   \'put your unique phrase here\' );\";s:5:\"value\";s:29:\"\'put your unique phrase here\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:34:\",   \'put your unique phrase here\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:60:\"define( \'NONCE_SALT\',       \'put your unique phrase here\' );\";s:5:\"value\";s:29:\"\'put your unique phrase here\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:38:\",       \'put your unique phrase here\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:9:\"FS_METHOD\";a:3:{s:3:\"src\";s:31:\"define( \'FS_METHOD\',\'direct\' );\";s:5:\"value\";s:8:\"\'direct\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'FS_METHOD\'\";i:1;s:10:\",\'direct\' \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:70923862;s:4:\"File\";s:80:\"20251122_demoiselleenvadrouille_440c2385ce2aff544808_20251122180638_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:2:{i:0;s:7:\"utf8mb4\";i:1;s:4:\"utf8\";}s:13:\"collationList\";a:2:{i:0;s:15:\"utf8_general_ci\";i:1;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:13:\"nellboulanger\";s:15:\"tablesBaseCount\";i:112;s:16:\"tablesFinalCount\";i:112;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:16243;s:16:\"tablesSizeOnDisk\";i:101138432;s:10:\"tablesList\";a:112:{s:26:\"wp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:89;s:12:\"insertedRows\";i:89;s:4:\"size\";i:180224;}s:25:\"wp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:25:\"wp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:9;s:4:\"size\";i:32768;}s:23:\"wp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:233;s:12:\"insertedRows\";i:243;s:4:\"size\";i:81920;}s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:114688;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:11:\"wp_e_events\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:30:\"wp_gla_attribute_mapping_rules\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:29:\"wp_gla_budget_recommendations\";a:3:{s:14:\"inaccurateRows\";i:4230;s:12:\"insertedRows\";i:4230;s:4:\"size\";i:344064;}s:22:\"wp_gla_merchant_issues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:21:\"wp_gla_shipping_rates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"wp_gla_shipping_times\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_mailpoet_automations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:27:\"wp_mailpoet_automation_runs\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:31:\"wp_mailpoet_automation_run_logs\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:35:\"wp_mailpoet_automation_run_subjects\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:31:\"wp_mailpoet_automation_triggers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:31:\"wp_mailpoet_automation_versions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:25:\"wp_mailpoet_custom_fields\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:35:\"wp_mailpoet_dynamic_segment_filters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:25:\"wp_mailpoet_feature_flags\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:17:\"wp_mailpoet_forms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:15:\"wp_mailpoet_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:22:\"wp_mailpoet_migrations\";a:3:{s:14:\"inaccurateRows\";i:35;s:12:\"insertedRows\";i:35;s:4:\"size\";i:32768;}s:23:\"wp_mailpoet_newsletters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:28:\"wp_mailpoet_newsletter_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:29:\"wp_mailpoet_newsletter_option\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:36:\"wp_mailpoet_newsletter_option_fields\";a:3:{s:14:\"inaccurateRows\";i:31;s:12:\"insertedRows\";i:31;s:4:\"size\";i:32768;}s:28:\"wp_mailpoet_newsletter_posts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:30:\"wp_mailpoet_newsletter_segment\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:32:\"wp_mailpoet_newsletter_templates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:27:\"wp_mailpoet_scheduled_tasks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:38:\"wp_mailpoet_scheduled_task_subscribers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:20:\"wp_mailpoet_segments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:2;s:4:\"size\";i:49152;}s:26:\"wp_mailpoet_sending_queues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:20:\"wp_mailpoet_settings\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:30:\"wp_mailpoet_statistics_bounces\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:29:\"wp_mailpoet_statistics_clicks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:28:\"wp_mailpoet_statistics_forms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:34:\"wp_mailpoet_statistics_newsletters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:28:\"wp_mailpoet_statistics_opens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:35:\"wp_mailpoet_statistics_unsubscribes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:44:\"wp_mailpoet_statistics_woocommerce_purchases\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:31:\"wp_mailpoet_stats_notifications\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:23:\"wp_mailpoet_subscribers\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:262144;}s:35:\"wp_mailpoet_subscriber_custom_field\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:26:\"wp_mailpoet_subscriber_ips\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:30:\"wp_mailpoet_subscriber_segment\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:2;s:4:\"size\";i:49152;}s:26:\"wp_mailpoet_subscriber_tag\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:16:\"wp_mailpoet_tags\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_mailpoet_user_agents\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:22:\"wp_mailpoet_user_flags\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:25:\"wp_nextend2_image_storage\";a:3:{s:14:\"inaccurateRows\";i:9;s:12:\"insertedRows\";i:12;s:4:\"size\";i:32768;}s:27:\"wp_nextend2_section_storage\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:10;s:4:\"size\";i:114688;}s:35:\"wp_nextend2_smartslider3_generators\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:32:\"wp_nextend2_smartslider3_sliders\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:131072;}s:37:\"wp_nextend2_smartslider3_sliders_xref\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:3;s:4:\"size\";i:32768;}s:31:\"wp_nextend2_smartslider3_slides\";a:3:{s:14:\"inaccurateRows\";i:11;s:12:\"insertedRows\";i:11;s:4:\"size\";i:212992;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:627;s:12:\"insertedRows\";i:645;s:4:\"size\";i:5373952;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:7963;s:12:\"insertedRows\";i:7719;s:4:\"size\";i:43843584;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:2575;s:12:\"insertedRows\";i:2784;s:4:\"size\";i:45793280;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:20;s:12:\"insertedRows\";i:23;s:4:\"size\";i:49152;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:38;s:12:\"insertedRows\";i:36;s:4:\"size\";i:32768;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:22;s:12:\"insertedRows\";i:23;s:4:\"size\";i:49152;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:44;s:12:\"insertedRows\";i:44;s:4:\"size\";i:49152;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:17:\"wp_wc_admin_notes\";a:3:{s:14:\"inaccurateRows\";i:57;s:12:\"insertedRows\";i:88;s:4:\"size\";i:65536;}s:24:\"wp_wc_admin_note_actions\";a:3:{s:14:\"inaccurateRows\";i:116;s:12:\"insertedRows\";i:116;s:4:\"size\";i:65536;}s:21:\"wp_wc_category_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:21:\"wp_wc_customer_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:18:\"wp_wc_download_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:12:\"wp_wc_orders\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:0;s:4:\"size\";i:131072;}s:17:\"wp_wc_orders_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"wp_wc_order_addresses\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:25:\"wp_wc_order_coupon_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:28:\"wp_wc_order_operational_data\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:26:\"wp_wc_order_product_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:17:\"wp_wc_order_stats\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:22:\"wp_wc_order_tax_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:31:\"wp_wc_product_attributes_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:34:\"wp_wc_product_download_directories\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:25:\"wp_wc_product_meta_lookup\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:9;s:4:\"size\";i:131072;}s:17:\"wp_wc_rate_limits\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:20:\"wp_wc_reserved_stock\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:22:\"wp_wc_tax_rate_classes\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:14:\"wp_wc_webhooks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_woocommerce_api_keys\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:35:\"wp_woocommerce_attribute_taxonomies\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:47:\"wp_woocommerce_downloadable_product_permissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:18:\"wp_woocommerce_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:29:\"wp_woocommerce_order_itemmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:26:\"wp_woocommerce_order_items\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:32:\"wp_woocommerce_payment_tokenmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:29:\"wp_woocommerce_payment_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_woocommerce_sessions\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:29:\"wp_woocommerce_shipping_zones\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:38:\"wp_woocommerce_shipping_zone_locations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:36:\"wp_woocommerce_shipping_zone_methods\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:24:\"wp_woocommerce_tax_rates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:33:\"wp_woocommerce_tax_rate_locations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:15:\"wp_wpforms_logs\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:19:\"wp_wpforms_payments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:163840;}s:23:\"wp_wpforms_payment_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:21:\"wp_wpforms_tasks_meta\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:16384;}s:18:\"wp_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:27;s:12:\"insertedRows\";i:27;s:4:\"size\";i:114688;}s:28:\"wp_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:20;s:12:\"insertedRows\";i:22;s:4:\"size\";i:65536;}s:19:\"wp_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:24;s:12:\"insertedRows\";i:24;s:4:\"size\";i:32768;}s:21:\"wp_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:18:\"wp_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:28;s:12:\"insertedRows\";i:28;s:4:\"size\";i:49152;}}s:19:\"lowerCaseTableNames\";i:2;s:8:\"dbEngine\";s:7:\"MariaDB\";s:7:\"version\";s:7:\"10.4.28\";s:14:\"versionComment\";s:19:\"Source distribution\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:164:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/backups-dup-lite/tmp/20251122_demoiselleenvadrouille_440c2385ce2aff544808_20251122180638_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-22 18:06:38\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:7:\"10.4.28\";s:10:\"VersionPHP\";s:6:\"8.0.28\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:31:\"20251122_demoiselleenvadrouille\";s:4:\"Hash\";s:35:\"440c2385ce2aff544808_20251122180638\";s:8:\"NameHash\";s:67:\"20251122_demoiselleenvadrouille_440c2385ce2aff544808_20251122180638\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:240;s:13:\"BuildProgress\";r:732;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("2", "20251122_demoiselleenvadrouille", "72fcf9d77ce1f11b5799_20251122182849", "20", "2025-11-22 18:29:00", "nellb", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-22 18:28:49\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:7:\"10.4.28\";s:10:\"VersionPHP\";s:6:\"8.0.28\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:2;s:4:\"Name\";s:31:\"20251122_demoiselleenvadrouille\";s:4:\"Hash\";s:35:\"72fcf9d77ce1f11b5799_20251122182849\";s:8:\"NameHash\";s:67:\"20251122_demoiselleenvadrouille_72fcf9d77ce1f11b5799_20251122182849\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:77:\"20251122_demoiselleenvadrouille_72fcf9d77ce1f11b5799_20251122182849_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.5\";s:6:\"WPUser\";s:5:\"nellb\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:79:\"20251122_demoiselleenvadrouille_72fcf9d77ce1f11b5799_20251122182849_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:51:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:5672;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:44422;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-22 18:28:49\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:7:\"10.4.28\";s:10:\"VersionPHP\";s:6:\"8.0.28\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:31:\"20251122_demoiselleenvadrouille\";s:4:\"Hash\";s:35:\"72fcf9d77ce1f11b5799_20251122182849\";s:8:\"NameHash\";s:67:\"20251122_demoiselleenvadrouille_72fcf9d77ce1f11b5799_20251122182849\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:85:\"20251122_demoiselleenvadrouille_72fcf9d77ce1f11b5799_20251122182849_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:65:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:80:\"20251122_demoiselleenvadrouille_72fcf9d77ce1f11b5799_20251122182849_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:164:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/backups-dup-lite/tmp/20251122_demoiselleenvadrouille_72fcf9d77ce1f11b5799_20251122182849_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:60:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-admin\";i:1;s:63:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-includes\";i:2;s:72:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:51:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger\";i:1;s:51:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger\";i:2;s:62:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content\";i:3;s:70:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/uploads\";i:4;s:70:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/plugins\";i:5;s:73:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/mu-plugins\";i:6;s:69:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:83:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_gla_budget_recommendations */
INSERT INTO `wp_gla_budget_recommendations` VALUES("1", "AED", "US", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2", "AED", "CH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3", "AED", "AU", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4", "AED", "GB", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("5", "AED", "DE", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("6", "AED", "DK", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("7", "AED", "AT", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("8", "AED", "NO", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("9", "AED", "CA", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("10", "AED", "NL", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("11", "AED", "SE", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("12", "AED", "IE", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("13", "AED", "BE", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("14", "AED", "FI", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("15", "AED", "FR", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("16", "AED", "NZ", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("17", "AED", "HK", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("18", "AED", "CZ", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("19", "AED", "SK", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("20", "AED", "AE", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("21", "AED", "SG", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("22", "AED", "IL", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("23", "AED", "KW", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("24", "AED", "IT", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("25", "AED", "JP", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("26", "AED", "ES", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("27", "AED", "VE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("28", "AED", "HU", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("29", "AED", "PT", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("30", "AED", "GR", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("31", "AED", "KR", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("32", "AED", "TW", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("33", "AED", "PL", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("34", "AED", "ZM", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("35", "AED", "PR", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("36", "AED", "CI", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("37", "AED", "RO", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("38", "AED", "BH", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("39", "AED", "PA", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("40", "AED", "GH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("41", "AED", "KH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("42", "AED", "SN", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("43", "AED", "SA", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("44", "AED", "RU", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("45", "AED", "UG", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("46", "AED", "BR", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("47", "AED", "NI", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("48", "AED", "MG", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("49", "AED", "DO", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("50", "AED", "MX", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("51", "AED", "OM", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("52", "AED", "CM", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("53", "AED", "ZA", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("54", "AED", "CL", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("55", "AED", "KE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("56", "AED", "NP", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("57", "AED", "PE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("58", "AED", "UA", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("59", "AED", "MZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("60", "AED", "TZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("61", "AED", "AO", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("62", "AED", "JO", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("63", "AED", "ZW", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("64", "AED", "TR", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("65", "AED", "MU", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("66", "AED", "SV", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("67", "AED", "TH", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("68", "AED", "CO", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("69", "AED", "LK", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("70", "AED", "CR", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("71", "AED", "AR", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("72", "AED", "MA", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("73", "AED", "MY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("74", "AED", "KZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("75", "AED", "DZ", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("76", "AED", "ID", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("77", "AED", "NG", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("78", "AED", "GT", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("79", "AED", "VN", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("80", "AED", "BY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("81", "AED", "EG", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("82", "AED", "UY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("83", "AED", "BD", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("84", "AED", "PK", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("85", "AED", "PH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("86", "AED", "ET", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("87", "AED", "TN", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("88", "AED", "LB", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("89", "AED", "IN", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("90", "AED", "PY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("91", "AED", "UZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("92", "AED", "EC", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("93", "AED", "MM", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("94", "AED", "GE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("95", "ARS", "US", "5347");
INSERT INTO `wp_gla_budget_recommendations` VALUES("96", "ARS", "CH", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("97", "ARS", "AU", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("98", "ARS", "GB", "6238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("99", "ARS", "DE", "6238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("100", "ARS", "DK", "4991");
INSERT INTO `wp_gla_budget_recommendations` VALUES("101", "ARS", "AT", "4278");
INSERT INTO `wp_gla_budget_recommendations` VALUES("102", "ARS", "NO", "4278");
INSERT INTO `wp_gla_budget_recommendations` VALUES("103", "ARS", "CA", "4991");
INSERT INTO `wp_gla_budget_recommendations` VALUES("104", "ARS", "NL", "4991");
INSERT INTO `wp_gla_budget_recommendations` VALUES("105", "ARS", "SE", "4991");
INSERT INTO `wp_gla_budget_recommendations` VALUES("106", "ARS", "IE", "3921");
INSERT INTO `wp_gla_budget_recommendations` VALUES("107", "ARS", "BE", "3921");
INSERT INTO `wp_gla_budget_recommendations` VALUES("108", "ARS", "FI", "3921");
INSERT INTO `wp_gla_budget_recommendations` VALUES("109", "ARS", "FR", "4991");
INSERT INTO `wp_gla_budget_recommendations` VALUES("110", "ARS", "NZ", "4278");
INSERT INTO `wp_gla_budget_recommendations` VALUES("111", "ARS", "HK", "2139");
INSERT INTO `wp_gla_budget_recommendations` VALUES("112", "ARS", "CZ", "4278");
INSERT INTO `wp_gla_budget_recommendations` VALUES("113", "ARS", "SK", "3921");
INSERT INTO `wp_gla_budget_recommendations` VALUES("114", "ARS", "AE", "4991");
INSERT INTO `wp_gla_budget_recommendations` VALUES("115", "ARS", "SG", "4991");
INSERT INTO `wp_gla_budget_recommendations` VALUES("116", "ARS", "IL", "4991");
INSERT INTO `wp_gla_budget_recommendations` VALUES("117", "ARS", "KW", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("118", "ARS", "IT", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("119", "ARS", "JP", "6238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("120", "ARS", "ES", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("121", "ARS", "VE", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("122", "ARS", "HU", "3921");
INSERT INTO `wp_gla_budget_recommendations` VALUES("123", "ARS", "PT", "4278");
INSERT INTO `wp_gla_budget_recommendations` VALUES("124", "ARS", "GR", "4278");
INSERT INTO `wp_gla_budget_recommendations` VALUES("125", "ARS", "KR", "2139");
INSERT INTO `wp_gla_budget_recommendations` VALUES("126", "ARS", "TW", "4278");
INSERT INTO `wp_gla_budget_recommendations` VALUES("127", "ARS", "PL", "1961");
INSERT INTO `wp_gla_budget_recommendations` VALUES("128", "ARS", "ZM", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("129", "ARS", "PR", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("130", "ARS", "CI", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("131", "ARS", "RO", "3921");
INSERT INTO `wp_gla_budget_recommendations` VALUES("132", "ARS", "BH", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("133", "ARS", "PA", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("134", "ARS", "GH", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("135", "ARS", "KH", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("136", "ARS", "SN", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("137", "ARS", "SA", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("138", "ARS", "RU", "4991");
INSERT INTO `wp_gla_budget_recommendations` VALUES("139", "ARS", "UG", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("140", "ARS", "BR", "1961");
INSERT INTO `wp_gla_budget_recommendations` VALUES("141", "ARS", "NI", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("142", "ARS", "MG", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("143", "ARS", "DO", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("144", "ARS", "MX", "2139");
INSERT INTO `wp_gla_budget_recommendations` VALUES("145", "ARS", "OM", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("146", "ARS", "CM", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("147", "ARS", "ZA", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("148", "ARS", "CL", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("149", "ARS", "KE", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("150", "ARS", "NP", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("151", "ARS", "PE", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("152", "ARS", "UA", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("153", "ARS", "MZ", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("154", "ARS", "TZ", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("155", "ARS", "AO", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("156", "ARS", "JO", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("157", "ARS", "ZW", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("158", "ARS", "TR", "3921");
INSERT INTO `wp_gla_budget_recommendations` VALUES("159", "ARS", "MU", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("160", "ARS", "SV", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("161", "ARS", "TH", "2139");
INSERT INTO `wp_gla_budget_recommendations` VALUES("162", "ARS", "CO", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("163", "ARS", "LK", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("164", "ARS", "CR", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("165", "ARS", "AR", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("166", "ARS", "MA", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("167", "ARS", "MY", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("168", "ARS", "KZ", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("169", "ARS", "DZ", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("170", "ARS", "ID", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("171", "ARS", "NG", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("172", "ARS", "GT", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("173", "ARS", "VN", "1961");
INSERT INTO `wp_gla_budget_recommendations` VALUES("174", "ARS", "BY", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("175", "ARS", "EG", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("176", "ARS", "UY", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("177", "ARS", "BD", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("178", "ARS", "PK", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("179", "ARS", "PH", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("180", "ARS", "ET", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("181", "ARS", "TN", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("182", "ARS", "LB", "2317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("183", "ARS", "IN", "1961");
INSERT INTO `wp_gla_budget_recommendations` VALUES("184", "ARS", "PY", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("185", "ARS", "UZ", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("186", "ARS", "EC", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("187", "ARS", "MM", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("188", "ARS", "GE", "4812");
INSERT INTO `wp_gla_budget_recommendations` VALUES("189", "AUD", "US", "23");
INSERT INTO `wp_gla_budget_recommendations` VALUES("190", "AUD", "CH", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("191", "AUD", "AU", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("192", "AUD", "GB", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("193", "AUD", "DE", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("194", "AUD", "DK", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("195", "AUD", "AT", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("196", "AUD", "NO", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("197", "AUD", "CA", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("198", "AUD", "NL", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("199", "AUD", "SE", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("200", "AUD", "IE", "17");
INSERT INTO `wp_gla_budget_recommendations` VALUES("201", "AUD", "BE", "17");
INSERT INTO `wp_gla_budget_recommendations` VALUES("202", "AUD", "FI", "17");
INSERT INTO `wp_gla_budget_recommendations` VALUES("203", "AUD", "FR", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("204", "AUD", "NZ", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("205", "AUD", "HK", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("206", "AUD", "CZ", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("207", "AUD", "SK", "17");
INSERT INTO `wp_gla_budget_recommendations` VALUES("208", "AUD", "AE", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("209", "AUD", "SG", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("210", "AUD", "IL", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("211", "AUD", "KW", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("212", "AUD", "IT", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("213", "AUD", "JP", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("214", "AUD", "ES", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("215", "AUD", "VE", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("216", "AUD", "HU", "17");
INSERT INTO `wp_gla_budget_recommendations` VALUES("217", "AUD", "PT", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("218", "AUD", "GR", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("219", "AUD", "KR", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("220", "AUD", "TW", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("221", "AUD", "PL", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("222", "AUD", "ZM", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("223", "AUD", "PR", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("224", "AUD", "CI", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("225", "AUD", "RO", "17");
INSERT INTO `wp_gla_budget_recommendations` VALUES("226", "AUD", "BH", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("227", "AUD", "PA", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("228", "AUD", "GH", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("229", "AUD", "KH", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("230", "AUD", "SN", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("231", "AUD", "SA", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("232", "AUD", "RU", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("233", "AUD", "UG", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("234", "AUD", "BR", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("235", "AUD", "NI", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("236", "AUD", "MG", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("237", "AUD", "DO", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("238", "AUD", "MX", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("239", "AUD", "OM", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("240", "AUD", "CM", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("241", "AUD", "ZA", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("242", "AUD", "CL", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("243", "AUD", "KE", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("244", "AUD", "NP", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("245", "AUD", "PE", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("246", "AUD", "UA", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("247", "AUD", "MZ", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("248", "AUD", "TZ", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("249", "AUD", "AO", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("250", "AUD", "JO", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("251", "AUD", "ZW", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("252", "AUD", "TR", "17");
INSERT INTO `wp_gla_budget_recommendations` VALUES("253", "AUD", "MU", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("254", "AUD", "SV", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("255", "AUD", "TH", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("256", "AUD", "CO", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("257", "AUD", "LK", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("258", "AUD", "CR", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("259", "AUD", "AR", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("260", "AUD", "MA", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("261", "AUD", "MY", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("262", "AUD", "KZ", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("263", "AUD", "DZ", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("264", "AUD", "ID", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("265", "AUD", "NG", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("266", "AUD", "GT", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("267", "AUD", "VN", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("268", "AUD", "BY", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("269", "AUD", "EG", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("270", "AUD", "UY", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("271", "AUD", "BD", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("272", "AUD", "PK", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("273", "AUD", "PH", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("274", "AUD", "ET", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("275", "AUD", "TN", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("276", "AUD", "LB", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("277", "AUD", "IN", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("278", "AUD", "PY", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("279", "AUD", "UZ", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("280", "AUD", "EC", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("281", "AUD", "MM", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("282", "AUD", "GE", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("283", "BGN", "US", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("284", "BGN", "CH", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("285", "BGN", "AU", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("286", "BGN", "GB", "31");
INSERT INTO `wp_gla_budget_recommendations` VALUES("287", "BGN", "DE", "31");
INSERT INTO `wp_gla_budget_recommendations` VALUES("288", "BGN", "DK", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("289", "BGN", "AT", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("290", "BGN", "NO", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("291", "BGN", "CA", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("292", "BGN", "NL", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("293", "BGN", "SE", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("294", "BGN", "IE", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("295", "BGN", "BE", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("296", "BGN", "FI", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("297", "BGN", "FR", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("298", "BGN", "NZ", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("299", "BGN", "HK", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("300", "BGN", "CZ", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("301", "BGN", "SK", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("302", "BGN", "AE", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("303", "BGN", "SG", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("304", "BGN", "IL", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("305", "BGN", "KW", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("306", "BGN", "IT", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("307", "BGN", "JP", "31");
INSERT INTO `wp_gla_budget_recommendations` VALUES("308", "BGN", "ES", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("309", "BGN", "VE", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("310", "BGN", "HU", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("311", "BGN", "PT", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("312", "BGN", "GR", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("313", "BGN", "KR", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("314", "BGN", "TW", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("315", "BGN", "PL", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("316", "BGN", "ZM", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("317", "BGN", "PR", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("318", "BGN", "CI", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("319", "BGN", "RO", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("320", "BGN", "BH", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("321", "BGN", "PA", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("322", "BGN", "GH", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("323", "BGN", "KH", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("324", "BGN", "SN", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("325", "BGN", "SA", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("326", "BGN", "RU", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("327", "BGN", "UG", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("328", "BGN", "BR", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("329", "BGN", "NI", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("330", "BGN", "MG", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("331", "BGN", "DO", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("332", "BGN", "MX", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("333", "BGN", "OM", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("334", "BGN", "CM", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("335", "BGN", "ZA", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("336", "BGN", "CL", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("337", "BGN", "KE", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("338", "BGN", "NP", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("339", "BGN", "PE", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("340", "BGN", "UA", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("341", "BGN", "MZ", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("342", "BGN", "TZ", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("343", "BGN", "AO", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("344", "BGN", "JO", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("345", "BGN", "ZW", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("346", "BGN", "TR", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("347", "BGN", "MU", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("348", "BGN", "SV", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("349", "BGN", "TH", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("350", "BGN", "CO", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("351", "BGN", "LK", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("352", "BGN", "CR", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("353", "BGN", "AR", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("354", "BGN", "MA", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("355", "BGN", "MY", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("356", "BGN", "KZ", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("357", "BGN", "DZ", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("358", "BGN", "ID", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("359", "BGN", "NG", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("360", "BGN", "GT", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("361", "BGN", "VN", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("362", "BGN", "BY", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("363", "BGN", "EG", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("364", "BGN", "UY", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("365", "BGN", "BD", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("366", "BGN", "PK", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("367", "BGN", "PH", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("368", "BGN", "ET", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("369", "BGN", "TN", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("370", "BGN", "LB", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("371", "BGN", "IN", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("372", "BGN", "PY", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("373", "BGN", "UZ", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("374", "BGN", "EC", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("375", "BGN", "MM", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("376", "BGN", "GE", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("377", "BOB", "US", "104");
INSERT INTO `wp_gla_budget_recommendations` VALUES("378", "BOB", "CH", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("379", "BOB", "AU", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("380", "BOB", "GB", "121");
INSERT INTO `wp_gla_budget_recommendations` VALUES("381", "BOB", "DE", "121");
INSERT INTO `wp_gla_budget_recommendations` VALUES("382", "BOB", "DK", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("383", "BOB", "AT", "83");
INSERT INTO `wp_gla_budget_recommendations` VALUES("384", "BOB", "NO", "83");
INSERT INTO `wp_gla_budget_recommendations` VALUES("385", "BOB", "CA", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("386", "BOB", "NL", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("387", "BOB", "SE", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("388", "BOB", "IE", "76");
INSERT INTO `wp_gla_budget_recommendations` VALUES("389", "BOB", "BE", "76");
INSERT INTO `wp_gla_budget_recommendations` VALUES("390", "BOB", "FI", "76");
INSERT INTO `wp_gla_budget_recommendations` VALUES("391", "BOB", "FR", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("392", "BOB", "NZ", "83");
INSERT INTO `wp_gla_budget_recommendations` VALUES("393", "BOB", "HK", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("394", "BOB", "CZ", "83");
INSERT INTO `wp_gla_budget_recommendations` VALUES("395", "BOB", "SK", "76");
INSERT INTO `wp_gla_budget_recommendations` VALUES("396", "BOB", "AE", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("397", "BOB", "SG", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("398", "BOB", "IL", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("399", "BOB", "KW", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("400", "BOB", "IT", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("401", "BOB", "JP", "121");
INSERT INTO `wp_gla_budget_recommendations` VALUES("402", "BOB", "ES", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("403", "BOB", "VE", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("404", "BOB", "HU", "76");
INSERT INTO `wp_gla_budget_recommendations` VALUES("405", "BOB", "PT", "83");
INSERT INTO `wp_gla_budget_recommendations` VALUES("406", "BOB", "GR", "83");
INSERT INTO `wp_gla_budget_recommendations` VALUES("407", "BOB", "KR", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("408", "BOB", "TW", "83");
INSERT INTO `wp_gla_budget_recommendations` VALUES("409", "BOB", "PL", "38");
INSERT INTO `wp_gla_budget_recommendations` VALUES("410", "BOB", "ZM", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("411", "BOB", "PR", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("412", "BOB", "CI", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("413", "BOB", "RO", "76");
INSERT INTO `wp_gla_budget_recommendations` VALUES("414", "BOB", "BH", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("415", "BOB", "PA", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("416", "BOB", "GH", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("417", "BOB", "KH", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("418", "BOB", "SN", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("419", "BOB", "SA", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("420", "BOB", "RU", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("421", "BOB", "UG", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("422", "BOB", "BR", "38");
INSERT INTO `wp_gla_budget_recommendations` VALUES("423", "BOB", "NI", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("424", "BOB", "MG", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("425", "BOB", "DO", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("426", "BOB", "MX", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("427", "BOB", "OM", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("428", "BOB", "CM", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("429", "BOB", "ZA", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("430", "BOB", "CL", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("431", "BOB", "KE", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("432", "BOB", "NP", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("433", "BOB", "PE", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("434", "BOB", "UA", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("435", "BOB", "MZ", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("436", "BOB", "TZ", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("437", "BOB", "AO", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("438", "BOB", "JO", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("439", "BOB", "ZW", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("440", "BOB", "TR", "76");
INSERT INTO `wp_gla_budget_recommendations` VALUES("441", "BOB", "MU", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("442", "BOB", "SV", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("443", "BOB", "TH", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("444", "BOB", "CO", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("445", "BOB", "LK", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("446", "BOB", "CR", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("447", "BOB", "AR", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("448", "BOB", "MA", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("449", "BOB", "MY", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("450", "BOB", "KZ", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("451", "BOB", "DZ", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("452", "BOB", "ID", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("453", "BOB", "NG", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("454", "BOB", "GT", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("455", "BOB", "VN", "38");
INSERT INTO `wp_gla_budget_recommendations` VALUES("456", "BOB", "BY", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("457", "BOB", "EG", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("458", "BOB", "UY", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("459", "BOB", "BD", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("460", "BOB", "PK", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("461", "BOB", "PH", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("462", "BOB", "ET", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("463", "BOB", "TN", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("464", "BOB", "LB", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("465", "BOB", "IN", "38");
INSERT INTO `wp_gla_budget_recommendations` VALUES("466", "BOB", "PY", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("467", "BOB", "UZ", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("468", "BOB", "EC", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("469", "BOB", "MM", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("470", "BOB", "GE", "93");
INSERT INTO `wp_gla_budget_recommendations` VALUES("471", "BRL", "US", "73");
INSERT INTO `wp_gla_budget_recommendations` VALUES("472", "BRL", "CH", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("473", "BRL", "AU", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("474", "BRL", "GB", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("475", "BRL", "DE", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("476", "BRL", "DK", "69");
INSERT INTO `wp_gla_budget_recommendations` VALUES("477", "BRL", "AT", "59");
INSERT INTO `wp_gla_budget_recommendations` VALUES("478", "BRL", "NO", "59");
INSERT INTO `wp_gla_budget_recommendations` VALUES("479", "BRL", "CA", "69");
INSERT INTO `wp_gla_budget_recommendations` VALUES("480", "BRL", "NL", "69");
INSERT INTO `wp_gla_budget_recommendations` VALUES("481", "BRL", "SE", "69");
INSERT INTO `wp_gla_budget_recommendations` VALUES("482", "BRL", "IE", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("483", "BRL", "BE", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("484", "BRL", "FI", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("485", "BRL", "FR", "69");
INSERT INTO `wp_gla_budget_recommendations` VALUES("486", "BRL", "NZ", "59");
INSERT INTO `wp_gla_budget_recommendations` VALUES("487", "BRL", "HK", "29");
INSERT INTO `wp_gla_budget_recommendations` VALUES("488", "BRL", "CZ", "59");
INSERT INTO `wp_gla_budget_recommendations` VALUES("489", "BRL", "SK", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("490", "BRL", "AE", "69");
INSERT INTO `wp_gla_budget_recommendations` VALUES("491", "BRL", "SG", "69");
INSERT INTO `wp_gla_budget_recommendations` VALUES("492", "BRL", "IL", "69");
INSERT INTO `wp_gla_budget_recommendations` VALUES("493", "BRL", "KW", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("494", "BRL", "IT", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("495", "BRL", "JP", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("496", "BRL", "ES", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("497", "BRL", "VE", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("498", "BRL", "HU", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("499", "BRL", "PT", "59");
INSERT INTO `wp_gla_budget_recommendations` VALUES("500", "BRL", "GR", "59");
INSERT INTO `wp_gla_budget_recommendations` VALUES("501", "BRL", "KR", "29");
INSERT INTO `wp_gla_budget_recommendations` VALUES("502", "BRL", "TW", "59");
INSERT INTO `wp_gla_budget_recommendations` VALUES("503", "BRL", "PL", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("504", "BRL", "ZM", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("505", "BRL", "PR", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("506", "BRL", "CI", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("507", "BRL", "RO", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("508", "BRL", "BH", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("509", "BRL", "PA", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("510", "BRL", "GH", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("511", "BRL", "KH", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("512", "BRL", "SN", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("513", "BRL", "SA", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("514", "BRL", "RU", "69");
INSERT INTO `wp_gla_budget_recommendations` VALUES("515", "BRL", "UG", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("516", "BRL", "BR", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("517", "BRL", "NI", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("518", "BRL", "MG", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("519", "BRL", "DO", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("520", "BRL", "MX", "29");
INSERT INTO `wp_gla_budget_recommendations` VALUES("521", "BRL", "OM", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("522", "BRL", "CM", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("523", "BRL", "ZA", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("524", "BRL", "CL", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("525", "BRL", "KE", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("526", "BRL", "NP", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("527", "BRL", "PE", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("528", "BRL", "UA", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("529", "BRL", "MZ", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("530", "BRL", "TZ", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("531", "BRL", "AO", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("532", "BRL", "JO", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("533", "BRL", "ZW", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("534", "BRL", "TR", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("535", "BRL", "MU", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("536", "BRL", "SV", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("537", "BRL", "TH", "29");
INSERT INTO `wp_gla_budget_recommendations` VALUES("538", "BRL", "CO", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("539", "BRL", "LK", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("540", "BRL", "CR", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("541", "BRL", "AR", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("542", "BRL", "MA", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("543", "BRL", "MY", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("544", "BRL", "KZ", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("545", "BRL", "DZ", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("546", "BRL", "ID", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("547", "BRL", "NG", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("548", "BRL", "GT", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("549", "BRL", "VN", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("550", "BRL", "BY", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("551", "BRL", "EG", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("552", "BRL", "UY", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("553", "BRL", "BD", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("554", "BRL", "PK", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("555", "BRL", "PH", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("556", "BRL", "ET", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("557", "BRL", "TN", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("558", "BRL", "LB", "32");
INSERT INTO `wp_gla_budget_recommendations` VALUES("559", "BRL", "IN", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("560", "BRL", "PY", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("561", "BRL", "UZ", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("562", "BRL", "EC", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("563", "BRL", "MM", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("564", "BRL", "GE", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("565", "CAD", "US", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("566", "CAD", "CH", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("567", "CAD", "AU", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("568", "CAD", "GB", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("569", "CAD", "DE", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("570", "CAD", "DK", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("571", "CAD", "AT", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("572", "CAD", "NO", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("573", "CAD", "CA", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("574", "CAD", "NL", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("575", "CAD", "SE", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("576", "CAD", "IE", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("577", "CAD", "BE", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("578", "CAD", "FI", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("579", "CAD", "FR", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("580", "CAD", "NZ", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("581", "CAD", "HK", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("582", "CAD", "CZ", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("583", "CAD", "SK", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("584", "CAD", "AE", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("585", "CAD", "SG", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("586", "CAD", "IL", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("587", "CAD", "KW", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("588", "CAD", "IT", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("589", "CAD", "JP", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("590", "CAD", "ES", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("591", "CAD", "VE", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("592", "CAD", "HU", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("593", "CAD", "PT", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("594", "CAD", "GR", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("595", "CAD", "KR", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("596", "CAD", "TW", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("597", "CAD", "PL", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("598", "CAD", "ZM", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("599", "CAD", "PR", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("600", "CAD", "CI", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("601", "CAD", "RO", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("602", "CAD", "BH", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("603", "CAD", "PA", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("604", "CAD", "GH", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("605", "CAD", "KH", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("606", "CAD", "SN", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("607", "CAD", "SA", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("608", "CAD", "RU", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("609", "CAD", "UG", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("610", "CAD", "BR", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("611", "CAD", "NI", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("612", "CAD", "MG", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("613", "CAD", "DO", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("614", "CAD", "MX", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("615", "CAD", "OM", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("616", "CAD", "CM", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("617", "CAD", "ZA", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("618", "CAD", "CL", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("619", "CAD", "KE", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("620", "CAD", "NP", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("621", "CAD", "PE", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("622", "CAD", "UA", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("623", "CAD", "MZ", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("624", "CAD", "TZ", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("625", "CAD", "AO", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("626", "CAD", "JO", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("627", "CAD", "ZW", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("628", "CAD", "TR", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("629", "CAD", "MU", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("630", "CAD", "SV", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("631", "CAD", "TH", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("632", "CAD", "CO", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("633", "CAD", "LK", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("634", "CAD", "CR", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("635", "CAD", "AR", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("636", "CAD", "MA", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("637", "CAD", "MY", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("638", "CAD", "KZ", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("639", "CAD", "DZ", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("640", "CAD", "ID", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("641", "CAD", "NG", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("642", "CAD", "GT", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("643", "CAD", "VN", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("644", "CAD", "BY", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("645", "CAD", "EG", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("646", "CAD", "UY", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("647", "CAD", "BD", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("648", "CAD", "PK", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("649", "CAD", "PH", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("650", "CAD", "ET", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("651", "CAD", "TN", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("652", "CAD", "LB", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("653", "CAD", "IN", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("654", "CAD", "PY", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("655", "CAD", "UZ", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("656", "CAD", "EC", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("657", "CAD", "MM", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("658", "CAD", "GE", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("659", "CHF", "US", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("660", "CHF", "CH", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("661", "CHF", "AU", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("662", "CHF", "GB", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("663", "CHF", "DE", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("664", "CHF", "DK", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("665", "CHF", "AT", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("666", "CHF", "NO", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("667", "CHF", "CA", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("668", "CHF", "NL", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("669", "CHF", "SE", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("670", "CHF", "IE", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("671", "CHF", "BE", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("672", "CHF", "FI", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("673", "CHF", "FR", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("674", "CHF", "NZ", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("675", "CHF", "HK", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("676", "CHF", "CZ", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("677", "CHF", "SK", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("678", "CHF", "AE", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("679", "CHF", "SG", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("680", "CHF", "IL", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("681", "CHF", "KW", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("682", "CHF", "IT", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("683", "CHF", "JP", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("684", "CHF", "ES", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("685", "CHF", "VE", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("686", "CHF", "HU", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("687", "CHF", "PT", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("688", "CHF", "GR", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("689", "CHF", "KR", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("690", "CHF", "TW", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("691", "CHF", "PL", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("692", "CHF", "ZM", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("693", "CHF", "PR", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("694", "CHF", "CI", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("695", "CHF", "RO", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("696", "CHF", "BH", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("697", "CHF", "PA", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("698", "CHF", "GH", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("699", "CHF", "KH", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("700", "CHF", "SN", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("701", "CHF", "SA", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("702", "CHF", "RU", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("703", "CHF", "UG", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("704", "CHF", "BR", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("705", "CHF", "NI", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("706", "CHF", "MG", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("707", "CHF", "DO", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("708", "CHF", "MX", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("709", "CHF", "OM", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("710", "CHF", "CM", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("711", "CHF", "ZA", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("712", "CHF", "CL", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("713", "CHF", "KE", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("714", "CHF", "NP", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("715", "CHF", "PE", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("716", "CHF", "UA", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("717", "CHF", "MZ", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("718", "CHF", "TZ", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("719", "CHF", "AO", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("720", "CHF", "JO", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("721", "CHF", "ZW", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("722", "CHF", "TR", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("723", "CHF", "MU", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("724", "CHF", "SV", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("725", "CHF", "TH", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("726", "CHF", "CO", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("727", "CHF", "LK", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("728", "CHF", "CR", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("729", "CHF", "AR", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("730", "CHF", "MA", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("731", "CHF", "MY", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("732", "CHF", "KZ", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("733", "CHF", "DZ", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("734", "CHF", "ID", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("735", "CHF", "NG", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("736", "CHF", "GT", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("737", "CHF", "VN", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("738", "CHF", "BY", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("739", "CHF", "EG", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("740", "CHF", "UY", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("741", "CHF", "BD", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("742", "CHF", "PK", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("743", "CHF", "PH", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("744", "CHF", "ET", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("745", "CHF", "TN", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("746", "CHF", "LB", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("747", "CHF", "IN", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("748", "CHF", "PY", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("749", "CHF", "UZ", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("750", "CHF", "EC", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("751", "CHF", "MM", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("752", "CHF", "GE", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("753", "CLP", "US", "13081");
INSERT INTO `wp_gla_budget_recommendations` VALUES("754", "CLP", "CH", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("755", "CLP", "AU", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("756", "CLP", "GB", "15261");
INSERT INTO `wp_gla_budget_recommendations` VALUES("757", "CLP", "DE", "15261");
INSERT INTO `wp_gla_budget_recommendations` VALUES("758", "CLP", "DK", "12209");
INSERT INTO `wp_gla_budget_recommendations` VALUES("759", "CLP", "AT", "10464");
INSERT INTO `wp_gla_budget_recommendations` VALUES("760", "CLP", "NO", "10464");
INSERT INTO `wp_gla_budget_recommendations` VALUES("761", "CLP", "CA", "12209");
INSERT INTO `wp_gla_budget_recommendations` VALUES("762", "CLP", "NL", "12209");
INSERT INTO `wp_gla_budget_recommendations` VALUES("763", "CLP", "SE", "12209");
INSERT INTO `wp_gla_budget_recommendations` VALUES("764", "CLP", "IE", "9592");
INSERT INTO `wp_gla_budget_recommendations` VALUES("765", "CLP", "BE", "9592");
INSERT INTO `wp_gla_budget_recommendations` VALUES("766", "CLP", "FI", "9592");
INSERT INTO `wp_gla_budget_recommendations` VALUES("767", "CLP", "FR", "12209");
INSERT INTO `wp_gla_budget_recommendations` VALUES("768", "CLP", "NZ", "10464");
INSERT INTO `wp_gla_budget_recommendations` VALUES("769", "CLP", "HK", "5232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("770", "CLP", "CZ", "10464");
INSERT INTO `wp_gla_budget_recommendations` VALUES("771", "CLP", "SK", "9592");
INSERT INTO `wp_gla_budget_recommendations` VALUES("772", "CLP", "AE", "12209");
INSERT INTO `wp_gla_budget_recommendations` VALUES("773", "CLP", "SG", "12209");
INSERT INTO `wp_gla_budget_recommendations` VALUES("774", "CLP", "IL", "12209");
INSERT INTO `wp_gla_budget_recommendations` VALUES("775", "CLP", "KW", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("776", "CLP", "IT", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("777", "CLP", "JP", "15261");
INSERT INTO `wp_gla_budget_recommendations` VALUES("778", "CLP", "ES", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("779", "CLP", "VE", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("780", "CLP", "HU", "9592");
INSERT INTO `wp_gla_budget_recommendations` VALUES("781", "CLP", "PT", "10464");
INSERT INTO `wp_gla_budget_recommendations` VALUES("782", "CLP", "GR", "10464");
INSERT INTO `wp_gla_budget_recommendations` VALUES("783", "CLP", "KR", "5232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("784", "CLP", "TW", "10464");
INSERT INTO `wp_gla_budget_recommendations` VALUES("785", "CLP", "PL", "4796");
INSERT INTO `wp_gla_budget_recommendations` VALUES("786", "CLP", "ZM", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("787", "CLP", "PR", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("788", "CLP", "CI", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("789", "CLP", "RO", "9592");
INSERT INTO `wp_gla_budget_recommendations` VALUES("790", "CLP", "BH", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("791", "CLP", "PA", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("792", "CLP", "GH", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("793", "CLP", "KH", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("794", "CLP", "SN", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("795", "CLP", "SA", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("796", "CLP", "RU", "12209");
INSERT INTO `wp_gla_budget_recommendations` VALUES("797", "CLP", "UG", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("798", "CLP", "BR", "4796");
INSERT INTO `wp_gla_budget_recommendations` VALUES("799", "CLP", "NI", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("800", "CLP", "MG", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("801", "CLP", "DO", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("802", "CLP", "MX", "5232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("803", "CLP", "OM", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("804", "CLP", "CM", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("805", "CLP", "ZA", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("806", "CLP", "CL", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("807", "CLP", "KE", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("808", "CLP", "NP", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("809", "CLP", "PE", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("810", "CLP", "UA", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("811", "CLP", "MZ", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("812", "CLP", "TZ", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("813", "CLP", "AO", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("814", "CLP", "JO", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("815", "CLP", "ZW", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("816", "CLP", "TR", "9592");
INSERT INTO `wp_gla_budget_recommendations` VALUES("817", "CLP", "MU", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("818", "CLP", "SV", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("819", "CLP", "TH", "5232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("820", "CLP", "CO", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("821", "CLP", "LK", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("822", "CLP", "CR", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("823", "CLP", "AR", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("824", "CLP", "MA", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("825", "CLP", "MY", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("826", "CLP", "KZ", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("827", "CLP", "DZ", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("828", "CLP", "ID", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("829", "CLP", "NG", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("830", "CLP", "GT", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("831", "CLP", "VN", "4796");
INSERT INTO `wp_gla_budget_recommendations` VALUES("832", "CLP", "BY", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("833", "CLP", "EG", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("834", "CLP", "UY", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("835", "CLP", "BD", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("836", "CLP", "PK", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("837", "CLP", "PH", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("838", "CLP", "ET", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("839", "CLP", "TN", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("840", "CLP", "LB", "5668");
INSERT INTO `wp_gla_budget_recommendations` VALUES("841", "CLP", "IN", "4796");
INSERT INTO `wp_gla_budget_recommendations` VALUES("842", "CLP", "PY", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("843", "CLP", "UZ", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("844", "CLP", "EC", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("845", "CLP", "MM", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("846", "CLP", "GE", "11773");
INSERT INTO `wp_gla_budget_recommendations` VALUES("847", "CNY", "US", "107");
INSERT INTO `wp_gla_budget_recommendations` VALUES("848", "CNY", "CH", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("849", "CNY", "AU", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("850", "CNY", "GB", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("851", "CNY", "DE", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("852", "CNY", "DK", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("853", "CNY", "AT", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("854", "CNY", "NO", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("855", "CNY", "CA", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("856", "CNY", "NL", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("857", "CNY", "SE", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("858", "CNY", "IE", "79");
INSERT INTO `wp_gla_budget_recommendations` VALUES("859", "CNY", "BE", "79");
INSERT INTO `wp_gla_budget_recommendations` VALUES("860", "CNY", "FI", "79");
INSERT INTO `wp_gla_budget_recommendations` VALUES("861", "CNY", "FR", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("862", "CNY", "NZ", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("863", "CNY", "HK", "43");
INSERT INTO `wp_gla_budget_recommendations` VALUES("864", "CNY", "CZ", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("865", "CNY", "SK", "79");
INSERT INTO `wp_gla_budget_recommendations` VALUES("866", "CNY", "AE", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("867", "CNY", "SG", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("868", "CNY", "IL", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("869", "CNY", "KW", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("870", "CNY", "IT", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("871", "CNY", "JP", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("872", "CNY", "ES", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("873", "CNY", "VE", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("874", "CNY", "HU", "79");
INSERT INTO `wp_gla_budget_recommendations` VALUES("875", "CNY", "PT", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("876", "CNY", "GR", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("877", "CNY", "KR", "43");
INSERT INTO `wp_gla_budget_recommendations` VALUES("878", "CNY", "TW", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("879", "CNY", "PL", "39");
INSERT INTO `wp_gla_budget_recommendations` VALUES("880", "CNY", "ZM", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("881", "CNY", "PR", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("882", "CNY", "CI", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("883", "CNY", "RO", "79");
INSERT INTO `wp_gla_budget_recommendations` VALUES("884", "CNY", "BH", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("885", "CNY", "PA", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("886", "CNY", "GH", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("887", "CNY", "KH", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("888", "CNY", "SN", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("889", "CNY", "SA", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("890", "CNY", "RU", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("891", "CNY", "UG", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("892", "CNY", "BR", "39");
INSERT INTO `wp_gla_budget_recommendations` VALUES("893", "CNY", "NI", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("894", "CNY", "MG", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("895", "CNY", "DO", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("896", "CNY", "MX", "43");
INSERT INTO `wp_gla_budget_recommendations` VALUES("897", "CNY", "OM", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("898", "CNY", "CM", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("899", "CNY", "ZA", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("900", "CNY", "CL", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("901", "CNY", "KE", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("902", "CNY", "NP", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("903", "CNY", "PE", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("904", "CNY", "UA", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("905", "CNY", "MZ", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("906", "CNY", "TZ", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("907", "CNY", "AO", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("908", "CNY", "JO", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("909", "CNY", "ZW", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("910", "CNY", "TR", "79");
INSERT INTO `wp_gla_budget_recommendations` VALUES("911", "CNY", "MU", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("912", "CNY", "SV", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("913", "CNY", "TH", "43");
INSERT INTO `wp_gla_budget_recommendations` VALUES("914", "CNY", "CO", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("915", "CNY", "LK", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("916", "CNY", "CR", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("917", "CNY", "AR", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("918", "CNY", "MA", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("919", "CNY", "MY", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("920", "CNY", "KZ", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("921", "CNY", "DZ", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("922", "CNY", "ID", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("923", "CNY", "NG", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("924", "CNY", "GT", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("925", "CNY", "VN", "39");
INSERT INTO `wp_gla_budget_recommendations` VALUES("926", "CNY", "BY", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("927", "CNY", "EG", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("928", "CNY", "UY", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("929", "CNY", "BD", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("930", "CNY", "PK", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("931", "CNY", "PH", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("932", "CNY", "ET", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("933", "CNY", "TN", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("934", "CNY", "LB", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("935", "CNY", "IN", "39");
INSERT INTO `wp_gla_budget_recommendations` VALUES("936", "CNY", "PY", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("937", "CNY", "UZ", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("938", "CNY", "EC", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("939", "CNY", "MM", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("940", "CNY", "GE", "97");
INSERT INTO `wp_gla_budget_recommendations` VALUES("941", "COP", "US", "61099");
INSERT INTO `wp_gla_budget_recommendations` VALUES("942", "COP", "CH", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("943", "COP", "AU", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("944", "COP", "GB", "71282");
INSERT INTO `wp_gla_budget_recommendations` VALUES("945", "COP", "DE", "71282");
INSERT INTO `wp_gla_budget_recommendations` VALUES("946", "COP", "DK", "57026");
INSERT INTO `wp_gla_budget_recommendations` VALUES("947", "COP", "AT", "48879");
INSERT INTO `wp_gla_budget_recommendations` VALUES("948", "COP", "NO", "48879");
INSERT INTO `wp_gla_budget_recommendations` VALUES("949", "COP", "CA", "57026");
INSERT INTO `wp_gla_budget_recommendations` VALUES("950", "COP", "NL", "57026");
INSERT INTO `wp_gla_budget_recommendations` VALUES("951", "COP", "SE", "57026");
INSERT INTO `wp_gla_budget_recommendations` VALUES("952", "COP", "IE", "44806");
INSERT INTO `wp_gla_budget_recommendations` VALUES("953", "COP", "BE", "44806");
INSERT INTO `wp_gla_budget_recommendations` VALUES("954", "COP", "FI", "44806");
INSERT INTO `wp_gla_budget_recommendations` VALUES("955", "COP", "FR", "57026");
INSERT INTO `wp_gla_budget_recommendations` VALUES("956", "COP", "NZ", "48879");
INSERT INTO `wp_gla_budget_recommendations` VALUES("957", "COP", "HK", "24440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("958", "COP", "CZ", "48879");
INSERT INTO `wp_gla_budget_recommendations` VALUES("959", "COP", "SK", "44806");
INSERT INTO `wp_gla_budget_recommendations` VALUES("960", "COP", "AE", "57026");
INSERT INTO `wp_gla_budget_recommendations` VALUES("961", "COP", "SG", "57026");
INSERT INTO `wp_gla_budget_recommendations` VALUES("962", "COP", "IL", "57026");
INSERT INTO `wp_gla_budget_recommendations` VALUES("963", "COP", "KW", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("964", "COP", "IT", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("965", "COP", "JP", "71282");
INSERT INTO `wp_gla_budget_recommendations` VALUES("966", "COP", "ES", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("967", "COP", "VE", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("968", "COP", "HU", "44806");
INSERT INTO `wp_gla_budget_recommendations` VALUES("969", "COP", "PT", "48879");
INSERT INTO `wp_gla_budget_recommendations` VALUES("970", "COP", "GR", "48879");
INSERT INTO `wp_gla_budget_recommendations` VALUES("971", "COP", "KR", "24440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("972", "COP", "TW", "48879");
INSERT INTO `wp_gla_budget_recommendations` VALUES("973", "COP", "PL", "22403");
INSERT INTO `wp_gla_budget_recommendations` VALUES("974", "COP", "ZM", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("975", "COP", "PR", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("976", "COP", "CI", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("977", "COP", "RO", "44806");
INSERT INTO `wp_gla_budget_recommendations` VALUES("978", "COP", "BH", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("979", "COP", "PA", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("980", "COP", "GH", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("981", "COP", "KH", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("982", "COP", "SN", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("983", "COP", "SA", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("984", "COP", "RU", "57026");
INSERT INTO `wp_gla_budget_recommendations` VALUES("985", "COP", "UG", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("986", "COP", "BR", "22403");
INSERT INTO `wp_gla_budget_recommendations` VALUES("987", "COP", "NI", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("988", "COP", "MG", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("989", "COP", "DO", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("990", "COP", "MX", "24440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("991", "COP", "OM", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("992", "COP", "CM", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("993", "COP", "ZA", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("994", "COP", "CL", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("995", "COP", "KE", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("996", "COP", "NP", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("997", "COP", "PE", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("998", "COP", "UA", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("999", "COP", "MZ", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1000", "COP", "TZ", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1001", "COP", "AO", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1002", "COP", "JO", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1003", "COP", "ZW", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1004", "COP", "TR", "44806");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1005", "COP", "MU", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1006", "COP", "SV", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1007", "COP", "TH", "24440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1008", "COP", "CO", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1009", "COP", "LK", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1010", "COP", "CR", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1011", "COP", "AR", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1012", "COP", "MA", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1013", "COP", "MY", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1014", "COP", "KZ", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1015", "COP", "DZ", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1016", "COP", "ID", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1017", "COP", "NG", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1018", "COP", "GT", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1019", "COP", "VN", "22403");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1020", "COP", "BY", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1021", "COP", "EG", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1022", "COP", "UY", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1023", "COP", "BD", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1024", "COP", "PK", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1025", "COP", "PH", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1026", "COP", "ET", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1027", "COP", "TN", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1028", "COP", "LB", "26476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1029", "COP", "IN", "22403");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1030", "COP", "PY", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1031", "COP", "UZ", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1032", "COP", "EC", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1033", "COP", "MM", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1034", "COP", "GE", "54989");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1035", "CZK", "US", "337");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1036", "CZK", "CH", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1037", "CZK", "AU", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1038", "CZK", "GB", "393");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1039", "CZK", "DE", "393");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1040", "CZK", "DK", "314");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1041", "CZK", "AT", "269");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1042", "CZK", "NO", "269");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1043", "CZK", "CA", "314");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1044", "CZK", "NL", "314");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1045", "CZK", "SE", "314");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1046", "CZK", "IE", "247");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1047", "CZK", "BE", "247");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1048", "CZK", "FI", "247");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1049", "CZK", "FR", "314");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1050", "CZK", "NZ", "269");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1051", "CZK", "HK", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1052", "CZK", "CZ", "269");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1053", "CZK", "SK", "247");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1054", "CZK", "AE", "314");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1055", "CZK", "SG", "314");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1056", "CZK", "IL", "314");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1057", "CZK", "KW", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1058", "CZK", "IT", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1059", "CZK", "JP", "393");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1060", "CZK", "ES", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1061", "CZK", "VE", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1062", "CZK", "HU", "247");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1063", "CZK", "PT", "269");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1064", "CZK", "GR", "269");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1065", "CZK", "KR", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1066", "CZK", "TW", "269");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1067", "CZK", "PL", "124");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1068", "CZK", "ZM", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1069", "CZK", "PR", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1070", "CZK", "CI", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1071", "CZK", "RO", "247");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1072", "CZK", "BH", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1073", "CZK", "PA", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1074", "CZK", "GH", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1075", "CZK", "KH", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1076", "CZK", "SN", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1077", "CZK", "SA", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1078", "CZK", "RU", "314");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1079", "CZK", "UG", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1080", "CZK", "BR", "124");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1081", "CZK", "NI", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1082", "CZK", "MG", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1083", "CZK", "DO", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1084", "CZK", "MX", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1085", "CZK", "OM", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1086", "CZK", "CM", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1087", "CZK", "ZA", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1088", "CZK", "CL", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1089", "CZK", "KE", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1090", "CZK", "NP", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1091", "CZK", "PE", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1092", "CZK", "UA", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1093", "CZK", "MZ", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1094", "CZK", "TZ", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1095", "CZK", "AO", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1096", "CZK", "JO", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1097", "CZK", "ZW", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1098", "CZK", "TR", "247");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1099", "CZK", "MU", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1100", "CZK", "SV", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1101", "CZK", "TH", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1102", "CZK", "CO", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1103", "CZK", "LK", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1104", "CZK", "CR", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1105", "CZK", "AR", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1106", "CZK", "MA", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1107", "CZK", "MY", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1108", "CZK", "KZ", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1109", "CZK", "DZ", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1110", "CZK", "ID", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1111", "CZK", "NG", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1112", "CZK", "GT", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1113", "CZK", "VN", "124");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1114", "CZK", "BY", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1115", "CZK", "EG", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1116", "CZK", "UY", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1117", "CZK", "BD", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1118", "CZK", "PK", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1119", "CZK", "PH", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1120", "CZK", "ET", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1121", "CZK", "TN", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1122", "CZK", "LB", "146");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1123", "CZK", "IN", "124");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1124", "CZK", "PY", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1125", "CZK", "UZ", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1126", "CZK", "EC", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1127", "CZK", "MM", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1128", "CZK", "GE", "303");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1129", "DKK", "US", "103");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1130", "DKK", "CH", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1131", "DKK", "AU", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1132", "DKK", "GB", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1133", "DKK", "DE", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1134", "DKK", "DK", "96");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1135", "DKK", "AT", "82");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1136", "DKK", "NO", "82");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1137", "DKK", "CA", "96");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1138", "DKK", "NL", "96");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1139", "DKK", "SE", "96");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1140", "DKK", "IE", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1141", "DKK", "BE", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1142", "DKK", "FI", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1143", "DKK", "FR", "96");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1144", "DKK", "NZ", "82");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1145", "DKK", "HK", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1146", "DKK", "CZ", "82");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1147", "DKK", "SK", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1148", "DKK", "AE", "96");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1149", "DKK", "SG", "96");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1150", "DKK", "IL", "96");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1151", "DKK", "KW", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1152", "DKK", "IT", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1153", "DKK", "JP", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1154", "DKK", "ES", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1155", "DKK", "VE", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1156", "DKK", "HU", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1157", "DKK", "PT", "82");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1158", "DKK", "GR", "82");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1159", "DKK", "KR", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1160", "DKK", "TW", "82");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1161", "DKK", "PL", "38");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1162", "DKK", "ZM", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1163", "DKK", "PR", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1164", "DKK", "CI", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1165", "DKK", "RO", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1166", "DKK", "BH", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1167", "DKK", "PA", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1168", "DKK", "GH", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1169", "DKK", "KH", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1170", "DKK", "SN", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1171", "DKK", "SA", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1172", "DKK", "RU", "96");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1173", "DKK", "UG", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1174", "DKK", "BR", "38");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1175", "DKK", "NI", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1176", "DKK", "MG", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1177", "DKK", "DO", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1178", "DKK", "MX", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1179", "DKK", "OM", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1180", "DKK", "CM", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1181", "DKK", "ZA", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1182", "DKK", "CL", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1183", "DKK", "KE", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1184", "DKK", "NP", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1185", "DKK", "PE", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1186", "DKK", "UA", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1187", "DKK", "MZ", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1188", "DKK", "TZ", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1189", "DKK", "AO", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1190", "DKK", "JO", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1191", "DKK", "ZW", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1192", "DKK", "TR", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1193", "DKK", "MU", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1194", "DKK", "SV", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1195", "DKK", "TH", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1196", "DKK", "CO", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1197", "DKK", "LK", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1198", "DKK", "CR", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1199", "DKK", "AR", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1200", "DKK", "MA", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1201", "DKK", "MY", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1202", "DKK", "KZ", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1203", "DKK", "DZ", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1204", "DKK", "ID", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1205", "DKK", "NG", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1206", "DKK", "GT", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1207", "DKK", "VN", "38");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1208", "DKK", "BY", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1209", "DKK", "EG", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1210", "DKK", "UY", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1211", "DKK", "BD", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1212", "DKK", "PK", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1213", "DKK", "PH", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1214", "DKK", "ET", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1215", "DKK", "TN", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1216", "DKK", "LB", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1217", "DKK", "IN", "38");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1218", "DKK", "PY", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1219", "DKK", "UZ", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1220", "DKK", "EC", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1221", "DKK", "MM", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1222", "DKK", "GE", "92");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1223", "EGP", "US", "463");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1224", "EGP", "CH", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1225", "EGP", "AU", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1226", "EGP", "GB", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1227", "EGP", "DE", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1228", "EGP", "DK", "433");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1229", "EGP", "AT", "371");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1230", "EGP", "NO", "371");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1231", "EGP", "CA", "433");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1232", "EGP", "NL", "433");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1233", "EGP", "SE", "433");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1234", "EGP", "IE", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1235", "EGP", "BE", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1236", "EGP", "FI", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1237", "EGP", "FR", "433");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1238", "EGP", "NZ", "371");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1239", "EGP", "HK", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1240", "EGP", "CZ", "371");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1241", "EGP", "SK", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1242", "EGP", "AE", "433");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1243", "EGP", "SG", "433");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1244", "EGP", "IL", "433");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1245", "EGP", "KW", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1246", "EGP", "IT", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1247", "EGP", "JP", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1248", "EGP", "ES", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1249", "EGP", "VE", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1250", "EGP", "HU", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1251", "EGP", "PT", "371");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1252", "EGP", "GR", "371");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1253", "EGP", "KR", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1254", "EGP", "TW", "371");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1255", "EGP", "PL", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1256", "EGP", "ZM", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1257", "EGP", "PR", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1258", "EGP", "CI", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1259", "EGP", "RO", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1260", "EGP", "BH", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1261", "EGP", "PA", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1262", "EGP", "GH", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1263", "EGP", "KH", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1264", "EGP", "SN", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1265", "EGP", "SA", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1266", "EGP", "RU", "433");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1267", "EGP", "UG", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1268", "EGP", "BR", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1269", "EGP", "NI", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1270", "EGP", "MG", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1271", "EGP", "DO", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1272", "EGP", "MX", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1273", "EGP", "OM", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1274", "EGP", "CM", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1275", "EGP", "ZA", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1276", "EGP", "CL", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1277", "EGP", "KE", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1278", "EGP", "NP", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1279", "EGP", "PE", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1280", "EGP", "UA", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1281", "EGP", "MZ", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1282", "EGP", "TZ", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1283", "EGP", "AO", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1284", "EGP", "JO", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1285", "EGP", "ZW", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1286", "EGP", "TR", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1287", "EGP", "MU", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1288", "EGP", "SV", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1289", "EGP", "TH", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1290", "EGP", "CO", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1291", "EGP", "LK", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1292", "EGP", "CR", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1293", "EGP", "AR", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1294", "EGP", "MA", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1295", "EGP", "MY", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1296", "EGP", "KZ", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1297", "EGP", "DZ", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1298", "EGP", "ID", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1299", "EGP", "NG", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1300", "EGP", "GT", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1301", "EGP", "VN", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1302", "EGP", "BY", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1303", "EGP", "EG", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1304", "EGP", "UY", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1305", "EGP", "BD", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1306", "EGP", "PK", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1307", "EGP", "PH", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1308", "EGP", "ET", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1309", "EGP", "TN", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1310", "EGP", "LB", "201");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1311", "EGP", "IN", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1312", "EGP", "PY", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1313", "EGP", "UZ", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1314", "EGP", "EC", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1315", "EGP", "MM", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1316", "EGP", "GE", "417");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1317", "EUR", "US", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1318", "EUR", "CH", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1319", "EUR", "AU", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1320", "EUR", "GB", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1321", "EUR", "DE", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1322", "EUR", "DK", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1323", "EUR", "AT", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1324", "EUR", "NO", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1325", "EUR", "CA", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1326", "EUR", "NL", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1327", "EUR", "SE", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1328", "EUR", "IE", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1329", "EUR", "BE", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1330", "EUR", "FI", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1331", "EUR", "FR", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1332", "EUR", "NZ", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1333", "EUR", "HK", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1334", "EUR", "CZ", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1335", "EUR", "SK", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1336", "EUR", "AE", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1337", "EUR", "SG", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1338", "EUR", "IL", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1339", "EUR", "KW", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1340", "EUR", "IT", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1341", "EUR", "JP", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1342", "EUR", "ES", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1343", "EUR", "VE", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1344", "EUR", "HU", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1345", "EUR", "PT", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1346", "EUR", "GR", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1347", "EUR", "KR", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1348", "EUR", "TW", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1349", "EUR", "PL", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1350", "EUR", "ZM", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1351", "EUR", "PR", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1352", "EUR", "CI", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1353", "EUR", "RO", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1354", "EUR", "BH", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1355", "EUR", "PA", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1356", "EUR", "GH", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1357", "EUR", "KH", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1358", "EUR", "SN", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1359", "EUR", "SA", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1360", "EUR", "RU", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1361", "EUR", "UG", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1362", "EUR", "BR", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1363", "EUR", "NI", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1364", "EUR", "MG", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1365", "EUR", "DO", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1366", "EUR", "MX", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1367", "EUR", "OM", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1368", "EUR", "CM", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1369", "EUR", "ZA", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1370", "EUR", "CL", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1371", "EUR", "KE", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1372", "EUR", "NP", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1373", "EUR", "PE", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1374", "EUR", "UA", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1375", "EUR", "MZ", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1376", "EUR", "TZ", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1377", "EUR", "AO", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1378", "EUR", "JO", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1379", "EUR", "ZW", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1380", "EUR", "TR", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1381", "EUR", "MU", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1382", "EUR", "SV", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1383", "EUR", "TH", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1384", "EUR", "CO", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1385", "EUR", "LK", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1386", "EUR", "CR", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1387", "EUR", "AR", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1388", "EUR", "MA", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1389", "EUR", "MY", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1390", "EUR", "KZ", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1391", "EUR", "DZ", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1392", "EUR", "ID", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1393", "EUR", "NG", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1394", "EUR", "GT", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1395", "EUR", "VN", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1396", "EUR", "BY", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1397", "EUR", "EG", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1398", "EUR", "UY", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1399", "EUR", "BD", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1400", "EUR", "PK", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1401", "EUR", "PH", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1402", "EUR", "ET", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1403", "EUR", "TN", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1404", "EUR", "LB", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1405", "EUR", "IN", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1406", "EUR", "PY", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1407", "EUR", "UZ", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1408", "EUR", "EC", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1409", "EUR", "MM", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1410", "EUR", "GE", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1411", "GBP", "US", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1412", "GBP", "CH", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1413", "GBP", "AU", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1414", "GBP", "GB", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1415", "GBP", "DE", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1416", "GBP", "DK", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1417", "GBP", "AT", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1418", "GBP", "NO", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1419", "GBP", "CA", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1420", "GBP", "NL", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1421", "GBP", "SE", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1422", "GBP", "IE", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1423", "GBP", "BE", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1424", "GBP", "FI", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1425", "GBP", "FR", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1426", "GBP", "NZ", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1427", "GBP", "HK", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1428", "GBP", "CZ", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1429", "GBP", "SK", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1430", "GBP", "AE", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1431", "GBP", "SG", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1432", "GBP", "IL", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1433", "GBP", "KW", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1434", "GBP", "IT", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1435", "GBP", "JP", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1436", "GBP", "ES", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1437", "GBP", "VE", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1438", "GBP", "HU", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1439", "GBP", "PT", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1440", "GBP", "GR", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1441", "GBP", "KR", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1442", "GBP", "TW", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1443", "GBP", "PL", "4");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1444", "GBP", "ZM", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1445", "GBP", "PR", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1446", "GBP", "CI", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1447", "GBP", "RO", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1448", "GBP", "BH", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1449", "GBP", "PA", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1450", "GBP", "GH", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1451", "GBP", "KH", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1452", "GBP", "SN", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1453", "GBP", "SA", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1454", "GBP", "RU", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1455", "GBP", "UG", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1456", "GBP", "BR", "4");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1457", "GBP", "NI", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1458", "GBP", "MG", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1459", "GBP", "DO", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1460", "GBP", "MX", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1461", "GBP", "OM", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1462", "GBP", "CM", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1463", "GBP", "ZA", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1464", "GBP", "CL", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1465", "GBP", "KE", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1466", "GBP", "NP", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1467", "GBP", "PE", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1468", "GBP", "UA", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1469", "GBP", "MZ", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1470", "GBP", "TZ", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1471", "GBP", "AO", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1472", "GBP", "JO", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1473", "GBP", "ZW", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1474", "GBP", "TR", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1475", "GBP", "MU", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1476", "GBP", "SV", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1477", "GBP", "TH", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1478", "GBP", "CO", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1479", "GBP", "LK", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1480", "GBP", "CR", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1481", "GBP", "AR", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1482", "GBP", "MA", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1483", "GBP", "MY", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1484", "GBP", "KZ", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1485", "GBP", "DZ", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1486", "GBP", "ID", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1487", "GBP", "NG", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1488", "GBP", "GT", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1489", "GBP", "VN", "4");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1490", "GBP", "BY", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1491", "GBP", "EG", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1492", "GBP", "UY", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1493", "GBP", "BD", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1494", "GBP", "PK", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1495", "GBP", "PH", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1496", "GBP", "ET", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1497", "GBP", "TN", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1498", "GBP", "LB", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1499", "GBP", "IN", "4");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1500", "GBP", "PY", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1501", "GBP", "UZ", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1502", "GBP", "EC", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1503", "GBP", "MM", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1504", "GBP", "GE", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1505", "HKD", "US", "117");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1506", "HKD", "CH", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1507", "HKD", "AU", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1508", "HKD", "GB", "136");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1509", "HKD", "DE", "136");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1510", "HKD", "DK", "109");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1511", "HKD", "AT", "94");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1512", "HKD", "NO", "94");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1513", "HKD", "CA", "109");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1514", "HKD", "NL", "109");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1515", "HKD", "SE", "109");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1516", "HKD", "IE", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1517", "HKD", "BE", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1518", "HKD", "FI", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1519", "HKD", "FR", "109");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1520", "HKD", "NZ", "94");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1521", "HKD", "HK", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1522", "HKD", "CZ", "94");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1523", "HKD", "SK", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1524", "HKD", "AE", "109");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1525", "HKD", "SG", "109");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1526", "HKD", "IL", "109");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1527", "HKD", "KW", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1528", "HKD", "IT", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1529", "HKD", "JP", "136");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1530", "HKD", "ES", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1531", "HKD", "VE", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1532", "HKD", "HU", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1533", "HKD", "PT", "94");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1534", "HKD", "GR", "94");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1535", "HKD", "KR", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1536", "HKD", "TW", "94");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1537", "HKD", "PL", "43");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1538", "HKD", "ZM", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1539", "HKD", "PR", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1540", "HKD", "CI", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1541", "HKD", "RO", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1542", "HKD", "BH", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1543", "HKD", "PA", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1544", "HKD", "GH", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1545", "HKD", "KH", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1546", "HKD", "SN", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1547", "HKD", "SA", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1548", "HKD", "RU", "109");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1549", "HKD", "UG", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1550", "HKD", "BR", "43");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1551", "HKD", "NI", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1552", "HKD", "MG", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1553", "HKD", "DO", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1554", "HKD", "MX", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1555", "HKD", "OM", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1556", "HKD", "CM", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1557", "HKD", "ZA", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1558", "HKD", "CL", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1559", "HKD", "KE", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1560", "HKD", "NP", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1561", "HKD", "PE", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1562", "HKD", "UA", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1563", "HKD", "MZ", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1564", "HKD", "TZ", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1565", "HKD", "AO", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1566", "HKD", "JO", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1567", "HKD", "ZW", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1568", "HKD", "TR", "86");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1569", "HKD", "MU", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1570", "HKD", "SV", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1571", "HKD", "TH", "47");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1572", "HKD", "CO", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1573", "HKD", "LK", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1574", "HKD", "CR", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1575", "HKD", "AR", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1576", "HKD", "MA", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1577", "HKD", "MY", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1578", "HKD", "KZ", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1579", "HKD", "DZ", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1580", "HKD", "ID", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1581", "HKD", "NG", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1582", "HKD", "GT", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1583", "HKD", "VN", "43");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1584", "HKD", "BY", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1585", "HKD", "EG", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1586", "HKD", "UY", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1587", "HKD", "BD", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1588", "HKD", "PK", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1589", "HKD", "PH", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1590", "HKD", "ET", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1591", "HKD", "TN", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1592", "HKD", "LB", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1593", "HKD", "IN", "43");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1594", "HKD", "PY", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1595", "HKD", "UZ", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1596", "HKD", "EC", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1597", "HKD", "MM", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1598", "HKD", "GE", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1599", "HUF", "US", "5254");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1600", "HUF", "CH", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1601", "HUF", "AU", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1602", "HUF", "GB", "6130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1603", "HUF", "DE", "6130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1604", "HUF", "DK", "4904");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1605", "HUF", "AT", "4203");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1606", "HUF", "NO", "4203");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1607", "HUF", "CA", "4904");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1608", "HUF", "NL", "4904");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1609", "HUF", "SE", "4904");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1610", "HUF", "IE", "3853");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1611", "HUF", "BE", "3853");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1612", "HUF", "FI", "3853");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1613", "HUF", "FR", "4904");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1614", "HUF", "NZ", "4203");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1615", "HUF", "HK", "2102");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1616", "HUF", "CZ", "4203");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1617", "HUF", "SK", "3853");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1618", "HUF", "AE", "4904");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1619", "HUF", "SG", "4904");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1620", "HUF", "IL", "4904");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1621", "HUF", "KW", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1622", "HUF", "IT", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1623", "HUF", "JP", "6130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1624", "HUF", "ES", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1625", "HUF", "VE", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1626", "HUF", "HU", "3853");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1627", "HUF", "PT", "4203");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1628", "HUF", "GR", "4203");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1629", "HUF", "KR", "2102");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1630", "HUF", "TW", "4203");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1631", "HUF", "PL", "1926");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1632", "HUF", "ZM", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1633", "HUF", "PR", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1634", "HUF", "CI", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1635", "HUF", "RO", "3853");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1636", "HUF", "BH", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1637", "HUF", "PA", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1638", "HUF", "GH", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1639", "HUF", "KH", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1640", "HUF", "SN", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1641", "HUF", "SA", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1642", "HUF", "RU", "4904");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1643", "HUF", "UG", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1644", "HUF", "BR", "1926");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1645", "HUF", "NI", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1646", "HUF", "MG", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1647", "HUF", "DO", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1648", "HUF", "MX", "2102");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1649", "HUF", "OM", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1650", "HUF", "CM", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1651", "HUF", "ZA", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1652", "HUF", "CL", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1653", "HUF", "KE", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1654", "HUF", "NP", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1655", "HUF", "PE", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1656", "HUF", "UA", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1657", "HUF", "MZ", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1658", "HUF", "TZ", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1659", "HUF", "AO", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1660", "HUF", "JO", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1661", "HUF", "ZW", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1662", "HUF", "TR", "3853");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1663", "HUF", "MU", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1664", "HUF", "SV", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1665", "HUF", "TH", "2102");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1666", "HUF", "CO", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1667", "HUF", "LK", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1668", "HUF", "CR", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1669", "HUF", "AR", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1670", "HUF", "MA", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1671", "HUF", "MY", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1672", "HUF", "KZ", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1673", "HUF", "DZ", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1674", "HUF", "ID", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1675", "HUF", "NG", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1676", "HUF", "GT", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1677", "HUF", "VN", "1926");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1678", "HUF", "BY", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1679", "HUF", "EG", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1680", "HUF", "UY", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1681", "HUF", "BD", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1682", "HUF", "PK", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1683", "HUF", "PH", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1684", "HUF", "ET", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1685", "HUF", "TN", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1686", "HUF", "LB", "2277");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1687", "HUF", "IN", "1926");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1688", "HUF", "PY", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1689", "HUF", "UZ", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1690", "HUF", "EC", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1691", "HUF", "MM", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1692", "HUF", "GE", "4729");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1693", "IDR", "US", "234395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1694", "IDR", "CH", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1695", "IDR", "AU", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1696", "IDR", "GB", "273461");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1697", "IDR", "DE", "273461");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1698", "IDR", "DK", "218769");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1699", "IDR", "AT", "187516");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1700", "IDR", "NO", "187516");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1701", "IDR", "CA", "218769");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1702", "IDR", "NL", "218769");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1703", "IDR", "SE", "218769");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1704", "IDR", "IE", "171890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1705", "IDR", "BE", "171890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1706", "IDR", "FI", "171890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1707", "IDR", "FR", "218769");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1708", "IDR", "NZ", "187516");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1709", "IDR", "HK", "93758");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1710", "IDR", "CZ", "187516");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1711", "IDR", "SK", "171890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1712", "IDR", "AE", "218769");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1713", "IDR", "SG", "218769");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1714", "IDR", "IL", "218769");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1715", "IDR", "KW", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1716", "IDR", "IT", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1717", "IDR", "JP", "273461");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1718", "IDR", "ES", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1719", "IDR", "VE", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1720", "IDR", "HU", "171890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1721", "IDR", "PT", "187516");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1722", "IDR", "GR", "187516");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1723", "IDR", "KR", "93758");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1724", "IDR", "TW", "187516");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1725", "IDR", "PL", "85945");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1726", "IDR", "ZM", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1727", "IDR", "PR", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1728", "IDR", "CI", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1729", "IDR", "RO", "171890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1730", "IDR", "BH", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1731", "IDR", "PA", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1732", "IDR", "GH", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1733", "IDR", "KH", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1734", "IDR", "SN", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1735", "IDR", "SA", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1736", "IDR", "RU", "218769");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1737", "IDR", "UG", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1738", "IDR", "BR", "85945");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1739", "IDR", "NI", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1740", "IDR", "MG", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1741", "IDR", "DO", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1742", "IDR", "MX", "93758");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1743", "IDR", "OM", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1744", "IDR", "CM", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1745", "IDR", "ZA", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1746", "IDR", "CL", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1747", "IDR", "KE", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1748", "IDR", "NP", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1749", "IDR", "PE", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1750", "IDR", "UA", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1751", "IDR", "MZ", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1752", "IDR", "TZ", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1753", "IDR", "AO", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1754", "IDR", "JO", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1755", "IDR", "ZW", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1756", "IDR", "TR", "171890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1757", "IDR", "MU", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1758", "IDR", "SV", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1759", "IDR", "TH", "93758");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1760", "IDR", "CO", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1761", "IDR", "LK", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1762", "IDR", "CR", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1763", "IDR", "AR", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1764", "IDR", "MA", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1765", "IDR", "MY", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1766", "IDR", "KZ", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1767", "IDR", "DZ", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1768", "IDR", "ID", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1769", "IDR", "NG", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1770", "IDR", "GT", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1771", "IDR", "VN", "85945");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1772", "IDR", "BY", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1773", "IDR", "EG", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1774", "IDR", "UY", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1775", "IDR", "BD", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1776", "IDR", "PK", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1777", "IDR", "PH", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1778", "IDR", "ET", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1779", "IDR", "TN", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1780", "IDR", "LB", "101571");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1781", "IDR", "IN", "85945");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1782", "IDR", "PY", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1783", "IDR", "UZ", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1784", "IDR", "EC", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1785", "IDR", "MM", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1786", "IDR", "GE", "210956");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1787", "ILS", "US", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1788", "ILS", "CH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1789", "ILS", "AU", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1790", "ILS", "GB", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1791", "ILS", "DE", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1792", "ILS", "DK", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1793", "ILS", "AT", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1794", "ILS", "NO", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1795", "ILS", "CA", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1796", "ILS", "NL", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1797", "ILS", "SE", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1798", "ILS", "IE", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1799", "ILS", "BE", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1800", "ILS", "FI", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1801", "ILS", "FR", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1802", "ILS", "NZ", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1803", "ILS", "HK", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1804", "ILS", "CZ", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1805", "ILS", "SK", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1806", "ILS", "AE", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1807", "ILS", "SG", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1808", "ILS", "IL", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1809", "ILS", "KW", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1810", "ILS", "IT", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1811", "ILS", "JP", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1812", "ILS", "ES", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1813", "ILS", "VE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1814", "ILS", "HU", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1815", "ILS", "PT", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1816", "ILS", "GR", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1817", "ILS", "KR", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1818", "ILS", "TW", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1819", "ILS", "PL", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1820", "ILS", "ZM", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1821", "ILS", "PR", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1822", "ILS", "CI", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1823", "ILS", "RO", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1824", "ILS", "BH", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1825", "ILS", "PA", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1826", "ILS", "GH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1827", "ILS", "KH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1828", "ILS", "SN", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1829", "ILS", "SA", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1830", "ILS", "RU", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1831", "ILS", "UG", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1832", "ILS", "BR", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1833", "ILS", "NI", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1834", "ILS", "MG", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1835", "ILS", "DO", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1836", "ILS", "MX", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1837", "ILS", "OM", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1838", "ILS", "CM", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1839", "ILS", "ZA", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1840", "ILS", "CL", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1841", "ILS", "KE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1842", "ILS", "NP", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1843", "ILS", "PE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1844", "ILS", "UA", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1845", "ILS", "MZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1846", "ILS", "TZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1847", "ILS", "AO", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1848", "ILS", "JO", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1849", "ILS", "ZW", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1850", "ILS", "TR", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1851", "ILS", "MU", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1852", "ILS", "SV", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1853", "ILS", "TH", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1854", "ILS", "CO", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1855", "ILS", "LK", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1856", "ILS", "CR", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1857", "ILS", "AR", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1858", "ILS", "MA", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1859", "ILS", "MY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1860", "ILS", "KZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1861", "ILS", "DZ", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1862", "ILS", "ID", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1863", "ILS", "NG", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1864", "ILS", "GT", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1865", "ILS", "VN", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1866", "ILS", "BY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1867", "ILS", "EG", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1868", "ILS", "UY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1869", "ILS", "BD", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1870", "ILS", "PK", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1871", "ILS", "PH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1872", "ILS", "ET", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1873", "ILS", "TN", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1874", "ILS", "LB", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1875", "ILS", "IN", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1876", "ILS", "PY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1877", "ILS", "UZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1878", "ILS", "EC", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1879", "ILS", "MM", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1880", "ILS", "GE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1881", "INR", "US", "1250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1882", "INR", "CH", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1883", "INR", "AU", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1884", "INR", "GB", "1458");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1885", "INR", "DE", "1458");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1886", "INR", "DK", "1166");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1887", "INR", "AT", "1000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1888", "INR", "NO", "1000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1889", "INR", "CA", "1166");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1890", "INR", "NL", "1166");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1891", "INR", "SE", "1166");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1892", "INR", "IE", "916");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1893", "INR", "BE", "916");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1894", "INR", "FI", "916");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1895", "INR", "FR", "1166");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1896", "INR", "NZ", "1000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1897", "INR", "HK", "500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1898", "INR", "CZ", "1000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1899", "INR", "SK", "916");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1900", "INR", "AE", "1166");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1901", "INR", "SG", "1166");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1902", "INR", "IL", "1166");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1903", "INR", "KW", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1904", "INR", "IT", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1905", "INR", "JP", "1458");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1906", "INR", "ES", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1907", "INR", "VE", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1908", "INR", "HU", "916");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1909", "INR", "PT", "1000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1910", "INR", "GR", "1000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1911", "INR", "KR", "500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1912", "INR", "TW", "1000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1913", "INR", "PL", "458");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1914", "INR", "ZM", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1915", "INR", "PR", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1916", "INR", "CI", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1917", "INR", "RO", "916");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1918", "INR", "BH", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1919", "INR", "PA", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1920", "INR", "GH", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1921", "INR", "KH", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1922", "INR", "SN", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1923", "INR", "SA", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1924", "INR", "RU", "1166");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1925", "INR", "UG", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1926", "INR", "BR", "458");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1927", "INR", "NI", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1928", "INR", "MG", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1929", "INR", "DO", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1930", "INR", "MX", "500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1931", "INR", "OM", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1932", "INR", "CM", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1933", "INR", "ZA", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1934", "INR", "CL", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1935", "INR", "KE", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1936", "INR", "NP", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1937", "INR", "PE", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1938", "INR", "UA", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1939", "INR", "MZ", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1940", "INR", "TZ", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1941", "INR", "AO", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1942", "INR", "JO", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1943", "INR", "ZW", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1944", "INR", "TR", "916");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1945", "INR", "MU", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1946", "INR", "SV", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1947", "INR", "TH", "500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1948", "INR", "CO", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1949", "INR", "LK", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1950", "INR", "CR", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1951", "INR", "AR", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1952", "INR", "MA", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1953", "INR", "MY", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1954", "INR", "KZ", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1955", "INR", "DZ", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1956", "INR", "ID", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1957", "INR", "NG", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1958", "INR", "GT", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1959", "INR", "VN", "458");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1960", "INR", "BY", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1961", "INR", "EG", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1962", "INR", "UY", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1963", "INR", "BD", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1964", "INR", "PK", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1965", "INR", "PH", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1966", "INR", "ET", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1967", "INR", "TN", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1968", "INR", "LB", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1969", "INR", "IN", "458");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1970", "INR", "PY", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1971", "INR", "UZ", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1972", "INR", "EC", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1973", "INR", "MM", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1974", "INR", "GE", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1975", "JPY", "US", "2244");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1976", "JPY", "CH", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1977", "JPY", "AU", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1978", "JPY", "GB", "2618");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1979", "JPY", "DE", "2618");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1980", "JPY", "DK", "2095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1981", "JPY", "AT", "1795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1982", "JPY", "NO", "1795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1983", "JPY", "CA", "2095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1984", "JPY", "NL", "2095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1985", "JPY", "SE", "2095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1986", "JPY", "IE", "1646");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1987", "JPY", "BE", "1646");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1988", "JPY", "FI", "1646");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1989", "JPY", "FR", "2095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1990", "JPY", "NZ", "1795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1991", "JPY", "HK", "898");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1992", "JPY", "CZ", "1795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1993", "JPY", "SK", "1646");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1994", "JPY", "AE", "2095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1995", "JPY", "SG", "2095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1996", "JPY", "IL", "2095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1997", "JPY", "KW", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1998", "JPY", "IT", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1999", "JPY", "JP", "2618");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2000", "JPY", "ES", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2001", "JPY", "VE", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2002", "JPY", "HU", "1646");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2003", "JPY", "PT", "1795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2004", "JPY", "GR", "1795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2005", "JPY", "KR", "898");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2006", "JPY", "TW", "1795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2007", "JPY", "PL", "823");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2008", "JPY", "ZM", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2009", "JPY", "PR", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2010", "JPY", "CI", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2011", "JPY", "RO", "1646");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2012", "JPY", "BH", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2013", "JPY", "PA", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2014", "JPY", "GH", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2015", "JPY", "KH", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2016", "JPY", "SN", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2017", "JPY", "SA", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2018", "JPY", "RU", "2095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2019", "JPY", "UG", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2020", "JPY", "BR", "823");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2021", "JPY", "NI", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2022", "JPY", "MG", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2023", "JPY", "DO", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2024", "JPY", "MX", "898");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2025", "JPY", "OM", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2026", "JPY", "CM", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2027", "JPY", "ZA", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2028", "JPY", "CL", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2029", "JPY", "KE", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2030", "JPY", "NP", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2031", "JPY", "PE", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2032", "JPY", "UA", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2033", "JPY", "MZ", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2034", "JPY", "TZ", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2035", "JPY", "AO", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2036", "JPY", "JO", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2037", "JPY", "ZW", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2038", "JPY", "TR", "1646");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2039", "JPY", "MU", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2040", "JPY", "SV", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2041", "JPY", "TH", "898");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2042", "JPY", "CO", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2043", "JPY", "LK", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2044", "JPY", "CR", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2045", "JPY", "AR", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2046", "JPY", "MA", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2047", "JPY", "MY", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2048", "JPY", "KZ", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2049", "JPY", "DZ", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2050", "JPY", "ID", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2051", "JPY", "NG", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2052", "JPY", "GT", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2053", "JPY", "VN", "823");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2054", "JPY", "BY", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2055", "JPY", "EG", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2056", "JPY", "UY", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2057", "JPY", "BD", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2058", "JPY", "PK", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2059", "JPY", "PH", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2060", "JPY", "ET", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2061", "JPY", "TN", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2062", "JPY", "LB", "973");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2063", "JPY", "IN", "823");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2064", "JPY", "PY", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2065", "JPY", "UZ", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2066", "JPY", "EC", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2067", "JPY", "MM", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2068", "JPY", "GE", "2020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2069", "KRW", "US", "19538");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2070", "KRW", "CH", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2071", "KRW", "AU", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2072", "KRW", "GB", "22794");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2073", "KRW", "DE", "22794");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2074", "KRW", "DK", "18235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2075", "KRW", "AT", "15630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2076", "KRW", "NO", "15630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2077", "KRW", "CA", "18235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2078", "KRW", "NL", "18235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2079", "KRW", "SE", "18235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2080", "KRW", "IE", "14328");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2081", "KRW", "BE", "14328");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2082", "KRW", "FI", "14328");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2083", "KRW", "FR", "18235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2084", "KRW", "NZ", "15630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2085", "KRW", "HK", "7815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2086", "KRW", "CZ", "15630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2087", "KRW", "SK", "14328");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2088", "KRW", "AE", "18235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2089", "KRW", "SG", "18235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2090", "KRW", "IL", "18235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2091", "KRW", "KW", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2092", "KRW", "IT", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2093", "KRW", "JP", "22794");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2094", "KRW", "ES", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2095", "KRW", "VE", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2096", "KRW", "HU", "14328");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2097", "KRW", "PT", "15630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2098", "KRW", "GR", "15630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2099", "KRW", "KR", "7815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2100", "KRW", "TW", "15630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2101", "KRW", "PL", "7164");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2102", "KRW", "ZM", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2103", "KRW", "PR", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2104", "KRW", "CI", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2105", "KRW", "RO", "14328");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2106", "KRW", "BH", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2107", "KRW", "PA", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2108", "KRW", "GH", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2109", "KRW", "KH", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2110", "KRW", "SN", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2111", "KRW", "SA", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2112", "KRW", "RU", "18235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2113", "KRW", "UG", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2114", "KRW", "BR", "7164");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2115", "KRW", "NI", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2116", "KRW", "MG", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2117", "KRW", "DO", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2118", "KRW", "MX", "7815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2119", "KRW", "OM", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2120", "KRW", "CM", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2121", "KRW", "ZA", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2122", "KRW", "CL", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2123", "KRW", "KE", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2124", "KRW", "NP", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2125", "KRW", "PE", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2126", "KRW", "UA", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2127", "KRW", "MZ", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2128", "KRW", "TZ", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2129", "KRW", "AO", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2130", "KRW", "JO", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2131", "KRW", "ZW", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2132", "KRW", "TR", "14328");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2133", "KRW", "MU", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2134", "KRW", "SV", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2135", "KRW", "TH", "7815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2136", "KRW", "CO", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2137", "KRW", "LK", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2138", "KRW", "CR", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2139", "KRW", "AR", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2140", "KRW", "MA", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2141", "KRW", "MY", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2142", "KRW", "KZ", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2143", "KRW", "DZ", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2144", "KRW", "ID", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2145", "KRW", "NG", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2146", "KRW", "GT", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2147", "KRW", "VN", "7164");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2148", "KRW", "BY", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2149", "KRW", "EG", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2150", "KRW", "UY", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2151", "KRW", "BD", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2152", "KRW", "PK", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2153", "KRW", "PH", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2154", "KRW", "ET", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2155", "KRW", "TN", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2156", "KRW", "LB", "8466");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2157", "KRW", "IN", "7164");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2158", "KRW", "PY", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2159", "KRW", "UZ", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2160", "KRW", "EC", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2161", "KRW", "MM", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2162", "KRW", "GE", "17584");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2163", "MAD", "US", "152");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2164", "MAD", "CH", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2165", "MAD", "AU", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2166", "MAD", "GB", "177");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2167", "MAD", "DE", "177");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2168", "MAD", "DK", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2169", "MAD", "AT", "122");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2170", "MAD", "NO", "122");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2171", "MAD", "CA", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2172", "MAD", "NL", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2173", "MAD", "SE", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2174", "MAD", "IE", "111");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2175", "MAD", "BE", "111");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2176", "MAD", "FI", "111");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2177", "MAD", "FR", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2178", "MAD", "NZ", "122");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2179", "MAD", "HK", "61");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2180", "MAD", "CZ", "122");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2181", "MAD", "SK", "111");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2182", "MAD", "AE", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2183", "MAD", "SG", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2184", "MAD", "IL", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2185", "MAD", "KW", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2186", "MAD", "IT", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2187", "MAD", "JP", "177");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2188", "MAD", "ES", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2189", "MAD", "VE", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2190", "MAD", "HU", "111");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2191", "MAD", "PT", "122");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2192", "MAD", "GR", "122");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2193", "MAD", "KR", "61");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2194", "MAD", "TW", "122");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2195", "MAD", "PL", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2196", "MAD", "ZM", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2197", "MAD", "PR", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2198", "MAD", "CI", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2199", "MAD", "RO", "111");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2200", "MAD", "BH", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2201", "MAD", "PA", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2202", "MAD", "GH", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2203", "MAD", "KH", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2204", "MAD", "SN", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2205", "MAD", "SA", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2206", "MAD", "RU", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2207", "MAD", "UG", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2208", "MAD", "BR", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2209", "MAD", "NI", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2210", "MAD", "MG", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2211", "MAD", "DO", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2212", "MAD", "MX", "61");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2213", "MAD", "OM", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2214", "MAD", "CM", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2215", "MAD", "ZA", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2216", "MAD", "CL", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2217", "MAD", "KE", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2218", "MAD", "NP", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2219", "MAD", "PE", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2220", "MAD", "UA", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2221", "MAD", "MZ", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2222", "MAD", "TZ", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2223", "MAD", "AO", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2224", "MAD", "JO", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2225", "MAD", "ZW", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2226", "MAD", "TR", "111");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2227", "MAD", "MU", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2228", "MAD", "SV", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2229", "MAD", "TH", "61");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2230", "MAD", "CO", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2231", "MAD", "LK", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2232", "MAD", "CR", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2233", "MAD", "AR", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2234", "MAD", "MA", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2235", "MAD", "MY", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2236", "MAD", "KZ", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2237", "MAD", "DZ", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2238", "MAD", "ID", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2239", "MAD", "NG", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2240", "MAD", "GT", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2241", "MAD", "VN", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2242", "MAD", "BY", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2243", "MAD", "EG", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2244", "MAD", "UY", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2245", "MAD", "BD", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2246", "MAD", "PK", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2247", "MAD", "PH", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2248", "MAD", "ET", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2249", "MAD", "TN", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2250", "MAD", "LB", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2251", "MAD", "IN", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2252", "MAD", "PY", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2253", "MAD", "UZ", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2254", "MAD", "EC", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2255", "MAD", "MM", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2256", "MAD", "GE", "137");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2257", "MXN", "US", "258");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2258", "MXN", "CH", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2259", "MXN", "AU", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2260", "MXN", "GB", "301");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2261", "MXN", "DE", "301");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2262", "MXN", "DK", "241");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2263", "MXN", "AT", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2264", "MXN", "NO", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2265", "MXN", "CA", "241");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2266", "MXN", "NL", "241");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2267", "MXN", "SE", "241");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2268", "MXN", "IE", "189");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2269", "MXN", "BE", "189");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2270", "MXN", "FI", "189");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2271", "MXN", "FR", "241");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2272", "MXN", "NZ", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2273", "MXN", "HK", "103");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2274", "MXN", "CZ", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2275", "MXN", "SK", "189");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2276", "MXN", "AE", "241");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2277", "MXN", "SG", "241");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2278", "MXN", "IL", "241");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2279", "MXN", "KW", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2280", "MXN", "IT", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2281", "MXN", "JP", "301");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2282", "MXN", "ES", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2283", "MXN", "VE", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2284", "MXN", "HU", "189");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2285", "MXN", "PT", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2286", "MXN", "GR", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2287", "MXN", "KR", "103");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2288", "MXN", "TW", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2289", "MXN", "PL", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2290", "MXN", "ZM", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2291", "MXN", "PR", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2292", "MXN", "CI", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2293", "MXN", "RO", "189");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2294", "MXN", "BH", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2295", "MXN", "PA", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2296", "MXN", "GH", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2297", "MXN", "KH", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2298", "MXN", "SN", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2299", "MXN", "SA", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2300", "MXN", "RU", "241");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2301", "MXN", "UG", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2302", "MXN", "BR", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2303", "MXN", "NI", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2304", "MXN", "MG", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2305", "MXN", "DO", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2306", "MXN", "MX", "103");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2307", "MXN", "OM", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2308", "MXN", "CM", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2309", "MXN", "ZA", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2310", "MXN", "CL", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2311", "MXN", "KE", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2312", "MXN", "NP", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2313", "MXN", "PE", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2314", "MXN", "UA", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2315", "MXN", "MZ", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2316", "MXN", "TZ", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2317", "MXN", "AO", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2318", "MXN", "JO", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2319", "MXN", "ZW", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2320", "MXN", "TR", "189");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2321", "MXN", "MU", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2322", "MXN", "SV", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2323", "MXN", "TH", "103");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2324", "MXN", "CO", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2325", "MXN", "LK", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2326", "MXN", "CR", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2327", "MXN", "AR", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2328", "MXN", "MA", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2329", "MXN", "MY", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2330", "MXN", "KZ", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2331", "MXN", "DZ", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2332", "MXN", "ID", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2333", "MXN", "NG", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2334", "MXN", "GT", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2335", "MXN", "VN", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2336", "MXN", "BY", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2337", "MXN", "EG", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2338", "MXN", "UY", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2339", "MXN", "BD", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2340", "MXN", "PK", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2341", "MXN", "PH", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2342", "MXN", "ET", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2343", "MXN", "TN", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2344", "MXN", "LB", "112");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2345", "MXN", "IN", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2346", "MXN", "PY", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2347", "MXN", "UZ", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2348", "MXN", "EC", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2349", "MXN", "MM", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2350", "MXN", "GE", "232");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2351", "MYR", "US", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2352", "MYR", "CH", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2353", "MYR", "AU", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2354", "MYR", "GB", "82");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2355", "MYR", "DE", "82");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2356", "MYR", "DK", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2357", "MYR", "AT", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2358", "MYR", "NO", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2359", "MYR", "CA", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2360", "MYR", "NL", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2361", "MYR", "SE", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2362", "MYR", "IE", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2363", "MYR", "BE", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2364", "MYR", "FI", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2365", "MYR", "FR", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2366", "MYR", "NZ", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2367", "MYR", "HK", "28");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2368", "MYR", "CZ", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2369", "MYR", "SK", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2370", "MYR", "AE", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2371", "MYR", "SG", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2372", "MYR", "IL", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2373", "MYR", "KW", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2374", "MYR", "IT", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2375", "MYR", "JP", "82");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2376", "MYR", "ES", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2377", "MYR", "VE", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2378", "MYR", "HU", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2379", "MYR", "PT", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2380", "MYR", "GR", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2381", "MYR", "KR", "28");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2382", "MYR", "TW", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2383", "MYR", "PL", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2384", "MYR", "ZM", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2385", "MYR", "PR", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2386", "MYR", "CI", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2387", "MYR", "RO", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2388", "MYR", "BH", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2389", "MYR", "PA", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2390", "MYR", "GH", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2391", "MYR", "KH", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2392", "MYR", "SN", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2393", "MYR", "SA", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2394", "MYR", "RU", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2395", "MYR", "UG", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2396", "MYR", "BR", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2397", "MYR", "NI", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2398", "MYR", "MG", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2399", "MYR", "DO", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2400", "MYR", "MX", "28");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2401", "MYR", "OM", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2402", "MYR", "CM", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2403", "MYR", "ZA", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2404", "MYR", "CL", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2405", "MYR", "KE", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2406", "MYR", "NP", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2407", "MYR", "PE", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2408", "MYR", "UA", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2409", "MYR", "MZ", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2410", "MYR", "TZ", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2411", "MYR", "AO", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2412", "MYR", "JO", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2413", "MYR", "ZW", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2414", "MYR", "TR", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2415", "MYR", "MU", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2416", "MYR", "SV", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2417", "MYR", "TH", "28");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2418", "MYR", "CO", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2419", "MYR", "LK", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2420", "MYR", "CR", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2421", "MYR", "AR", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2422", "MYR", "MA", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2423", "MYR", "MY", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2424", "MYR", "KZ", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2425", "MYR", "DZ", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2426", "MYR", "ID", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2427", "MYR", "NG", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2428", "MYR", "GT", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2429", "MYR", "VN", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2430", "MYR", "BY", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2431", "MYR", "EG", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2432", "MYR", "UY", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2433", "MYR", "BD", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2434", "MYR", "PK", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2435", "MYR", "PH", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2436", "MYR", "ET", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2437", "MYR", "TN", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2438", "MYR", "LB", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2439", "MYR", "IN", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2440", "MYR", "PY", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2441", "MYR", "UZ", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2442", "MYR", "EC", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2443", "MYR", "MM", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2444", "MYR", "GE", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2445", "NGN", "US", "12242");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2446", "NGN", "CH", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2447", "NGN", "AU", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2448", "NGN", "GB", "14282");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2449", "NGN", "DE", "14282");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2450", "NGN", "DK", "11426");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2451", "NGN", "AT", "9793");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2452", "NGN", "NO", "9793");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2453", "NGN", "CA", "11426");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2454", "NGN", "NL", "11426");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2455", "NGN", "SE", "11426");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2456", "NGN", "IE", "8977");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2457", "NGN", "BE", "8977");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2458", "NGN", "FI", "8977");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2459", "NGN", "FR", "11426");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2460", "NGN", "NZ", "9793");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2461", "NGN", "HK", "4897");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2462", "NGN", "CZ", "9793");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2463", "NGN", "SK", "8977");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2464", "NGN", "AE", "11426");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2465", "NGN", "SG", "11426");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2466", "NGN", "IL", "11426");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2467", "NGN", "KW", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2468", "NGN", "IT", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2469", "NGN", "JP", "14282");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2470", "NGN", "ES", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2471", "NGN", "VE", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2472", "NGN", "HU", "8977");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2473", "NGN", "PT", "9793");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2474", "NGN", "GR", "9793");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2475", "NGN", "KR", "4897");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2476", "NGN", "TW", "9793");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2477", "NGN", "PL", "4489");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2478", "NGN", "ZM", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2479", "NGN", "PR", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2480", "NGN", "CI", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2481", "NGN", "RO", "8977");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2482", "NGN", "BH", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2483", "NGN", "PA", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2484", "NGN", "GH", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2485", "NGN", "KH", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2486", "NGN", "SN", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2487", "NGN", "SA", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2488", "NGN", "RU", "11426");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2489", "NGN", "UG", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2490", "NGN", "BR", "4489");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2491", "NGN", "NI", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2492", "NGN", "MG", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2493", "NGN", "DO", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2494", "NGN", "MX", "4897");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2495", "NGN", "OM", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2496", "NGN", "CM", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2497", "NGN", "ZA", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2498", "NGN", "CL", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2499", "NGN", "KE", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2500", "NGN", "NP", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2501", "NGN", "PE", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2502", "NGN", "UA", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2503", "NGN", "MZ", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2504", "NGN", "TZ", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2505", "NGN", "AO", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2506", "NGN", "JO", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2507", "NGN", "ZW", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2508", "NGN", "TR", "8977");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2509", "NGN", "MU", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2510", "NGN", "SV", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2511", "NGN", "TH", "4897");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2512", "NGN", "CO", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2513", "NGN", "LK", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2514", "NGN", "CR", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2515", "NGN", "AR", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2516", "NGN", "MA", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2517", "NGN", "MY", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2518", "NGN", "KZ", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2519", "NGN", "DZ", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2520", "NGN", "ID", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2521", "NGN", "NG", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2522", "NGN", "GT", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2523", "NGN", "VN", "4489");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2524", "NGN", "BY", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2525", "NGN", "EG", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2526", "NGN", "UY", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2527", "NGN", "BD", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2528", "NGN", "PK", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2529", "NGN", "PH", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2530", "NGN", "ET", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2531", "NGN", "TN", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2532", "NGN", "LB", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2533", "NGN", "IN", "4489");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2534", "NGN", "PY", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2535", "NGN", "UZ", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2536", "NGN", "EC", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2537", "NGN", "MM", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2538", "NGN", "GE", "11017");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2539", "NOK", "US", "161");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2540", "NOK", "CH", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2541", "NOK", "AU", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2542", "NOK", "GB", "188");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2543", "NOK", "DE", "188");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2544", "NOK", "DK", "151");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2545", "NOK", "AT", "129");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2546", "NOK", "NO", "129");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2547", "NOK", "CA", "151");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2548", "NOK", "NL", "151");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2549", "NOK", "SE", "151");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2550", "NOK", "IE", "118");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2551", "NOK", "BE", "118");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2552", "NOK", "FI", "118");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2553", "NOK", "FR", "151");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2554", "NOK", "NZ", "129");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2555", "NOK", "HK", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2556", "NOK", "CZ", "129");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2557", "NOK", "SK", "118");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2558", "NOK", "AE", "151");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2559", "NOK", "SG", "151");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2560", "NOK", "IL", "151");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2561", "NOK", "KW", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2562", "NOK", "IT", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2563", "NOK", "JP", "188");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2564", "NOK", "ES", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2565", "NOK", "VE", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2566", "NOK", "HU", "118");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2567", "NOK", "PT", "129");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2568", "NOK", "GR", "129");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2569", "NOK", "KR", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2570", "NOK", "TW", "129");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2571", "NOK", "PL", "59");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2572", "NOK", "ZM", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2573", "NOK", "PR", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2574", "NOK", "CI", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2575", "NOK", "RO", "118");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2576", "NOK", "BH", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2577", "NOK", "PA", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2578", "NOK", "GH", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2579", "NOK", "KH", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2580", "NOK", "SN", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2581", "NOK", "SA", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2582", "NOK", "RU", "151");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2583", "NOK", "UG", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2584", "NOK", "BR", "59");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2585", "NOK", "NI", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2586", "NOK", "MG", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2587", "NOK", "DO", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2588", "NOK", "MX", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2589", "NOK", "OM", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2590", "NOK", "CM", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2591", "NOK", "ZA", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2592", "NOK", "CL", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2593", "NOK", "KE", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2594", "NOK", "NP", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2595", "NOK", "PE", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2596", "NOK", "UA", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2597", "NOK", "MZ", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2598", "NOK", "TZ", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2599", "NOK", "AO", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2600", "NOK", "JO", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2601", "NOK", "ZW", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2602", "NOK", "TR", "118");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2603", "NOK", "MU", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2604", "NOK", "SV", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2605", "NOK", "TH", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2606", "NOK", "CO", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2607", "NOK", "LK", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2608", "NOK", "CR", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2609", "NOK", "AR", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2610", "NOK", "MA", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2611", "NOK", "MY", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2612", "NOK", "KZ", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2613", "NOK", "DZ", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2614", "NOK", "ID", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2615", "NOK", "NG", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2616", "NOK", "GT", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2617", "NOK", "VN", "59");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2618", "NOK", "BY", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2619", "NOK", "EG", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2620", "NOK", "UY", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2621", "NOK", "BD", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2622", "NOK", "PK", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2623", "NOK", "PH", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2624", "NOK", "ET", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2625", "NOK", "TN", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2626", "NOK", "LB", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2627", "NOK", "IN", "59");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2628", "NOK", "PY", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2629", "NOK", "UZ", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2630", "NOK", "EC", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2631", "NOK", "MM", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2632", "NOK", "GE", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2633", "PEN", "US", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2634", "PEN", "CH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2635", "PEN", "AU", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2636", "PEN", "GB", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2637", "PEN", "DE", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2638", "PEN", "DK", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2639", "PEN", "AT", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2640", "PEN", "NO", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2641", "PEN", "CA", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2642", "PEN", "NL", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2643", "PEN", "SE", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2644", "PEN", "IE", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2645", "PEN", "BE", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2646", "PEN", "FI", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2647", "PEN", "FR", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2648", "PEN", "NZ", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2649", "PEN", "HK", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2650", "PEN", "CZ", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2651", "PEN", "SK", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2652", "PEN", "AE", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2653", "PEN", "SG", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2654", "PEN", "IL", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2655", "PEN", "KW", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2656", "PEN", "IT", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2657", "PEN", "JP", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2658", "PEN", "ES", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2659", "PEN", "VE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2660", "PEN", "HU", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2661", "PEN", "PT", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2662", "PEN", "GR", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2663", "PEN", "KR", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2664", "PEN", "TW", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2665", "PEN", "PL", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2666", "PEN", "ZM", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2667", "PEN", "PR", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2668", "PEN", "CI", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2669", "PEN", "RO", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2670", "PEN", "BH", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2671", "PEN", "PA", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2672", "PEN", "GH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2673", "PEN", "KH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2674", "PEN", "SN", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2675", "PEN", "SA", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2676", "PEN", "RU", "52");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2677", "PEN", "UG", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2678", "PEN", "BR", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2679", "PEN", "NI", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2680", "PEN", "MG", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2681", "PEN", "DO", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2682", "PEN", "MX", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2683", "PEN", "OM", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2684", "PEN", "CM", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2685", "PEN", "ZA", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2686", "PEN", "CL", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2687", "PEN", "KE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2688", "PEN", "NP", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2689", "PEN", "PE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2690", "PEN", "UA", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2691", "PEN", "MZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2692", "PEN", "TZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2693", "PEN", "AO", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2694", "PEN", "JO", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2695", "PEN", "ZW", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2696", "PEN", "TR", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2697", "PEN", "MU", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2698", "PEN", "SV", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2699", "PEN", "TH", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2700", "PEN", "CO", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2701", "PEN", "LK", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2702", "PEN", "CR", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2703", "PEN", "AR", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2704", "PEN", "MA", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2705", "PEN", "MY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2706", "PEN", "KZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2707", "PEN", "DZ", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2708", "PEN", "ID", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2709", "PEN", "NG", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2710", "PEN", "GT", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2711", "PEN", "VN", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2712", "PEN", "BY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2713", "PEN", "EG", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2714", "PEN", "UY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2715", "PEN", "BD", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2716", "PEN", "PK", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2717", "PEN", "PH", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2718", "PEN", "ET", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2719", "PEN", "TN", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2720", "PEN", "LB", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2721", "PEN", "IN", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2722", "PEN", "PY", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2723", "PEN", "UZ", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2724", "PEN", "EC", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2725", "PEN", "MM", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2726", "PEN", "GE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2727", "PHP", "US", "832");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2728", "PHP", "CH", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2729", "PHP", "AU", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2730", "PHP", "GB", "971");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2731", "PHP", "DE", "971");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2732", "PHP", "DK", "777");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2733", "PHP", "AT", "666");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2734", "PHP", "NO", "666");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2735", "PHP", "CA", "777");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2736", "PHP", "NL", "777");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2737", "PHP", "SE", "777");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2738", "PHP", "IE", "610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2739", "PHP", "BE", "610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2740", "PHP", "FI", "610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2741", "PHP", "FR", "777");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2742", "PHP", "NZ", "666");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2743", "PHP", "HK", "333");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2744", "PHP", "CZ", "666");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2745", "PHP", "SK", "610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2746", "PHP", "AE", "777");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2747", "PHP", "SG", "777");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2748", "PHP", "IL", "777");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2749", "PHP", "KW", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2750", "PHP", "IT", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2751", "PHP", "JP", "971");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2752", "PHP", "ES", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2753", "PHP", "VE", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2754", "PHP", "HU", "610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2755", "PHP", "PT", "666");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2756", "PHP", "GR", "666");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2757", "PHP", "KR", "333");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2758", "PHP", "TW", "666");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2759", "PHP", "PL", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2760", "PHP", "ZM", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2761", "PHP", "PR", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2762", "PHP", "CI", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2763", "PHP", "RO", "610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2764", "PHP", "BH", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2765", "PHP", "PA", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2766", "PHP", "GH", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2767", "PHP", "KH", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2768", "PHP", "SN", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2769", "PHP", "SA", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2770", "PHP", "RU", "777");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2771", "PHP", "UG", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2772", "PHP", "BR", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2773", "PHP", "NI", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2774", "PHP", "MG", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2775", "PHP", "DO", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2776", "PHP", "MX", "333");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2777", "PHP", "OM", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2778", "PHP", "CM", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2779", "PHP", "ZA", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2780", "PHP", "CL", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2781", "PHP", "KE", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2782", "PHP", "NP", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2783", "PHP", "PE", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2784", "PHP", "UA", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2785", "PHP", "MZ", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2786", "PHP", "TZ", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2787", "PHP", "AO", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2788", "PHP", "JO", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2789", "PHP", "ZW", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2790", "PHP", "TR", "610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2791", "PHP", "MU", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2792", "PHP", "SV", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2793", "PHP", "TH", "333");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2794", "PHP", "CO", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2795", "PHP", "LK", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2796", "PHP", "CR", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2797", "PHP", "AR", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2798", "PHP", "MA", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2799", "PHP", "MY", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2800", "PHP", "KZ", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2801", "PHP", "DZ", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2802", "PHP", "ID", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2803", "PHP", "NG", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2804", "PHP", "GT", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2805", "PHP", "VN", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2806", "PHP", "BY", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2807", "PHP", "EG", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2808", "PHP", "UY", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2809", "PHP", "BD", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2810", "PHP", "PK", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2811", "PHP", "PH", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2812", "PHP", "ET", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2813", "PHP", "TN", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2814", "PHP", "LB", "361");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2815", "PHP", "IN", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2816", "PHP", "PY", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2817", "PHP", "UZ", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2818", "PHP", "EC", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2819", "PHP", "MM", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2820", "PHP", "GE", "749");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2821", "PKR", "US", "4272");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2822", "PKR", "CH", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2823", "PKR", "AU", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2824", "PKR", "GB", "4984");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2825", "PKR", "DE", "4984");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2826", "PKR", "DK", "3987");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2827", "PKR", "AT", "3418");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2828", "PKR", "NO", "3418");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2829", "PKR", "CA", "3987");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2830", "PKR", "NL", "3987");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2831", "PKR", "SE", "3987");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2832", "PKR", "IE", "3133");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2833", "PKR", "BE", "3133");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2834", "PKR", "FI", "3133");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2835", "PKR", "FR", "3987");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2836", "PKR", "NZ", "3418");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2837", "PKR", "HK", "1709");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2838", "PKR", "CZ", "3418");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2839", "PKR", "SK", "3133");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2840", "PKR", "AE", "3987");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2841", "PKR", "SG", "3987");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2842", "PKR", "IL", "3987");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2843", "PKR", "KW", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2844", "PKR", "IT", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2845", "PKR", "JP", "4984");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2846", "PKR", "ES", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2847", "PKR", "VE", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2848", "PKR", "HU", "3133");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2849", "PKR", "PT", "3418");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2850", "PKR", "GR", "3418");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2851", "PKR", "KR", "1709");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2852", "PKR", "TW", "3418");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2853", "PKR", "PL", "1566");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2854", "PKR", "ZM", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2855", "PKR", "PR", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2856", "PKR", "CI", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2857", "PKR", "RO", "3133");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2858", "PKR", "BH", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2859", "PKR", "PA", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2860", "PKR", "GH", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2861", "PKR", "KH", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2862", "PKR", "SN", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2863", "PKR", "SA", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2864", "PKR", "RU", "3987");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2865", "PKR", "UG", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2866", "PKR", "BR", "1566");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2867", "PKR", "NI", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2868", "PKR", "MG", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2869", "PKR", "DO", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2870", "PKR", "MX", "1709");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2871", "PKR", "OM", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2872", "PKR", "CM", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2873", "PKR", "ZA", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2874", "PKR", "CL", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2875", "PKR", "KE", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2876", "PKR", "NP", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2877", "PKR", "PE", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2878", "PKR", "UA", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2879", "PKR", "MZ", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2880", "PKR", "TZ", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2881", "PKR", "AO", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2882", "PKR", "JO", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2883", "PKR", "ZW", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2884", "PKR", "TR", "3133");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2885", "PKR", "MU", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2886", "PKR", "SV", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2887", "PKR", "TH", "1709");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2888", "PKR", "CO", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2889", "PKR", "LK", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2890", "PKR", "CR", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2891", "PKR", "AR", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2892", "PKR", "MA", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2893", "PKR", "MY", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2894", "PKR", "KZ", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2895", "PKR", "DZ", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2896", "PKR", "ID", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2897", "PKR", "NG", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2898", "PKR", "GT", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2899", "PKR", "VN", "1566");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2900", "PKR", "BY", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2901", "PKR", "EG", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2902", "PKR", "UY", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2903", "PKR", "BD", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2904", "PKR", "PK", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2905", "PKR", "PH", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2906", "PKR", "ET", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2907", "PKR", "TN", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2908", "PKR", "LB", "1851");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2909", "PKR", "IN", "1566");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2910", "PKR", "PY", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2911", "PKR", "UZ", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2912", "PKR", "EC", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2913", "PKR", "MM", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2914", "PKR", "GE", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2915", "PLN", "US", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2916", "PLN", "CH", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2917", "PLN", "AU", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2918", "PLN", "GB", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2919", "PLN", "DE", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2920", "PLN", "DK", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2921", "PLN", "AT", "48");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2922", "PLN", "NO", "48");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2923", "PLN", "CA", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2924", "PLN", "NL", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2925", "PLN", "SE", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2926", "PLN", "IE", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2927", "PLN", "BE", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2928", "PLN", "FI", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2929", "PLN", "FR", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2930", "PLN", "NZ", "48");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2931", "PLN", "HK", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2932", "PLN", "CZ", "48");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2933", "PLN", "SK", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2934", "PLN", "AE", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2935", "PLN", "SG", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2936", "PLN", "IL", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2937", "PLN", "KW", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2938", "PLN", "IT", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2939", "PLN", "JP", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2940", "PLN", "ES", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2941", "PLN", "VE", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2942", "PLN", "HU", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2943", "PLN", "PT", "48");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2944", "PLN", "GR", "48");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2945", "PLN", "KR", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2946", "PLN", "TW", "48");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2947", "PLN", "PL", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2948", "PLN", "ZM", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2949", "PLN", "PR", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2950", "PLN", "CI", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2951", "PLN", "RO", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2952", "PLN", "BH", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2953", "PLN", "PA", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2954", "PLN", "GH", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2955", "PLN", "KH", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2956", "PLN", "SN", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2957", "PLN", "SA", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2958", "PLN", "RU", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2959", "PLN", "UG", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2960", "PLN", "BR", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2961", "PLN", "NI", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2962", "PLN", "MG", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2963", "PLN", "DO", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2964", "PLN", "MX", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2965", "PLN", "OM", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2966", "PLN", "CM", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2967", "PLN", "ZA", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2968", "PLN", "CL", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2969", "PLN", "KE", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2970", "PLN", "NP", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2971", "PLN", "PE", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2972", "PLN", "UA", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2973", "PLN", "MZ", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2974", "PLN", "TZ", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2975", "PLN", "AO", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2976", "PLN", "JO", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2977", "PLN", "ZW", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2978", "PLN", "TR", "44");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2979", "PLN", "MU", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2980", "PLN", "SV", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2981", "PLN", "TH", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2982", "PLN", "CO", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2983", "PLN", "LK", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2984", "PLN", "CR", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2985", "PLN", "AR", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2986", "PLN", "MA", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2987", "PLN", "MY", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2988", "PLN", "KZ", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2989", "PLN", "DZ", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2990", "PLN", "ID", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2991", "PLN", "NG", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2992", "PLN", "GT", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2993", "PLN", "VN", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2994", "PLN", "BY", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2995", "PLN", "EG", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2996", "PLN", "UY", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2997", "PLN", "BD", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2998", "PLN", "PK", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2999", "PLN", "PH", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3000", "PLN", "ET", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3001", "PLN", "TN", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3002", "PLN", "LB", "26");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3003", "PLN", "IN", "22");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3004", "PLN", "PY", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3005", "PLN", "UZ", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3006", "PLN", "EC", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3007", "PLN", "MM", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3008", "PLN", "GE", "54");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3009", "RON", "US", "69");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3010", "RON", "CH", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3011", "RON", "AU", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3012", "RON", "GB", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3013", "RON", "DE", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3014", "RON", "DK", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3015", "RON", "AT", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3016", "RON", "NO", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3017", "RON", "CA", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3018", "RON", "NL", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3019", "RON", "SE", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3020", "RON", "IE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3021", "RON", "BE", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3022", "RON", "FI", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3023", "RON", "FR", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3024", "RON", "NZ", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3025", "RON", "HK", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3026", "RON", "CZ", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3027", "RON", "SK", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3028", "RON", "AE", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3029", "RON", "SG", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3030", "RON", "IL", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3031", "RON", "KW", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3032", "RON", "IT", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3033", "RON", "JP", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3034", "RON", "ES", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3035", "RON", "VE", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3036", "RON", "HU", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3037", "RON", "PT", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3038", "RON", "GR", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3039", "RON", "KR", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3040", "RON", "TW", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3041", "RON", "PL", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3042", "RON", "ZM", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3043", "RON", "PR", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3044", "RON", "CI", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3045", "RON", "RO", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3046", "RON", "BH", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3047", "RON", "PA", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3048", "RON", "GH", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3049", "RON", "KH", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3050", "RON", "SN", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3051", "RON", "SA", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3052", "RON", "RU", "64");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3053", "RON", "UG", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3054", "RON", "BR", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3055", "RON", "NI", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3056", "RON", "MG", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3057", "RON", "DO", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3058", "RON", "MX", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3059", "RON", "OM", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3060", "RON", "CM", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3061", "RON", "ZA", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3062", "RON", "CL", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3063", "RON", "KE", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3064", "RON", "NP", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3065", "RON", "PE", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3066", "RON", "UA", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3067", "RON", "MZ", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3068", "RON", "TZ", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3069", "RON", "AO", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3070", "RON", "JO", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3071", "RON", "ZW", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3072", "RON", "TR", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3073", "RON", "MU", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3074", "RON", "SV", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3075", "RON", "TH", "27");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3076", "RON", "CO", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3077", "RON", "LK", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3078", "RON", "CR", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3079", "RON", "AR", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3080", "RON", "MA", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3081", "RON", "MY", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3082", "RON", "KZ", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3083", "RON", "DZ", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3084", "RON", "ID", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3085", "RON", "NG", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3086", "RON", "GT", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3087", "RON", "VN", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3088", "RON", "BY", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3089", "RON", "EG", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3090", "RON", "UY", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3091", "RON", "BD", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3092", "RON", "PK", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3093", "RON", "PH", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3094", "RON", "ET", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3095", "RON", "TN", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3096", "RON", "LB", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3097", "RON", "IN", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3098", "RON", "PY", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3099", "RON", "UZ", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3100", "RON", "EC", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3101", "RON", "MM", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3102", "RON", "GE", "62");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3103", "RSD", "US", "1612");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3104", "RSD", "CH", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3105", "RSD", "AU", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3106", "RSD", "GB", "1880");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3107", "RSD", "DE", "1880");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3108", "RSD", "DK", "1504");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3109", "RSD", "AT", "1289");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3110", "RSD", "NO", "1289");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3111", "RSD", "CA", "1504");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3112", "RSD", "NL", "1504");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3113", "RSD", "SE", "1504");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3114", "RSD", "IE", "1182");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3115", "RSD", "BE", "1182");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3116", "RSD", "FI", "1182");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3117", "RSD", "FR", "1504");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3118", "RSD", "NZ", "1289");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3119", "RSD", "HK", "645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3120", "RSD", "CZ", "1289");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3121", "RSD", "SK", "1182");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3122", "RSD", "AE", "1504");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3123", "RSD", "SG", "1504");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3124", "RSD", "IL", "1504");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3125", "RSD", "KW", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3126", "RSD", "IT", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3127", "RSD", "JP", "1880");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3128", "RSD", "ES", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3129", "RSD", "VE", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3130", "RSD", "HU", "1182");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3131", "RSD", "PT", "1289");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3132", "RSD", "GR", "1289");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3133", "RSD", "KR", "645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3134", "RSD", "TW", "1289");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3135", "RSD", "PL", "591");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3136", "RSD", "ZM", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3137", "RSD", "PR", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3138", "RSD", "CI", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3139", "RSD", "RO", "1182");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3140", "RSD", "BH", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3141", "RSD", "PA", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3142", "RSD", "GH", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3143", "RSD", "KH", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3144", "RSD", "SN", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3145", "RSD", "SA", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3146", "RSD", "RU", "1504");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3147", "RSD", "UG", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3148", "RSD", "BR", "591");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3149", "RSD", "NI", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3150", "RSD", "MG", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3151", "RSD", "DO", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3152", "RSD", "MX", "645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3153", "RSD", "OM", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3154", "RSD", "CM", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3155", "RSD", "ZA", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3156", "RSD", "CL", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3157", "RSD", "KE", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3158", "RSD", "NP", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3159", "RSD", "PE", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3160", "RSD", "UA", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3161", "RSD", "MZ", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3162", "RSD", "TZ", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3163", "RSD", "AO", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3164", "RSD", "JO", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3165", "RSD", "ZW", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3166", "RSD", "TR", "1182");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3167", "RSD", "MU", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3168", "RSD", "SV", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3169", "RSD", "TH", "645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3170", "RSD", "CO", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3171", "RSD", "LK", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3172", "RSD", "CR", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3173", "RSD", "AR", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3174", "RSD", "MA", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3175", "RSD", "MY", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3176", "RSD", "KZ", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3177", "RSD", "DZ", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3178", "RSD", "ID", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3179", "RSD", "NG", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3180", "RSD", "GT", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3181", "RSD", "VN", "591");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3182", "RSD", "BY", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3183", "RSD", "EG", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3184", "RSD", "UY", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3185", "RSD", "BD", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3186", "RSD", "PK", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3187", "RSD", "PH", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3188", "RSD", "ET", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3189", "RSD", "TN", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3190", "RSD", "LB", "698");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3191", "RSD", "IN", "591");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3192", "RSD", "PY", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3193", "RSD", "UZ", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3194", "RSD", "EC", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3195", "RSD", "MM", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3196", "RSD", "GE", "1451");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3197", "RUB", "US", "1326");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3198", "RUB", "CH", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3199", "RUB", "AU", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3200", "RUB", "GB", "1547");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3201", "RUB", "DE", "1547");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3202", "RUB", "DK", "1238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3203", "RUB", "AT", "1061");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3204", "RUB", "NO", "1061");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3205", "RUB", "CA", "1238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3206", "RUB", "NL", "1238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3207", "RUB", "SE", "1238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3208", "RUB", "IE", "972");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3209", "RUB", "BE", "972");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3210", "RUB", "FI", "972");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3211", "RUB", "FR", "1238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3212", "RUB", "NZ", "1061");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3213", "RUB", "HK", "530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3214", "RUB", "CZ", "1061");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3215", "RUB", "SK", "972");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3216", "RUB", "AE", "1238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3217", "RUB", "SG", "1238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3218", "RUB", "IL", "1238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3219", "RUB", "KW", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3220", "RUB", "IT", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3221", "RUB", "JP", "1547");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3222", "RUB", "ES", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3223", "RUB", "VE", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3224", "RUB", "HU", "972");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3225", "RUB", "PT", "1061");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3226", "RUB", "GR", "1061");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3227", "RUB", "KR", "530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3228", "RUB", "TW", "1061");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3229", "RUB", "PL", "486");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3230", "RUB", "ZM", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3231", "RUB", "PR", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3232", "RUB", "CI", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3233", "RUB", "RO", "972");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3234", "RUB", "BH", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3235", "RUB", "PA", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3236", "RUB", "GH", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3237", "RUB", "KH", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3238", "RUB", "SN", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3239", "RUB", "SA", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3240", "RUB", "RU", "1238");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3241", "RUB", "UG", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3242", "RUB", "BR", "486");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3243", "RUB", "NI", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3244", "RUB", "MG", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3245", "RUB", "DO", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3246", "RUB", "MX", "530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3247", "RUB", "OM", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3248", "RUB", "CM", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3249", "RUB", "ZA", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3250", "RUB", "CL", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3251", "RUB", "KE", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3252", "RUB", "NP", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3253", "RUB", "PE", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3254", "RUB", "UA", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3255", "RUB", "MZ", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3256", "RUB", "TZ", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3257", "RUB", "AO", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3258", "RUB", "JO", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3259", "RUB", "ZW", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3260", "RUB", "TR", "972");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3261", "RUB", "MU", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3262", "RUB", "SV", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3263", "RUB", "TH", "530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3264", "RUB", "CO", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3265", "RUB", "LK", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3266", "RUB", "CR", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3267", "RUB", "AR", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3268", "RUB", "MA", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3269", "RUB", "MY", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3270", "RUB", "KZ", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3271", "RUB", "DZ", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3272", "RUB", "ID", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3273", "RUB", "NG", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3274", "RUB", "GT", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3275", "RUB", "VN", "486");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3276", "RUB", "BY", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3277", "RUB", "EG", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3278", "RUB", "UY", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3279", "RUB", "BD", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3280", "RUB", "PK", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3281", "RUB", "PH", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3282", "RUB", "ET", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3283", "RUB", "TN", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3284", "RUB", "LB", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3285", "RUB", "IN", "486");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3286", "RUB", "PY", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3287", "RUB", "UZ", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3288", "RUB", "EC", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3289", "RUB", "MM", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3290", "RUB", "GE", "1193");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3291", "SAR", "US", "56");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3292", "SAR", "CH", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3293", "SAR", "AU", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3294", "SAR", "GB", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3295", "SAR", "DE", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3296", "SAR", "DK", "53");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3297", "SAR", "AT", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3298", "SAR", "NO", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3299", "SAR", "CA", "53");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3300", "SAR", "NL", "53");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3301", "SAR", "SE", "53");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3302", "SAR", "IE", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3303", "SAR", "BE", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3304", "SAR", "FI", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3305", "SAR", "FR", "53");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3306", "SAR", "NZ", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3307", "SAR", "HK", "23");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3308", "SAR", "CZ", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3309", "SAR", "SK", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3310", "SAR", "AE", "53");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3311", "SAR", "SG", "53");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3312", "SAR", "IL", "53");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3313", "SAR", "KW", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3314", "SAR", "IT", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3315", "SAR", "JP", "66");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3316", "SAR", "ES", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3317", "SAR", "VE", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3318", "SAR", "HU", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3319", "SAR", "PT", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3320", "SAR", "GR", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3321", "SAR", "KR", "23");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3322", "SAR", "TW", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3323", "SAR", "PL", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3324", "SAR", "ZM", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3325", "SAR", "PR", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3326", "SAR", "CI", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3327", "SAR", "RO", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3328", "SAR", "BH", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3329", "SAR", "PA", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3330", "SAR", "GH", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3331", "SAR", "KH", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3332", "SAR", "SN", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3333", "SAR", "SA", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3334", "SAR", "RU", "53");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3335", "SAR", "UG", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3336", "SAR", "BR", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3337", "SAR", "NI", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3338", "SAR", "MG", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3339", "SAR", "DO", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3340", "SAR", "MX", "23");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3341", "SAR", "OM", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3342", "SAR", "CM", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3343", "SAR", "ZA", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3344", "SAR", "CL", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3345", "SAR", "KE", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3346", "SAR", "NP", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3347", "SAR", "PE", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3348", "SAR", "UA", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3349", "SAR", "MZ", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3350", "SAR", "TZ", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3351", "SAR", "AO", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3352", "SAR", "JO", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3353", "SAR", "ZW", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3354", "SAR", "TR", "41");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3355", "SAR", "MU", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3356", "SAR", "SV", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3357", "SAR", "TH", "23");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3358", "SAR", "CO", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3359", "SAR", "LK", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3360", "SAR", "CR", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3361", "SAR", "AR", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3362", "SAR", "MA", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3363", "SAR", "MY", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3364", "SAR", "KZ", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3365", "SAR", "DZ", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3366", "SAR", "ID", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3367", "SAR", "NG", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3368", "SAR", "GT", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3369", "SAR", "VN", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3370", "SAR", "BY", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3371", "SAR", "EG", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3372", "SAR", "UY", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3373", "SAR", "BD", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3374", "SAR", "PK", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3375", "SAR", "PH", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3376", "SAR", "ET", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3377", "SAR", "TN", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3378", "SAR", "LB", "24");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3379", "SAR", "IN", "21");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3380", "SAR", "PY", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3381", "SAR", "UZ", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3382", "SAR", "EC", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3383", "SAR", "MM", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3384", "SAR", "GE", "51");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3385", "SEK", "US", "157");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3386", "SEK", "CH", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3387", "SEK", "AU", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3388", "SEK", "GB", "183");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3389", "SEK", "DE", "183");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3390", "SEK", "DK", "147");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3391", "SEK", "AT", "126");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3392", "SEK", "NO", "126");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3393", "SEK", "CA", "147");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3394", "SEK", "NL", "147");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3395", "SEK", "SE", "147");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3396", "SEK", "IE", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3397", "SEK", "BE", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3398", "SEK", "FI", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3399", "SEK", "FR", "147");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3400", "SEK", "NZ", "126");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3401", "SEK", "HK", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3402", "SEK", "CZ", "126");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3403", "SEK", "SK", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3404", "SEK", "AE", "147");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3405", "SEK", "SG", "147");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3406", "SEK", "IL", "147");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3407", "SEK", "KW", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3408", "SEK", "IT", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3409", "SEK", "JP", "183");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3410", "SEK", "ES", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3411", "SEK", "VE", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3412", "SEK", "HU", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3413", "SEK", "PT", "126");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3414", "SEK", "GR", "126");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3415", "SEK", "KR", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3416", "SEK", "TW", "126");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3417", "SEK", "PL", "58");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3418", "SEK", "ZM", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3419", "SEK", "PR", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3420", "SEK", "CI", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3421", "SEK", "RO", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3422", "SEK", "BH", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3423", "SEK", "PA", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3424", "SEK", "GH", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3425", "SEK", "KH", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3426", "SEK", "SN", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3427", "SEK", "SA", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3428", "SEK", "RU", "147");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3429", "SEK", "UG", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3430", "SEK", "BR", "58");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3431", "SEK", "NI", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3432", "SEK", "MG", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3433", "SEK", "DO", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3434", "SEK", "MX", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3435", "SEK", "OM", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3436", "SEK", "CM", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3437", "SEK", "ZA", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3438", "SEK", "CL", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3439", "SEK", "KE", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3440", "SEK", "NP", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3441", "SEK", "PE", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3442", "SEK", "UA", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3443", "SEK", "MZ", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3444", "SEK", "TZ", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3445", "SEK", "AO", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3446", "SEK", "JO", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3447", "SEK", "ZW", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3448", "SEK", "TR", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3449", "SEK", "MU", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3450", "SEK", "SV", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3451", "SEK", "TH", "63");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3452", "SEK", "CO", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3453", "SEK", "LK", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3454", "SEK", "CR", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3455", "SEK", "AR", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3456", "SEK", "MA", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3457", "SEK", "MY", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3458", "SEK", "KZ", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3459", "SEK", "DZ", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3460", "SEK", "ID", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3461", "SEK", "NG", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3462", "SEK", "GT", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3463", "SEK", "VN", "58");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3464", "SEK", "BY", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3465", "SEK", "EG", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3466", "SEK", "UY", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3467", "SEK", "BD", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3468", "SEK", "PK", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3469", "SEK", "PH", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3470", "SEK", "ET", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3471", "SEK", "TN", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3472", "SEK", "LB", "68");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3473", "SEK", "IN", "58");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3474", "SEK", "PY", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3475", "SEK", "UZ", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3476", "SEK", "EC", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3477", "SEK", "MM", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3478", "SEK", "GE", "142");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3479", "SGD", "US", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3480", "SGD", "CH", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3481", "SGD", "AU", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3482", "SGD", "GB", "23");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3483", "SGD", "DE", "23");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3484", "SGD", "DK", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3485", "SGD", "AT", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3486", "SGD", "NO", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3487", "SGD", "CA", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3488", "SGD", "NL", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3489", "SGD", "SE", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3490", "SGD", "IE", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3491", "SGD", "BE", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3492", "SGD", "FI", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3493", "SGD", "FR", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3494", "SGD", "NZ", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3495", "SGD", "HK", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3496", "SGD", "CZ", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3497", "SGD", "SK", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3498", "SGD", "AE", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3499", "SGD", "SG", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3500", "SGD", "IL", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3501", "SGD", "KW", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3502", "SGD", "IT", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3503", "SGD", "JP", "23");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3504", "SGD", "ES", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3505", "SGD", "VE", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3506", "SGD", "HU", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3507", "SGD", "PT", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3508", "SGD", "GR", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3509", "SGD", "KR", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3510", "SGD", "TW", "16");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3511", "SGD", "PL", "7");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3512", "SGD", "ZM", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3513", "SGD", "PR", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3514", "SGD", "CI", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3515", "SGD", "RO", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3516", "SGD", "BH", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3517", "SGD", "PA", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3518", "SGD", "GH", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3519", "SGD", "KH", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3520", "SGD", "SN", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3521", "SGD", "SA", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3522", "SGD", "RU", "19");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3523", "SGD", "UG", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3524", "SGD", "BR", "7");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3525", "SGD", "NI", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3526", "SGD", "MG", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3527", "SGD", "DO", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3528", "SGD", "MX", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3529", "SGD", "OM", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3530", "SGD", "CM", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3531", "SGD", "ZA", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3532", "SGD", "CL", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3533", "SGD", "KE", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3534", "SGD", "NP", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3535", "SGD", "PE", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3536", "SGD", "UA", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3537", "SGD", "MZ", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3538", "SGD", "TZ", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3539", "SGD", "AO", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3540", "SGD", "JO", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3541", "SGD", "ZW", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3542", "SGD", "TR", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3543", "SGD", "MU", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3544", "SGD", "SV", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3545", "SGD", "TH", "8");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3546", "SGD", "CO", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3547", "SGD", "LK", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3548", "SGD", "CR", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3549", "SGD", "AR", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3550", "SGD", "MA", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3551", "SGD", "MY", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3552", "SGD", "KZ", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3553", "SGD", "DZ", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3554", "SGD", "ID", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3555", "SGD", "NG", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3556", "SGD", "GT", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3557", "SGD", "VN", "7");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3558", "SGD", "BY", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3559", "SGD", "EG", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3560", "SGD", "UY", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3561", "SGD", "BD", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3562", "SGD", "PK", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3563", "SGD", "PH", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3564", "SGD", "ET", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3565", "SGD", "TN", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3566", "SGD", "LB", "9");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3567", "SGD", "IN", "7");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3568", "SGD", "PY", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3569", "SGD", "UZ", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3570", "SGD", "EC", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3571", "SGD", "MM", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3572", "SGD", "GE", "18");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3573", "THB", "US", "529");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3574", "THB", "CH", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3575", "THB", "AU", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3576", "THB", "GB", "617");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3577", "THB", "DE", "617");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3578", "THB", "DK", "494");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3579", "THB", "AT", "423");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3580", "THB", "NO", "423");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3581", "THB", "CA", "494");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3582", "THB", "NL", "494");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3583", "THB", "SE", "494");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3584", "THB", "IE", "388");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3585", "THB", "BE", "388");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3586", "THB", "FI", "388");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3587", "THB", "FR", "494");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3588", "THB", "NZ", "423");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3589", "THB", "HK", "212");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3590", "THB", "CZ", "423");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3591", "THB", "SK", "388");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3592", "THB", "AE", "494");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3593", "THB", "SG", "494");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3594", "THB", "IL", "494");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3595", "THB", "KW", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3596", "THB", "IT", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3597", "THB", "JP", "617");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3598", "THB", "ES", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3599", "THB", "VE", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3600", "THB", "HU", "388");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3601", "THB", "PT", "423");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3602", "THB", "GR", "423");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3603", "THB", "KR", "212");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3604", "THB", "TW", "423");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3605", "THB", "PL", "194");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3606", "THB", "ZM", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3607", "THB", "PR", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3608", "THB", "CI", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3609", "THB", "RO", "388");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3610", "THB", "BH", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3611", "THB", "PA", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3612", "THB", "GH", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3613", "THB", "KH", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3614", "THB", "SN", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3615", "THB", "SA", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3616", "THB", "RU", "494");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3617", "THB", "UG", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3618", "THB", "BR", "194");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3619", "THB", "NI", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3620", "THB", "MG", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3621", "THB", "DO", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3622", "THB", "MX", "212");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3623", "THB", "OM", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3624", "THB", "CM", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3625", "THB", "ZA", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3626", "THB", "CL", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3627", "THB", "KE", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3628", "THB", "NP", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3629", "THB", "PE", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3630", "THB", "UA", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3631", "THB", "MZ", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3632", "THB", "TZ", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3633", "THB", "AO", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3634", "THB", "JO", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3635", "THB", "ZW", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3636", "THB", "TR", "388");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3637", "THB", "MU", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3638", "THB", "SV", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3639", "THB", "TH", "212");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3640", "THB", "CO", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3641", "THB", "LK", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3642", "THB", "CR", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3643", "THB", "AR", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3644", "THB", "MA", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3645", "THB", "MY", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3646", "THB", "KZ", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3647", "THB", "DZ", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3648", "THB", "ID", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3649", "THB", "NG", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3650", "THB", "GT", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3651", "THB", "VN", "194");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3652", "THB", "BY", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3653", "THB", "EG", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3654", "THB", "UY", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3655", "THB", "BD", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3656", "THB", "PK", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3657", "THB", "PH", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3658", "THB", "ET", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3659", "THB", "TN", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3660", "THB", "LB", "229");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3661", "THB", "IN", "194");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3662", "THB", "PY", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3663", "THB", "UZ", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3664", "THB", "EC", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3665", "THB", "MM", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3666", "THB", "GE", "476");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3667", "TRY", "US", "433");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3668", "TRY", "CH", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3669", "TRY", "AU", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3670", "TRY", "GB", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3671", "TRY", "DE", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3672", "TRY", "DK", "404");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3673", "TRY", "AT", "346");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3674", "TRY", "NO", "346");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3675", "TRY", "CA", "404");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3676", "TRY", "NL", "404");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3677", "TRY", "SE", "404");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3678", "TRY", "IE", "317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3679", "TRY", "BE", "317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3680", "TRY", "FI", "317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3681", "TRY", "FR", "404");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3682", "TRY", "NZ", "346");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3683", "TRY", "HK", "173");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3684", "TRY", "CZ", "346");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3685", "TRY", "SK", "317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3686", "TRY", "AE", "404");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3687", "TRY", "SG", "404");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3688", "TRY", "IL", "404");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3689", "TRY", "KW", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3690", "TRY", "IT", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3691", "TRY", "JP", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3692", "TRY", "ES", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3693", "TRY", "VE", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3694", "TRY", "HU", "317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3695", "TRY", "PT", "346");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3696", "TRY", "GR", "346");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3697", "TRY", "KR", "173");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3698", "TRY", "TW", "346");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3699", "TRY", "PL", "159");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3700", "TRY", "ZM", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3701", "TRY", "PR", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3702", "TRY", "CI", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3703", "TRY", "RO", "317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3704", "TRY", "BH", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3705", "TRY", "PA", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3706", "TRY", "GH", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3707", "TRY", "KH", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3708", "TRY", "SN", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3709", "TRY", "SA", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3710", "TRY", "RU", "404");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3711", "TRY", "UG", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3712", "TRY", "BR", "159");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3713", "TRY", "NI", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3714", "TRY", "MG", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3715", "TRY", "DO", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3716", "TRY", "MX", "173");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3717", "TRY", "OM", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3718", "TRY", "CM", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3719", "TRY", "ZA", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3720", "TRY", "CL", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3721", "TRY", "KE", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3722", "TRY", "NP", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3723", "TRY", "PE", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3724", "TRY", "UA", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3725", "TRY", "MZ", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3726", "TRY", "TZ", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3727", "TRY", "AO", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3728", "TRY", "JO", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3729", "TRY", "ZW", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3730", "TRY", "TR", "317");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3731", "TRY", "MU", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3732", "TRY", "SV", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3733", "TRY", "TH", "173");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3734", "TRY", "CO", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3735", "TRY", "LK", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3736", "TRY", "CR", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3737", "TRY", "AR", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3738", "TRY", "MA", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3739", "TRY", "MY", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3740", "TRY", "KZ", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3741", "TRY", "DZ", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3742", "TRY", "ID", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3743", "TRY", "NG", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3744", "TRY", "GT", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3745", "TRY", "VN", "159");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3746", "TRY", "BY", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3747", "TRY", "EG", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3748", "TRY", "UY", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3749", "TRY", "BD", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3750", "TRY", "PK", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3751", "TRY", "PH", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3752", "TRY", "ET", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3753", "TRY", "TN", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3754", "TRY", "LB", "187");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3755", "TRY", "IN", "159");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3756", "TRY", "PY", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3757", "TRY", "UZ", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3758", "TRY", "EC", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3759", "TRY", "MM", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3760", "TRY", "GE", "389");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3761", "TWD", "US", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3762", "TWD", "CH", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3763", "TWD", "AU", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3764", "TWD", "GB", "554");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3765", "TWD", "DE", "554");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3766", "TWD", "DK", "443");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3767", "TWD", "AT", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3768", "TWD", "NO", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3769", "TWD", "CA", "443");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3770", "TWD", "NL", "443");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3771", "TWD", "SE", "443");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3772", "TWD", "IE", "348");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3773", "TWD", "BE", "348");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3774", "TWD", "FI", "348");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3775", "TWD", "FR", "443");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3776", "TWD", "NZ", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3777", "TWD", "HK", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3778", "TWD", "CZ", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3779", "TWD", "SK", "348");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3780", "TWD", "AE", "443");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3781", "TWD", "SG", "443");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3782", "TWD", "IL", "443");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3783", "TWD", "KW", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3784", "TWD", "IT", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3785", "TWD", "JP", "554");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3786", "TWD", "ES", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3787", "TWD", "VE", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3788", "TWD", "HU", "348");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3789", "TWD", "PT", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3790", "TWD", "GR", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3791", "TWD", "KR", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3792", "TWD", "TW", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3793", "TWD", "PL", "174");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3794", "TWD", "ZM", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3795", "TWD", "PR", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3796", "TWD", "CI", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3797", "TWD", "RO", "348");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3798", "TWD", "BH", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3799", "TWD", "PA", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3800", "TWD", "GH", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3801", "TWD", "KH", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3802", "TWD", "SN", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3803", "TWD", "SA", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3804", "TWD", "RU", "443");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3805", "TWD", "UG", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3806", "TWD", "BR", "174");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3807", "TWD", "NI", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3808", "TWD", "MG", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3809", "TWD", "DO", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3810", "TWD", "MX", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3811", "TWD", "OM", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3812", "TWD", "CM", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3813", "TWD", "ZA", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3814", "TWD", "CL", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3815", "TWD", "KE", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3816", "TWD", "NP", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3817", "TWD", "PE", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3818", "TWD", "UA", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3819", "TWD", "MZ", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3820", "TWD", "TZ", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3821", "TWD", "AO", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3822", "TWD", "JO", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3823", "TWD", "ZW", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3824", "TWD", "TR", "348");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3825", "TWD", "MU", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3826", "TWD", "SV", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3827", "TWD", "TH", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3828", "TWD", "CO", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3829", "TWD", "LK", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3830", "TWD", "CR", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3831", "TWD", "AR", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3832", "TWD", "MA", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3833", "TWD", "MY", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3834", "TWD", "KZ", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3835", "TWD", "DZ", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3836", "TWD", "ID", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3837", "TWD", "NG", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3838", "TWD", "GT", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3839", "TWD", "VN", "174");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3840", "TWD", "BY", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3841", "TWD", "EG", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3842", "TWD", "UY", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3843", "TWD", "BD", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3844", "TWD", "PK", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3845", "TWD", "PH", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3846", "TWD", "ET", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3847", "TWD", "TN", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3848", "TWD", "LB", "206");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3849", "TWD", "IN", "174");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3850", "TWD", "PY", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3851", "TWD", "UZ", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3852", "TWD", "EC", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3853", "TWD", "MM", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3854", "TWD", "GE", "427");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3855", "UAH", "US", "541");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3856", "UAH", "CH", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3857", "UAH", "AU", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3858", "UAH", "GB", "631");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3859", "UAH", "DE", "631");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3860", "UAH", "DK", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3861", "UAH", "AT", "432");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3862", "UAH", "NO", "432");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3863", "UAH", "CA", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3864", "UAH", "NL", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3865", "UAH", "SE", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3866", "UAH", "IE", "396");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3867", "UAH", "BE", "396");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3868", "UAH", "FI", "396");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3869", "UAH", "FR", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3870", "UAH", "NZ", "432");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3871", "UAH", "HK", "216");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3872", "UAH", "CZ", "432");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3873", "UAH", "SK", "396");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3874", "UAH", "AE", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3875", "UAH", "SG", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3876", "UAH", "IL", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3877", "UAH", "KW", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3878", "UAH", "IT", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3879", "UAH", "JP", "631");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3880", "UAH", "ES", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3881", "UAH", "VE", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3882", "UAH", "HU", "396");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3883", "UAH", "PT", "432");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3884", "UAH", "GR", "432");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3885", "UAH", "KR", "216");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3886", "UAH", "TW", "432");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3887", "UAH", "PL", "198");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3888", "UAH", "ZM", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3889", "UAH", "PR", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3890", "UAH", "CI", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3891", "UAH", "RO", "396");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3892", "UAH", "BH", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3893", "UAH", "PA", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3894", "UAH", "GH", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3895", "UAH", "KH", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3896", "UAH", "SN", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3897", "UAH", "SA", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3898", "UAH", "RU", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3899", "UAH", "UG", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3900", "UAH", "BR", "198");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3901", "UAH", "NI", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3902", "UAH", "MG", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3903", "UAH", "DO", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3904", "UAH", "MX", "216");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3905", "UAH", "OM", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3906", "UAH", "CM", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3907", "UAH", "ZA", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3908", "UAH", "CL", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3909", "UAH", "KE", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3910", "UAH", "NP", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3911", "UAH", "PE", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3912", "UAH", "UA", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3913", "UAH", "MZ", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3914", "UAH", "TZ", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3915", "UAH", "AO", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3916", "UAH", "JO", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3917", "UAH", "ZW", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3918", "UAH", "TR", "396");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3919", "UAH", "MU", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3920", "UAH", "SV", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3921", "UAH", "TH", "216");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3922", "UAH", "CO", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3923", "UAH", "LK", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3924", "UAH", "CR", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3925", "UAH", "AR", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3926", "UAH", "MA", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3927", "UAH", "MY", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3928", "UAH", "KZ", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3929", "UAH", "DZ", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3930", "UAH", "ID", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3931", "UAH", "NG", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3932", "UAH", "GT", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3933", "UAH", "VN", "198");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3934", "UAH", "BY", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3935", "UAH", "EG", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3936", "UAH", "UY", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3937", "UAH", "BD", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3938", "UAH", "PK", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3939", "UAH", "PH", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3940", "UAH", "ET", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3941", "UAH", "TN", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3942", "UAH", "LB", "234");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3943", "UAH", "IN", "198");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3944", "UAH", "PY", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3945", "UAH", "UZ", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3946", "UAH", "EC", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3947", "UAH", "MM", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3948", "UAH", "GE", "487");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3949", "USD", "US", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3950", "USD", "CH", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3951", "USD", "AU", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3952", "USD", "GB", "17");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3953", "USD", "DE", "17");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3954", "USD", "DK", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3955", "USD", "AT", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3956", "USD", "NO", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3957", "USD", "CA", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3958", "USD", "NL", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3959", "USD", "SE", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3960", "USD", "IE", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3961", "USD", "BE", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3962", "USD", "FI", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3963", "USD", "FR", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3964", "USD", "NZ", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3965", "USD", "HK", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3966", "USD", "CZ", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3967", "USD", "SK", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3968", "USD", "AE", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3969", "USD", "SG", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3970", "USD", "IL", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3971", "USD", "KW", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3972", "USD", "IT", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3973", "USD", "JP", "17");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3974", "USD", "ES", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3975", "USD", "VE", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3976", "USD", "HU", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3977", "USD", "PT", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3978", "USD", "GR", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3979", "USD", "KR", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3980", "USD", "TW", "12");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3981", "USD", "PL", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3982", "USD", "ZM", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3983", "USD", "PR", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3984", "USD", "CI", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3985", "USD", "RO", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3986", "USD", "BH", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3987", "USD", "PA", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3988", "USD", "GH", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3989", "USD", "KH", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3990", "USD", "SN", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3991", "USD", "SA", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3992", "USD", "RU", "14");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3993", "USD", "UG", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3994", "USD", "BR", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3995", "USD", "NI", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3996", "USD", "MG", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3997", "USD", "DO", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3998", "USD", "MX", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3999", "USD", "OM", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4000", "USD", "CM", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4001", "USD", "ZA", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4002", "USD", "CL", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4003", "USD", "KE", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4004", "USD", "NP", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4005", "USD", "PE", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4006", "USD", "UA", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4007", "USD", "MZ", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4008", "USD", "TZ", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4009", "USD", "AO", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4010", "USD", "JO", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4011", "USD", "ZW", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4012", "USD", "TR", "11");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4013", "USD", "MU", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4014", "USD", "SV", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4015", "USD", "TH", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4016", "USD", "CO", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4017", "USD", "LK", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4018", "USD", "CR", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4019", "USD", "AR", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4020", "USD", "MA", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4021", "USD", "MY", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4022", "USD", "KZ", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4023", "USD", "DZ", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4024", "USD", "ID", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4025", "USD", "NG", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4026", "USD", "GT", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4027", "USD", "VN", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4028", "USD", "BY", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4029", "USD", "EG", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4030", "USD", "UY", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4031", "USD", "BD", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4032", "USD", "PK", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4033", "USD", "PH", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4034", "USD", "ET", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4035", "USD", "TN", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4036", "USD", "LB", "6");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4037", "USD", "IN", "5");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4038", "USD", "PY", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4039", "USD", "UZ", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4040", "USD", "EC", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4041", "USD", "MM", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4042", "USD", "GE", "13");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4043", "VND", "US", "363225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4044", "VND", "CH", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4045", "VND", "AU", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4046", "VND", "GB", "423763");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4047", "VND", "DE", "423763");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4048", "VND", "DK", "339010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4049", "VND", "AT", "290580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4050", "VND", "NO", "290580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4051", "VND", "CA", "339010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4052", "VND", "NL", "339010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4053", "VND", "SE", "339010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4054", "VND", "IE", "266365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4055", "VND", "BE", "266365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4056", "VND", "FI", "266365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4057", "VND", "FR", "339010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4058", "VND", "NZ", "290580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4059", "VND", "HK", "145290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4060", "VND", "CZ", "290580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4061", "VND", "SK", "266365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4062", "VND", "AE", "339010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4063", "VND", "SG", "339010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4064", "VND", "IL", "339010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4065", "VND", "KW", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4066", "VND", "IT", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4067", "VND", "JP", "423763");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4068", "VND", "ES", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4069", "VND", "VE", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4070", "VND", "HU", "266365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4071", "VND", "PT", "290580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4072", "VND", "GR", "290580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4073", "VND", "KR", "145290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4074", "VND", "TW", "290580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4075", "VND", "PL", "133183");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4076", "VND", "ZM", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4077", "VND", "PR", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4078", "VND", "CI", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4079", "VND", "RO", "266365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4080", "VND", "BH", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4081", "VND", "PA", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4082", "VND", "GH", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4083", "VND", "KH", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4084", "VND", "SN", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4085", "VND", "SA", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4086", "VND", "RU", "339010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4087", "VND", "UG", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4088", "VND", "BR", "133183");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4089", "VND", "NI", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4090", "VND", "MG", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4091", "VND", "DO", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4092", "VND", "MX", "145290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4093", "VND", "OM", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4094", "VND", "CM", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4095", "VND", "ZA", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4096", "VND", "CL", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4097", "VND", "KE", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4098", "VND", "NP", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4099", "VND", "PE", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4100", "VND", "UA", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4101", "VND", "MZ", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4102", "VND", "TZ", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4103", "VND", "AO", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4104", "VND", "JO", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4105", "VND", "ZW", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4106", "VND", "TR", "266365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4107", "VND", "MU", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4108", "VND", "SV", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4109", "VND", "TH", "145290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4110", "VND", "CO", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4111", "VND", "LK", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4112", "VND", "CR", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4113", "VND", "AR", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4114", "VND", "MA", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4115", "VND", "MY", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4116", "VND", "KZ", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4117", "VND", "DZ", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4118", "VND", "ID", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4119", "VND", "NG", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4120", "VND", "GT", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4121", "VND", "VN", "133183");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4122", "VND", "BY", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4123", "VND", "EG", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4124", "VND", "UY", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4125", "VND", "BD", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4126", "VND", "PK", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4127", "VND", "PH", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4128", "VND", "ET", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4129", "VND", "TN", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4130", "VND", "LB", "157398");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4131", "VND", "IN", "133183");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4132", "VND", "PY", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4133", "VND", "UZ", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4134", "VND", "EC", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4135", "VND", "MM", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4136", "VND", "GE", "326903");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4137", "ZAR", "US", "283");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4138", "ZAR", "CH", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4139", "ZAR", "AU", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4140", "ZAR", "GB", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4141", "ZAR", "DE", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4142", "ZAR", "DK", "264");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4143", "ZAR", "AT", "227");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4144", "ZAR", "NO", "227");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4145", "ZAR", "CA", "264");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4146", "ZAR", "NL", "264");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4147", "ZAR", "SE", "264");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4148", "ZAR", "IE", "208");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4149", "ZAR", "BE", "208");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4150", "ZAR", "FI", "208");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4151", "ZAR", "FR", "264");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4152", "ZAR", "NZ", "227");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4153", "ZAR", "HK", "113");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4154", "ZAR", "CZ", "227");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4155", "ZAR", "SK", "208");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4156", "ZAR", "AE", "264");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4157", "ZAR", "SG", "264");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4158", "ZAR", "IL", "264");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4159", "ZAR", "KW", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4160", "ZAR", "IT", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4161", "ZAR", "JP", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4162", "ZAR", "ES", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4163", "ZAR", "VE", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4164", "ZAR", "HU", "208");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4165", "ZAR", "PT", "227");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4166", "ZAR", "GR", "227");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4167", "ZAR", "KR", "113");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4168", "ZAR", "TW", "227");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4169", "ZAR", "PL", "104");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4170", "ZAR", "ZM", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4171", "ZAR", "PR", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4172", "ZAR", "CI", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4173", "ZAR", "RO", "208");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4174", "ZAR", "BH", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4175", "ZAR", "PA", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4176", "ZAR", "GH", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4177", "ZAR", "KH", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4178", "ZAR", "SN", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4179", "ZAR", "SA", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4180", "ZAR", "RU", "264");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4181", "ZAR", "UG", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4182", "ZAR", "BR", "104");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4183", "ZAR", "NI", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4184", "ZAR", "MG", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4185", "ZAR", "DO", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4186", "ZAR", "MX", "113");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4187", "ZAR", "OM", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4188", "ZAR", "CM", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4189", "ZAR", "ZA", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4190", "ZAR", "CL", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4191", "ZAR", "KE", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4192", "ZAR", "NP", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4193", "ZAR", "PE", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4194", "ZAR", "UA", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4195", "ZAR", "MZ", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4196", "ZAR", "TZ", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4197", "ZAR", "AO", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4198", "ZAR", "JO", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4199", "ZAR", "ZW", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4200", "ZAR", "TR", "208");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4201", "ZAR", "MU", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4202", "ZAR", "SV", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4203", "ZAR", "TH", "113");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4204", "ZAR", "CO", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4205", "ZAR", "LK", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4206", "ZAR", "CR", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4207", "ZAR", "AR", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4208", "ZAR", "MA", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4209", "ZAR", "MY", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4210", "ZAR", "KZ", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4211", "ZAR", "DZ", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4212", "ZAR", "ID", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4213", "ZAR", "NG", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4214", "ZAR", "GT", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4215", "ZAR", "VN", "104");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4216", "ZAR", "BY", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4217", "ZAR", "EG", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4218", "ZAR", "UY", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4219", "ZAR", "BD", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4220", "ZAR", "PK", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4221", "ZAR", "PH", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4222", "ZAR", "ET", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4223", "ZAR", "TN", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4224", "ZAR", "LB", "123");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4225", "ZAR", "IN", "104");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4226", "ZAR", "PY", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4227", "ZAR", "UZ", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4228", "ZAR", "EC", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4229", "ZAR", "MM", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4230", "ZAR", "GE", "255");

/* INSERT TABLE DATA: wp_mailpoet_migrations */
INSERT INTO `wp_mailpoet_migrations` VALUES("1", "Migration_20221028_105818", "2025-03-27 05:18:09", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("2", "Migration_20221110_151621", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("3", "Migration_20230111_120000", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("4", "Migration_20230111_130000", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("5", "Migration_20230215_050813", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("6", "Migration_20230221_200520", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("7", "Migration_20230421_135915", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("8", "Migration_20230503_210945", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("9", "Migration_20230605_174836", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("10", "Migration_20230703_105957", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("11", "Migration_20230716_130221_Db", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("12", "Migration_20230824_054259_Db", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("13", "Migration_20230831_124214_Db", "2025-03-27 05:18:10", "2025-03-27 05:18:10", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("14", "Migration_20230831_143755_Db", "2025-03-27 05:18:10", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("15", "Migration_20240119_113943_Db", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("16", "Migration_20240617_122847_Db", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("17", "Migration_20240725_182318_Db", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("18", "Migration_20241007_170437_Db", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("19", "Migration_20241108_103249_Db", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("20", "Migration_20221028_105818_App", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("21", "Migration_20230109_144830", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("22", "Migration_20230131_121621", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("23", "Migration_20230419_080000", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("24", "Migration_20230425_211517", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("25", "Migration_20230712_180341", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("26", "Migration_20230803_200413_App", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("27", "Migration_20230825_093531_App", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("28", "Migration_20231128_120355_App", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("29", "Migration_20240202_130053_App", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("30", "Migration_20240207_105912_App", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("31", "Migration_20240322_110443_App", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("32", "Migration_20240730_212419_App", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("33", "Migration_20241015_105511_App", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("34", "Migration_20241128_114257_App", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("35", "Migration_20250120_094614_App", "2025-03-27 05:18:11", "2025-03-27 05:18:11", "0", NULL);

/* INSERT TABLE DATA: wp_mailpoet_newsletter_option_fields */
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("1", "isScheduled", "standard", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("2", "scheduledAt", "standard", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("3", "event", "welcome", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("4", "segment", "welcome", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("5", "role", "welcome", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("6", "afterTimeNumber", "welcome", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("7", "afterTimeType", "welcome", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("8", "intervalType", "notification", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("9", "timeOfDay", "notification", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("10", "weekDay", "notification", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("11", "monthDay", "notification", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("12", "nthWeekDay", "notification", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("13", "schedule", "notification", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("14", "group", "automatic", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("15", "group", "automation", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("16", "group", "automation_transactional", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("17", "event", "automatic", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("18", "event", "automation", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("19", "event", "automation_transactional", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("20", "sendTo", "automatic", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("21", "segment", "automatic", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("22", "afterTimeNumber", "automatic", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("23", "afterTimeType", "automatic", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("24", "meta", "automatic", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("25", "afterTimeNumber", "re_engagement", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("26", "afterTimeType", "re_engagement", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("27", "automationId", "automation", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("28", "automationStepId", "automation", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("29", "filterSegmentId", "standard", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("30", "filterSegmentId", "re_engagement", NULL, "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("31", "filterSegmentId", "notification", NULL, "2025-03-27 05:18:11");

/* INSERT TABLE DATA: wp_mailpoet_segments */
INSERT INTO `wp_mailpoet_segments` VALUES("1", "Utilisateurs WordPress", "wp_users", "Cette liste contient tous vos utilisateurs WordPress.", "2025-03-27 09:18:34", "2025-03-27 09:18:34", NULL, NULL, NULL, "0");
INSERT INTO `wp_mailpoet_segments` VALUES("2", "Clients WooCommerce", "woocommerce_users", "Cette liste contient tous vos clients WooCommerce.", "2025-06-16 01:35:37", "2025-06-16 01:35:37", NULL, NULL, NULL, "0");

/* INSERT TABLE DATA: wp_mailpoet_settings */
INSERT INTO `wp_mailpoet_settings` VALUES("1", "mta_log", "a:8:{s:4:\"sent\";a:0:{}s:7:\"started\";i:1743027491;s:6:\"status\";N;s:13:\"retry_attempt\";N;s:8:\"retry_at\";N;s:5:\"error\";N;s:33:\"transactional_email_last_error_at\";N;s:31:\"transactional_email_error_count\";N;}", "2025-03-27 05:18:11", "2025-03-27 05:18:11");
INSERT INTO `wp_mailpoet_settings` VALUES("2", "homepage", "a:1:{s:27:\"product_discovery_dismissed\";b:0;}", "2025-03-27 05:18:11", "2025-03-27 05:18:11");

/* INSERT TABLE DATA: wp_mailpoet_subscriber_segment */
INSERT INTO `wp_mailpoet_subscriber_segment` VALUES("1", "1", "1", "subscribed", "2025-03-27 09:18:34", "2025-03-27 09:18:34");
INSERT INTO `wp_mailpoet_subscriber_segment` VALUES("2", "1", "2", "subscribed", "2025-06-16 01:35:37", "2025-06-16 01:35:37");

/* INSERT TABLE DATA: wp_mailpoet_subscribers */
INSERT INTO `wp_mailpoet_subscribers` VALUES("1", "1", "1", "nellb", "", "nellboulanger07@gmail.com", "unconfirmed", NULL, NULL, NULL, NULL, "2025-03-27 09:18:34", "2025-11-23 00:05:41", NULL, NULL, "wordpress_user", "0", NULL, NULL, NULL, NULL, "2025-11-23 00:04:41", NULL, "0", NULL, NULL, NULL, NULL, "2025-11-23 00:04:41");

/* INSERT TABLE DATA: wp_nextend2_image_storage */
INSERT INTO `wp_nextend2_image_storage` VALUES("1", "716b3b89af0064ad5e55759fe0c1c9b1", "$upload$/slider2/image-slider-with-thumbnail1.jpeg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlIjp7ImltYWdlIjoiIiwic2l6ZSI6IjB8KnwwIn0sImRlc2t0b3AiOnsic2l6ZSI6IjB8KnwwIn0sInRhYmxldC1yZXRpbmEiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9fQ==");
INSERT INTO `wp_nextend2_image_storage` VALUES("2", "0dfd3eb1dc96f2f56aa13e7532134d0d", "$upload$/slider2/image-slider-with-thumbnail2.jpeg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlIjp7ImltYWdlIjoiIiwic2l6ZSI6IjB8KnwwIn0sImRlc2t0b3AiOnsic2l6ZSI6IjB8KnwwIn0sInRhYmxldC1yZXRpbmEiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9fQ==");
INSERT INTO `wp_nextend2_image_storage` VALUES("3", "6937e5fb2ea1fa5cb5b887ebb970569f", "$upload$/slider2/image-slider-with-thumbnail3.jpeg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlIjp7ImltYWdlIjoiIiwic2l6ZSI6IjB8KnwwIn0sImRlc2t0b3AiOnsic2l6ZSI6IjB8KnwwIn0sInRhYmxldC1yZXRpbmEiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9fQ==");
INSERT INTO `wp_nextend2_image_storage` VALUES("4", "32cdca2e1198f6ecb5a46138fa5e8e39", "$upload$/slider2/image-slider-with-thumbnail4.jpeg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlIjp7ImltYWdlIjoiIiwic2l6ZSI6IjB8KnwwIn0sImRlc2t0b3AiOnsic2l6ZSI6IjB8KnwwIn0sInRhYmxldC1yZXRpbmEiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9fQ==");
INSERT INTO `wp_nextend2_image_storage` VALUES("5", "f0fe234eedc931988c63fde08aa01fb3", "$upload$/slider2/image-slider-with-thumbnail5.jpeg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlIjp7ImltYWdlIjoiIiwic2l6ZSI6IjB8KnwwIn0sImRlc2t0b3AiOnsic2l6ZSI6IjB8KnwwIn0sInRhYmxldC1yZXRpbmEiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9fQ==");
INSERT INTO `wp_nextend2_image_storage` VALUES("6", "2824000f38981d7f0d43e062830ee164", "$upload$/slider2/image-slider-with-thumbnail6.jpeg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlIjp7ImltYWdlIjoiIiwic2l6ZSI6IjB8KnwwIn0sImRlc2t0b3AiOnsic2l6ZSI6IjB8KnwwIn0sInRhYmxldC1yZXRpbmEiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9fQ==");
INSERT INTO `wp_nextend2_image_storage` VALUES("7", "03ecb08cd94a290b2f3872698ea78963", "$upload$/slider2/image-slider-with-thumbnail7.jpeg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlIjp7ImltYWdlIjoiIiwic2l6ZSI6IjB8KnwwIn0sImRlc2t0b3AiOnsic2l6ZSI6IjB8KnwwIn0sInRhYmxldC1yZXRpbmEiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlLXJldGluYSI6eyJpbWFnZSI6IiIsInNpemUiOiIwfCp8MCJ9fQ==");
INSERT INTO `wp_nextend2_image_storage` VALUES("8", "dcf40ff7d421aac7cdb17a803f3f07a7", "$upload$/slider4/full1.jpeg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlIjp7ImltYWdlIjoiIiwic2l6ZSI6IjB8KnwwIn0sImRlc2t0b3AiOnsic2l6ZSI6IjB8KnwwIn19");
INSERT INTO `wp_nextend2_image_storage` VALUES("9", "b253a2cb0981c1531f8af37141014648", "$upload$/slider4/full2.jpg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlIjp7ImltYWdlIjoiIiwic2l6ZSI6IjB8KnwwIn0sImRlc2t0b3AiOnsic2l6ZSI6IjB8KnwwIn19");
INSERT INTO `wp_nextend2_image_storage` VALUES("10", "17a693ec44672d4937fcc48f6cf9d8c3", "$upload$/slider4/full3.jpg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIiLCJzaXplIjoiMHwqfDAifSwibW9iaWxlIjp7ImltYWdlIjoiIiwic2l6ZSI6IjB8KnwwIn0sImRlc2t0b3AiOnsic2l6ZSI6IjB8KnwwIn19");
INSERT INTO `wp_nextend2_image_storage` VALUES("11", "3a58141b2d8b98c3efe352f09c2a7c6e", "$upload$/2025/07/2ec912fe-87bd-4c0e-9b2a-49a982a44178.jpeg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIifSwibW9iaWxlIjp7ImltYWdlIjoiIn19");
INSERT INTO `wp_nextend2_image_storage` VALUES("12", "423de1b270c1dd10ac56f3bd672754eb", "$upload$/2025/07/4aee027a-8f57-4ff5-b044-1c48be6e8dfa.jpeg", "eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIifSwibW9iaWxlIjp7ImltYWdlIjoiIn19");

/* INSERT TABLE DATA: wp_nextend2_section_storage */
INSERT INTO `wp_nextend2_section_storage` VALUES("10000", "smartslider", "settings", "", "{\"n2_ss3_version\":\"3.5.1.28\\/b:release-3.5.1.28\\/r:c93425663714d4ea8408a34cc97c0cf3e857f9fa\",\"limit\":\"all\",\"slidersOrder2\":\"ordering\",\"slidersOrder2Direction\":\"ASC\"}", "0", "1");
INSERT INTO `wp_nextend2_section_storage` VALUES("10001", "smartslider", "free", "dismissNewsletterSampleSliders", "1", "0", "1");
INSERT INTO `wp_nextend2_section_storage` VALUES("10042", "smartslider", "tutorial", "GettingStarted", "1", "0", "1");
INSERT INTO `wp_nextend2_section_storage` VALUES("10411", "smartslider", "sliderChanged", "4", "0", "0", "1");
INSERT INTO `wp_nextend2_section_storage` VALUES("10412", "cache", "notweb/n2-ss-4", "data.manifest", "{\"generator\":[]}", "0", "1");
INSERT INTO `wp_nextend2_section_storage` VALUES("10413", "cache", "notweb/n2-ss-4", "variations.manifest", "1", "0", "1");
INSERT INTO `wp_nextend2_section_storage` VALUES("10414", "cache", "notweb/n2-ss-4", "sliderfr_FR1.manifest", "{\"hash\":\"\",\"nextCacheRefresh\":2145916800,\"currentPath\":\"2feb54038a5c5437d4e1143eb58e4701\",\"version\":\"3.5.1.28\"}", "0", "1");
INSERT INTO `wp_nextend2_section_storage` VALUES("10415", "cache", "notweb/n2-ss-4", "sliderfr_FR1", "{\"html\":\"<div class=\\\"n2-section-smartslider fitvidsignore  n2_clear\\\" data-ssid=\\\"4\\\" tabindex=\\\"0\\\" role=\\\"region\\\" aria-label=\\\"Slider\\\"><div id=\\\"n2-ss-4-align\\\" class=\\\"n2-ss-align\\\"><div class=\\\"n2-padding\\\"><div id=\\\"n2-ss-4\\\" data-creator=\\\"Smart Slider 3\\\" data-responsive=\\\"fullwidth\\\" class=\\\"n2-ss-slider n2-ow n2-has-hover n2notransition  \\\">\\n\\n\\n\\n\\n\\n<div class=\\\"n2-ss-slider-wrapper-inside\\\">\\n        <div class=\\\"n2-ss-slider-1 n2_ss__touch_element n2-ow\\\">\\n            <div class=\\\"n2-ss-slider-2 n2-ow\\\">\\n                                                <div class=\\\"n2-ss-slider-3 n2-ow\\\">\\n\\n                    <div class=\\\"n2-ss-slide-backgrounds n2-ow-all\\\"><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"1\\\" data-mode=\\\"fill\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"20\\\" data-y=\\\"58\\\" data-alt=\\\"\\\" data-title=\\\"\\\" style=\\\"--ss-o-pos-x:20%;--ss-o-pos-y:58%\\\"><picture class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/10802a08259602b5ac540aed3487b16b\\/4aee027a-8f57-4ff5-b044-1c48be6e8dfa.jpg\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"2\\\" data-mode=\\\"fill\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"57\\\" data-y=\\\"56\\\" data-alt=\\\"\\\" data-title=\\\"\\\" style=\\\"--ss-o-pos-x:57%;--ss-o-pos-y:56%\\\"><picture class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/1d1ba6d6cd2d0f2dae89fc5d656e956e\\/2ec912fe-87bd-4c0e-9b2a-49a982a44178.jpg\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><\\/div>                    <div class=\\\"n2-ss-slider-4 n2-ow\\\">\\n                        <svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 1200 600\\\" data-related-device=\\\"desktopPortrait\\\" class=\\\"n2-ow n2-ss-preserve-size n2-ss-preserve-size--slider n2-ss-slide-limiter\\\"><\\/svg><div data-first=\\\"1\\\" data-slide-duration=\\\"0\\\" data-id=\\\"11\\\" data-slide-public-id=\\\"1\\\" data-title=\\\"Full 2\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-11\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Full 2<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-SS3KpB5ZzQB3\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-1f4f8ad18c1a0\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-1f4f8ad18c1a0-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-7JaoibEfUkkL n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item1\\\" class=\\\"n2-font-37213fe73f82b18706d4317a894623bc-hover n2-style-b9880470c8178890efa20e7c510bc08a-heading   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:inline-block;white-space:nowrap;\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-D03vvwqTejiS\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item2\\\" class=\\\"n2-font-4c6c7e1b1bf49436c2f87de4e58f32ed-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-9FOxQr3pAg1u\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-2387300732a019110a5380f67e47d63c-link  n2-ss-nowrap\\\"><a class=\\\"n2-style-2a8fd540f213f5c6466dae96e765ee6e-heading  n2-ow \\\" href=\\\"http:\\/\\/localhost\\/nellboulanger\\/index.php\\/services\\/\\\"><div><div>JE LE VEUX !<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><img loading=\\\"lazy\\\" class=\\\"n2-ss-slide-thumbnail skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\" src=\\\"http:\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/36478dadaef0a15953727baf064f3426\\/4aee027a-8f57-4ff5-b044-1c48be6e8dfa.jpg\\\" alt=\\\"Full 2\\\"><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"10\\\" data-slide-public-id=\\\"2\\\" data-title=\\\"Full 1\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-10\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Full 1<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-XniSnhMc92kM\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-187d8f1049b03\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"1\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-187d8f1049b03-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-2CmBc17E75oi n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item4\\\" class=\\\"n2-font-37213fe73f82b18706d4317a894623bc-hover n2-style-b9880470c8178890efa20e7c510bc08a-heading   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:inline-block;white-space:nowrap;\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-tIGNamtRr8aM n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-c64fa1d6c43811c1c8a62069a1f404e5-link  n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-394d8fc34bf40d635a06fe8baea9d188-heading  n2-ow \\\" onclick=\\\"return false;\\\" href=\\\"#\\\"><div><div>JE LE VEUX !<\\/div><\\/div><\\/a><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-kYioCZs0uzPW\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item6\\\" class=\\\"n2-font-239ce1a80bbcd585366301bfded06d91-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><img loading=\\\"lazy\\\" class=\\\"n2-ss-slide-thumbnail skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\" src=\\\"http:\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/fe221e85228e0cc2c36d11b1fd7a9fda\\/2ec912fe-87bd-4c0e-9b2a-49a982a44178.jpg\\\" alt=\\\"Full 1\\\"><\\/div>                    <\\/div>\\n\\n                                    <\\/div>\\n            <\\/div>\\n        <\\/div>\\n        <div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-left-center\\\"><div style=\\\"--widget-offset:5px;\\\" class=\\\"n2-ss-widget nextend-arrow n2-ow-all nextend-arrow-previous  nextend-arrow-animated-fade\\\" data-hide-mobileportrait=\\\"1\\\" id=\\\"n2-ss-4-arrow-previous\\\" role=\\\"button\\\" aria-label=\\\"previous arrow\\\" tabindex=\\\"0\\\"><img width=\\\"32\\\" height=\\\"32\\\" class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\" src=\\\"data:image\\/svg+xml;base64,PHN2ZyB3aWR0aD0iMzIiIGhlaWdodD0iMzIiIHZpZXdCb3g9IjAgMCAzMiAzMiIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICAgIDxwYXRoIGQ9Ik0xMS40MzMgMTUuOTkyTDIyLjY5IDUuNzEyYy4zOTMtLjM5LjM5My0xLjAzIDAtMS40Mi0uMzkzLS4zOS0xLjAzLS4zOS0xLjQyMyAwbC0xMS45OCAxMC45NGMtLjIxLjIxLS4zLjQ5LS4yODUuNzYtLjAxNS4yOC4wNzUuNTYuMjg0Ljc3bDExLjk4IDEwLjk0Yy4zOTMuMzkgMS4wMy4zOSAxLjQyNCAwIC4zOTMtLjQuMzkzLTEuMDMgMC0xLjQybC0xMS4yNTctMTAuMjkiCiAgICAgICAgICBmaWxsPSIjZmZmZmZmIiBvcGFjaXR5PSIwLjgiIGZpbGwtcnVsZT0iZXZlbm9kZCIvPgo8L3N2Zz4=\\\" alt=\\\"previous arrow\\\"><\\/div><\\/div><div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-right-center\\\"><div style=\\\"--widget-offset:5px;\\\" class=\\\"n2-ss-widget nextend-arrow n2-ow-all nextend-arrow-next  nextend-arrow-animated-fade\\\" data-hide-mobileportrait=\\\"1\\\" id=\\\"n2-ss-4-arrow-next\\\" role=\\\"button\\\" aria-label=\\\"next arrow\\\" tabindex=\\\"0\\\"><img width=\\\"32\\\" height=\\\"32\\\" class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\" src=\\\"data:image\\/svg+xml;base64,PHN2ZyB3aWR0aD0iMzIiIGhlaWdodD0iMzIiIHZpZXdCb3g9IjAgMCAzMiAzMiIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICAgIDxwYXRoIGQ9Ik0xMC43MjIgNC4yOTNjLS4zOTQtLjM5LTEuMDMyLS4zOS0xLjQyNyAwLS4zOTMuMzktLjM5MyAxLjAzIDAgMS40MmwxMS4yODMgMTAuMjgtMTEuMjgzIDEwLjI5Yy0uMzkzLjM5LS4zOTMgMS4wMiAwIDEuNDIuMzk1LjM5IDEuMDMzLjM5IDEuNDI3IDBsMTIuMDA3LTEwLjk0Yy4yMS0uMjEuMy0uNDkuMjg0LS43Ny4wMTQtLjI3LS4wNzYtLjU1LS4yODYtLjc2TDEwLjcyIDQuMjkzeiIKICAgICAgICAgIGZpbGw9IiNmZmZmZmYiIG9wYWNpdHk9IjAuOCIgZmlsbC1ydWxlPSJldmVub2RkIi8+Cjwvc3ZnPg==\\\" alt=\\\"next arrow\\\"><\\/div><\\/div><div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-center-bottom\\\"><div style=\\\"--widget-offset:5px;\\\" class=\\\"n2-ss-widget n2-ss-control-bullet n2-ow-all n2-ss-control-bullet-horizontal\\\"><div class=\\\" nextend-bullet-bar n2-bar-justify-content-center\\\" role=\\\"group\\\" aria-label=\\\"Choose slide to display.\\\"><div class=\\\"n2-bullet n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot \\\" style=\\\"visibility:hidden;\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><ss3-loader><\\/ss3-loader><\\/div><\\/div><div class=\\\"n2_clear\\\"><\\/div><\\/div>\",\"assets\":{\"css\":{\"staticGroupPreload\":{\"smartslider\":\"\\/Applications\\/XAMPP\\/xamppfiles\\/htdocs\\/nellboulanger\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Application\\/Frontend\\/Assets\\/dist\\/smartslider.min.css\"},\"staticGroup\":[],\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":{\"n2-ss-4\":\"div#n2-ss-4 .n2-ss-slider-1{display:grid;position:relative;}div#n2-ss-4 .n2-ss-slider-2{display:grid;position:relative;overflow:hidden;padding:0px 0px 0px 0px;border:0px solid RGBA(62,62,62,1);border-radius:0px;background-clip:padding-box;background-repeat:repeat;background-position:50% 50%;background-size:cover;background-attachment:scroll;z-index:1;}div#n2-ss-4:not(.n2-ss-loaded) .n2-ss-slider-2{background-image:none !important;}div#n2-ss-4 .n2-ss-slider-3{display:grid;grid-template-areas:\'cover\';position:relative;overflow:hidden;z-index:10;}div#n2-ss-4 .n2-ss-slider-3 > *{grid-area:cover;}div#n2-ss-4 .n2-ss-slide-backgrounds,div#n2-ss-4 .n2-ss-slider-3 > .n2-ss-divider{position:relative;}div#n2-ss-4 .n2-ss-slide-backgrounds{z-index:10;}div#n2-ss-4 .n2-ss-slide-backgrounds > *{overflow:hidden;}div#n2-ss-4 .n2-ss-slide-background{transform:translateX(-100000px);}div#n2-ss-4 .n2-ss-slider-4{place-self:center;position:relative;width:100%;height:100%;z-index:20;display:grid;grid-template-areas:\'slide\';}div#n2-ss-4 .n2-ss-slider-4 > *{grid-area:slide;}div#n2-ss-4.n2-ss-full-page--constrain-ratio .n2-ss-slider-4{height:auto;}div#n2-ss-4 .n2-ss-slide{display:grid;place-items:center;grid-auto-columns:100%;position:relative;z-index:20;-webkit-backface-visibility:hidden;transform:translateX(-100000px);}div#n2-ss-4 .n2-ss-slide{perspective:1000px;}div#n2-ss-4 .n2-ss-slide-active{z-index:21;}.n2-ss-background-animation{position:absolute;top:0;left:0;width:100%;height:100%;z-index:3;}div#n2-ss-4 .n2-ss-button-container,div#n2-ss-4 .n2-ss-button-container a{display:block;}div#n2-ss-4 .n2-ss-button-container--non-full-width,div#n2-ss-4 .n2-ss-button-container--non-full-width a{display:inline-block;}div#n2-ss-4 .n2-ss-button-container.n2-ss-nowrap{white-space:nowrap;}div#n2-ss-4 .n2-ss-button-container a div{display:inline;font-size:inherit;text-decoration:inherit;color:inherit;line-height:inherit;font-family:inherit;font-weight:inherit;}div#n2-ss-4 .n2-ss-button-container a > div{display:inline-flex;align-items:center;vertical-align:top;}div#n2-ss-4 .n2-ss-button-container span{font-size:100%;vertical-align:baseline;}div#n2-ss-4 .n2-ss-button-container a[data-iconplacement=\\\"left\\\"] span{margin-right:0.3em;}div#n2-ss-4 .n2-ss-button-container a[data-iconplacement=\\\"right\\\"] span{margin-left:0.3em;}div#n2-ss-4 .nextend-arrow{cursor:pointer;overflow:hidden;line-height:0 !important;z-index:18;-webkit-user-select:none;}div#n2-ss-4 .nextend-arrow img{position:relative;display:block;}div#n2-ss-4 .nextend-arrow img.n2-arrow-hover-img{display:none;}div#n2-ss-4 .nextend-arrow:FOCUS img.n2-arrow-hover-img,div#n2-ss-4 .nextend-arrow:HOVER img.n2-arrow-hover-img{display:inline;}div#n2-ss-4 .nextend-arrow:FOCUS img.n2-arrow-normal-img,div#n2-ss-4 .nextend-arrow:HOVER img.n2-arrow-normal-img{display:none;}div#n2-ss-4 .nextend-arrow-animated{overflow:hidden;}div#n2-ss-4 .nextend-arrow-animated > div{position:relative;}div#n2-ss-4 .nextend-arrow-animated .n2-active{position:absolute;}div#n2-ss-4 .nextend-arrow-animated-fade{transition:background 0.3s, opacity 0.4s;}div#n2-ss-4 .nextend-arrow-animated-horizontal > div{transition:all 0.4s;transform:none;}div#n2-ss-4 .nextend-arrow-animated-horizontal .n2-active{top:0;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-horizontal .n2-active{left:100%;}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-horizontal .n2-active{right:100%;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-horizontal:HOVER > div,div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-horizontal:FOCUS > div{transform:translateX(-100%);}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-horizontal:HOVER > div,div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-horizontal:FOCUS > div{transform:translateX(100%);}div#n2-ss-4 .nextend-arrow-animated-vertical > div{transition:all 0.4s;transform:none;}div#n2-ss-4 .nextend-arrow-animated-vertical .n2-active{left:0;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-vertical .n2-active{top:100%;}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-vertical .n2-active{bottom:100%;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-vertical:HOVER > div,div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-vertical:FOCUS > div{transform:translateY(-100%);}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-vertical:HOVER > div,div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-vertical:FOCUS > div{transform:translateY(100%);}div#n2-ss-4 .n2-ss-control-bullet{visibility:hidden;text-align:center;justify-content:center;z-index:14;}div#n2-ss-4 .n2-ss-control-bullet--calculate-size{left:0 !important;}div#n2-ss-4 .n2-ss-control-bullet-horizontal.n2-ss-control-bullet-fullsize{width:100%;}div#n2-ss-4 .n2-ss-control-bullet-vertical.n2-ss-control-bullet-fullsize{height:100%;flex-flow:column;}div#n2-ss-4 .nextend-bullet-bar{display:inline-flex;vertical-align:top;visibility:visible;align-items:center;flex-wrap:wrap;}div#n2-ss-4 .n2-bar-justify-content-left{justify-content:flex-start;}div#n2-ss-4 .n2-bar-justify-content-center{justify-content:center;}div#n2-ss-4 .n2-bar-justify-content-right{justify-content:flex-end;}div#n2-ss-4 .n2-ss-control-bullet-vertical > .nextend-bullet-bar{flex-flow:column;}div#n2-ss-4 .n2-ss-control-bullet-fullsize > .nextend-bullet-bar{display:flex;}div#n2-ss-4 .n2-ss-control-bullet-horizontal.n2-ss-control-bullet-fullsize > .nextend-bullet-bar{flex:1 1 auto;}div#n2-ss-4 .n2-ss-control-bullet-vertical.n2-ss-control-bullet-fullsize > .nextend-bullet-bar{height:100%;}div#n2-ss-4 .nextend-bullet-bar .n2-bullet{cursor:pointer;transition:background-color 0.4s;}div#n2-ss-4 .nextend-bullet-bar .n2-bullet.n2-active{cursor:default;}div#n2-ss-4 div.n2-ss-bullet-thumbnail-container{position:absolute;z-index:10000000;}div#n2-ss-4 .n2-ss-bullet-thumbnail-container .n2-ss-bullet-thumbnail{background-size:cover;background-repeat:no-repeat;background-position:center;}div#n2-ss-4 .n2-font-37213fe73f82b18706d4317a894623bc-hover{font-family: \'Montserrat\',\'Arial\';color: #ffffff;font-size:112.5%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: inherit;letter-spacing: normal;word-spacing: normal;text-transform: uppercase;font-weight: 400;}div#n2-ss-4 .n2-style-b9880470c8178890efa20e7c510bc08a-heading{background: RGBA(255,255,255,0);opacity:1;padding:0px 0px 0px 0px ;box-shadow: none;border: 0px solid RGBA(0,0,0,1);border-radius:0px;border-bottom:3px solid #fff;}div#n2-ss-4 .n2-font-4c6c7e1b1bf49436c2f87de4e58f32ed-hover{font-family: \'Playfair Display\';color: #ffffff;font-size:300%;text-shadow: none;line-height: 1.3;font-weight: normal;font-style: normal;text-decoration: none;text-align: inherit;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 700;}div#n2-ss-4 .n2-font-2387300732a019110a5380f67e47d63c-link a{font-family: \'Montserrat\',\'Arial\';color: #000000;font-size:100%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: center;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 700;}div#n2-ss-4 .n2-font-2387300732a019110a5380f67e47d63c-link a:HOVER, div#n2-ss-4 .n2-font-2387300732a019110a5380f67e47d63c-link a:ACTIVE, div#n2-ss-4 .n2-font-2387300732a019110a5380f67e47d63c-link a:FOCUS{color: #262626;}div#n2-ss-4 .n2-style-2a8fd540f213f5c6466dae96e765ee6e-heading{background: #cbf3bd;opacity:1;padding:0.8em 1.5em 0.8em 1.5em ;box-shadow: none;border: 2px solid RGBA(203,243,189,1);border-radius:99px;}div#n2-ss-4 .n2-style-2a8fd540f213f5c6466dae96e765ee6e-heading:Hover, div#n2-ss-4 .n2-style-2a8fd540f213f5c6466dae96e765ee6e-heading:ACTIVE, div#n2-ss-4 .n2-style-2a8fd540f213f5c6466dae96e765ee6e-heading:FOCUS{background: #ffffff;}div#n2-ss-4 .n-uc-187d8f1049b03-inner{--n2bgimage:URL(\\\"\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/2025\\/07\\/3d6d6b31-c6aa-4c3f-911e-bfade3a38018.jpeg\\\");background-position:50% 50%,12% 52%;}div#n2-ss-4 .n2-font-c64fa1d6c43811c1c8a62069a1f404e5-link a{font-family: \'Montserrat\',\'Arial\';color: #000000;font-size:112.5%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: center;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 700;}div#n2-ss-4 .n2-font-c64fa1d6c43811c1c8a62069a1f404e5-link a:HOVER, div#n2-ss-4 .n2-font-c64fa1d6c43811c1c8a62069a1f404e5-link a:ACTIVE, div#n2-ss-4 .n2-font-c64fa1d6c43811c1c8a62069a1f404e5-link a:FOCUS{color: #262626;}div#n2-ss-4 .n2-style-394d8fc34bf40d635a06fe8baea9d188-heading{background: #cbf3bd;opacity:1;padding:0.8em 1.5em 0.8em 1.5em ;box-shadow: none;border: 2px solid RGBA(1,173,211,1);border-radius:99px;}div#n2-ss-4 .n2-style-394d8fc34bf40d635a06fe8baea9d188-heading:Hover, div#n2-ss-4 .n2-style-394d8fc34bf40d635a06fe8baea9d188-heading:ACTIVE, div#n2-ss-4 .n2-style-394d8fc34bf40d635a06fe8baea9d188-heading:FOCUS{background: #ffffff;}div#n2-ss-4 .n2-font-239ce1a80bbcd585366301bfded06d91-hover{font-family: \'\';color: #ffffff;font-size:300%;text-shadow: none;line-height: 1.3;font-weight: normal;font-style: normal;text-decoration: none;text-align: inherit;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 700;}div#n2-ss-4 .n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot{background: RGBA(255,255,255,0.5);opacity:1;padding:5px 5px 5px 5px ;box-shadow: none;border: 0px solid RGBA(0,0,0,1);border-radius:50px;margin:4px;}div#n2-ss-4 .n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot.n2-active, div#n2-ss-4 .n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot:HOVER, div#n2-ss-4 .n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot:FOCUS{background: #ffffff;}div#n2-ss-4 .n2-style-c551d6c8778ab3d08aca13db75fd7f5e-simple{background: RGBA(0,0,0,0.5);opacity:1;padding:0px 0px 0px 0px ;box-shadow: none;border: 0px solid RGBA(0,0,0,1);border-radius:3px;margin:5px;}div#n2-ss-4 .n2-ss-slide-limiter{max-width:1200px;}div#n2-ss-4 .n-uc-SS3KpB5ZzQB3{padding:0px 0px 0px 0px}div#n2-ss-4 .n-uc-1f4f8ad18c1a0-inner{padding:40px 60px 40px 60px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-1f4f8ad18c1a0{max-width: 1030px;align-self:var(--ss-fe);}div#n2-ss-4 .n-uc-7JaoibEfUkkL{--margin-bottom:10px}div#n2-ss-4 .n-uc-D03vvwqTejiS{--margin-bottom:30px}div#n2-ss-4 .n-uc-9FOxQr3pAg1u{--margin-right:-265px;max-width:250px}div#n2-ss-4 .n-uc-XniSnhMc92kM{padding:0px 0px 0px 0px}div#n2-ss-4 .n-uc-187d8f1049b03-inner{padding:40px 60px 40px 60px;justify-content:center}div#n2-ss-4 .n-uc-2CmBc17E75oi{--margin-bottom:15px}div#n2-ss-4 .n-uc-tIGNamtRr8aM{--margin-right:300px;--margin-left:-170px;max-width:295px;align-self:var(--ss-fe);}div#n2-ss-4 .n-uc-kYioCZs0uzPW{--margin-bottom:30px}div#n2-ss-4 .nextend-arrow img{width: 32px}@media (min-width: 1200px){div#n2-ss-4 [data-hide-desktopportrait=\\\"1\\\"]{display: none !important;}}@media (orientation: landscape) and (max-width: 1199px) and (min-width: 901px),(orientation: portrait) and (max-width: 1199px) and (min-width: 701px){div#n2-ss-4 .n-uc-D03vvwqTejiS{--margin-bottom:30px;--ssfont-scale:0.8}div#n2-ss-4 .n-uc-tIGNamtRr8aM{--margin-right:35px;--margin-left:-20px}div#n2-ss-4 .n-uc-kYioCZs0uzPW{--ssfont-scale:0.8}div#n2-ss-4 [data-hide-tabletportrait=\\\"1\\\"]{display: none !important;}}@media (orientation: landscape) and (max-width: 900px),(orientation: portrait) and (max-width: 700px){div#n2-ss-4 .n-uc-1f4f8ad18c1a0-inner{padding:40px 25px 40px 25px;justify-content:center}div#n2-ss-4 .n-uc-7JaoibEfUkkL{--ssfont-scale:0.9}div#n2-ss-4 .n-uc-D03vvwqTejiS{--margin-bottom:10px;--ssfont-scale:0.65}div#n2-ss-4 .n-uc-9FOxQr3pAg1u{max-width:215px;--ssfont-scale:0.8}div#n2-ss-4 .n-uc-187d8f1049b03-inner{padding:40px 25px 40px 25px}div#n2-ss-4 .n-uc-2CmBc17E75oi{--margin-bottom:10px;--ssfont-scale:0.9}div#n2-ss-4 .n-uc-tIGNamtRr8aM{--margin-right:20px;--margin-left:-20px;max-width:175px;--ssfont-scale:0.8}div#n2-ss-4 .n-uc-kYioCZs0uzPW{--margin-bottom:10px;--ssfont-scale:0.6}div#n2-ss-4 [data-hide-mobileportrait=\\\"1\\\"]{display: none !important;}div#n2-ss-4 .nextend-arrow img{width: 16px}}\"},\"globalInline\":[]},\"less\":{\"staticGroupPreload\":[],\"staticGroup\":[],\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[],\"globalInline\":[]},\"js\":{\"staticGroupPreload\":[],\"staticGroup\":{\"smartslider-frontend\":\"\\/Applications\\/XAMPP\\/xamppfiles\\/htdocs\\/nellboulanger\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Application\\/Frontend\\/Assets\\/dist\\/smartslider-frontend.min.js\",\"ss-simple\":\"\\/Applications\\/XAMPP\\/xamppfiles\\/htdocs\\/nellboulanger\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Slider\\/SliderType\\/Simple\\/Assets\\/dist\\/ss-simple.min.js\",\"w-arrow-image\":\"\\/Applications\\/XAMPP\\/xamppfiles\\/htdocs\\/nellboulanger\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Widget\\/Arrow\\/ArrowImage\\/Assets\\/dist\\/w-arrow-image.min.js\",\"w-bullet\":\"\\/Applications\\/XAMPP\\/xamppfiles\\/htdocs\\/nellboulanger\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Widget\\/Bullet\\/Assets\\/dist\\/w-bullet.min.js\"},\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[\"_N2.r([\\\"documentReady\\\",\\\"smartslider-frontend\\\",\\\"SmartSliderWidgetArrowImage\\\",\\\"SmartSliderWidgetBulletTransition\\\",\\\"ss-simple\\\"],function(){new _N2.SmartSliderSimple(\'n2-ss-4\', {\\\"admin\\\":false,\\\"background.video.mobile\\\":1,\\\"loadingTime\\\":2000,\\\"randomize\\\":{\\\"randomize\\\":0,\\\"randomizeFirst\\\":0},\\\"alias\\\":{\\\"id\\\":0,\\\"smoothScroll\\\":0,\\\"slideSwitch\\\":0,\\\"scroll\\\":1},\\\"align\\\":\\\"normal\\\",\\\"isDelayed\\\":0,\\\"responsive\\\":{\\\"mediaQueries\\\":{\\\"all\\\":false,\\\"desktopportrait\\\":[\\\"(min-width: 1200px)\\\"],\\\"tabletportrait\\\":[\\\"(orientation: landscape) and (max-width: 1199px) and (min-width: 901px)\\\",\\\"(orientation: portrait) and (max-width: 1199px) and (min-width: 701px)\\\"],\\\"mobileportrait\\\":[\\\"(orientation: landscape) and (max-width: 900px)\\\",\\\"(orientation: portrait) and (max-width: 700px)\\\"]},\\\"base\\\":{\\\"slideOuterWidth\\\":1200,\\\"slideOuterHeight\\\":600,\\\"sliderWidth\\\":1200,\\\"sliderHeight\\\":600,\\\"slideWidth\\\":1200,\\\"slideHeight\\\":600},\\\"hideOn\\\":{\\\"desktopLandscape\\\":false,\\\"desktopPortrait\\\":false,\\\"tabletLandscape\\\":false,\\\"tabletPortrait\\\":false,\\\"mobileLandscape\\\":false,\\\"mobilePortrait\\\":false},\\\"onResizeEnabled\\\":true,\\\"type\\\":\\\"fullwidth\\\",\\\"sliderHeightBasedOn\\\":\\\"real\\\",\\\"focusUser\\\":1,\\\"focusEdge\\\":\\\"auto\\\",\\\"breakpoints\\\":[{\\\"device\\\":\\\"tabletPortrait\\\",\\\"type\\\":\\\"max-screen-width\\\",\\\"portraitWidth\\\":1199,\\\"landscapeWidth\\\":1199},{\\\"device\\\":\\\"mobilePortrait\\\",\\\"type\\\":\\\"max-screen-width\\\",\\\"portraitWidth\\\":700,\\\"landscapeWidth\\\":900}],\\\"enabledDevices\\\":{\\\"desktopLandscape\\\":0,\\\"desktopPortrait\\\":1,\\\"tabletLandscape\\\":0,\\\"tabletPortrait\\\":1,\\\"mobileLandscape\\\":0,\\\"mobilePortrait\\\":1},\\\"sizes\\\":{\\\"desktopPortrait\\\":{\\\"width\\\":1200,\\\"height\\\":600,\\\"max\\\":3000,\\\"min\\\":1200},\\\"tabletPortrait\\\":{\\\"width\\\":701,\\\"height\\\":350,\\\"customHeight\\\":false,\\\"max\\\":1199,\\\"min\\\":701},\\\"mobilePortrait\\\":{\\\"width\\\":320,\\\"height\\\":160,\\\"customHeight\\\":false,\\\"max\\\":900,\\\"min\\\":320}},\\\"overflowHiddenPage\\\":0,\\\"focus\\\":{\\\"offsetTop\\\":\\\"#wpadminbar\\\",\\\"offsetBottom\\\":\\\"\\\"}},\\\"controls\\\":{\\\"mousewheel\\\":0,\\\"touch\\\":\\\"horizontal\\\",\\\"keyboard\\\":1,\\\"blockCarouselInteraction\\\":1},\\\"playWhenVisible\\\":1,\\\"playWhenVisibleAt\\\":0.5,\\\"lazyLoad\\\":0,\\\"lazyLoadNeighbor\\\":0,\\\"blockrightclick\\\":0,\\\"maintainSession\\\":0,\\\"autoplay\\\":{\\\"enabled\\\":0,\\\"start\\\":1,\\\"duration\\\":8000,\\\"autoplayLoop\\\":1,\\\"allowReStart\\\":0,\\\"pause\\\":{\\\"click\\\":1,\\\"mouse\\\":\\\"0\\\",\\\"mediaStarted\\\":1},\\\"resume\\\":{\\\"click\\\":0,\\\"mouse\\\":\\\"0\\\",\\\"mediaEnded\\\":1,\\\"slidechanged\\\":0},\\\"interval\\\":1,\\\"intervalModifier\\\":\\\"loop\\\",\\\"intervalSlide\\\":\\\"current\\\"},\\\"perspective\\\":1000,\\\"layerMode\\\":{\\\"playOnce\\\":0,\\\"playFirstLayer\\\":1,\\\"mode\\\":\\\"skippable\\\",\\\"inAnimation\\\":\\\"mainInEnd\\\"},\\\"bgAnimations\\\":0,\\\"mainanimation\\\":{\\\"type\\\":\\\"horizontal\\\",\\\"duration\\\":800,\\\"delay\\\":0,\\\"ease\\\":\\\"easeOutQuad\\\",\\\"shiftedBackgroundAnimation\\\":0},\\\"carousel\\\":1,\\\"initCallbacks\\\":function(){new _N2.SmartSliderWidgetArrowImage(this);new _N2.SmartSliderWidgetBulletTransition(this, {\\\"area\\\":10,\\\"dotClasses\\\":\\\"n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot \\\",\\\"mode\\\":\\\"\\\",\\\"action\\\":\\\"click\\\",\\\"thumbnail\\\":1,\\\"thumbnailWidth\\\":120,\\\"thumbnailHeight\\\":81,\\\"thumbnailStyle\\\":\\\"n2-style-c551d6c8778ab3d08aca13db75fd7f5e-simple \\\",\\\"thumbnailPosition\\\":\\\"top\\\"});}});});\"],\"globalInline\":[]},\"googleFonts\":{\"staticGroupPreload\":[],\"staticGroup\":[],\"files\":{\"Montserrat\":[\"300\",\"400\"],\"Playfair Display\":[\"300\",\"400\"]},\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[],\"globalInline\":[]},\"image\":{\"images\":[\"\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/10802a08259602b5ac540aed3487b16b\\/4aee027a-8f57-4ff5-b044-1c48be6e8dfa.jpg\",\"\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/1d1ba6d6cd2d0f2dae89fc5d656e956e\\/2ec912fe-87bd-4c0e-9b2a-49a982a44178.jpg\"]}}}", "0", "1");
INSERT INTO `wp_nextend2_section_storage` VALUES("10416", "cache", "notweb/n2-ss-4", "sliderfr_FRiframe1.manifest", "{\"hash\":\"\",\"nextCacheRefresh\":2145916800,\"currentPath\":\"2feb54038a5c5437d4e1143eb58e4701\",\"version\":\"3.5.1.28\"}", "0", "1");
INSERT INTO `wp_nextend2_section_storage` VALUES("10417", "cache", "notweb/n2-ss-4", "sliderfr_FRiframe1", "{\"html\":\"<div class=\\\"n2-section-smartslider fitvidsignore  n2_clear\\\" data-ssid=\\\"4\\\" tabindex=\\\"0\\\" role=\\\"region\\\" aria-label=\\\"Slider\\\"><div id=\\\"n2-ss-4-align\\\" class=\\\"n2-ss-align\\\"><div class=\\\"n2-padding\\\"><div id=\\\"n2-ss-4\\\" data-creator=\\\"Smart Slider 3\\\" data-responsive=\\\"fullwidth\\\" class=\\\"n2-ss-slider n2-ow n2-has-hover n2notransition  \\\">\\n\\n\\n\\n\\n\\n<div class=\\\"n2-ss-slider-wrapper-inside\\\">\\n        <div class=\\\"n2-ss-slider-1 n2_ss__touch_element n2-ow\\\">\\n            <div class=\\\"n2-ss-slider-2 n2-ow\\\">\\n                                                <div class=\\\"n2-ss-slider-3 n2-ow\\\">\\n\\n                    <div class=\\\"n2-ss-slide-backgrounds n2-ow-all\\\"><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"1\\\" data-mode=\\\"fill\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"20\\\" data-y=\\\"58\\\" data-alt=\\\"\\\" data-title=\\\"\\\" style=\\\"--ss-o-pos-x:20%;--ss-o-pos-y:58%\\\"><picture class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/10802a08259602b5ac540aed3487b16b\\/4aee027a-8f57-4ff5-b044-1c48be6e8dfa.jpg\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"2\\\" data-mode=\\\"fill\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"57\\\" data-y=\\\"56\\\" data-alt=\\\"\\\" data-title=\\\"\\\" style=\\\"--ss-o-pos-x:57%;--ss-o-pos-y:56%\\\"><picture class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/1d1ba6d6cd2d0f2dae89fc5d656e956e\\/2ec912fe-87bd-4c0e-9b2a-49a982a44178.jpg\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><\\/div>                    <div class=\\\"n2-ss-slider-4 n2-ow\\\">\\n                        <svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 1200 600\\\" data-related-device=\\\"desktopPortrait\\\" class=\\\"n2-ow n2-ss-preserve-size n2-ss-preserve-size--slider n2-ss-slide-limiter\\\"><\\/svg><div data-first=\\\"1\\\" data-slide-duration=\\\"0\\\" data-id=\\\"11\\\" data-slide-public-id=\\\"1\\\" data-title=\\\"Full 2\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-11\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Full 2<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-70GwbsDd4Uua\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-1f4f8ad18c1a0\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-1f4f8ad18c1a0-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-7JaoibEfUkkL n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item1\\\" class=\\\"n2-font-37213fe73f82b18706d4317a894623bc-hover n2-style-b9880470c8178890efa20e7c510bc08a-heading   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:inline-block;white-space:nowrap;\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-D03vvwqTejiS\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item2\\\" class=\\\"n2-font-4c6c7e1b1bf49436c2f87de4e58f32ed-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-9FOxQr3pAg1u\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-2387300732a019110a5380f67e47d63c-link  n2-ss-nowrap\\\"><a class=\\\"n2-style-2a8fd540f213f5c6466dae96e765ee6e-heading  n2-ow \\\" href=\\\"http:\\/\\/localhost\\/nellboulanger\\/index.php\\/services\\/\\\"><div><div>JE LE VEUX !<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><img loading=\\\"lazy\\\" class=\\\"n2-ss-slide-thumbnail skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\" src=\\\"http:\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/36478dadaef0a15953727baf064f3426\\/4aee027a-8f57-4ff5-b044-1c48be6e8dfa.jpg\\\" alt=\\\"Full 2\\\"><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"10\\\" data-slide-public-id=\\\"2\\\" data-title=\\\"Full 1\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-10\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Full 1<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-6xD1JF6nZjFa\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-187d8f1049b03\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"1\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-187d8f1049b03-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-2CmBc17E75oi n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item4\\\" class=\\\"n2-font-37213fe73f82b18706d4317a894623bc-hover n2-style-b9880470c8178890efa20e7c510bc08a-heading   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:inline-block;white-space:nowrap;\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-tIGNamtRr8aM n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-c64fa1d6c43811c1c8a62069a1f404e5-link  n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-394d8fc34bf40d635a06fe8baea9d188-heading  n2-ow \\\" onclick=\\\"return false;\\\" href=\\\"#\\\"><div><div>JE LE VEUX !<\\/div><\\/div><\\/a><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-kYioCZs0uzPW\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item6\\\" class=\\\"n2-font-239ce1a80bbcd585366301bfded06d91-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><img loading=\\\"lazy\\\" class=\\\"n2-ss-slide-thumbnail skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\" src=\\\"http:\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/fe221e85228e0cc2c36d11b1fd7a9fda\\/2ec912fe-87bd-4c0e-9b2a-49a982a44178.jpg\\\" alt=\\\"Full 1\\\"><\\/div>                    <\\/div>\\n\\n                                    <\\/div>\\n            <\\/div>\\n        <\\/div>\\n        <div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-left-center\\\"><div style=\\\"--widget-offset:5px;\\\" class=\\\"n2-ss-widget nextend-arrow n2-ow-all nextend-arrow-previous  nextend-arrow-animated-fade\\\" data-hide-mobileportrait=\\\"1\\\" id=\\\"n2-ss-4-arrow-previous\\\" role=\\\"button\\\" aria-label=\\\"previous arrow\\\" tabindex=\\\"0\\\"><img width=\\\"32\\\" height=\\\"32\\\" class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\" src=\\\"data:image\\/svg+xml;base64,PHN2ZyB3aWR0aD0iMzIiIGhlaWdodD0iMzIiIHZpZXdCb3g9IjAgMCAzMiAzMiIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICAgIDxwYXRoIGQ9Ik0xMS40MzMgMTUuOTkyTDIyLjY5IDUuNzEyYy4zOTMtLjM5LjM5My0xLjAzIDAtMS40Mi0uMzkzLS4zOS0xLjAzLS4zOS0xLjQyMyAwbC0xMS45OCAxMC45NGMtLjIxLjIxLS4zLjQ5LS4yODUuNzYtLjAxNS4yOC4wNzUuNTYuMjg0Ljc3bDExLjk4IDEwLjk0Yy4zOTMuMzkgMS4wMy4zOSAxLjQyNCAwIC4zOTMtLjQuMzkzLTEuMDMgMC0xLjQybC0xMS4yNTctMTAuMjkiCiAgICAgICAgICBmaWxsPSIjZmZmZmZmIiBvcGFjaXR5PSIwLjgiIGZpbGwtcnVsZT0iZXZlbm9kZCIvPgo8L3N2Zz4=\\\" alt=\\\"previous arrow\\\"><\\/div><\\/div><div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-right-center\\\"><div style=\\\"--widget-offset:5px;\\\" class=\\\"n2-ss-widget nextend-arrow n2-ow-all nextend-arrow-next  nextend-arrow-animated-fade\\\" data-hide-mobileportrait=\\\"1\\\" id=\\\"n2-ss-4-arrow-next\\\" role=\\\"button\\\" aria-label=\\\"next arrow\\\" tabindex=\\\"0\\\"><img width=\\\"32\\\" height=\\\"32\\\" class=\\\"skip-lazy jetpack-lazy-image\\\" data-skip-lazy=\\\"1\\\" src=\\\"data:image\\/svg+xml;base64,PHN2ZyB3aWR0aD0iMzIiIGhlaWdodD0iMzIiIHZpZXdCb3g9IjAgMCAzMiAzMiIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICAgIDxwYXRoIGQ9Ik0xMC43MjIgNC4yOTNjLS4zOTQtLjM5LTEuMDMyLS4zOS0xLjQyNyAwLS4zOTMuMzktLjM5MyAxLjAzIDAgMS40MmwxMS4yODMgMTAuMjgtMTEuMjgzIDEwLjI5Yy0uMzkzLjM5LS4zOTMgMS4wMiAwIDEuNDIuMzk1LjM5IDEuMDMzLjM5IDEuNDI3IDBsMTIuMDA3LTEwLjk0Yy4yMS0uMjEuMy0uNDkuMjg0LS43Ny4wMTQtLjI3LS4wNzYtLjU1LS4yODYtLjc2TDEwLjcyIDQuMjkzeiIKICAgICAgICAgIGZpbGw9IiNmZmZmZmYiIG9wYWNpdHk9IjAuOCIgZmlsbC1ydWxlPSJldmVub2RkIi8+Cjwvc3ZnPg==\\\" alt=\\\"next arrow\\\"><\\/div><\\/div><div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-center-bottom\\\"><div style=\\\"--widget-offset:5px;\\\" class=\\\"n2-ss-widget n2-ss-control-bullet n2-ow-all n2-ss-control-bullet-horizontal\\\"><div class=\\\" nextend-bullet-bar n2-bar-justify-content-center\\\" role=\\\"group\\\" aria-label=\\\"Choose slide to display.\\\"><div class=\\\"n2-bullet n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot \\\" style=\\\"visibility:hidden;\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><ss3-loader><\\/ss3-loader><\\/div><\\/div><div class=\\\"n2_clear\\\"><\\/div><\\/div>\",\"assets\":{\"css\":{\"staticGroupPreload\":{\"smartslider\":\"\\/Applications\\/XAMPP\\/xamppfiles\\/htdocs\\/nellboulanger\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Application\\/Frontend\\/Assets\\/dist\\/smartslider.min.css\"},\"staticGroup\":[],\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":{\"n2-ss-4\":\"div#n2-ss-4 .n2-ss-slider-1{display:grid;position:relative;}div#n2-ss-4 .n2-ss-slider-2{display:grid;position:relative;overflow:hidden;padding:0px 0px 0px 0px;border:0px solid RGBA(62,62,62,1);border-radius:0px;background-clip:padding-box;background-repeat:repeat;background-position:50% 50%;background-size:cover;background-attachment:scroll;z-index:1;}div#n2-ss-4:not(.n2-ss-loaded) .n2-ss-slider-2{background-image:none !important;}div#n2-ss-4 .n2-ss-slider-3{display:grid;grid-template-areas:\'cover\';position:relative;overflow:hidden;z-index:10;}div#n2-ss-4 .n2-ss-slider-3 > *{grid-area:cover;}div#n2-ss-4 .n2-ss-slide-backgrounds,div#n2-ss-4 .n2-ss-slider-3 > .n2-ss-divider{position:relative;}div#n2-ss-4 .n2-ss-slide-backgrounds{z-index:10;}div#n2-ss-4 .n2-ss-slide-backgrounds > *{overflow:hidden;}div#n2-ss-4 .n2-ss-slide-background{transform:translateX(-100000px);}div#n2-ss-4 .n2-ss-slider-4{place-self:center;position:relative;width:100%;height:100%;z-index:20;display:grid;grid-template-areas:\'slide\';}div#n2-ss-4 .n2-ss-slider-4 > *{grid-area:slide;}div#n2-ss-4.n2-ss-full-page--constrain-ratio .n2-ss-slider-4{height:auto;}div#n2-ss-4 .n2-ss-slide{display:grid;place-items:center;grid-auto-columns:100%;position:relative;z-index:20;-webkit-backface-visibility:hidden;transform:translateX(-100000px);}div#n2-ss-4 .n2-ss-slide{perspective:1000px;}div#n2-ss-4 .n2-ss-slide-active{z-index:21;}.n2-ss-background-animation{position:absolute;top:0;left:0;width:100%;height:100%;z-index:3;}div#n2-ss-4 .n2-ss-button-container,div#n2-ss-4 .n2-ss-button-container a{display:block;}div#n2-ss-4 .n2-ss-button-container--non-full-width,div#n2-ss-4 .n2-ss-button-container--non-full-width a{display:inline-block;}div#n2-ss-4 .n2-ss-button-container.n2-ss-nowrap{white-space:nowrap;}div#n2-ss-4 .n2-ss-button-container a div{display:inline;font-size:inherit;text-decoration:inherit;color:inherit;line-height:inherit;font-family:inherit;font-weight:inherit;}div#n2-ss-4 .n2-ss-button-container a > div{display:inline-flex;align-items:center;vertical-align:top;}div#n2-ss-4 .n2-ss-button-container span{font-size:100%;vertical-align:baseline;}div#n2-ss-4 .n2-ss-button-container a[data-iconplacement=\\\"left\\\"] span{margin-right:0.3em;}div#n2-ss-4 .n2-ss-button-container a[data-iconplacement=\\\"right\\\"] span{margin-left:0.3em;}div#n2-ss-4 .nextend-arrow{cursor:pointer;overflow:hidden;line-height:0 !important;z-index:18;-webkit-user-select:none;}div#n2-ss-4 .nextend-arrow img{position:relative;display:block;}div#n2-ss-4 .nextend-arrow img.n2-arrow-hover-img{display:none;}div#n2-ss-4 .nextend-arrow:FOCUS img.n2-arrow-hover-img,div#n2-ss-4 .nextend-arrow:HOVER img.n2-arrow-hover-img{display:inline;}div#n2-ss-4 .nextend-arrow:FOCUS img.n2-arrow-normal-img,div#n2-ss-4 .nextend-arrow:HOVER img.n2-arrow-normal-img{display:none;}div#n2-ss-4 .nextend-arrow-animated{overflow:hidden;}div#n2-ss-4 .nextend-arrow-animated > div{position:relative;}div#n2-ss-4 .nextend-arrow-animated .n2-active{position:absolute;}div#n2-ss-4 .nextend-arrow-animated-fade{transition:background 0.3s, opacity 0.4s;}div#n2-ss-4 .nextend-arrow-animated-horizontal > div{transition:all 0.4s;transform:none;}div#n2-ss-4 .nextend-arrow-animated-horizontal .n2-active{top:0;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-horizontal .n2-active{left:100%;}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-horizontal .n2-active{right:100%;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-horizontal:HOVER > div,div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-horizontal:FOCUS > div{transform:translateX(-100%);}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-horizontal:HOVER > div,div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-horizontal:FOCUS > div{transform:translateX(100%);}div#n2-ss-4 .nextend-arrow-animated-vertical > div{transition:all 0.4s;transform:none;}div#n2-ss-4 .nextend-arrow-animated-vertical .n2-active{left:0;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-vertical .n2-active{top:100%;}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-vertical .n2-active{bottom:100%;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-vertical:HOVER > div,div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-vertical:FOCUS > div{transform:translateY(-100%);}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-vertical:HOVER > div,div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-vertical:FOCUS > div{transform:translateY(100%);}div#n2-ss-4 .n2-ss-control-bullet{visibility:hidden;text-align:center;justify-content:center;z-index:14;}div#n2-ss-4 .n2-ss-control-bullet--calculate-size{left:0 !important;}div#n2-ss-4 .n2-ss-control-bullet-horizontal.n2-ss-control-bullet-fullsize{width:100%;}div#n2-ss-4 .n2-ss-control-bullet-vertical.n2-ss-control-bullet-fullsize{height:100%;flex-flow:column;}div#n2-ss-4 .nextend-bullet-bar{display:inline-flex;vertical-align:top;visibility:visible;align-items:center;flex-wrap:wrap;}div#n2-ss-4 .n2-bar-justify-content-left{justify-content:flex-start;}div#n2-ss-4 .n2-bar-justify-content-center{justify-content:center;}div#n2-ss-4 .n2-bar-justify-content-right{justify-content:flex-end;}div#n2-ss-4 .n2-ss-control-bullet-vertical > .nextend-bullet-bar{flex-flow:column;}div#n2-ss-4 .n2-ss-control-bullet-fullsize > .nextend-bullet-bar{display:flex;}div#n2-ss-4 .n2-ss-control-bullet-horizontal.n2-ss-control-bullet-fullsize > .nextend-bullet-bar{flex:1 1 auto;}div#n2-ss-4 .n2-ss-control-bullet-vertical.n2-ss-control-bullet-fullsize > .nextend-bullet-bar{height:100%;}div#n2-ss-4 .nextend-bullet-bar .n2-bullet{cursor:pointer;transition:background-color 0.4s;}div#n2-ss-4 .nextend-bullet-bar .n2-bullet.n2-active{cursor:default;}div#n2-ss-4 div.n2-ss-bullet-thumbnail-container{position:absolute;z-index:10000000;}div#n2-ss-4 .n2-ss-bullet-thumbnail-container .n2-ss-bullet-thumbnail{background-size:cover;background-repeat:no-repeat;background-position:center;}div#n2-ss-4 .n2-font-37213fe73f82b18706d4317a894623bc-hover{font-family: \'Montserrat\',\'Arial\';color: #ffffff;font-size:112.5%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: inherit;letter-spacing: normal;word-spacing: normal;text-transform: uppercase;font-weight: 400;}div#n2-ss-4 .n2-style-b9880470c8178890efa20e7c510bc08a-heading{background: RGBA(255,255,255,0);opacity:1;padding:0px 0px 0px 0px ;box-shadow: none;border: 0px solid RGBA(0,0,0,1);border-radius:0px;border-bottom:3px solid #fff;}div#n2-ss-4 .n2-font-4c6c7e1b1bf49436c2f87de4e58f32ed-hover{font-family: \'Playfair Display\';color: #ffffff;font-size:300%;text-shadow: none;line-height: 1.3;font-weight: normal;font-style: normal;text-decoration: none;text-align: inherit;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 700;}div#n2-ss-4 .n2-font-2387300732a019110a5380f67e47d63c-link a{font-family: \'Montserrat\',\'Arial\';color: #000000;font-size:100%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: center;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 700;}div#n2-ss-4 .n2-font-2387300732a019110a5380f67e47d63c-link a:HOVER, div#n2-ss-4 .n2-font-2387300732a019110a5380f67e47d63c-link a:ACTIVE, div#n2-ss-4 .n2-font-2387300732a019110a5380f67e47d63c-link a:FOCUS{color: #262626;}div#n2-ss-4 .n2-style-2a8fd540f213f5c6466dae96e765ee6e-heading{background: #cbf3bd;opacity:1;padding:0.8em 1.5em 0.8em 1.5em ;box-shadow: none;border: 2px solid RGBA(203,243,189,1);border-radius:99px;}div#n2-ss-4 .n2-style-2a8fd540f213f5c6466dae96e765ee6e-heading:Hover, div#n2-ss-4 .n2-style-2a8fd540f213f5c6466dae96e765ee6e-heading:ACTIVE, div#n2-ss-4 .n2-style-2a8fd540f213f5c6466dae96e765ee6e-heading:FOCUS{background: #ffffff;}div#n2-ss-4 .n-uc-187d8f1049b03-inner{--n2bgimage:URL(\\\"\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/2025\\/07\\/3d6d6b31-c6aa-4c3f-911e-bfade3a38018.jpeg\\\");background-position:50% 50%,12% 52%;}div#n2-ss-4 .n2-font-c64fa1d6c43811c1c8a62069a1f404e5-link a{font-family: \'Montserrat\',\'Arial\';color: #000000;font-size:112.5%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: center;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 700;}div#n2-ss-4 .n2-font-c64fa1d6c43811c1c8a62069a1f404e5-link a:HOVER, div#n2-ss-4 .n2-font-c64fa1d6c43811c1c8a62069a1f404e5-link a:ACTIVE, div#n2-ss-4 .n2-font-c64fa1d6c43811c1c8a62069a1f404e5-link a:FOCUS{color: #262626;}div#n2-ss-4 .n2-style-394d8fc34bf40d635a06fe8baea9d188-heading{background: #cbf3bd;opacity:1;padding:0.8em 1.5em 0.8em 1.5em ;box-shadow: none;border: 2px solid RGBA(1,173,211,1);border-radius:99px;}div#n2-ss-4 .n2-style-394d8fc34bf40d635a06fe8baea9d188-heading:Hover, div#n2-ss-4 .n2-style-394d8fc34bf40d635a06fe8baea9d188-heading:ACTIVE, div#n2-ss-4 .n2-style-394d8fc34bf40d635a06fe8baea9d188-heading:FOCUS{background: #ffffff;}div#n2-ss-4 .n2-font-239ce1a80bbcd585366301bfded06d91-hover{font-family: \'\';color: #ffffff;font-size:300%;text-shadow: none;line-height: 1.3;font-weight: normal;font-style: normal;text-decoration: none;text-align: inherit;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 700;}div#n2-ss-4 .n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot{background: RGBA(255,255,255,0.5);opacity:1;padding:5px 5px 5px 5px ;box-shadow: none;border: 0px solid RGBA(0,0,0,1);border-radius:50px;margin:4px;}div#n2-ss-4 .n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot.n2-active, div#n2-ss-4 .n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot:HOVER, div#n2-ss-4 .n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot:FOCUS{background: #ffffff;}div#n2-ss-4 .n2-style-c551d6c8778ab3d08aca13db75fd7f5e-simple{background: RGBA(0,0,0,0.5);opacity:1;padding:0px 0px 0px 0px ;box-shadow: none;border: 0px solid RGBA(0,0,0,1);border-radius:3px;margin:5px;}div#n2-ss-4 .n2-ss-slide-limiter{max-width:1200px;}div#n2-ss-4 .n-uc-70GwbsDd4Uua{padding:0px 0px 0px 0px}div#n2-ss-4 .n-uc-1f4f8ad18c1a0-inner{padding:40px 60px 40px 60px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-1f4f8ad18c1a0{max-width: 1030px;align-self:var(--ss-fe);}div#n2-ss-4 .n-uc-7JaoibEfUkkL{--margin-bottom:10px}div#n2-ss-4 .n-uc-D03vvwqTejiS{--margin-bottom:30px}div#n2-ss-4 .n-uc-9FOxQr3pAg1u{--margin-right:-265px;max-width:250px}div#n2-ss-4 .n-uc-6xD1JF6nZjFa{padding:0px 0px 0px 0px}div#n2-ss-4 .n-uc-187d8f1049b03-inner{padding:40px 60px 40px 60px;justify-content:center}div#n2-ss-4 .n-uc-2CmBc17E75oi{--margin-bottom:15px}div#n2-ss-4 .n-uc-tIGNamtRr8aM{--margin-right:300px;--margin-left:-170px;max-width:295px;align-self:var(--ss-fe);}div#n2-ss-4 .n-uc-kYioCZs0uzPW{--margin-bottom:30px}div#n2-ss-4 .nextend-arrow img{width: 32px}@media (min-width: 1200px){div#n2-ss-4 [data-hide-desktopportrait=\\\"1\\\"]{display: none !important;}}@media (max-width: 1199px) and (min-width: 701px){div#n2-ss-4 .n-uc-D03vvwqTejiS{--margin-bottom:30px;--ssfont-scale:0.8}div#n2-ss-4 .n-uc-tIGNamtRr8aM{--margin-right:35px;--margin-left:-20px}div#n2-ss-4 .n-uc-kYioCZs0uzPW{--ssfont-scale:0.8}div#n2-ss-4 [data-hide-tabletportrait=\\\"1\\\"]{display: none !important;}}@media (max-width: 700px){div#n2-ss-4 .n-uc-1f4f8ad18c1a0-inner{padding:40px 25px 40px 25px;justify-content:center}div#n2-ss-4 .n-uc-7JaoibEfUkkL{--ssfont-scale:0.9}div#n2-ss-4 .n-uc-D03vvwqTejiS{--margin-bottom:10px;--ssfont-scale:0.65}div#n2-ss-4 .n-uc-9FOxQr3pAg1u{max-width:215px;--ssfont-scale:0.8}div#n2-ss-4 .n-uc-187d8f1049b03-inner{padding:40px 25px 40px 25px}div#n2-ss-4 .n-uc-2CmBc17E75oi{--margin-bottom:10px;--ssfont-scale:0.9}div#n2-ss-4 .n-uc-tIGNamtRr8aM{--margin-right:20px;--margin-left:-20px;max-width:175px;--ssfont-scale:0.8}div#n2-ss-4 .n-uc-kYioCZs0uzPW{--margin-bottom:10px;--ssfont-scale:0.6}div#n2-ss-4 [data-hide-mobileportrait=\\\"1\\\"]{display: none !important;}div#n2-ss-4 .nextend-arrow img{width: 16px}}\"},\"globalInline\":[]},\"less\":{\"staticGroupPreload\":[],\"staticGroup\":[],\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[],\"globalInline\":[]},\"js\":{\"staticGroupPreload\":[],\"staticGroup\":{\"smartslider-frontend\":\"\\/Applications\\/XAMPP\\/xamppfiles\\/htdocs\\/nellboulanger\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Application\\/Frontend\\/Assets\\/dist\\/smartslider-frontend.min.js\",\"ss-simple\":\"\\/Applications\\/XAMPP\\/xamppfiles\\/htdocs\\/nellboulanger\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Slider\\/SliderType\\/Simple\\/Assets\\/dist\\/ss-simple.min.js\",\"w-arrow-image\":\"\\/Applications\\/XAMPP\\/xamppfiles\\/htdocs\\/nellboulanger\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Widget\\/Arrow\\/ArrowImage\\/Assets\\/dist\\/w-arrow-image.min.js\",\"w-bullet\":\"\\/Applications\\/XAMPP\\/xamppfiles\\/htdocs\\/nellboulanger\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Widget\\/Bullet\\/Assets\\/dist\\/w-bullet.min.js\"},\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[\"_N2.r([\\\"documentReady\\\",\\\"smartslider-frontend\\\",\\\"SmartSliderWidgetArrowImage\\\",\\\"SmartSliderWidgetBulletTransition\\\",\\\"ss-simple\\\"],function(){new _N2.SmartSliderSimple(\'n2-ss-4\', {\\\"admin\\\":false,\\\"background.video.mobile\\\":1,\\\"loadingTime\\\":2000,\\\"randomize\\\":{\\\"randomize\\\":0,\\\"randomizeFirst\\\":0},\\\"alias\\\":{\\\"id\\\":0,\\\"smoothScroll\\\":0,\\\"slideSwitch\\\":0,\\\"scroll\\\":1},\\\"align\\\":\\\"normal\\\",\\\"isDelayed\\\":0,\\\"responsive\\\":{\\\"mediaQueries\\\":{\\\"all\\\":false,\\\"desktopportrait\\\":[\\\"(min-width: 1200px)\\\"],\\\"tabletportrait\\\":[\\\"(max-width: 1199px) and (min-width: 701px)\\\"],\\\"mobileportrait\\\":[\\\"(max-width: 700px)\\\"]},\\\"base\\\":{\\\"slideOuterWidth\\\":1200,\\\"slideOuterHeight\\\":600,\\\"sliderWidth\\\":1200,\\\"sliderHeight\\\":600,\\\"slideWidth\\\":1200,\\\"slideHeight\\\":600},\\\"hideOn\\\":{\\\"desktopLandscape\\\":false,\\\"desktopPortrait\\\":false,\\\"tabletLandscape\\\":false,\\\"tabletPortrait\\\":false,\\\"mobileLandscape\\\":false,\\\"mobilePortrait\\\":false},\\\"onResizeEnabled\\\":true,\\\"type\\\":\\\"fullwidth\\\",\\\"sliderHeightBasedOn\\\":\\\"real\\\",\\\"focusUser\\\":1,\\\"focusEdge\\\":\\\"auto\\\",\\\"breakpoints\\\":[{\\\"device\\\":\\\"tabletPortrait\\\",\\\"type\\\":\\\"max-screen-width\\\",\\\"portraitWidth\\\":1199,\\\"landscapeWidth\\\":1199},{\\\"device\\\":\\\"mobilePortrait\\\",\\\"type\\\":\\\"max-screen-width\\\",\\\"portraitWidth\\\":700,\\\"landscapeWidth\\\":900}],\\\"enabledDevices\\\":{\\\"desktopLandscape\\\":0,\\\"desktopPortrait\\\":1,\\\"tabletLandscape\\\":0,\\\"tabletPortrait\\\":1,\\\"mobileLandscape\\\":0,\\\"mobilePortrait\\\":1},\\\"sizes\\\":{\\\"desktopPortrait\\\":{\\\"width\\\":1200,\\\"height\\\":600,\\\"max\\\":3000,\\\"min\\\":1200},\\\"tabletPortrait\\\":{\\\"width\\\":701,\\\"height\\\":350,\\\"customHeight\\\":false,\\\"max\\\":1199,\\\"min\\\":701},\\\"mobilePortrait\\\":{\\\"width\\\":320,\\\"height\\\":160,\\\"customHeight\\\":false,\\\"max\\\":900,\\\"min\\\":320}},\\\"overflowHiddenPage\\\":0,\\\"focus\\\":{\\\"offsetTop\\\":\\\"#wpadminbar\\\",\\\"offsetBottom\\\":\\\"\\\"}},\\\"controls\\\":{\\\"mousewheel\\\":0,\\\"touch\\\":\\\"horizontal\\\",\\\"keyboard\\\":1,\\\"blockCarouselInteraction\\\":1},\\\"playWhenVisible\\\":1,\\\"playWhenVisibleAt\\\":0.5,\\\"lazyLoad\\\":0,\\\"lazyLoadNeighbor\\\":0,\\\"blockrightclick\\\":0,\\\"maintainSession\\\":0,\\\"autoplay\\\":{\\\"enabled\\\":0,\\\"start\\\":1,\\\"duration\\\":8000,\\\"autoplayLoop\\\":1,\\\"allowReStart\\\":0,\\\"pause\\\":{\\\"click\\\":1,\\\"mouse\\\":\\\"0\\\",\\\"mediaStarted\\\":1},\\\"resume\\\":{\\\"click\\\":0,\\\"mouse\\\":\\\"0\\\",\\\"mediaEnded\\\":1,\\\"slidechanged\\\":0},\\\"interval\\\":1,\\\"intervalModifier\\\":\\\"loop\\\",\\\"intervalSlide\\\":\\\"current\\\"},\\\"perspective\\\":1000,\\\"layerMode\\\":{\\\"playOnce\\\":0,\\\"playFirstLayer\\\":1,\\\"mode\\\":\\\"skippable\\\",\\\"inAnimation\\\":\\\"mainInEnd\\\"},\\\"bgAnimations\\\":0,\\\"mainanimation\\\":{\\\"type\\\":\\\"horizontal\\\",\\\"duration\\\":800,\\\"delay\\\":0,\\\"ease\\\":\\\"easeOutQuad\\\",\\\"shiftedBackgroundAnimation\\\":0},\\\"carousel\\\":1,\\\"initCallbacks\\\":function(){new _N2.SmartSliderWidgetArrowImage(this);new _N2.SmartSliderWidgetBulletTransition(this, {\\\"area\\\":10,\\\"dotClasses\\\":\\\"n2-style-4ef2b9ef3ac95757a797a679951a67a3-dot \\\",\\\"mode\\\":\\\"\\\",\\\"action\\\":\\\"click\\\",\\\"thumbnail\\\":1,\\\"thumbnailWidth\\\":120,\\\"thumbnailHeight\\\":81,\\\"thumbnailStyle\\\":\\\"n2-style-c551d6c8778ab3d08aca13db75fd7f5e-simple \\\",\\\"thumbnailPosition\\\":\\\"top\\\"});}});});\"],\"globalInline\":[]},\"googleFonts\":{\"staticGroupPreload\":[],\"staticGroup\":[],\"files\":{\"Montserrat\":[\"300\",\"400\"],\"Playfair Display\":[\"300\",\"400\"]},\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[],\"globalInline\":[]},\"image\":{\"images\":[\"\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/10802a08259602b5ac540aed3487b16b\\/4aee027a-8f57-4ff5-b044-1c48be6e8dfa.jpg\",\"\\/\\/localhost\\/nellboulanger\\/wp-content\\/uploads\\/slider\\/cache\\/1d1ba6d6cd2d0f2dae89fc5d656e956e\\/2ec912fe-87bd-4c0e-9b2a-49a982a44178.jpg\"]}}}", "0", "1");

/* INSERT TABLE DATA: wp_nextend2_smartslider3_sliders */
INSERT INTO `wp_nextend2_smartslider3_sliders` VALUES("1", NULL, "Tutorial Slider", "simple", "{\"aria-label\":\"Slider\",\"alias-id\":\"\",\"alias-smoothscroll\":\"\",\"alias-slideswitch\":\"\",\"background\":\"\",\"background-fixed\":\"0\",\"background-size\":\"cover\",\"background-color\":\"FFFFFF00\",\"backgroundVideoMp4\":\"\",\"backgroundVideoMuted\":\"1\",\"backgroundVideoLoop\":\"1\",\"backgroundVideoMode\":\"fill\",\"align\":\"normal\",\"margin\":\"0|*|0|*|0|*|0\",\"padding\":\"0|*|0|*|0|*|0\",\"perspective\":\"1000\",\"border-width\":\"0\",\"border-color\":\"3E3E3Eff\",\"border-radius\":\"0\",\"slider-preset\":\"\",\"slider-css\":\"\",\"width\":\"1200\",\"height\":\"600\",\"mobileportrait\":\"1\",\"mobilelandscape\":\"1\",\"tabletportrait\":\"1\",\"tabletlandscape\":\"1\",\"desktopportrait\":\"1\",\"desktoplandscape\":\"1\",\"responsiveLimitSlideWidth\":\"1\",\"responsiveSlideWidthDesktopLandscape\":\"0\",\"responsiveSlideWidthMaxDesktopLandscape\":\"1600\",\"responsiveSlideWidth\":\"0\",\"responsiveSlideWidthMax\":\"3000\",\"responsiveSlideWidthTabletLandscape\":\"0\",\"responsiveSlideWidthMaxTabletLandscape\":\"1200\",\"responsiveSlideWidthTablet\":\"0\",\"responsiveSlideWidthMaxTablet\":\"3000\",\"responsiveSlideWidthMobileLandscape\":\"0\",\"responsiveSlideWidthMaxMobileLandscape\":\"740\",\"responsiveSlideWidthMobile\":\"0\",\"responsiveSlideWidthMaxMobile\":\"480\",\"responsive-breakpoint-desktop-portrait\":\"1440\",\"responsive-breakpoint-desktop-portrait-landscape\":\"1440\",\"responsive-breakpoint-tablet-landscape\":\"1300\",\"responsive-breakpoint-tablet-landscape-landscape\":\"1300\",\"responsive-breakpoint-tablet-portrait\":\"1199\",\"responsive-breakpoint-tablet-portrait-landscape\":\"1199\",\"responsive-breakpoint-mobile-landscape\":\"900\",\"responsive-breakpoint-mobile-landscape-landscape\":\"1050\",\"responsive-breakpoint-mobile-portrait\":\"700\",\"responsive-breakpoint-mobile-portrait-landscape\":\"900\",\"responsive-breakpoint-desktop-landscape-enabled\":\"0\",\"responsive-breakpoint-tablet-landscape-enabled\":\"0\",\"responsive-breakpoint-tablet-portrait-enabled\":\"1\",\"responsive-breakpoint-mobile-landscape-enabled\":\"0\",\"responsive-breakpoint-mobile-portrait-enabled\":\"1\",\"responsive-breakpoint-global\":\"0\",\"breakpoints-orientation\":\"portrait\",\"responsive-mode\":\"fullwidth\",\"responsiveSliderHeightMin\":\"0\",\"responsiveForceFull\":\"1\",\"responsiveForceFullOverflowX\":\"body\",\"responsiveForceFullHorizontalSelector\":\"body\",\"slider-size-override\":\"0\",\"slider-size-override-mobile-portrait\":\"0\",\"mobile-portrait-width\":\"320\",\"mobile-portrait-height\":\"568\",\"slider-size-override-mobile-landscape\":\"0\",\"mobile-landscape-width\":\"568\",\"mobile-landscape-height\":\"320\",\"slider-size-override-tablet-portrait\":\"0\",\"tablet-portrait-width\":\"768\",\"tablet-portrait-height\":\"1024\",\"slider-size-override-tablet-landscape\":\"0\",\"tablet-landscape-width\":\"1024\",\"tablet-landscape-height\":\"768\",\"slider-size-override-desktop-landscape\":\"0\",\"desktop-landscape-width\":\"1440\",\"desktop-landscape-height\":\"900\",\"controlsTouch\":\"horizontal\",\"controlsScroll\":\"0\",\"controlsKeyboard\":\"1\",\"widget-arrow-enabled\":\"0\",\"widgetarrow\":\"imageEmpty\",\"widget-arrow-previous\":\"thin-horizontal.svg\",\"widget-arrow-previous-image\":\"\",\"widget-arrow-previous-color\":\"ffffffcc\",\"widget-arrow-previous-hover\":\"1\",\"widget-arrow-previous-hover-color\":\"ffffffff\",\"widget-arrow-mirror\":\"1\",\"widget-arrow-next\":\"thin-horizontal.svg\",\"widget-arrow-next-image\":\"\",\"widget-arrow-next-color\":\"ffffffcc\",\"widget-arrow-next-hover\":\"0\",\"widget-arrow-next-hover-color\":\"ffffffcc\",\"widget-arrow-style\":\"\",\"widget-arrow-previous-position-mode\":\"simple\",\"widget-arrow-previous-position-area\":\"6\",\"widget-arrow-previous-position-stack\":\"1\",\"widget-arrow-previous-position-offset\":\"15\",\"widget-arrow-previous-position-horizontal\":\"left\",\"widget-arrow-previous-position-horizontal-position\":\"0\",\"widget-arrow-previous-position-horizontal-unit\":\"px\",\"widget-arrow-previous-position-vertical\":\"top\",\"widget-arrow-previous-position-vertical-position\":\"0\",\"widget-arrow-previous-position-vertical-unit\":\"px\",\"widget-arrow-next-position-mode\":\"simple\",\"widget-arrow-next-position-area\":\"7\",\"widget-arrow-next-position-stack\":\"1\",\"widget-arrow-next-position-offset\":\"15\",\"widget-arrow-next-position-horizontal\":\"left\",\"widget-arrow-next-position-horizontal-position\":\"0\",\"widget-arrow-next-position-horizontal-unit\":\"px\",\"widget-arrow-next-position-vertical\":\"top\",\"widget-arrow-next-position-vertical-position\":\"0\",\"widget-arrow-next-position-vertical-unit\":\"px\",\"widget-arrow-animation\":\"fade\",\"widget-arrow-previous-alt\":\"previous arrow\",\"widget-arrow-next-alt\":\"next arrow\",\"widget-arrow-base64\":\"1\",\"widget-arrow-display-hover\":\"0\",\"widget-arrow-display-mobileportrait\":\"0\",\"widget-arrow-display-mobilelandscape\":\"0\",\"widget-arrow-display-tabletportrait\":\"1\",\"widget-arrow-display-tabletlandscape\":\"1\",\"widget-arrow-display-desktopportrait\":\"1\",\"widget-arrow-display-desktoplandscape\":\"1\",\"widget-arrow-exclude-slides\":\"\",\"widget-bullet-enabled\":\"1\",\"widgetbullet\":\"transition\",\"widget-bullet-position-mode\":\"simple\",\"widget-bullet-position-area\":\"10\",\"widget-bullet-position-stack\":\"1\",\"widget-bullet-position-offset\":\"5\",\"widget-bullet-position-horizontal\":\"left\",\"widget-bullet-position-horizontal-position\":\"0\",\"widget-bullet-position-horizontal-unit\":\"px\",\"widget-bullet-position-vertical\":\"top\",\"widget-bullet-position-vertical-position\":\"0\",\"widget-bullet-position-vertical-unit\":\"px\",\"widget-bullet-action\":\"click\",\"widget-bullet-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffcc\\\",\\\"borderradius\\\":\\\"50\\\",\\\"extra\\\":\\\"margin: 4px;\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffcc\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffcc\\\"}]}\",\"widget-bullet-bar\":\"\",\"widget-bullet-bar-full-size\":\"0\",\"widget-bullet-align\":\"center\",\"widget-bullet-orientation\":\"auto\",\"widget-bullet-thumbnail-show-image\":\"0\",\"widget-bullet-thumbnail-width\":\"60\",\"widget-bullet-thumbnail-height\":\"60\",\"widget-bullet-thumbnail-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"margin: 5px;\\\"}]}\",\"widget-bullet-thumbnail-side\":\"before\",\"widget-bullet-display-hover\":\"0\",\"widget-bullet-display-mobileportrait\":\"1\",\"widget-bullet-display-mobilelandscape\":\"1\",\"widget-bullet-display-tabletportrait\":\"1\",\"widget-bullet-display-tabletlandscape\":\"1\",\"widget-bullet-display-desktopportrait\":\"1\",\"widget-bullet-display-desktoplandscape\":\"1\",\"widget-bullet-exclude-slides\":\"\",\"widget-bar-enabled\":\"0\",\"widgetbar\":\"horizontal\",\"widget-bar-position-mode\":\"simple\",\"widget-bar-position-area\":\"10\",\"widget-bar-position-stack\":\"1\",\"widget-bar-position-offset\":\"30\",\"widget-bar-position-horizontal\":\"left\",\"widget-bar-position-horizontal-position\":\"0\",\"widget-bar-position-horizontal-unit\":\"px\",\"widget-bar-position-vertical\":\"top\",\"widget-bar-position-vertical-position\":\"0\",\"widget-bar-position-vertical-unit\":\"px\",\"widget-bar-animate\":\"0\",\"widget-bar-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|20|*|5|*|20|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"40\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bar-show-title\":\"1\",\"widget-bar-font-title\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http://fonts.googleapis.com/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-show-description\":\"1\",\"widget-bar-font-description\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":1,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-slide-count\":\"0\",\"widget-bar-width\":\"100%\",\"widget-bar-full-width\":\"0\",\"widget-bar-separator\":\" - \",\"widget-bar-align\":\"center\",\"widget-bar-display-hover\":\"0\",\"widget-bar-display-mobileportrait\":\"1\",\"widget-bar-display-mobilelandscape\":\"1\",\"widget-bar-display-tabletportrait\":\"1\",\"widget-bar-display-tabletlandscape\":\"1\",\"widget-bar-display-desktopportrait\":\"1\",\"widget-bar-display-desktoplandscape\":\"1\",\"widget-bar-exclude-slides\":\"\",\"widget-thumbnail-enabled\":\"0\",\"widgetthumbnail\":\"default\",\"widget-thumbnail-show-image\":\"1\",\"widget-thumbnail-width\":\"100\",\"widget-thumbnail-height\":\"60\",\"widget-thumbnail-position-mode\":\"simple\",\"widget-thumbnail-position-area\":\"12\",\"widget-thumbnail-position-stack\":\"1\",\"widget-thumbnail-position-offset\":\"0\",\"widget-thumbnail-position-horizontal\":\"left\",\"widget-thumbnail-position-horizontal-position\":\"0\",\"widget-thumbnail-position-horizontal-unit\":\"px\",\"widget-thumbnail-position-vertical\":\"top\",\"widget-thumbnail-position-vertical-position\":\"0\",\"widget-thumbnail-position-vertical-unit\":\"px\",\"widget-thumbnail-action\":\"click\",\"widget-thumbnail-align-content\":\"start\",\"widget-thumbnail-style-bar\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"242424ff\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-style-slides\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|ffffff00\\\",\\\"borderradius\\\":\\\"0\\\",\\\"opacity\\\":\\\"40\\\",\\\"extra\\\":\\\"margin: 3px;\\ntransition: all 0.4s;\\nbackground-size: cover;\\\"},{\\\"border\\\":\\\"0|*|solid|*|ffffffcc\\\",\\\"opacity\\\":\\\"100\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-title-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"3|*|10|*|3|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"bottom: 0;\\nleft: 0;\\\"}]}\",\"widget-thumbnail-title\":\"0\",\"widget-thumbnail-title-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http://fonts.googleapis.com/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-description\":\"0\",\"widget-thumbnail-description-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http://fonts.googleapis.com/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-caption-placement\":\"overlay\",\"widget-thumbnail-caption-size\":\"100\",\"widget-thumbnail-arrow\":\"1\",\"widget-thumbnail-arrow-width\":\"26\",\"widget-thumbnail-arrow-offset\":\"0\",\"widget-thumbnail-arrow-prev-alt\":\"previous arrow\",\"widget-thumbnail-arrow-next-alt\":\"next arrow\",\"widget-thumbnail-arrow-image\":\"\",\"widget-thumbnail-group\":\"1\",\"widget-thumbnail-invert-group-direction\":\"0\",\"widget-thumbnail-orientation\":\"auto\",\"widget-thumbnail-size\":\"100%\",\"widget-thumbnail-display-hover\":\"0\",\"widget-thumbnail-display-mobileportrait\":\"1\",\"widget-thumbnail-display-mobilelandscape\":\"1\",\"widget-thumbnail-display-tabletportrait\":\"1\",\"widget-thumbnail-display-tabletlandscape\":\"1\",\"widget-thumbnail-display-desktopportrait\":\"1\",\"widget-thumbnail-display-desktoplandscape\":\"1\",\"widget-thumbnail-exclude-slides\":\"\",\"widget-shadow-enabled\":\"0\",\"widgetshadow\":\"shadow\",\"widget-shadow-shadow\":\"dark.png\",\"widget-shadow-shadow-image\":\"\",\"widget-shadow-width\":\"100%\",\"widget-shadow-display-mobileportrait\":\"1\",\"widget-shadow-display-mobilelandscape\":\"1\",\"widget-shadow-display-tabletportrait\":\"1\",\"widget-shadow-display-tabletlandscape\":\"1\",\"widget-shadow-display-desktopportrait\":\"1\",\"widget-shadow-display-desktoplandscape\":\"1\",\"widget-shadow-exclude-slides\":\"\",\"widget-fullscreen-enabled\":\"0\",\"widgetfullscreen\":\"image\",\"widget-fullscreen-tonormal\":\"full1.svg\",\"widget-fullscreen-tonormal-image\":\"\",\"widget-fullscreen-tonormal-color\":\"ffffffcc\",\"widget-fullscreen-mirror\":\"1\",\"widget-fullscreen-tofull\":\"full1.svg\",\"widget-fullscreen-tofull-image\":\"\",\"widget-fullscreen-tofull-color\":\"ffffffcc\",\"widget-fullscreen-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-fullscreen-position-mode\":\"simple\",\"widget-fullscreen-position-area\":\"4\",\"widget-fullscreen-position-stack\":\"1\",\"widget-fullscreen-position-offset\":\"15\",\"widget-fullscreen-position-horizontal\":\"left\",\"widget-fullscreen-position-horizontal-position\":\"0\",\"widget-fullscreen-position-horizontal-unit\":\"px\",\"widget-fullscreen-position-vertical\":\"top\",\"widget-fullscreen-position-vertical-position\":\"0\",\"widget-fullscreen-position-vertical-unit\":\"px\",\"widget-fullscreen-responsive-desktop\":\"1\",\"widget-fullscreen-responsive-tablet\":\"0.7\",\"widget-fullscreen-responsive-mobile\":\"0.5\",\"widget-fullscreen-display-hover\":\"0\",\"widget-fullscreen-display-mobileportrait\":\"1\",\"widget-fullscreen-display-mobilelandscape\":\"1\",\"widget-fullscreen-display-tabletportrait\":\"1\",\"widget-fullscreen-display-tabletlandscape\":\"1\",\"widget-fullscreen-display-desktopportrait\":\"1\",\"widget-fullscreen-display-desktoplandscape\":\"1\",\"widget-fullscreen-exclude-slides\":\"\",\"widget-html-enabled\":\"0\",\"widgethtml\":\"html\",\"widget-html-position-mode\":\"simple\",\"widget-html-position-area\":\"2\",\"widget-html-position-stack\":\"1\",\"widget-html-position-offset\":\"0\",\"widget-html-position-horizontal\":\"left\",\"widget-html-position-horizontal-position\":\"0\",\"widget-html-position-horizontal-unit\":\"px\",\"widget-html-position-vertical\":\"top\",\"widget-html-position-vertical-position\":\"0\",\"widget-html-position-vertical-unit\":\"px\",\"widget-html-code\":\"\",\"widget-html-display-hover\":\"0\",\"widget-html-display-mobileportrait\":\"1\",\"widget-html-display-mobilelandscape\":\"1\",\"widget-html-display-tabletportrait\":\"1\",\"widget-html-display-tabletlandscape\":\"1\",\"widget-html-display-desktopportrait\":\"1\",\"widget-html-display-desktoplandscape\":\"1\",\"widget-html-exclude-slides\":\"\",\"animation\":\"fade\",\"animation-duration\":\"500\",\"animation-delay\":\"0\",\"animation-easing\":\"easeOutQuad\",\"carousel\":\"1\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"normal\",\"animation-shifted-background-animation\":\"auto\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"shape-divider\":\"\",\"particle\":\"\",\"playfirstlayer\":\"1\",\"playonce\":\"0\",\"layer-animation-play-in\":\"end\",\"layer-animation-play-mode\":\"skippable\",\"parallax-enabled\":\"1\",\"parallax-enabled-mobile\":\"0\",\"parallax-3d\":\"0\",\"parallax-animate\":\"1\",\"parallax-horizontal\":\"mouse\",\"parallax-vertical\":\"mouse\",\"parallax-mouse-origin\":\"slider\",\"parallax-scroll-move\":\"both\",\"autoplay\":\"0\",\"autoplayDuration\":\"8000\",\"autoplayStart\":\"1\",\"autoplayAllowReStart\":\"0\",\"autoplayLoop\":\"1\",\"autoplayfinish\":\"1|*|loop|*|current\",\"loop-single-slide\":\"0\",\"autoplayStopClick\":\"1\",\"autoplayStopMouse\":\"0\",\"autoplayStopMedia\":\"1\",\"autoplayResumeClick\":\"0\",\"autoplayResumeMouse\":\"0\",\"autoplayResumeMedia\":\"1\",\"widget-autoplay-enabled\":\"0\",\"widgetautoplay\":\"image\",\"widget-autoplay-play\":\"small-light.svg\",\"widget-autoplay-play-image\":\"\",\"widget-autoplay-play-color\":\"ffffffcc\",\"widget-autoplay-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-autoplay-mirror\":\"1\",\"widget-autoplay-pause\":\"small-light.svg\",\"widget-autoplay-pause-image\":\"\",\"widget-autoplay-pause-color\":\"ffffffcc\",\"widget-autoplay-responsive-desktop\":\"1\",\"widget-autoplay-responsive-tablet\":\"0.7\",\"widget-autoplay-responsive-mobile\":\"0.5\",\"widget-autoplay-position-mode\":\"simple\",\"widget-autoplay-position-area\":\"4\",\"widget-autoplay-position-stack\":\"1\",\"widget-autoplay-position-offset\":\"15\",\"widget-autoplay-position-horizontal\":\"left\",\"widget-autoplay-position-horizontal-position\":\"0\",\"widget-autoplay-position-horizontal-unit\":\"px\",\"widget-autoplay-position-vertical\":\"top\",\"widget-autoplay-position-vertical-position\":\"0\",\"widget-autoplay-position-vertical-unit\":\"px\",\"widget-autoplay-display-hover\":\"0\",\"widget-autoplay-display-mobileportrait\":\"1\",\"widget-autoplay-display-mobilelandscape\":\"1\",\"widget-autoplay-display-tabletportrait\":\"1\",\"widget-autoplay-display-tabletlandscape\":\"1\",\"widget-autoplay-display-desktopportrait\":\"1\",\"widget-autoplay-display-desktoplandscape\":\"1\",\"widget-autoplay-exclude-slides\":\"\",\"widget-indicator-enabled\":\"0\",\"widgetindicator\":\"pie\",\"widget-indicator-position-mode\":\"simple\",\"widget-indicator-position-area\":\"4\",\"widget-indicator-position-stack\":\"1\",\"widget-indicator-position-offset\":\"15\",\"widget-indicator-position-horizontal\":\"left\",\"widget-indicator-position-horizontal-position\":\"0\",\"widget-indicator-position-horizontal-unit\":\"px\",\"widget-indicator-position-vertical\":\"top\",\"widget-indicator-position-vertical-position\":\"0\",\"widget-indicator-position-vertical-unit\":\"px\",\"widget-indicator-size\":\"25\",\"widget-indicator-thickness\":\"30\",\"widget-indicator-track\":\"000000ab\",\"widget-indicator-bar\":\"ffffffff\",\"widget-indicator-style\":\"\",\"widget-indicator-display-hover\":\"0\",\"widget-indicator-display-mobileportrait\":\"1\",\"widget-indicator-display-mobilelandscape\":\"1\",\"widget-indicator-display-tabletportrait\":\"1\",\"widget-indicator-display-tabletlandscape\":\"1\",\"widget-indicator-display-desktopportrait\":\"1\",\"widget-indicator-display-desktoplandscape\":\"1\",\"widget-indicator-exclude-slides\":\"\",\"imageload\":\"0\",\"imageloadNeighborSlides\":\"0\",\"optimize-scale\":\"0\",\"optimize-quality\":\"70\",\"optimize-thumbnail-scale\":\"0\",\"optimize-thumbnail-quality\":\"70\",\"optimize-slide-width-normal\":\"1920\",\"optimizeThumbnailWidth\":\"100\",\"optimizeThumbnailHeight\":\"60\",\"layer-image-optimize\":\"0\",\"layer-image-width-tablet\":\"800\",\"layer-image-width-mobile\":\"425\",\"layer-image-base64\":\"0\",\"layer-image-base64-size\":\"50\",\"slides-background-video-mobile\":\"1\",\"playWhenVisible\":\"1\",\"playWhenVisibleAt\":\"50\",\"dependency\":\"\",\"delay\":\"0\",\"is-delayed\":\"0\",\"backgroundMode\":\"fill\",\"slide-css\":\"\",\"randomize\":\"0\",\"randomizeFirst\":\"0\",\"randomize-cache\":\"1\",\"variations\":\"5\",\"reverse-slides\":\"0\",\"maximumslidecount\":\"1000\",\"maintain-session\":\"0\",\"global-lightbox\":\"0\",\"global-lightbox-label\":\"0\",\"slide-background-parallax\":\"0\",\"slide-background-parallax-strength\":\"50\",\"bg-parallax-tablet\":\"0\",\"bg-parallax-mobile\":\"0\",\"blockrightclick\":\"0\",\"controlsBlockCarouselInteraction\":\"1\",\"clear-both\":\"1\",\"clear-both-after\":\"1\",\"overflow-hidden-page\":\"0\",\"responsiveFocusUser\":\"1\",\"responsiveFocusEdge\":\"auto\",\"classes\":\"\",\"custom-css-codes\":\"\",\"callbacks\":\"\",\"related-posts\":\"\"}", "published", "2020-02-25 13:53:41", "https://smartslider3.com/wp-content/uploads/slider404/tutorialsliderthumbnail-1.png", "3");
INSERT INTO `wp_nextend2_smartslider3_sliders` VALUES("2", NULL, "Slider e-books", "simple", "{\"thumbnail\":\"\",\"aria-label\":\"Slider\",\"alias-id\":\"\",\"alias-smoothscroll\":\"\",\"alias-slideswitch\":\"\",\"alias-slideswitch-scroll\":\"1\",\"align\":\"normal\",\"margin\":\"0|*|0|*|0|*|0\",\"width\":\"1200\",\"height\":\"600\",\"responsiveLimitSlideWidth\":\"0\",\"responsiveSlideWidth\":\"0\",\"responsiveSlideWidthMax\":\"3000\",\"responsiveSlideWidthTablet\":\"0\",\"responsiveSlideWidthMaxTablet\":\"3000\",\"responsiveSlideWidthMobile\":\"0\",\"responsiveSlideWidthMaxMobile\":\"480\",\"responsive-breakpoint-tablet-portrait\":\"1199\",\"responsive-breakpoint-tablet-portrait-landscape\":\"1199\",\"responsive-breakpoint-mobile-portrait\":\"700\",\"responsive-breakpoint-mobile-portrait-landscape\":\"900\",\"responsive-breakpoint-tablet-portrait-enabled\":\"1\",\"responsive-breakpoint-mobile-portrait-enabled\":\"1\",\"responsive-breakpoint-global\":\"0\",\"breakpoints-orientation\":\"portrait\",\"responsive-mode\":\"auto\",\"responsiveScaleDown\":\"1\",\"responsiveScaleUp\":\"0\",\"responsiveSliderHeightMin\":\"0\",\"controlsTouch\":\"horizontal\",\"controlsScroll\":\"0\",\"controlsKeyboard\":\"1\",\"widget-arrow-enabled\":\"0\",\"widgetarrow\":\"imageSmallRectangle\",\"widget-arrow-previous\":\"full.svg\",\"widget-arrow-previous-color\":\"ffffffcc\",\"widget-arrow-previous-hover\":\"0\",\"widget-arrow-previous-hover-color\":\"ffffffcc\",\"widget-arrow-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"2|*|2|*|2|*|2|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"FF9139FF\\\"}]}\",\"widget-arrow-previous-position-area\":\"6\",\"widget-arrow-previous-position-stack\":\"1\",\"widget-arrow-previous-position-offset\":\"15\",\"widget-arrow-next-position-area\":\"7\",\"widget-arrow-next-position-stack\":\"1\",\"widget-arrow-next-position-offset\":\"15\",\"widget-arrow-previous-alt\":\"previous arrow\",\"widget-arrow-next-alt\":\"next arrow\",\"widget-arrow-base64\":\"1\",\"widget-arrow-desktop-image-width\":\"26\",\"widget-arrow-tablet-image-width\":\"26\",\"widget-arrow-mobile-image-width\":\"16\",\"widget-arrow-display-hover\":\"1\",\"widget-arrow-display-mobileportrait\":\"1\",\"widget-arrow-display-tabletportrait\":\"1\",\"widget-arrow-display-desktopportrait\":\"1\",\"widget-bullet-enabled\":\"0\",\"widgetbullet\":\"transition\",\"widget-bullet-position-area\":\"10\",\"widget-bullet-position-stack\":\"1\",\"widget-bullet-position-offset\":\"10\",\"widget-bullet-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"50\\\",\\\"extra\\\":\\\"margin: 4px;\\\"},{\\\"backgroundcolor\\\":\\\"1D81F9FF\\\"}]}\",\"widget-bullet-bar\":\"\",\"widget-bullet-aria-label\":\"Choose slide to display.\",\"widget-bullet-thumbnail-show-image\":\"0\",\"widget-bullet-thumbnail-width\":\"100\",\"widget-bullet-thumbnail-height\":\"60\",\"widget-bullet-thumbnail-style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"margin: 5px;background-size:cover;\\\"}]}\",\"widget-bullet-thumbnail-side\":\"before\",\"widget-bullet-display-hover\":\"0\",\"widget-bullet-display-mobileportrait\":\"1\",\"widget-bullet-display-tabletportrait\":\"1\",\"widget-bullet-display-desktopportrait\":\"1\",\"widget-bar-enabled\":\"0\",\"widgetbar\":\"horizontal\",\"widget-bar-position-area\":\"10\",\"widget-bar-position-stack\":\"1\",\"widget-bar-position-offset\":\"30\",\"widget-bar-animate\":\"0\",\"widget-bar-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|20|*|5|*|20|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"40\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bar-show-title\":\"1\",\"widget-bar-font-title\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-show-description\":\"1\",\"widget-bar-font-description\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":1,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-slide-count\":\"0\",\"widget-bar-full-width\":\"0\",\"widget-bar-separator\":\" - \",\"widget-bar-align\":\"center\",\"widget-bar-display-hover\":\"0\",\"widget-bar-display-mobileportrait\":\"1\",\"widget-bar-display-tabletportrait\":\"1\",\"widget-bar-display-desktopportrait\":\"1\",\"widget-thumbnail-enabled\":\"1\",\"widgetthumbnail\":\"default\",\"widget-thumbnail-width\":\"240\",\"widget-thumbnail-height\":\"120\",\"widget-thumbnail-tablet-width\":\"240\",\"widget-thumbnail-tablet-height\":\"120\",\"widget-thumbnail-mobile-width\":\"240\",\"widget-thumbnail-mobile-height\":\"120\",\"widget-thumbnail-position-area\":\"12\",\"widget-thumbnail-position-stack\":\"1\",\"widget-thumbnail-position-offset\":\"0\",\"widget-thumbnail-align-content\":\"start\",\"widget-thumbnail-style-bar\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000e3\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-style-slides\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"opacity\\\":\\\"20\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|00000000\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"background-size: cover;\\\\ntransition: all 0.4s;\\\\nmargin-right: 5px;\\\"},{\\\"extra\\\":\\\"\\\",\\\"border\\\":\\\"0|*|solid|*|000000cc\\\",\\\"backgroundcolor\\\":\\\"e79d1900\\\",\\\"opacity\\\":\\\"100\\\"}]}\",\"widget-thumbnail-title-style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"3|*|10|*|3|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"bottom: 0;\\\\nleft: 0;\\\"}]}\",\"widget-thumbnail-title\":\"0\",\"widget-thumbnail-title-font\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-description\":\"0\",\"widget-thumbnail-description-font\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-caption-placement\":\"overlay\",\"widget-thumbnail-caption-size\":\"100\",\"widget-thumbnail-display-hover\":\"0\",\"widget-thumbnail-display-mobileportrait\":\"1\",\"widget-thumbnail-display-tabletportrait\":\"1\",\"widget-thumbnail-display-desktopportrait\":\"1\",\"widget-shadow-enabled\":\"0\",\"widgetshadow\":\"shadow\",\"widget-shadow-shadow\":\"dark.png\",\"widget-shadow-display-mobileportrait\":\"1\",\"widget-shadow-display-tabletportrait\":\"1\",\"widget-shadow-display-desktopportrait\":\"1\",\"animation\":\"horizontal\",\"animation-duration\":\"800\",\"background-animation\":\"1014||1402\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"normal\",\"autoplay\":\"1\",\"autoplayDuration\":\"8000\",\"autoplayStopClick\":\"1\",\"autoplayStopMouse\":\"0\",\"autoplayStopMedia\":\"1\",\"autoplayResumeClick\":\"0\",\"autoplayResumeMouse\":\"0\",\"autoplayResumeMedia\":\"1\",\"widget-autoplay-enabled\":\"1\",\"widgetautoplay\":\"image\",\"widget-autoplay-play\":\"small-light.svg\",\"widget-autoplay-play-color\":\"ffffffcc\",\"widget-autoplay-style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"2|*|solid|*|00000080\\\",\\\"borderradius\\\":\\\"99\\\",\\\"extra\\\":\\\"\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-autoplay-desktop-image-width\":\"16\",\"widget-autoplay-tablet-image-width\":\"16\",\"widget-autoplay-mobile-image-width\":\"8\",\"widget-autoplay-position-area\":\"4\",\"widget-autoplay-position-stack\":\"2\",\"widget-autoplay-position-offset\":\"18\",\"widget-autoplay-display-hover\":\"0\",\"widget-autoplay-display-mobileportrait\":\"1\",\"widget-autoplay-display-tabletportrait\":\"1\",\"widget-autoplay-display-desktopportrait\":\"1\",\"loading-type\":\"\",\"delay\":\"0\",\"playWhenVisible\":\"1\",\"playWhenVisibleAt\":\"50\",\"optimize-scale\":\"1\",\"optimize-quality\":\"70\",\"optimize-slide-width-normal\":\"1920\",\"optimize-thumbnail-scale\":\"1\",\"optimize-thumbnail-quality\":\"70\",\"optimizeThumbnailWidth\":\"240\",\"optimizeThumbnailHeight\":\"120\",\"backgroundMode\":\"fill\",\"backgroundBlurFit\":\"7\",\"controlsBlockCarouselInteraction\":\"1\",\"clear-both\":\"1\",\"clear-both-after\":\"1\",\"overflow-hidden-page\":\"0\",\"responsiveFocusUser\":\"1\",\"responsiveFocusEdge\":\"auto\",\"is-delayed\":\"0\",\"legacy-font-scale\":\"0\",\"classes\":\"\",\"custom-css-codes\":\"\",\"loading-time\":\"2000\",\"related-posts\":\"\",\"version\":\"3.5.1.28\"}", "trash", "2025-07-19 19:54:47", "", "2");
INSERT INTO `wp_nextend2_smartslider3_sliders` VALUES("3", NULL, "Mon projet", "block", "{\"width\":1200,\"height\":600,\"responsiveLimitSlideWidth\":1,\"responsive-mode\":\"fullwidth\",\"version\":\"3.5.1.28\"}", "trash", "2025-07-19 19:57:06", "", "1");
INSERT INTO `wp_nextend2_smartslider3_sliders` VALUES("4", NULL, "Free Full-width", "simple", "{\"widget-thumbnail-position-mode\":\"simple\",\"widget-thumbnail-position-area\":\"12\",\"widget-thumbnail-action\":\"click\",\"widget-thumbnail-style-bar\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"242424ff\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-style-slides\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|ffffff00\\\",\\\"borderradius\\\":\\\"0\\\",\\\"opacity\\\":\\\"40\\\",\\\"extra\\\":\\\"margin: 3px;\\\\ntransition: all 0.4s;\\\\nbackground-size: cover;\\\"},{\\\"border\\\":\\\"0|*|solid|*|ffffffcc\\\",\\\"opacity\\\":\\\"100\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-arrow\":\"1\",\"widget-thumbnail-arrow-image\":\"\",\"widget-thumbnail-arrow-width\":\"26\",\"widget-thumbnail-arrow-offset\":\"0\",\"widget-thumbnail-arrow-prev-alt\":\"previous arrow\",\"widget-thumbnail-arrow-next-alt\":\"next arrow\",\"widget-thumbnail-title-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"3|*|10|*|3|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"bottom: 0;\\\\nleft: 0;\\\"}]}\",\"widget-thumbnail-title\":\"0\",\"widget-thumbnail-title-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-description\":\"0\",\"widget-thumbnail-description-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-caption-placement\":\"overlay\",\"widget-thumbnail-caption-size\":\"100\",\"widget-thumbnail-group\":\"1\",\"widget-thumbnail-orientation\":\"auto\",\"widget-thumbnail-size\":\"100%\",\"widget-thumbnail-show-image\":\"1\",\"widget-thumbnail-width\":\"100\",\"widget-thumbnail-height\":\"60\",\"widget-thumbnail-align-content\":\"start\",\"widget-shadow-position-mode\":\"simple\",\"widget-shadow-position-area\":12,\"widget-shadow-position-stack\":3,\"widget-shadow-shadow-image\":\"\",\"widget-shadow-shadow\":\"dark.png\",\"widget-bullet-position-mode\":\"simple\",\"widget-bullet-position-area\":\"10\",\"widget-bullet-position-offset\":\"5\",\"widget-bullet-action\":\"click\",\"widget-bullet-style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff80\\\",\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"50\\\",\\\"extra\\\":\\\"margin: 4px;\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\"}]}\",\"widget-bullet-bar\":\"\",\"widget-bullet-align\":\"center\",\"widget-bullet-orientation\":\"auto\",\"widget-bullet-bar-full-size\":\"0\",\"widget-bullet-thumbnail-show-image\":\"1\",\"widget-bullet-thumbnail-width\":\"120\",\"widget-bullet-thumbnail-style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"margin: 5px;\\\"}]}\",\"widget-bullet-thumbnail-side\":\"before\",\"widget-bar-position-mode\":\"simple\",\"widget-bar-position-area\":\"10\",\"widget-bar-position-offset\":\"30\",\"widget-bar-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|20|*|5|*|20|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"40\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bar-show-title\":\"1\",\"widget-bar-font-title\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-show-description\":\"1\",\"widget-bar-font-description\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":1,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-slide-count\":\"0\",\"widget-bar-width\":\"100%\",\"widget-bar-full-width\":\"0\",\"widget-bar-separator\":\" - \",\"widget-bar-align\":\"center\",\"widget-bar-animate\":\"0\",\"widget-autoplay-desktop-image-width\":\"16\",\"widget-autoplay-tablet-image-width\":\"16\",\"widget-autoplay-mobile-image-width\":\"8\",\"widget-autoplay-play-image\":\"\",\"widget-autoplay-play-color\":\"ffffffcc\",\"widget-autoplay-play\":\"small-light.svg\",\"widget-autoplay-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-autoplay-position-mode\":\"simple\",\"widget-autoplay-position-area\":\"4\",\"widget-autoplay-position-offset\":\"15\",\"widget-autoplay-mirror\":\"1\",\"widget-autoplay-pause-image\":\"\",\"widget-autoplay-pause-color\":\"ffffffcc\",\"widget-autoplay-pause\":\"small-light.svg\",\"widget-arrow-desktop-image-width\":\"32\",\"widget-arrow-tablet-image-width\":\"32\",\"widget-arrow-mobile-image-width\":\"16\",\"widget-arrow-previous-image\":\"\",\"widget-arrow-previous\":\"thin-horizontal.svg\",\"widget-arrow-previous-color\":\"ffffffcc\",\"widget-arrow-previous-hover\":\"0\",\"widget-arrow-previous-hover-color\":\"ffffffcc\",\"widget-arrow-style\":\"\",\"widget-arrow-previous-position-mode\":\"simple\",\"widget-arrow-previous-position-area\":\"6\",\"widget-arrow-previous-position-offset\":\"5\",\"widget-arrow-next-position-mode\":\"simple\",\"widget-arrow-next-position-area\":\"7\",\"widget-arrow-next-position-offset\":\"5\",\"widget-arrow-animation\":\"fade\",\"widget-arrow-mirror\":\"1\",\"widget-arrow-next-image\":\"\",\"widget-arrow-next\":\"thin-horizontal.svg\",\"widget-arrow-next-color\":\"ffffffcc\",\"widget-arrow-next-hover\":\"0\",\"widget-arrow-next-hover-color\":\"ffffffcc\",\"widget-arrow-previous-alt\":\"previous arrow\",\"widget-arrow-next-alt\":\"next arrow\",\"widget-arrow-base64\":\"1\",\"widget-html-position-mode\":\"simple\",\"widget-html-position-area\":\"2\",\"widget-html-code\":\"\",\"widget-indicator-position-mode\":\"simple\",\"widget-indicator-position-area\":\"4\",\"widget-indicator-position-offset\":\"15\",\"widget-indicator-size\":\"25\",\"widget-indicator-thickness\":\"30\",\"widget-indicator-track\":\"000000ab\",\"widget-indicator-bar\":\"ffffffff\",\"widget-fullscreen-desktop-image-width\":\"16\",\"widget-fullscreen-tablet-image-width\":\"16\",\"widget-fullscreen-mobile-image-width\":\"8\",\"widget-fullscreen-tonormal-image\":\"\",\"widget-fullscreen-tonormal-color\":\"ffffffcc\",\"widget-fullscreen-tonormal\":\"full1.svg\",\"widget-fullscreen-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-fullscreen-position-mode\":\"simple\",\"widget-fullscreen-position-area\":\"4\",\"widget-fullscreen-position-offset\":\"15\",\"widget-fullscreen-mirror\":\"1\",\"widget-fullscreen-tofull-image\":\"\",\"widget-fullscreen-tofull-color\":\"ffffffcc\",\"widget-fullscreen-tofull\":\"full1.svg\",\"aria-label\":\"Slider\",\"alias-id\":\"\",\"alias-smoothscroll\":\"\",\"alias-slideswitch\":\"\",\"alias-slideswitch-scroll\":\"1\",\"background\":\"\",\"background-fixed\":\"0\",\"background-size\":\"cover\",\"background-color\":\"FFFFFF00\",\"backgroundVideoMp4\":\"\",\"backgroundVideoMuted\":\"1\",\"backgroundVideoLoop\":\"1\",\"backgroundVideoMode\":\"fill\",\"align\":\"normal\",\"margin\":\"0|*|0|*|0|*|0\",\"padding\":\"0|*|0|*|0|*|0\",\"perspective\":\"1000\",\"border-width\":\"0\",\"border-color\":\"3E3E3Eff\",\"border-radius\":\"0\",\"slider-preset\":\"\",\"slider-css\":\"\",\"width\":\"1200\",\"height\":\"600\",\"mobileportrait\":\"1\",\"mobilelandscape\":\"1\",\"tabletportrait\":\"1\",\"tabletlandscape\":\"1\",\"desktopportrait\":\"1\",\"desktoplandscape\":\"1\",\"responsiveLimitSlideWidth\":\"1\",\"responsiveSlideWidthDesktopLandscape\":\"0\",\"responsiveSlideWidthMaxDesktopLandscape\":\"1200\",\"responsiveSlideWidth\":\"0\",\"responsiveSlideWidthMax\":\"1200\",\"responsiveSlideWidthTabletLandscape\":\"0\",\"responsiveSlideWidthMaxTabletLandscape\":\"1200\",\"responsiveSlideWidthTablet\":\"0\",\"responsiveSlideWidthMaxTablet\":\"980\",\"responsiveSlideWidthMobileLandscape\":\"0\",\"responsiveSlideWidthMaxMobileLandscape\":\"740\",\"responsiveSlideWidthMobile\":\"0\",\"responsiveSlideWidthMaxMobile\":\"480\",\"responsive-breakpoint-desktop-portrait\":\"1440\",\"responsive-breakpoint-desktop-portrait-landscape\":\"1440\",\"responsive-breakpoint-tablet-landscape\":\"1300\",\"responsive-breakpoint-tablet-landscape-landscape\":\"1300\",\"responsive-breakpoint-tablet-portrait\":\"1199\",\"responsive-breakpoint-tablet-portrait-landscape\":\"1199\",\"responsive-breakpoint-mobile-landscape\":\"900\",\"responsive-breakpoint-mobile-landscape-landscape\":\"1050\",\"responsive-breakpoint-mobile-portrait\":\"700\",\"responsive-breakpoint-mobile-portrait-landscape\":\"900\",\"responsive-breakpoint-desktop-landscape-enabled\":\"0\",\"responsive-breakpoint-tablet-landscape-enabled\":\"0\",\"responsive-breakpoint-tablet-portrait-enabled\":\"1\",\"responsive-breakpoint-mobile-landscape-enabled\":\"0\",\"responsive-breakpoint-mobile-portrait-enabled\":\"1\",\"responsive-breakpoint-global\":\"0\",\"breakpoints-orientation\":\"portrait\",\"responsive-mode\":\"fullwidth\",\"responsiveSliderHeightMin\":\"0\",\"responsiveForceFull\":\"0\",\"responsiveForceFullOverflowX\":\"body\",\"responsiveForceFullHorizontalSelector\":\"body\",\"slider-size-override\":\"0\",\"slider-size-override-mobile-portrait\":\"0\",\"mobile-portrait-width\":\"440\",\"mobile-portrait-height\":\"0\",\"slider-size-override-mobile-landscape\":\"0\",\"mobile-landscape-width\":\"740\",\"mobile-landscape-height\":\"0\",\"slider-size-override-tablet-portrait\":\"0\",\"tablet-portrait-width\":\"800\",\"tablet-portrait-height\":\"0\",\"slider-size-override-tablet-landscape\":\"0\",\"tablet-landscape-width\":\"1024\",\"tablet-landscape-height\":\"0\",\"slider-size-override-desktop-landscape\":\"0\",\"desktop-landscape-width\":\"1440\",\"desktop-landscape-height\":\"0\",\"controlsTouch\":\"horizontal\",\"controlsScroll\":\"0\",\"controlsKeyboard\":\"1\",\"widget-arrow-enabled\":\"1\",\"widgetarrow\":\"imageEmpty\",\"widget-arrow-previous-position-stack\":\"1\",\"widget-arrow-previous-position-horizontal\":\"left\",\"widget-arrow-previous-position-horizontal-position\":\"0\",\"widget-arrow-previous-position-horizontal-unit\":\"px\",\"widget-arrow-previous-position-vertical\":\"top\",\"widget-arrow-previous-position-vertical-position\":\"0\",\"widget-arrow-previous-position-vertical-unit\":\"px\",\"widget-arrow-next-position-stack\":\"1\",\"widget-arrow-next-position-horizontal\":\"left\",\"widget-arrow-next-position-horizontal-position\":\"0\",\"widget-arrow-next-position-horizontal-unit\":\"px\",\"widget-arrow-next-position-vertical\":\"top\",\"widget-arrow-next-position-vertical-position\":\"0\",\"widget-arrow-next-position-vertical-unit\":\"px\",\"widget-arrow-display-hover\":\"0\",\"widget-arrow-display-mobileportrait\":\"0\",\"widget-arrow-display-mobilelandscape\":\"1\",\"widget-arrow-display-tabletportrait\":\"1\",\"widget-arrow-display-tabletlandscape\":\"1\",\"widget-arrow-display-desktopportrait\":\"1\",\"widget-arrow-display-desktoplandscape\":\"1\",\"widget-arrow-exclude-slides\":\"\",\"widget-bullet-enabled\":\"1\",\"widgetbullet\":\"transition\",\"widget-bullet-position-stack\":\"1\",\"widget-bullet-position-horizontal\":\"left\",\"widget-bullet-position-horizontal-position\":\"0\",\"widget-bullet-position-horizontal-unit\":\"px\",\"widget-bullet-position-vertical\":\"top\",\"widget-bullet-position-vertical-position\":\"0\",\"widget-bullet-position-vertical-unit\":\"px\",\"widget-bullet-thumbnail-height\":\"81\",\"widget-bullet-display-hover\":\"0\",\"widget-bullet-display-mobileportrait\":\"1\",\"widget-bullet-display-mobilelandscape\":\"1\",\"widget-bullet-display-tabletportrait\":\"1\",\"widget-bullet-display-tabletlandscape\":\"1\",\"widget-bullet-display-desktopportrait\":\"1\",\"widget-bullet-display-desktoplandscape\":\"1\",\"widget-bullet-exclude-slides\":\"\",\"widget-bar-enabled\":\"0\",\"widgetbar\":\"horizontal\",\"widget-bar-position-stack\":\"1\",\"widget-bar-position-horizontal\":\"left\",\"widget-bar-position-horizontal-position\":\"0\",\"widget-bar-position-horizontal-unit\":\"px\",\"widget-bar-position-vertical\":\"top\",\"widget-bar-position-vertical-position\":\"0\",\"widget-bar-position-vertical-unit\":\"px\",\"widget-bar-display-hover\":\"0\",\"widget-bar-display-mobileportrait\":\"1\",\"widget-bar-display-mobilelandscape\":\"1\",\"widget-bar-display-tabletportrait\":\"1\",\"widget-bar-display-tabletlandscape\":\"1\",\"widget-bar-display-desktopportrait\":\"1\",\"widget-bar-display-desktoplandscape\":\"1\",\"widget-bar-exclude-slides\":\"\",\"widget-thumbnail-enabled\":\"0\",\"widgetthumbnail\":\"default\",\"widget-thumbnail-tablet-width\":\"100\",\"widget-thumbnail-tablet-height\":\"60\",\"widget-thumbnail-mobile-width\":\"100\",\"widget-thumbnail-mobile-height\":\"60\",\"widget-thumbnail-position-stack\":\"1\",\"widget-thumbnail-position-offset\":\"0\",\"widget-thumbnail-position-horizontal\":\"left\",\"widget-thumbnail-position-horizontal-position\":\"0\",\"widget-thumbnail-position-horizontal-unit\":\"px\",\"widget-thumbnail-position-vertical\":\"top\",\"widget-thumbnail-position-vertical-position\":\"0\",\"widget-thumbnail-position-vertical-unit\":\"px\",\"widget-thumbnail-display-hover\":\"0\",\"widget-thumbnail-display-mobileportrait\":\"1\",\"widget-thumbnail-display-mobilelandscape\":\"1\",\"widget-thumbnail-display-tabletportrait\":\"1\",\"widget-thumbnail-display-tabletlandscape\":\"1\",\"widget-thumbnail-display-desktopportrait\":\"1\",\"widget-thumbnail-display-desktoplandscape\":\"1\",\"widget-thumbnail-exclude-slides\":\"\",\"widget-shadow-enabled\":\"0\",\"widgetshadow\":\"shadow\",\"widget-shadow-display-mobileportrait\":\"1\",\"widget-shadow-display-mobilelandscape\":\"1\",\"widget-shadow-display-tabletportrait\":\"1\",\"widget-shadow-display-tabletlandscape\":\"1\",\"widget-shadow-display-desktopportrait\":\"1\",\"widget-shadow-display-desktoplandscape\":\"1\",\"widget-shadow-exclude-slides\":\"\",\"widget-fullscreen-enabled\":\"0\",\"widgetfullscreen\":\"image\",\"widget-fullscreen-position-stack\":\"1\",\"widget-fullscreen-position-horizontal\":\"left\",\"widget-fullscreen-position-horizontal-position\":\"0\",\"widget-fullscreen-position-horizontal-unit\":\"px\",\"widget-fullscreen-position-vertical\":\"top\",\"widget-fullscreen-position-vertical-position\":\"0\",\"widget-fullscreen-position-vertical-unit\":\"px\",\"widget-fullscreen-display-hover\":\"0\",\"widget-fullscreen-display-mobileportrait\":\"1\",\"widget-fullscreen-display-mobilelandscape\":\"1\",\"widget-fullscreen-display-tabletportrait\":\"1\",\"widget-fullscreen-display-tabletlandscape\":\"1\",\"widget-fullscreen-display-desktopportrait\":\"1\",\"widget-fullscreen-display-desktoplandscape\":\"1\",\"widget-fullscreen-exclude-slides\":\"\",\"widget-html-enabled\":\"0\",\"widgethtml\":\"html\",\"widget-html-position-stack\":\"1\",\"widget-html-position-offset\":\"0\",\"widget-html-position-horizontal\":\"left\",\"widget-html-position-horizontal-position\":\"0\",\"widget-html-position-horizontal-unit\":\"px\",\"widget-html-position-vertical\":\"top\",\"widget-html-position-vertical-position\":\"0\",\"widget-html-position-vertical-unit\":\"px\",\"widget-html-display-hover\":\"0\",\"widget-html-display-mobileportrait\":\"1\",\"widget-html-display-mobilelandscape\":\"1\",\"widget-html-display-tabletportrait\":\"1\",\"widget-html-display-tabletlandscape\":\"1\",\"widget-html-display-desktopportrait\":\"1\",\"widget-html-display-desktoplandscape\":\"1\",\"widget-html-exclude-slides\":\"\",\"animation\":\"horizontal\",\"animation-duration\":\"800\",\"animation-delay\":\"0\",\"animation-easing\":\"easeOutQuad\",\"carousel\":\"1\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"normal\",\"animation-shifted-background-animation\":\"auto\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"shape-divider\":\"\",\"particle\":\"\",\"playfirstlayer\":\"1\",\"playonce\":\"0\",\"layer-animation-play-in\":\"end\",\"layer-animation-play-mode\":\"skippable\",\"parallax-enabled\":\"1\",\"parallax-enabled-mobile\":\"0\",\"parallax-3d\":\"0\",\"parallax-animate\":\"1\",\"parallax-horizontal\":\"mouse\",\"parallax-vertical\":\"mouse\",\"parallax-mouse-origin\":\"slider\",\"parallax-scroll-move\":\"both\",\"autoplay\":\"0\",\"autoplayDuration\":\"8000\",\"autoplayStart\":\"1\",\"autoplayAllowReStart\":\"0\",\"autoplayLoop\":\"1\",\"autoplayfinish\":\"1|*|loop|*|current\",\"loop-single-slide\":\"0\",\"autoplayStopClick\":\"1\",\"autoplayStopMouse\":\"0\",\"autoplayStopMedia\":\"1\",\"autoplayResumeClick\":\"0\",\"autoplayResumeMouse\":\"0\",\"autoplayResumeMedia\":\"1\",\"widget-autoplay-enabled\":\"0\",\"widgetautoplay\":\"image\",\"widget-autoplay-position-stack\":\"1\",\"widget-autoplay-position-horizontal\":\"left\",\"widget-autoplay-position-horizontal-position\":\"0\",\"widget-autoplay-position-horizontal-unit\":\"px\",\"widget-autoplay-position-vertical\":\"top\",\"widget-autoplay-position-vertical-position\":\"0\",\"widget-autoplay-position-vertical-unit\":\"px\",\"widget-autoplay-display-hover\":\"0\",\"widget-autoplay-display-mobileportrait\":\"1\",\"widget-autoplay-display-mobilelandscape\":\"1\",\"widget-autoplay-display-tabletportrait\":\"1\",\"widget-autoplay-display-tabletlandscape\":\"1\",\"widget-autoplay-display-desktopportrait\":\"1\",\"widget-autoplay-display-desktoplandscape\":\"1\",\"widget-autoplay-exclude-slides\":\"\",\"widget-indicator-enabled\":\"0\",\"widgetindicator\":\"pie\",\"widget-indicator-position-stack\":\"1\",\"widget-indicator-position-horizontal\":\"left\",\"widget-indicator-position-horizontal-position\":\"0\",\"widget-indicator-position-horizontal-unit\":\"px\",\"widget-indicator-position-vertical\":\"top\",\"widget-indicator-position-vertical-position\":\"0\",\"widget-indicator-position-vertical-unit\":\"px\",\"widget-indicator-style\":\"\",\"widget-indicator-display-hover\":\"0\",\"widget-indicator-display-mobileportrait\":\"1\",\"widget-indicator-display-mobilelandscape\":\"1\",\"widget-indicator-display-tabletportrait\":\"1\",\"widget-indicator-display-tabletlandscape\":\"1\",\"widget-indicator-display-desktopportrait\":\"1\",\"widget-indicator-display-desktoplandscape\":\"1\",\"widget-indicator-exclude-slides\":\"\",\"loading-type\":\"\",\"delay\":\"0\",\"playWhenVisible\":\"1\",\"playWhenVisibleAt\":\"50\",\"imageload\":\"0\",\"imageloadNeighborSlides\":\"0\",\"optimize-webp\":\"1\",\"optimize-quality\":\"70\",\"optimize-scale\":\"1\",\"optimize-slide-width-normal\":\"1920\",\"optimize-slide-width-tablet\":\"1200\",\"optimize-slide-height-tablet\":\"0\",\"optimize-slide-width-mobile\":\"500\",\"optimize-slide-height-mobile\":\"400\",\"optimize-slide-width-retina\":\"0\",\"optimize-thumbnail-scale\":\"1\",\"optimize-thumbnail-quality\":\"70\",\"optimizeThumbnailWidth\":\"100\",\"optimizeThumbnailHeight\":\"60\",\"layer-image-webp\":\"1\",\"layer-image-optimize-quality\":\"70\",\"layer-image-optimize\":\"1\",\"layer-image-width-normal\":\"1400\",\"layer-image-width-tablet\":\"800\",\"layer-image-width-mobile\":\"425\",\"layer-image-width-retina\":\"0\",\"layer-image-base64\":\"0\",\"layer-image-base64-size\":\"5\",\"optimize-slider-webp\":\"0\",\"optimize-slider-quality\":\"70\",\"optimize-slider-scale\":\"0\",\"optimize-slider-width-normal\":\"1920\",\"optimize-slider-width-tablet\":\"1200\",\"optimize-slider-height-tablet\":\"0\",\"optimize-slider-width-mobile\":\"500\",\"optimize-slider-height-mobile\":\"0\",\"slides-background-video-mobile\":\"1\",\"backgroundMode\":\"fill\",\"slide-css\":\"\",\"randomize\":\"0\",\"randomizeFirst\":\"0\",\"randomize-cache\":\"1\",\"variations\":\"5\",\"reverse-slides\":\"0\",\"maximumslidecount\":\"20\",\"maintain-session\":\"0\",\"global-lightbox\":\"0\",\"global-lightbox-label\":\"0\",\"slide-background-parallax\":\"0\",\"slide-background-parallax-strength\":\"50\",\"bg-parallax-tablet\":\"1\",\"bg-parallax-mobile\":\"1\",\"blockrightclick\":\"0\",\"controlsBlockCarouselInteraction\":\"1\",\"clear-both\":\"1\",\"clear-both-after\":\"1\",\"overflow-hidden-page\":\"0\",\"responsiveFocusUser\":\"1\",\"responsiveFocusEdge\":\"auto\",\"is-delayed\":\"0\",\"legacy-font-scale\":\"0\",\"classes\":\"\",\"custom-css-codes\":\"\",\"callbacks\":\"\",\"related-posts\":\"\"}", "published", "2025-07-19 19:58:29", "$upload$/slider4/freefullwidththumb-1.png", "0");

/* INSERT TABLE DATA: wp_nextend2_smartslider3_sliders_xref */
INSERT INTO `wp_nextend2_smartslider3_sliders_xref` VALUES("0", "2", "0");
INSERT INTO `wp_nextend2_smartslider3_sliders_xref` VALUES("0", "3", "1");
INSERT INTO `wp_nextend2_smartslider3_sliders_xref` VALUES("0", "4", "2");

/* INSERT TABLE DATA: wp_nextend2_smartslider3_slides */
INSERT INTO `wp_nextend2_smartslider3_slides` VALUES("1", "Slide Background", "1", "1970-01-01 00:00:00", "1970-01-01 00:00:00", "1", "0", "[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":1120,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-IbNOabpfT5aE\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"tabletportraitgutter\":20,\"mobileportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"mobileportraitgutter\":20,\"mobileportraitwrapafter\":1,\"mobileportraitmaxwidth\":400,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-dtwtw9DVCwgQ\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Row\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitorder\":0,\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitinneralign\":\"left\",\"mobileportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitorder\":2,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-Fjvyu081qJeK\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"2/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":60,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Jeans Store Interior\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"36||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"01. Slide Background\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Lorem ipsum dolor sit amet, consect\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"24||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"weight\\\":300,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Every slide includes a background, which can be a picture or solid color.\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 1\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"To change the background click on the label bar and in the layer window select the style tab.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 2\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"Choose a source from the background top tab then upload an image or pick a background color.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Read More\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"0568f6ff\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"0568f6ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"1|*|2|*|1|*|2|*|em\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"5\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\"}]}\",\"content\":\"Next Slide\",\"nowrap\":\"1\",\"fullwidth\":\"0\",\"href\":\"NextSlide[]\",\"href-target\":\"_self\",\"href-rel\":\"\",\"class\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"mobileportraitinneralign\":\"center\",\"mobileportraitorder\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-LnImbm1HgUAv\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"3/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitmaxwidth\":300,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"https://smartslider3.com/wp-content/uploads/slider424/background.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|auto\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]}]}]}]", "", "https://smartslider3.com/wp-content/uploads/slider424/slidebackground.jpg", "{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|60|*|10|*|60\",\"tabletportraitpadding\":\"10|*|50|*|10|*|50\",\"mobileportraitpadding\":\"10|*|10|*|35|*|10\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"https://smartslider3.com/wp-content/uploads/slider424/slide1.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.4.0\"}", "1", "0");
INSERT INTO `wp_nextend2_smartslider3_slides` VALUES("2", "Build & Design", "1", "1970-01-01 00:00:00", "1970-01-01 00:00:00", "1", "0", "[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":1120,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-TPnUuKlAWVoC\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"tabletportraitgutter\":20,\"mobileportraitinneralign\":\"inherit\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"mobileportraitgutter\":20,\"mobileportraitwrapafter\":1,\"mobileportraitmaxwidth\":400,\"mobileportraitselfalign\":\"inherit\",\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-NmnNQvKK01kO\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Row\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitorder\":0,\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitmaxwidth\":0,\"mobileportraitinneralign\":\"left\",\"mobileportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitorder\":2,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-R5Jkk06Nmzr4\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"2/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":60,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Jeans Store Interior\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"36||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"02. Build & Design\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Lorem ipsum dolor sit amet, consect\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"24||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"weight\\\":300,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Build any layout with layers and customize your designs limitlessly.\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 1\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"To add a layer, click the green plus button in the left sidebar and select the type of layer.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 2\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"Select any layer and you can edit its content and style properties in the layer window.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Read More\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"0568f6ff\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"0568f6ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"1|*|2|*|1|*|2|*|em\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"5\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\"}]}\",\"content\":\"Next Slide\",\"nowrap\":\"1\",\"fullwidth\":\"0\",\"href\":\"NextSlide[]\",\"href-target\":\"_self\",\"href-rel\":\"\",\"class\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"mobileportraitinneralign\":\"center\",\"mobileportraitorder\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-iYi6ZKk8yeVp\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"3/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitmaxwidth\":300,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"https://smartslider3.com/wp-content/uploads/slider424/buildanddesign.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|auto\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]}]}]}]", "", "https://smartslider3.com/wp-content/uploads/slider424/buildanddesign.jpg", "{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|60|*|10|*|60\",\"tabletportraitpadding\":\"10|*|50|*|10|*|50\",\"mobileportraitpadding\":\"10|*|10|*|35|*|10\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"https://smartslider3.com/wp-content/uploads/slider424/slide2.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.4.0\"}", "2", "0");
INSERT INTO `wp_nextend2_smartslider3_slides` VALUES("3", "image-slider-with-thumbnail1.jpeg", "2", "1970-01-01 00:00:00", "1970-01-01 00:00:00", "1", "1", "[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"center\",\"mobileportraitpadding\":\"0|*|10|*|0|*|10|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1530ede93d30e\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"adaptivefont\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[]}]", "", "$upload$/slider2/image-slider-with-thumbnail1.jpeg", "{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"adaptivefont\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/slider2/image-slider-with-thumbnail1.jpeg\",\"backgroundFocusX\":27,\"backgroundFocusY\":71,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoMuted\":1,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.0.4\"}", "0", "0");
INSERT INTO `wp_nextend2_smartslider3_slides` VALUES("4", "image-slider-with-thumbnail2.jpeg", "2", "1970-01-01 00:00:00", "1970-01-01 00:00:00", "1", "0", "[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"center\",\"mobileportraitpadding\":\"0|*|10|*|0|*|10|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-175ed58b562d0\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"adaptivefont\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[]}]", "", "$upload$/slider2/image-slider-with-thumbnail2.jpeg", "{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"adaptivefont\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/slider2/image-slider-with-thumbnail2.jpeg\",\"backgroundFocusX\":38,\"backgroundFocusY\":75,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoMuted\":1,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.0.4\"}", "1", "0");
INSERT INTO `wp_nextend2_smartslider3_slides` VALUES("5", "image-slider-with-thumbnail3.jpeg", "2", "1970-01-01 00:00:00", "1970-01-01 00:00:00", "1", "0", "[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"center\",\"mobileportraitpadding\":\"0|*|10|*|0|*|10|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1e8f6672cbc62\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"adaptivefont\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[]}]", "", "$upload$/slider2/image-slider-with-thumbnail3.jpeg", "{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"adaptivefont\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/slider2/image-slider-with-thumbnail3.jpeg\",\"backgroundFocusX\":67,\"backgroundFocusY\":81,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoMuted\":1,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.0.4\"}", "2", "0");
INSERT INTO `wp_nextend2_smartslider3_slides` VALUES("6", "image-slider-with-thumbnail4.jpeg", "2", "1970-01-01 00:00:00", "1970-01-01 00:00:00", "1", "0", "[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"center\",\"mobileportraitpadding\":\"0|*|10|*|0|*|10|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-160f32656f8ed\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"adaptivefont\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[]}]", "", "$upload$/slider2/image-slider-with-thumbnail4.jpeg", "{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"adaptivefont\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/slider2/image-slider-with-thumbnail4.jpeg\",\"backgroundFocusX\":50,\"backgroundFocusY\":83,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoMuted\":1,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.0.4\"}", "3", "0");
INSERT INTO `wp_nextend2_smartslider3_slides` VALUES("7", "image-slider-with-thumbnail5.jpeg", "2", "1970-01-01 00:00:00", "1970-01-01 00:00:00", "1", "0", "[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"center\",\"mobileportraitpadding\":\"0|*|10|*|0|*|10|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1dc5ba38e44e0\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"adaptivefont\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[]}]", "", "$upload$/slider2/image-slider-with-thumbnail5.jpeg", "{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"adaptivefont\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/slider2/image-slider-with-thumbnail5.jpeg\",\"backgroundFocusX\":86,\"backgroundFocusY\":71,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoMuted\":1,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.0.4\"}", "4", "0");
INSERT INTO `wp_nextend2_smartslider3_slides` VALUES("8", "image-slider-with-thumbnail6.jpeg", "2", "1970-01-01 00:00:00", "1970-01-01 00:00:00", "1", "0", "[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"center\",\"mobileportraitpadding\":\"0|*|10|*|0|*|10|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-19b2f900fc9bf\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"adaptivefont\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[]}]", "", "$upload$/slider2/image-slider-with-thumbnail6.jpeg", "{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"adaptivefont\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/slider2/image-slider-with-thumbnail6.jpeg\",\"backgroundFocusX\":83,\"backgroundFocusY\":78,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoMuted\":1,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.0.4\"}", "5", "0");
INSERT INTO `wp_nextend2_smartslider3_slides` VALUES("9", "image-slider-with-thumbnail7.jpeg", "2", "1970-01-01 00:00:00", "1970-01-01 00:00:00", "1", "0", "[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"center\",\"mobileportraitpadding\":\"0|*|10|*|0|*|10|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-11689575e7e3c\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"adaptivefont\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[]}]", "", "$upload$/slider2/image-slider-with-thumbnail7.jpeg", "{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"adaptivefont\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/slider2/image-slider-with-thumbnail7.jpeg\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoMuted\":1,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.0.4\"}", "6", "0");
INSERT INTO `wp_nextend2_smartslider3_slides` VALUES("10", "Full 1", "4", "1970-01-01 00:00:00", "1970-01-01 00:00:00", "1", "0", "[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"40|*|60|*|40|*|60|*|px\",\"desktopportraitselfalign\":\"inherit\",\"mobileportraitpadding\":\"40|*|25|*|40|*|25|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-187d8f1049b03\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"$upload$/2025/07/3d6d6b31-c6aa-4c3f-911e-bfade3a38018.jpeg\",\"bgimagex\":12,\"bgimagey\":52,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|15|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitfontsize\":90,\"mobileportraitmargin\":\"0|*|0|*|10|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"n-uc-2CmBc17E75oi\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Short story\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Montserrat,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"border-bottom: 3px solid #fff;\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"priority\":\"div\",\"fullwidth\":\"0\",\"nowrap\":\"1\",\"heading\":\"\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|300|*|0|*|-170|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":295,\"desktopportraitselfalign\":\"right\",\"tabletportraitmargin\":\"0|*|35|*|0|*|-20|*|px\",\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"0|*|20|*|0|*|-20|*|px\",\"mobileportraitmaxwidth\":175,\"id\":\"\",\"uniqueclass\":\"n-uc-tIGNamtRr8aM\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Read more\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"content\":\"JE LE VEUX !\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Montserrat,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":700,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"262626ff\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"cbf3bdff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"0.8|*|1.5|*|0.8|*|1.5|*|em\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"2|*|solid|*|01add3ff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\"}]}\",\"fullwidth\":\"0\",\"nowrap\":\"0\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|30|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":60,\"mobileportraitmargin\":\"0|*|0|*|10|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"n-uc-kYioCZs0uzPW\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"There stood a little lighthouse in \",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"48||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"weight\\\":700,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}}]}]", "", "$upload$/2025/07/2ec912fe-87bd-4c0e-9b2a-49a982a44178.jpeg", "{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailTitle\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2025/07/2ec912fe-87bd-4c0e-9b2a-49a982a44178.jpeg\",\"backgroundFocusX\":57,\"backgroundFocusY\":56,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.28\"}", "2", "0");
INSERT INTO `wp_nextend2_smartslider3_slides` VALUES("11", "Full 2", "4", "1970-01-01 00:00:00", "1970-01-01 00:00:00", "1", "0", "[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":1030,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"40|*|60|*|40|*|60|*|px\",\"desktopportraitselfalign\":\"right\",\"mobileportraitverticalalign\":\"center\",\"mobileportraitpadding\":\"40|*|25|*|40|*|25|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1f4f8ad18c1a0\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|10|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitfontsize\":90,\"id\":\"\",\"uniqueclass\":\"n-uc-7JaoibEfUkkL\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"LifeHAck\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Montserrat,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"border-bottom: 3px solid #fff;\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"priority\":\"div\",\"fullwidth\":\"0\",\"nowrap\":\"1\",\"heading\":\"\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|30|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"tabletportraitmargin\":\"0|*|0|*|30|*|0|*|px\",\"mobileportraitfontsize\":65,\"mobileportraitmargin\":\"0|*|0|*|10|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"n-uc-D03vvwqTejiS\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"The Best Office Furniture You\'ve Pr\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"48||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"\\\\\\\"Playfair Display\\\\\\\"\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"weight\\\":700,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|-265|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":250,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitfontsize\":80,\"mobileportraitmaxwidth\":215,\"id\":\"\",\"uniqueclass\":\"n-uc-9FOxQr3pAg1u\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Read more\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"content\":\"JE LE VEUX !\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Montserrat,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":700,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"262626ff\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"cbf3bdff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"0.8|*|1.5|*|0.8|*|1.5|*|em\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"2|*|solid|*|cbf3bdff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\"}]}\",\"fullwidth\":\"1\",\"nowrap\":\"1\",\"href\":\"http://localhost/nellboulanger/index.php/services/\",\"href-target\":\"_self\",\"href-rel\":\"\"}}}]}]", "", "$upload$/2025/07/4aee027a-8f57-4ff5-b044-1c48be6e8dfa.jpeg", "{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailTitle\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2025/07/4aee027a-8f57-4ff5-b044-1c48be6e8dfa.jpeg\",\"backgroundFocusX\":20,\"backgroundFocusY\":58,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.28\"}", "1", "0");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:29:{i:1763836171;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1763836321;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1763836892;a:1:{s:27:\"wpseo_indexable_index_batch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:15:\"fifteen_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1763838121;a:2:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1763838233;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1763838979;a:2:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1763838985;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1763849778;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763849779;a:2:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763849788;a:2:{s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763849879;a:1:{s:29:\"validate_woopay_compatibility\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763856000;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763860578;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763871378;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1763874137;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1763877721;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1763916988;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763916990;a:1:{s:29:\"wpseo_detect_default_seo_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763917321;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763917337;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763917338;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763917961;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763942400;a:2:{s:28:\"wpforms_email_summaries_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}s:33:\"wpforms_weekly_entries_count_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1763992800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764033245;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764349384;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764435721;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765059438;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "http://localhost/nellboulanger", "on");
INSERT INTO `wp_options` VALUES("3", "home", "http://localhost/nellboulanger", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "Demoiselle en vadrouille", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "nellboulanger07@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "0", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/index.php/%year%/%monthnum%/%day%/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:259:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:21:\"index.php/boutique/?$\";s:27:\"index.php?post_type=product\";s:51:\"index.php/boutique/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:46:\"index.php/boutique/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:38:\"index.php/boutique/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:61:\"^\\.well-known\\/apple-developer-merchantid-domain-association$\";s:57:\"index.php?apple-developer-merchantid-domain-association=1\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:27:\"index.php/mailpoet_email/?$\";s:34:\"index.php?post_type=mailpoet_email\";s:57:\"index.php/mailpoet_email/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=mailpoet_email&feed=$matches[1]\";s:52:\"index.php/mailpoet_email/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=mailpoet_email&feed=$matches[1]\";s:44:\"index.php/mailpoet_email/page/([0-9]{1,})/?$\";s:52:\"index.php?post_type=mailpoet_email&paged=$matches[1]\";s:57:\"index.php/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:45:\"index.php/category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:53:\"index.php/category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"index.php/category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:27:\"index.php/category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:54:\"index.php/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:49:\"index.php/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:30:\"index.php/tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:42:\"index.php/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:50:\"index.php/tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"index.php/tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:24:\"index.php/tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:55:\"index.php/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:50:\"index.php/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:31:\"index.php/type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:43:\"index.php/type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:25:\"index.php/type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:56:\"index.php/e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:66:\"index.php/e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:86:\"index.php/e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:81:\"index.php/e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:81:\"index.php/e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:62:\"index.php/e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"index.php/e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:49:\"index.php/e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:57:\"index.php/e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:64:\"index.php/e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:65:\"index.php/e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:54:\"index.php/e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:71:\"index.php/e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:82:\"index.php/e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"index.php/e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:71:\"index.php/e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"index.php/e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:45:\"index.php/e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"index.php/e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"index.php/e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"index.php/e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"index.php/e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"index.php/e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/igmap/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/igmap/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/igmap/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/igmap/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/igmap/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/igmap/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"index.php/igmap/(.+?)/embed/?$\";s:57:\"index.php?post_type=igmap&pagename=$matches[1]&embed=true\";s:34:\"index.php/igmap/(.+?)/trackback/?$\";s:51:\"index.php?post_type=igmap&pagename=$matches[1]&tb=1\";s:42:\"index.php/igmap/(.+?)/page/?([0-9]{1,})/?$\";s:64:\"index.php?post_type=igmap&pagename=$matches[1]&paged=$matches[2]\";s:49:\"index.php/igmap/(.+?)/comment-page-([0-9]{1,})/?$\";s:64:\"index.php?post_type=igmap&pagename=$matches[1]&cpage=$matches[2]\";s:50:\"index.php/igmap/(.+?)/wc/file/transient(/(.*))?/?$\";s:76:\"index.php?post_type=igmap&pagename=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"index.php/igmap/(.+?)/wc-api(/(.*))?/?$\";s:65:\"index.php?post_type=igmap&pagename=$matches[1]&wc-api=$matches[3]\";s:56:\"index.php/igmap/.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:67:\"index.php/igmap/.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:45:\"index.php/igmap/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"index.php/igmap/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"index.php/igmap/(.+?)(?:/([0-9]+))?/?$\";s:63:\"index.php?post_type=igmap&pagename=$matches[1]&page=$matches[2]\";s:55:\"index.php/marque/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:50:\"index.php/marque/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:31:\"index.php/marque/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:43:\"index.php/marque/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:25:\"index.php/marque/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:66:\"index.php/categorie-produit/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:61:\"index.php/categorie-produit/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:42:\"index.php/categorie-produit/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:54:\"index.php/categorie-produit/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:36:\"index.php/categorie-produit/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:68:\"index.php/etiquette-produit/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:63:\"index.php/etiquette-produit/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:44:\"index.php/etiquette-produit/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:56:\"index.php/etiquette-produit/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:38:\"index.php/etiquette-produit/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:45:\"index.php/produit/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"index.php/produit/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"index.php/produit/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"index.php/produit/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"index.php/produit/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"index.php/produit/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"index.php/produit/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:38:\"index.php/produit/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:58:\"index.php/produit/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:53:\"index.php/produit/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:46:\"index.php/produit/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:53:\"index.php/produit/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:54:\"index.php/produit/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"index.php/produit/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:60:\"index.php/produit/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:71:\"index.php/produit/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:49:\"index.php/produit/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:60:\"index.php/produit/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"index.php/produit/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:34:\"index.php/produit/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"index.php/produit/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"index.php/produit/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"index.php/produit/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"index.php/produit/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"index.php/produit/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"index.php/mailpoet_email/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:62:\"index.php/mailpoet_email/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:82:\"index.php/mailpoet_email/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/mailpoet_email/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/mailpoet_email/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"index.php/mailpoet_email/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/mailpoet_email/([^/]+)/embed/?$\";s:47:\"index.php?mailpoet_email=$matches[1]&embed=true\";s:45:\"index.php/mailpoet_email/([^/]+)/trackback/?$\";s:41:\"index.php?mailpoet_email=$matches[1]&tb=1\";s:65:\"index.php/mailpoet_email/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?mailpoet_email=$matches[1]&feed=$matches[2]\";s:60:\"index.php/mailpoet_email/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?mailpoet_email=$matches[1]&feed=$matches[2]\";s:53:\"index.php/mailpoet_email/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?mailpoet_email=$matches[1]&paged=$matches[2]\";s:60:\"index.php/mailpoet_email/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?mailpoet_email=$matches[1]&cpage=$matches[2]\";s:61:\"index.php/mailpoet_email/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?mailpoet_email=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"index.php/mailpoet_email/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?mailpoet_email=$matches[1]&wc-api=$matches[3]\";s:67:\"index.php/mailpoet_email/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:78:\"index.php/mailpoet_email/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:56:\"index.php/mailpoet_email/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:67:\"index.php/mailpoet_email/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"index.php/mailpoet_email/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?mailpoet_email=$matches[1]&page=$matches[2]\";s:41:\"index.php/mailpoet_email/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/mailpoet_email/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/mailpoet_email/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/mailpoet_email/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/mailpoet_email/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/mailpoet_email/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:42:\"index.php/feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:37:\"index.php/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:18:\"index.php/embed/?$\";s:21:\"index.php?&embed=true\";s:30:\"index.php/page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:38:\"index.php/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:27:\"index.php/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:51:\"index.php/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:46:\"index.php/comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:27:\"index.php/comments/embed/?$\";s:21:\"index.php?&embed=true\";s:47:\"index.php/comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:36:\"index.php/comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:54:\"index.php/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:49:\"index.php/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:30:\"index.php/search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:42:\"index.php/search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:50:\"index.php/search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"index.php/search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:24:\"index.php/search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:57:\"index.php/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:45:\"index.php/author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:53:\"index.php/author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"index.php/author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:27:\"index.php/author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:79:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:55:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:75:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:64:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:49:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:66:\"index.php/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:42:\"index.php/([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:54:\"index.php/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:62:\"index.php/([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:51:\"index.php/([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:36:\"index.php/([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:53:\"index.php/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:48:\"index.php/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:29:\"index.php/([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:41:\"index.php/([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:49:\"index.php/([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"index.php/([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:23:\"index.php/([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:68:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:78:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:98:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:74:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:87:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:75:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:83:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc/file/transient(/(.*))?/?$\";s:110:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc/file/transient=$matches[6]\";s:72:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:83:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:94:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:83:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:71:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:57:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:67:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:87:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:63:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:48:\"index.php/([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:37:\"index.php/.?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"index.php/.?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"index.php/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"index.php/.?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"index.php/(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:30:\"index.php/(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:50:\"index.php/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:45:\"index.php/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:38:\"index.php/(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:45:\"index.php/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:46:\"index.php/(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"index.php/(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:38:\"index.php/(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:43:\"index.php/(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:35:\"index.php/(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:39:\"index.php/(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:38:\"index.php/(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:41:\"index.php/(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:41:\"index.php/(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:44:\"index.php/(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:42:\"index.php/(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:44:\"index.php/(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:47:\"index.php/(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:50:\"index.php/(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:55:\"index.php/(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:52:\"index.php/.?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"index.php/.?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"index.php/.?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"index.php/.?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"index.php/(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:17:{i:0;s:33:\"duplicate-post/duplicate-post.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:23:\"elementor/elementor.php\";i:3;s:51:\"google-listings-and-ads/google-listings-and-ads.php\";i:4;s:41:\"image-optimization/image-optimization.php\";i:5;s:45:\"interactive-geo-maps/interactive-geo-maps.php\";i:6;s:19:\"jetpack/jetpack.php\";i:7;s:21:\"mailpoet/mailpoet.php\";i:8;s:45:\"olympus-google-fonts/olympus-google-fonts.php\";i:9;s:55:\"pinterest-for-woocommerce/pinterest-for-woocommerce.php\";i:10;s:33:\"smart-slider-3/smart-slider-3.php\";i:11;s:46:\"tiktok-for-business/tiktok-for-woocommerce.php\";i:12;s:45:\"woocommerce-payments/woocommerce-payments.php\";i:13;s:45:\"woocommerce-services/woocommerce-services.php\";i:14;s:27:\"woocommerce/woocommerce.php\";i:15;s:24:\"wordpress-seo/wp-seo.php\";i:16;s:24:\"wpforms-lite/wpforms.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "twentytwentyfour", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "twentytwentyfour", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "posts", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:3:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:45:\"woocommerce-services/woocommerce-services.php\";a:2:{i:0;s:17:\"WC_Connect_Loader\";i:1;s:16:\"plugin_uninstall\";}s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "0", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1772645180", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:9:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:120:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:10:\"copy_posts\";b:1;s:11:\"smartslider\";b:1;s:18:\"smartslider_config\";b:1;s:16:\"smartslider_edit\";b:1;s:18:\"smartslider_delete\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.7.2\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("125", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("126", "nonce_key", "9DsUY/R(*d4X94bv{9_QxIGGpMLw2tUAy-vJNax9O~s [v4.*.]6ASkZ]E&f $Jw", "off");
INSERT INTO `wp_options` VALUES("127", "nonce_salt", "jCoZWx;*o9`p=Wm7gD_G7Kik436hFHQb6IHjOZ4fy:1h|eEiC`h}BIr>>};YY.lW", "off");
INSERT INTO `wp_options` VALUES("128", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1741367617;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("129", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"90f21bb83f9e1040d158ee430d9f86ee\";s:6:\"blocks\";a:64:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:347:\":root :where(.wp-block-pullquote){border-radius: var(--wp--preset--spacing--20);font-family: var(--wp--preset--font-family--heading);font-size: var(--wp--preset--font-size--x-large);font-style: italic;font-weight: 400;letter-spacing: 0em;line-height: 1.5;padding-top: var(--wp--preset--spacing--40);padding-bottom: var(--wp--preset--spacing--40);}\";s:32:\"c48738dcb285a3f6ab83acff204fc486\";s:157:\":root :where(.wp-block-pullquote cite){font-family: var(--wp--preset--font-family--body);font-size: var(--wp--preset--font-size--medium);font-style: normal;}\";s:11:\"core/avatar\";s:56:\":root :where(.wp-block-avatar img){border-radius: 90px;}\";s:12:\"core/buttons\";s:673:\":root :where(.wp-block-buttons-is-layout-flow) > :first-child{margin-block-start: 0;}:root :where(.wp-block-buttons-is-layout-flow) > :last-child{margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-flow) > *{margin-block-start: 0.7rem;margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > :first-child{margin-block-start: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > :last-child{margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > *{margin-block-start: 0.7rem;margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-flex){gap: 0.7rem;}:root :where(.wp-block-buttons-is-layout-grid){gap: 0.7rem;}\";s:13:\"core/calendar\";s:456:\":root :where(.wp-block-calendar table, .wp-block-calendar th){color: var(--wp--preset--color--contrast);}:root :where(.wp-block-calendar.wp-block-calendar table:where(:not(.has-text-color)) th){background-color:var(--wp--preset--color--contrast-2);color:var(--wp--preset--color--base);border-color:var(--wp--preset--color--contrast-2)}:root :where(.wp-block-calendar table:where(:not(.has-text-color)) td){border-color:var(--wp--preset--color--contrast-2)}\";s:15:\"core/categories\";s:191:\":root :where(.wp-block-categories){padding-right: 0px;padding-left: 0px;}:root :where(.wp-block-categories){list-style-type:none;}:root :where(.wp-block-categories li){margin-bottom: 0.5rem;}\";s:9:\"core/code\";s:567:\":root :where(.wp-block-code){background-color: var(--wp--preset--color--base-2);border-radius: var(--wp--preset--spacing--20);border-color: var(--wp--preset--color--contrast);color: var(--wp--preset--color--contrast-2);font-size: var(--wp--preset--font-size--medium);font-style: normal;font-weight: 400;line-height: 1.6;padding-top: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-right: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-bottom: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-left: calc(var(--wp--preset--spacing--30) + 0.75rem);}\";s:24:\"core/comment-author-name\";s:170:\":root :where(.wp-block-comment-author-name){color: var(--wp--preset--color--contrast);font-size: var(--wp--preset--font-size--small);font-style: normal;font-weight: 600;}\";s:32:\"c0002c260f8238c4212f3e4c369fc4f7\";s:143:\":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast);text-decoration: none;}\";s:32:\"1e7c38b45537b325dbbbaec17a301676\";s:112:\":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:20:\"core/comment-content\";s:177:\":root :where(.wp-block-comment-content){font-size: var(--wp--preset--font-size--small);margin-top: var(--wp--preset--spacing--20);margin-bottom: var(--wp--preset--spacing--20);}\";s:17:\"core/comment-date\";s:164:\":root :where(.wp-block-comment-date){color: var(--wp--preset--color--contrast-2);font-size: var(--wp--preset--font-size--small);margin-top: 0px;margin-bottom: 0px;}\";s:32:\"c83ca7b3e52884c70f7830c54f99b318\";s:138:\":root :where(.wp-block-comment-date a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast-2);text-decoration: none;}\";s:32:\"7a05169cd0e6c7a5390492b955f8fd3d\";s:105:\":root :where(.wp-block-comment-date a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:22:\"core/comment-edit-link\";s:90:\":root :where(.wp-block-comment-edit-link){font-size: var(--wp--preset--font-size--small);}\";s:32:\"41d70710612536a90e368c12bcb0efea\";s:143:\":root :where(.wp-block-comment-edit-link a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast-2);text-decoration: none;}\";s:32:\"9c12982bf0f274860d94c3aa18230c84\";s:110:\":root :where(.wp-block-comment-edit-link a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:23:\"core/comment-reply-link\";s:91:\":root :where(.wp-block-comment-reply-link){font-size: var(--wp--preset--font-size--small);}\";s:32:\"13c96340dbf37700add1f4c5cae19f3e\";s:144:\":root :where(.wp-block-comment-reply-link a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast-2);text-decoration: none;}\";s:32:\"f8339fa97df92f99a6b4eac7a6597226\";s:111:\":root :where(.wp-block-comment-reply-link a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:23:\"core/post-comments-form\";s:109:\":root :where(.wp-block-post-comments-form textarea, .wp-block-post-comments-form input){border-radius:.33rem}\";s:24:\"core/comments-pagination\";s:92:\":root :where(.wp-block-comments-pagination){font-size: var(--wp--preset--font-size--small);}\";s:29:\"core/comments-pagination-next\";s:97:\":root :where(.wp-block-comments-pagination-next){font-size: var(--wp--preset--font-size--small);}\";s:32:\"core/comments-pagination-numbers\";s:100:\":root :where(.wp-block-comments-pagination-numbers){font-size: var(--wp--preset--font-size--small);}\";s:33:\"core/comments-pagination-previous\";s:101:\":root :where(.wp-block-comments-pagination-previous){font-size: var(--wp--preset--font-size--small);}\";s:14:\"core/footnotes\";s:82:\":root :where(.wp-block-footnotes){font-size: var(--wp--preset--font-size--small);}\";s:12:\"core/gallery\";s:79:\":root :where(.wp-block-gallery){margin-bottom: var(--wp--preset--spacing--50);}\";s:10:\"core/image\";s:0:\"\";s:9:\"core/list\";s:75:\":root :where(.wp-block-list){padding-left: var(--wp--preset--spacing--10);}\";s:13:\"core/loginout\";s:114:\":root :where(.wp-block-loginout input){border-radius:.33rem;padding:calc(0.667em + 2px);border:1px solid #949494;}\";s:15:\"core/navigation\";s:53:\":root :where(.wp-block-navigation){font-weight: 500;}\";s:32:\"25289a01850f5a0264ddb79a9a3baf3d\";s:92:\":root :where(.wp-block-navigation a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"026c04da08398d655a95047f1f235d97\";s:103:\":root :where(.wp-block-navigation a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:16:\"core/post-author\";s:84:\":root :where(.wp-block-post-author){font-size: var(--wp--preset--font-size--small);}\";s:21:\"core/post-author-name\";s:89:\":root :where(.wp-block-post-author-name){font-size: var(--wp--preset--font-size--small);}\";s:32:\"5e6daa05ce887f9195642ee978692d48\";s:98:\":root :where(.wp-block-post-author-name a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"9a762eac1c7e11f5da88ab6368f7855f\";s:109:\":root :where(.wp-block-post-author-name a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:14:\"core/post-date\";s:126:\":root :where(.wp-block-post-date){color: var(--wp--preset--color--contrast-2);font-size: var(--wp--preset--font-size--small);}\";s:32:\"ac0d4e00f5ec22d14451759983e5bd43\";s:135:\":root :where(.wp-block-post-date a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast-2);text-decoration: none;}\";s:32:\"0ae6ffd1b886044c2da62d75d05ab13d\";s:102:\":root :where(.wp-block-post-date a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:17:\"core/post-excerpt\";s:55:\":root :where(.wp-block-post-excerpt){line-height: 1.6;}\";s:24:\"core/post-featured-image\";s:228:\":root :where(.wp-block-post-featured-image img, .wp-block-post-featured-image .block-editor-media-placeholder, .wp-block-post-featured-image .wp-block-post-featured-image__overlay){border-radius: var(--wp--preset--spacing--20);}\";s:15:\"core/post-terms\";s:192:\":root :where(.wp-block-post-terms){font-size: var(--wp--preset--font-size--small);}:root :where(.wp-block-post-terms .wp-block-post-terms__prefix){color: var(--wp--preset--color--contrast-2);}\";s:32:\"b7c958776cf894ff147e343b0c9ddf57\";s:92:\":root :where(.wp-block-post-terms a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"eb904b88c81440705e2673cf9a778b66\";s:103:\":root :where(.wp-block-post-terms a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:15:\"core/post-title\";s:0:\"\";s:32:\"bb496d3fcd9be3502ce57ff8281e5687\";s:92:\":root :where(.wp-block-post-title a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"12380ab98fdc81351bb32a39bbfc9249\";s:103:\":root :where(.wp-block-post-title a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:16:\"core/query-title\";s:61:\":root :where(.wp-block-query-title span){font-style: italic;}\";s:21:\"core/query-no-results\";s:86:\":root :where(.wp-block-query-no-results){padding-top: var(--wp--preset--spacing--30);}\";s:10:\"core/quote\";s:1316:\":root :where(.wp-block-quote){background-color: var(--wp--preset--color--base-2);border-radius: var(--wp--preset--spacing--20);font-family: var(--wp--preset--font-family--heading);font-size: var(--wp--preset--font-size--large);font-style: italic;line-height: 1.3;padding-top: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-right: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-bottom: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-left: calc(var(--wp--preset--spacing--30) + 0.75rem);}:root :where(.wp-block-quote :where(p)){margin-block-start:0;margin-block-end:calc(var(--wp--preset--spacing--10) + 0.5rem);}:root :where(.wp-block-quote :where(:last-child)){margin-block-end:0;}:root :where(.wp-block-quote.has-text-align-right.is-style-plain, .rtl .is-style-plain.wp-block-quote:not(.has-text-align-center):not(.has-text-align-left)){border-width: 0 2px 0 0;padding-left:calc(var(--wp--preset--spacing--20) + 0.5rem);padding-right:calc(var(--wp--preset--spacing--20) + 0.5rem);}:root :where(.wp-block-quote.has-text-align-left.is-style-plain, body:not(.rtl) .is-style-plain.wp-block-quote:not(.has-text-align-center):not(.has-text-align-right)){border-width: 0 0 0 2px;padding-left:calc(var(--wp--preset--spacing--20) + 0.5rem);padding-right:calc(var(--wp--preset--spacing--20) + 0.5rem)}\";s:32:\"1de7a22e22013106efc5be82788cb6c0\";s:152:\":root :where(.wp-block-quote cite){font-family: var(--wp--preset--font-family--body);font-size: var(--wp--preset--font-size--small);font-style: normal;}\";s:11:\"core/search\";s:264:\":root :where(.wp-block-search .wp-block-search__label, .wp-block-search .wp-block-search__input, .wp-block-search .wp-block-search__button){font-size: var(--wp--preset--font-size--small);}:root :where(.wp-block-search .wp-block-search__input){border-radius:.33rem}\";s:32:\"14fa6a3d0cfbde171cbc0fb04aa8a6cf\";s:114:\":root :where(.wp-block-search .wp-element-button,.wp-block-search  .wp-block-button__link){border-radius: .33rem;}\";s:14:\"core/separator\";s:327:\":root :where(.wp-block-separator){border-color: currentColor;border-width: 0 0 1px 0;border-style: solid;color: var(--wp--preset--color--contrast);}:root :where(.wp-block-separator){}:root :where(.wp-block-separator:not(.is-style-wide):not(.is-style-dots):not(.alignwide):not(.alignfull)){width: var(--wp--preset--spacing--60)}\";s:17:\"core/site-tagline\";s:129:\":root :where(.wp-block-site-tagline){color: var(--wp--preset--color--contrast-2);font-size: var(--wp--preset--font-size--small);}\";s:15:\"core/site-title\";s:177:\":root :where(.wp-block-site-title){font-family: var(--wp--preset--font-family--bodoni-moda);font-size: var(--wp--preset--font-size--medium);font-style: normal;font-weight: 700;}\";s:32:\"f513d889cf971b13995cc3fffed2f39b\";s:92:\":root :where(.wp-block-site-title a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"22c37a317cc0ebd50155b5ad78564f37\";s:98:\":root :where(.wp-block-site-title a:where(:not(.wp-element-button)):hover){text-decoration: none;}\";s:25:\"core/post-navigation-link\";s:103:\":root :where(.wp-block-post-navigation-link){font-family: var(--wp--preset--font-family--bodoni-moda);}\";}}", "on");
INSERT INTO `wp_options` VALUES("130", "auth_key", "SrMXbB`]j}Q,*P9fU)-P@HRF|GEWIPH&MTi#,.!|3&^5R;(4-Zqe7E+D&]jMj43I", "off");
INSERT INTO `wp_options` VALUES("131", "auth_salt", "tT8tk(Cy.QPtx,mVn(jy:#oNz3W@wLCm@)zKEQnwMLjOP#9.<$9uBnKYZ/v1c*BA", "off");
INSERT INTO `wp_options` VALUES("132", "logged_in_key", "sPi,>EyNI(MZYvMCS{npEi?/5c9H.7$dBh?2/e`[Zo_Y;>M]UfNOX-SMKSY]N&WW", "off");
INSERT INTO `wp_options` VALUES("133", "logged_in_salt", "vz,j8E*=^xDu|<[EKF=M{q/4<7v7&,@,*BMZZM_:Y*+$0]6la8T/cC,Iutq+S)(2", "off");
INSERT INTO `wp_options` VALUES("144", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("157", "_site_transient_wp_plugin_dependencies_plugin_data", "a:1:{s:11:\"woocommerce\";a:35:{s:4:\"name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:7:\"version\";s:6:\"10.3.5\";s:6:\"author\";s:67:\"<a href=\"https://profiles.wordpress.org/automattic/\">Automattic</a>\";s:14:\"author_profile\";s:42:\"https://profiles.wordpress.org/automattic/\";s:12:\"contributors\";a:50:{s:10:\"automattic\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/automattic/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/73edc627541112a447e978843cf72f516bdbf6350e7cbac10016c71ab1b8c8a1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Automattic\";}s:11:\"woocommerce\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/woocommerce/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c7781a3c13bcc86b57064b9539ec22da52fd5ef1902fbc020d0a4a8595b14ea0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"WooCommerce\";}s:10:\"mikejolley\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/mikejolley/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/8295774fc174b6a5b9bd960709949f4de88cd0b8708d711dc5b6676693d41432?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Mike Jolley\";}s:11:\"jameskoster\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/jameskoster/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/94b5473c03a46cb204f0a868dfe65f8199ef483242814ec1bcaf6770ba90d203?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"James Koster\";}s:14:\"claudiosanches\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/claudiosanches/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ac91c7d73bb4501567ab3790755bf001d53dac8d1f4311a2480a5fb62dfb180c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Claudio Sanches\";}s:13:\"rodrigosprimo\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/rodrigosprimo/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1dc85457417601db220b14e7fa96c842700fbd1cceecd21d65306c26fffb92cc?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Rodrigo Primo\";}s:15:\"peterfabian1000\";a:3:{s:7:\"profile\";s:47:\"https://profiles.wordpress.org/peterfabian1000/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c25372df076206b9fe44dddd7ec6af6ba427d3fe2a457fa301fcb9cf90b23ddd?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Peter Fabian\";}s:7:\"vedjain\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/vedjain/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/eb19da24784b2f86d310a213b60c903b0a5464a6c725cf5fcabfd274383337c4?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Vedanshu - a11n\";}s:8:\"jamosova\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/jamosova/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/73f150b0172cbb319293e372b3b20f4b78f0d5fbe70558318f69aad70908e95a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Julia Amosova\";}s:16:\"obliviousharmony\";a:3:{s:7:\"profile\";s:48:\"https://profiles.wordpress.org/obliviousharmony/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/67851e0deeb2c6a7a4c238cf45c0e9694a919e2c5e02706c5852e67c4ad279c9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"obliviousharmony\";}s:9:\"konamiman\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/konamiman/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ee97f225bf5be24cd3c3b04990b9fc3dfc67a2c9aaea418ec2bdd32e164ed9b1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:23:\"Néstor Soriano Vilchez\";}s:8:\"sadowski\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/sadowski/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/cee318a6ec06e747df7f70f274da4e0cf4adba60c59e12d660d0f5a6ba78658a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"sadowski\";}s:8:\"wpmuguru\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/wpmuguru/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/23afb25faac780cb6ec9533b2ac9e5daedf7a1faf444b41db471b9529701f87e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Ron Rennick\";}s:5:\"royho\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/royho/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1beda14f19fa93030ba2c66359dc270286820af6c667cdfeb4e87833c747f3a0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"royho\";}s:13:\"barryhughes-1\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/barryhughes-1/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/6ce0f4afb77f8d32da9c43e9a39c84fcfb3ed0e9cac24f440c46a151946cdec8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Barry\";}s:12:\"claudiulodro\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/claudiulodro/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/34a74527d3859bd9fb0b477cd80c9f78b3610259a251c32a31023ead285ac124?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"Claudiu Lodromanean\";}s:12:\"tiagonoronha\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/tiagonoronha/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0352cd451932c8a2ab15b8457933e6d90cc919bbf23db63e3bc35ee41d56577e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Tiago Noronha\";}s:6:\"ryelle\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/ryelle/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/6d860975d8bd4b166268bba8da8c1ea0e861a7d7f4ef0aee52fa727fc69e12b2?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Kelly Choyce-Dwan\";}s:10:\"levinmedia\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/levinmedia/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/657d301b3683f02c75e4b2363681518e94485770056cc51526f19818884ba6aa?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"levinmedia\";}s:7:\"aljullu\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/aljullu/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/784f29a6d06799d1d40adc32b115da932cd1ee2b22d91cd8597e9fe6e4ee1420?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:21:\"Albert Juhé Lluveras\";}s:6:\"nerrad\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/nerrad/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1bd692736861bd20949789e4a3d922736480efcacb0e44041616c5a79eaa54c0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:22:\"Darren Ethier (nerrad)\";}s:10:\"joshuawold\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/joshuawold/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/f98224d78e12fcc0e9686dbf15f8c37b1967835212f25a92fceb6caafdc5b08d?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Joshua Wold\";}s:13:\"assassinateur\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/assassinateur/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/00ec8d736cf51890768bcfd3614fc7eea91eec753262bc37cea7c8e988d4d3a3?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Nadir Seghir\";}s:7:\"haszari\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/haszari/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/5478c55437f47714a4dae1016cf521e803dfc4633ce5781b2f24d749d1623f69?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Rua Haszard\";}s:10:\"mppfeiffer\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/mppfeiffer/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0fe64f1ef1e4abe1825653bcb17113a4a14c755f5b6f77d2f27494fe349d7081?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"Michael P. Pfeiffer\";}s:10:\"nielslange\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/nielslange/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0894ec0d7e5d70306a16431b36249b1928cad88a572de9b5211a54d75ad5d77a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Niels Lange\";}s:9:\"ralucastn\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/ralucastn/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/e65d79886499f47ee368495f5016117deef427d5abca9d3ed76c4bfaa42e7c0a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"Raluca\";}s:11:\"tjcafferkey\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/tjcafferkey/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/23d134901eef453e721759c9d84810f5748a84fc8681ed230c7d78e53583c77a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"tjcafferkey\";}s:13:\"danielwrobert\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/danielwrobert/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/f1f823ffbe2a6adb7f94c6998079fd6ae6636d3b6272dd8c54385783360e2cf8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"danielwrobert\";}s:19:\"patriciahillebrandt\";a:3:{s:7:\"profile\";s:51:\"https://profiles.wordpress.org/patriciahillebrandt/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/13f5707fad9a68e5cf9c3c0ebb9c7179c862dcb279c761d20c9b40bd2fff9f4a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"patriciahillebrandt\";}s:7:\"albarin\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/albarin/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0dd150b60949026a3c34f49d40089e3a8cf97dc331e2f5b27e805ffd34648e22?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"albarin\";}s:10:\"dinhtungdu\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/dinhtungdu/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/07e79c32b1abba868f8c5e3ee0c85b9150c74e2c2a946088a268e6be486d9114?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"Tung Du\";}s:10:\"imanish003\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/imanish003/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/59ff646ede2dd6475f24762ac21ee2afd7d72fdcade7b9d2915cf1c3c2d984a2?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Manish Menaria\";}s:12:\"karolmanijak\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/karolmanijak/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/42305d7047ca11d494b1912d687266a50edd05954fdec22e61ab1fe63cf2df6b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Karol Manijak\";}s:13:\"sunyatasattva\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/sunyatasattva/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/73ce316f9775441698b601e6902728a80837f7fd6df0846e3c5a82448dce447c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:20:\"sunyatasattva (a11n)\";}s:13:\"alexandrelara\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/alexandrelara/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1c0c71a072f798066e4661395461e73e0fb6692eaddcced2a0e457ef01a458e8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Alexandre Lara\";}s:7:\"gigitux\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/gigitux/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/2dcd003f15403180364c56b093b48e6edca9a88c8f1470b965b87fc230c66d7f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Luigi Teschio\";}s:12:\"danieldudzic\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/danieldudzic/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/b689767c4b308b8f5910cef3a2f44c2acdadcb3b63326b0d5c865d2c208c668e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"danieldudzic\";}s:11:\"samueljseay\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/samueljseay/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/4c4a5e8fd5b99749ed9ac735c31d0370254356e40feea46bcf51b2b607f8ab0e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:3:\"Sam\";}s:12:\"alexflorisca\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/alexflorisca/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/b68615471f527e6224909ce0726dda68b074e6cbcf89e0d4b5ecc483a96557ca?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Alex Florisca\";}s:5:\"opr18\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/opr18/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/e083a0759b8ea01b11c1f154a3087ddfaf65a93011cf97a85fdbfc0cda709538?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"opr18\";}s:12:\"tarunvijwani\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/tarunvijwani/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/fa4a4b2688afb8d238bb035f31fda4d07dabd67ccf41576276e5eb084463d617?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"tarunvijwani\";}s:12:\"pauloarromba\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/pauloarromba/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ab6034aa12c0e53f21978df9e470f161f06810d814082cbe3ab74450f0618818?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Paulo Arromba\";}s:9:\"saadtarhi\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/saadtarhi/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/f4fd0df69b8c7bf3a3e6526df3b42c3854de544904ef825bfd549afc9829f645?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"Saad T.\";}s:4:\"bor0\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/bor0/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/787d8ea71701ced680cd80411d656c20e0e600be5d34f6ce3478143d43dc9fd9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Boro Sitnikovski\";}s:5:\"kloon\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/kloon/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c7c708f5b0957714ab48e00220b0f74acccb43b70fa0d4b5ee091d59951ae751?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Gerhard Potgieter\";}s:12:\"coreymckrill\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/coreymckrill/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/9cc64cf0f650f165ac55f1294105259f82f2b72c4c24903a79af6d6cd1ad2a9a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Corey McKrill\";}s:12:\"jorgeatorres\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/jorgeatorres/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/33d6a063c7411775135383c5bae6cd4e45d094b72ec062c96ceafca5e2a4956f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Jorge A. Torres\";}s:10:\"leifsinger\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/leifsinger/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/8107603a6bbc5ff73e07e2450f260335af41a5adb2cccd80cba20cdd28b96651?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Leif Singer\";}s:9:\"neosinner\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/neosinner/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/68b52d53a3c6dd39841f697853a1965057c6f3aeb9e89f7d960d1921ffa90d29?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Ján Mikláš\";}}s:8:\"requires\";s:3:\"6.7\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:3853;i:4;i:191;i:3;i:104;i:2;i:109;i:1;i:406;}s:11:\"num_ratings\";i:4663;s:11:\"support_url\";s:49:\"https://wordpress.org/support/plugin/woocommerce/\";s:15:\"support_threads\";i:495;s:24:\"support_threads_resolved\";i:401;s:15:\"active_installs\";i:7000000;s:12:\"last_updated\";s:21:\"2025-11-12 1:35pm GMT\";s:5:\"added\";s:10:\"2011-09-27\";s:8:\"homepage\";s:24:\"https://woocommerce.com/\";s:8:\"sections\";a:6:{s:11:\"description\";s:14078:\"<p><a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">WooCommerce</a> est la plateforme d’eCommerce open-source pour WordPress.</p>\n<p>Notre plateforme centrale est gratuite, flexible et amplifiée par une communauté mondiale. La liberté de son caractère open-source signifie que vous conservez à jamais la pleine propriété du contenu et des données de votre boutique.</p>\n<p>Que vous lanciez une activité, basculiez un magasin physique en ligne ou développiez des sites pour vos clients, WooCommerce permet d’obtenir une boutique qui allie puissamment contenu et commerce.</p>\n<ul>\n<li><strong>Créez des devantures belles et attractives</strong> avec des <a href=\"https://woocommerce.com/product-category/themes/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">thèmes</a> adaptés à votre marque et votre secteur.</li>\n<li><strong>Augmentez vos revenus</strong> grâce à une <a href=\"https://woocommerce.com/checkout-blocks/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">expérience de panier d’achat</a> optimisée qui favorise les conversions.</li>\n<li><strong>Personnalisez les pages de produits en quelques minutes</strong> à l’aide de <a href=\"https://woocommerce.com/document/woocommerce-blocks/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">blocs de produits</a> modulaires.</li>\n<li>Présentez des produits physiques et numériques, des variantes de produits, des configurations personnalisées, des téléchargements instantanés et des articles affiliés.</li>\n<li>Vendez des <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">abonnements</a>, des <a href=\"https://woocommerce.com/products/woocommerce-bookings/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">réservations</a> ou des <a href=\"https://woocommerce.com/products/woocommerce-memberships/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">adhésions</a> grâce à nos extensions approuvées par les développeurs.</li>\n<li><strong>Monter en haut des résultats de recherche</strong> en tirant parti des <a href=\"https://www.searchenginejournal.com/wordpress-best-cms-seo/\" rel=\"nofollow ugc\">qualités SEO de WordPress</a>.</li>\n<li><strong>Créez sur une plateforme qui évolue.</strong> Obtenez une solution d’eCommerce flexible pour les <a href=\"https://woocommerce.com/high-volume-stores/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">boutiques à volume élevé</a>.</li>\n</ul>\n<h4>TOUS LES OUTILS DONT VOUS AVEZ BESOIN POUR VENDRE</h4>\n<p>Les outils et intégrations populaires facilitent la gestion de votre activité. De nombreux services peuvent être ajoutés gratuitement d’un seul clic avec <a href=\"https://woocommerce.com/document/woocommerce-setup-wizard/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">l’assistant de configuration</a> facultatif.</p>\n<ul>\n<li><strong>Choisissez comment vous souhaitez recevoir vos paiements</strong>. Gérez facilement et confortablement les paiements depuis votre boutique avec <a href=\"https://woocommerce.com/payments/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooPayments</a> (Disponible aux États-Unis, au Royaume-Uni, en Irlande, en Australie, en Nouvelle-Zélande, au Canada, en Espagne, en France, en Allemagne et en Italie). Acceptez en toute sécurité les cartes de crédit, les portefeuilles mobiles, les transferts bancaires et les espèces grâce à <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/payment-gateways/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">plus de 100 passerelles de paiement</a> dont <a href=\"https://woocommerce.com/products/stripe/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Stripe</a>, <a href=\"https://woocommerce.com/products/woocommerce-gateway-paypal-checkout/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">PayPal</a> et <a href=\"https://woocommerce.com/products/square/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Square</a>.</li>\n<li><strong>Configurez vos options de livraison</strong>. Imprimez des étiquettes USPS directement à partir de votre tableau de bord et planifiez un retrait avec <a href=\"https://woocommerce.com/products/shipping/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Shipping</a> (États-Unis uniquement). Connectez-vous avec des <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/shipping-methods/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">transporteurs connus</a> comme UPS et FedEx, ainsi qu’une grande variété de solutions de livraison, d’inventaire et de traitement des commandes pour votre région.</li>\n<li><strong>Simplifiez les taxes sur les ventes</strong>. Ajoutez <a href=\"https://woocommerce.com/products/tax/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Tax</a> ou des <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/tax?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">services intégrés similaires</a> pour faire des calculs automatisés une réalité.</li>\n</ul>\n<h4>Développez votre activité, ajoutez des fonctionnalités et surveillez votre boutique où que vous soyez</h4>\n<p>WooCommerce signifie activité. Gardez un œil sur les indicateurs de performance les plus importants pour vous grâce à un tableau de bord central puissant et flexible intégré à WooCommerce.</p>\n<p>Élargissez votre audience sur les canaux marketing et sociaux avec les intégrations <a href=\"https://woocommerce.com/products/google-ads/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Google Ads</a>, <a href=\"https://woocommerce.com/products/hubspot-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">HubSpot</a>, <a href=\"https://woocommerce.com/products/mailchimp-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Mailchimp</a> et <a href=\"https://woocommerce.com/products/facebook/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Facebook</a>. Vous pouvez consulter le <a href=\"https://woocommerce.com/document/marketing-hub/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Marketing Hub</a> dans le tableau de bord pour trouver de nouvelles idées et des astuces pour vous aider à prospérer.</p>\n<p>Améliorez les fonctionnalités de votre boutique grâce à des centaines d’extensions gratuites et payantes sur <a href=\"https://woocommerce.com/products/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Marketplace</a>. Nos développeurs <a href=\"https://woocommerce.com/document/marketplace-overview/#section-6?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">vérifient chaque nouvelle extension</a> et examinent régulièrement les extensions existantes pour maintenir les normes de qualité du marché. Nous sommes activement <a href=\"https://woocommerce.com/document/marketplace-overview/#section-2?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">à la recherche de produits qui aident les créateurs de boutique à en faire des boutiques prospères</a>.</p>\n<p>Gérez votre boutique depuis n’importe quel endroit avec <a href=\"https://woocommerce.com/mobile/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">l’application mobile</a> WooCommerce (sur Android et iOS). Spoiler alert : restez à l’affût du son légèrement addictif de la notification qui retentit à chaque vente.</p>\n<h4>Détenez et contrôlez les données de votre boutique à vie</h4>\n<p>Avec <a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">WooCommerce</a>, vos données vous appartiennent. Toujours.</p>\n<p>Si vous optez pour partager <a href=\"https://woocommerce.com/usage-tracking/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">les données d’utilisation</a> avec nous, vous avez l’assurance que celles-ci seront anonymisées et conservées en toute sécurité. Vous pouvez changer d’avis à tout moment sans que cela n’ait la moindre incidence sur votre boutique.</p>\n<p>Contrairement aux solutions d’eCommerce hébergées, les données des boutiques WooCommerce sont pérennes. Vous pouvez exporter l’intégralité de votre contenu et transférer votre site vers la plateforme de votre choix. Aucune restriction.</p>\n<h4>Pourquoi les développeurs choisissent (et aiment) WooCommerce</h4>\n<p>Les développeurs peuvent utiliser <a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">WooCommerce</a> pour créer, personnaliser et adapter une boutique en fonction des spécifications exactes du client tout en y apportant des améliorations par le biais d’extensions ou de solutions personnalisées.</p>\n<ul>\n<li>Exploitez les <a href=\"https://woocommerce.com/document/introduction-to-hooks-actions-and-filters/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">crochets d’action et les filtres</a> pour modifier ou créer des fonctionnalités.</li>\n<li>Intégrez pratiquement n’importe quel service à l’aide d’une <a href=\"https://developer.woocommerce.com/docs/getting-started-with-the-woocommerce-rest-api/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">API REST</a> robuste et des webhooks.</li>\n<li>Concevez et créez des blocs de contenu personnalisés avec React.</li>\n<li><a href=\"https://developer.woocommerce.com/docs/category/extension-development/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Inspectez et modifiez</a> tous les aspects du code principal de l’extension.</li>\n<li>Accélérez le développement avec une <a href=\"https://developer.woocommerce.com/docs/category/wc-cli/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">CLI</a> rapide comme l’éclair.</li>\n</ul>\n<p>La plateforme centrale fait l’objet de tests rigoureux et fréquents. Ils sont exécutés par une équipe de développement dédiée qui travaillent sur différents fuseaux horaires. La documentation complète est mise à jour à chaque version afin de vous apporter les outils requis pour créer en tout point la boutique dont vous avez besoin.</p>\n<h4>Rejoignez notre communauté internationale grandissante</h4>\n<p>WooCommerce compte une communauté importante et passionnée qui contribue à la réussite des commerçants et qui s’agrandit rapidement.</p>\n<p>Il y a des <a href=\"https://woocommerce.com/meetups/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">rencontres WooCommerce</a> à travers le monde, auxquelles vous pouvez assister gratuitement ; vous pouvez même vous impliquer dans leur organisation. Ces événements sont excellents pour apprendre des expériences de chacun, partager votre expertise et rencontrer des personnes qui pensent comme vous.</p>\n<p>WooCommerce participe également régulièrement aux WordCamps organisés dans le monde entier. Nous serions ravis de vous rencontrer.</p>\n<h4>Contribution et traduction</h4>\n<p>WooCommerce est développé et pris en charge par Automattic, les créateurs de WordPress.com et Jetpack. Nous avons également des centaines de contributeurs indépendants, et il y a toujours de la place pour plus. Dirigez-vous vers le <a href=\"https://github.com/woocommerce/woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Dépôt WooCommerce GitHub</a> pour découvrir comment vous pouvez participer.</p>\n<p>WooCommerce est traduit en plusieurs langues, dont le danois, l’ukrainien et le persan. Aidez à localiser encore plus WooCommerce en ajoutant vos paramètres régionaux &#8211; visitez <a href=\"https://translate.wordpress.org/projects/wp-plugins/woocommerce/?utm_medium=referral&#038;utm_source=wordpress.org&#038;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">translate.wordpress.org</a>.</p>\n<h4>Connexion à WooCommerce.com</h4>\n<p>Vous pouvez connecter votre boutique à <a href=\"https://woocommerce.com/\" rel=\"nofollow ugc\">WooCommerce.com</a> pour gérer vos abonnements à WooCommerce Marketplace et recevoir des mises à jour produit sans quitter WordPress Admin. La connexion permet également l’installation des produits achetés depuis WooCommerce.com et rationalise l’accès à l’assistance technique. Si vous désirez savoir quelles sont les données collectées et l’utilisation qui en est faite, veuillez consulter notre <a href=\"https://automattic.com/privacy/\" rel=\"nofollow ugc\">politique de confidentialité</a>.</p>\n\";s:12:\"installation\";s:2895:\"<h4>Configuration minimale</h4>\n<ul>\n<li>PHP 7.4 ou supérieur est requis (PHP 8.0 ou supérieur est recommandé)</li>\n<li>MySQL 5.5.5 or greater, OR MariaDB version 10.1 or greater, is required</li>\n<li>WordPress 6.7 or greater</li>\n<li>(Recommended) WordPress <a href=\"https://woocommerce.com/document/increasing-the-wordpress-memory-limit/\" rel=\"nofollow ugc\">memory limit</a> of 256 MB or greater.</li>\n<li>(Recommended) <a href=\"https://woocommerce.com/document/ssl-and-https/\" rel=\"nofollow ugc\">HTTPS</a> support.</li>\n</ul>\n<h4>Installation automatique</h4>\n<p>L’installation automatique est l’option la plus simple, car WordPress gère le transfert des fichiers sans que vous n’ayez à quitter votre navigateur. Pour effectuer une installation automatique de WooCommerce, connectez-vous à votre tableau de bord WordPress, accédez au menu « Extensions » et cliquez sur « Ajouter ».</p>\n<p>Dans le champ de recherche, saisissez « WooCommerce », puis cliquez sur « Rechercher des extensions ». Une fois que vous l’avez trouvée, vous pouvez voir les détails la concernant comme la version intermédiaire, l’évaluation et la description. Mais surtout, vous pouvez l’installer en cliquant simplement sur « Installer maintenant ». WordPress s’occupera alors de la suite.</p>\n<h4>Installation manuelle</h4>\n<p>La méthode d’installation manuelle consiste à télécharger l’extension WooCommerce et à la téléverser sur votre serveur Web via votre application FTP préférée. Le codex de WordPress contient <a href=\"https://wordpress.org/support/article/managing-plugins/#manual-plugin-installation\" rel=\"ugc\">des instructions pour se faire ici</a>.</p>\n<h4>Mise à jour</h4>\n<p>Les mises à jour automatiques ne devraient pas poser de problème, mais nous vous recommandons tout de même de sauvegarder votre site.</p>\n<p>Si par malchance vous recontrez des problèmes avec les pages de la boutique / catégorie après une mise à jour, il vous suffit de regénérer les permaliens en allant sur  WordPress &gt; Réglages &gt; Permaliens puis en cliquant sur « sauvegarder. » Cela devrait régler ces problèmes.</p>\n<h4>Exemple de données</h4>\n<p>WooCommerce s’accompagne d’échantillons de données que vous pouvez utiliser pour voir à quoi ressemblent les produits ; importez sample_products.xml via l’<a href=\"https://wordpress.org/plugins/wordpress-importer/\" rel=\"ugc\">importateur WordPress</a>. Vous pouvez également utiliser l’<a href=\"https://woocommerce.com/document/product-csv-importer-exporter/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">importateur de CSV</a> ou notre <a href=\"https://woocommerce.com/products/product-csv-import-suite/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">extension CSV Import Suite</a> pour importer sample_products.csv</p>\n\";s:3:\"faq\";s:8726:\"\n<dt id=\'where%20can%20i%20find%20woocommerce%20documentation%20and%20user%20guides%3F\'>\nOù puis-je trouver de la documentation et des guides de l&rsquo;utilisateur pour l&rsquo;extension WooCommerce&nbsp;?\n</h4>\n<p>\n<p>Si vous désirez une aide à propos de la configuration de WooCommerce, veuillez consulter le guide <a href=\"https://woocommerce.com/documentation/plugins/woocommerce/getting-started/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Premier pas</a> et le <a href=\"https://woocommerce.com/guides/new-store/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">guide pour le nouveau propriétaire de boutique WooCommerce</a>.</p>\n<p>Pour créer une extension ou un thème WooCommerce, consultez notre <a href=\"https://github.com/woocommerce/woocommerce/tree/trunk/docs\" rel=\"nofollow ugc\">documentation</a>, ainsi que les <a href=\"https://github.com/woocommerce/woocommerce/blob/trunk/docs/extension-development/extension-development-best-practices.md\" rel=\"nofollow ugc\">Bonnes pratiques pour les développeurs d’extensions</a>.</p>\n</p>\n<dt id=\'where%20can%20i%20get%20help%20or%20talk%20to%20other%20users%20about%20woocommerce%20core%3F\'>\nOù puis-je trouver de l’aide ou discuter avec d’autres utilisateurs à propos de WooCommerce Core ?\n</h4>\n<p>\n<p>Si ça coince, vous pouvez demander de l’aide sur <a href=\"https://wordpress.org/support/plugin/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">le forum d’assistance WooCommerce</a> en suivant <a href=\"https://wordpress.org/support/topic/guide-to-the-woocommerce-forum/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">ces directives</a>, poster sur le <a href=\"https://woocommerce.com/community-slack/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Slack de la communauté WooCommerce</a>, ou publier sur le <a href=\"https://www.facebook.com/groups/advanced.woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">groupe de la communauté WooCommerce</a> sur Facebook.</p>\n</p>\n<dt id=\'where%20can%20i%20get%20help%20for%20extensions%20i%20have%20purchased%20from%20the%20woocommerce%20marketplace%3F\'>\nOù puis-je trouver de l’aide concernant les extensions que j’ai achetées sur WooCommerce Marketplace ?\n</h4>\n<p>\n<p>Pour toute assistance concernant les extensions payantes de WooCommerce Marketplace : commencez par consulter notre <a href=\"https://woocommerce.com/document/woocommerce-self-service-guide/\" rel=\"nofollow ugc\">guide de résolution de problème en libre-service</a>. Si le problème persiste, veuillez ouvrir un ticket d’assistance via <a href=\"https://woocommerce.com/my-account/create-a-ticket/\" rel=\"nofollow ugc\">notre service d’assistance</a>. Nos Happiness Engineers dévoués vous répondront dans les 24 heures.</p>\n</p>\n<dt id=\'i%E2%80%99m%20having%20trouble%20logging%20in%20to%20woocommerce.com%20%E2%80%93%20what%20now%3F\'>\nJ’ai des problèmes de connexion à WooCommerce.com. Que dois-je faire ?\n</h4>\n<p>\n<p>Tout d’abord, résolvez les problèmes de connexion courants à l’aide de ce <a href=\"https://woocommerce.com/document/log-into-woocommerce-com-with-wordpress-com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">guide étape par étape</a> utile. Cela ne fonctionne toujours pas ? <a href=\"https://woocommerce.com/contact-us/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Contactez-nous</a>.</p>\n</p>\n<dt id=\'will%20woocommerce%20work%20with%20my%20theme%3F\'>\nEst-ce que WooCommerce fonctionnera avec mon thème ?\n</h4>\n<p>\n<p>Oui ! WooCommerce est compatible avec tous les thèmes mais quelques adaptations stylistiques supplémentaires peuvent être nécessaires. Si vous cherchez un thème qui s’intègre parfaitement à WooCommerce, nous recommandons <a href=\"https://woocommerce.com/storefront/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Storefront</a>.</p>\n</p>\n<dt id=\'how%20do%20i%20update%20woocommerce%3F\'>\nComment puis-je mettre à jour WooCommerce ?\n</h4>\n<p>\n<p>Nous disposons d’un guide détaillé intitulé <a href=\"https://woocommerce.com/document/how-to-update-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Comment mettre à jour WooCommerce</a>.</p>\n</p>\n<dt id=\'my%20site%20broke%20%E2%80%93%20what%20do%20i%20do%3F\'>\nMon site ne fonctionne plus. Que dois-je faire ?\n</h4>\n<p>\n<p>Commencez par diagnostiquer le problème à l’aide de notre <a href=\"https://woocommerce.com/documentation/get-help/troubleshooting-get-help/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">guide de résolution de problème</a>.</p>\n<p>Si l’erreur est apparue après la mise à jour d’un thème ou d’une extension, des problèmes de compatibilité peuvent exister entre ce thème/cette extension et WooCommerce. Si le problème est apparu après la mise à jour de WooCommerce, un conflit peut exister entre WooCommerce et un thème ou une extension obsolète.</p>\n<p>Quoi qu’il en soit, nous recommandons de procéder à un test de conflits à l’aide de <a href=\"https://woocommerce.com/document/troubleshooting-using-health-check/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Health Check</a> (ce qui vous permet de désactiver les thèmes et les extensions sans affecter vos visiteurs) ou de résoudre le problème à l’aide du <a href=\"https://woocommerce.com/document/how-to-test-for-conflicts/#section-3?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">site de préproduction</a>.</p>\n</p>\n<dt id=\'where%20can%20i%20report%20bugs%3F\'>\nOù puis-je signaler des bugs ?\n</h4>\n<p>\n<p>Signaler des bogues sur <a href=\"https://github.com/woocommerce/woocommerce/issues?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Dépôt WooCommerce GitHub</a>. Vous pouvez également nous en informer via notre support &#8211; assurez-vous de rechercher les forums pour confirmer que l’erreur n’a pas déjà été signalée.</p>\n</p>\n<dt id=\'where%20can%20i%20request%20new%20features%2C%20themes%2C%20and%20extensions%3F\'>\nOù puis-je demander de nouvelles fonctionnalités, des thèmes et des extensions ?\n</h4>\n<p>\n<p>Demandez de nouvelles fonctionnalités et extensions, et votez pour les suggestions existantes sur notre <a href=\"https://woocommerce.com/feature-requests/woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">tableau de demande de fonctionnalité</a> officiel. Nos équipes Produits consultent régulièrement les demandes, qui leur sont d’un soutien précieux pour la planification des produits.</p>\n</p>\n<dt id=\'woocommerce%20is%20awesome%21%20can%20i%20contribute%3F\'>\nWooCommerce est génial ? Puis-je y contribuer ?\n</h4>\n<p>\n<p>Rejoignez notre <a href=\"https://github.com/woocommerce/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">dépôt GitHub</a> et suivez le <a href=\"https://woocommerce.wordpress.com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">blog de développement</a> pour rester informé de tout ce qui se passe dans le projet.</p>\n</p>\n<dt id=\'where%20can%20i%20find%20rest%20api%20documentation%3F\'>\nOù puis-je trouver la documentation pour l’API Rest ?\n</h4>\n<p>\n<p>Une <a href=\"https://woocommerce.github.io/woocommerce-rest-api-docs/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">documentation complète de l’API REST WooCommerce</a> est disponible sur GitHub.</p>\n</p>\n<dt id=\'my%20question%20is%20not%20listed%20here.%20where%20can%20i%20find%20more%20answers%3F\'>\nMa question n’apparaît pas dans la liste. Où puis-je trouver d’autres réponses ?\n</h4>\n<p>\n<p>Consultez les <a href=\"https://woocommerce.com/document/frequently-asked-questions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">questions les plus fréquentes</a> pour en savoir plus.</p>\n</p>\n\n\";s:9:\"changelog\";s:1965:\"<h4>10.3.5 2025-11-12</h4>\n<p><strong>WooCommerce</strong></p>\n<ul>\n<li>Fix &#8211; Add a new line when concatenating translations in a script for the Mini-Cart block <a href=\"https://github.com/woocommerce/woocommerce/pull/61918\" rel=\"nofollow ugc\">#61918</a></li>\n<li>Fix &#8211; Disable the Deactivate menu option for bundled payment gateways. <a href=\"https://github.com/woocommerce/woocommerce/pull/61841\" rel=\"nofollow ugc\">#61841</a></li>\n<li>Fix &#8211; Fix &lsquo;shows password form in products protected with password&rsquo; e2e tests in WP 6.9 <a href=\"https://github.com/woocommerce/woocommerce/pull/61911\" rel=\"nofollow ugc\">#61911</a></li>\n<li>Fix &#8211; Fixes CSV import where hierarchical brands could not be imported. <a href=\"https://github.com/woocommerce/woocommerce/pull/61873\" rel=\"nofollow ugc\">#61873</a></li>\n<li>Fix &#8211; Legacy assets: respect theme support when using Classic Template or Product Image Gallery blocks with block themes. <a href=\"https://github.com/woocommerce/woocommerce/pull/61837\" rel=\"nofollow ugc\">#61837</a></li>\n<li>Fix &#8211; WP 6.9: load WP Button block styles when rendering the Add to Cart Button <a href=\"https://github.com/woocommerce/woocommerce/pull/61911\" rel=\"nofollow ugc\">#61911</a></li>\n<li>Update &#8211; Onboarding: Remove onboarding step to Customize Your Store flow <a href=\"https://github.com/woocommerce/woocommerce/pull/61911\" rel=\"nofollow ugc\">#61911</a></li>\n<li>Dev &#8211; e2e tests: skip block-based product editor tests <a href=\"https://github.com/woocommerce/woocommerce/pull/61911\" rel=\"nofollow ugc\">#61911</a></li>\n<li>Dev &#8211; Remove price filter widget accounting script deprecation notice <a href=\"https://github.com/woocommerce/woocommerce/pull/61844\" rel=\"nofollow ugc\">#61844</a></li>\n</ul>\n<p><a href=\"https://raw.githubusercontent.com/woocommerce/woocommerce/trunk/changelog.txt\" rel=\"nofollow ugc\">Voir le journal des modifications pour toutes les versions</a>.</p>\n\";s:11:\"screenshots\";s:1035:\"<ol><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=3235205\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=3235205\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=3234504\" alt=\"\"></a></li></ol>\";s:7:\"reviews\";s:15437:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Review plug in</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/butterfly124/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/62647ab33af3614f3a4ed30d7435e2dd39ddcc7148ea1d05caca7a0cb5c2b5cc?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/62647ab33af3614f3a4ed30d7435e2dd39ddcc7148ea1d05caca7a0cb5c2b5cc?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/butterfly124/\" class=\"reviewer-name\">butterfly124</a> le <span class=\"review-date\">novembre 20, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>This plug-in is starting to generate us more reviews faster. Working well</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Áno, dobrá podpora</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/taxibratislava/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e3a4df4468ab8aaf352c1869a2fe05d1484fa3e7e216bd99202ac84bab8e31c2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e3a4df4468ab8aaf352c1869a2fe05d1484fa3e7e216bd99202ac84bab8e31c2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/taxibratislava/\" class=\"reviewer-name\">taxibratislava</a> le <span class=\"review-date\">novembre 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Problém, ktorý som mal mi pomohli rýchlo vyriešiť. Ďakujem</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">The Best plugin for eCommerce Websites Generated by WordPressrdPress</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/hmorie/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/39bd39c8b1ee3e26cd1ff9ea5718efe3c54e315c2805f0c59647b99635294a65?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/39bd39c8b1ee3e26cd1ff9ea5718efe3c54e315c2805f0c59647b99635294a65?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/hmorie/\" class=\"reviewer-name\">hmorie</a> le <span class=\"review-date\">novembre 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Woocommerce is the greatest plugin that can be used for eCommerce websites</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">woo commerce support team</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/debsap/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/df1c86b4d76e37745e51e04b636bc65e6676e261b8d2fd854021536bc93d003b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/df1c86b4d76e37745e51e04b636bc65e6676e261b8d2fd854021536bc93d003b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/debsap/\" class=\"reviewer-name\">debsap</a> le <span class=\"review-date\">novembre 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>The woo commerce support team were amazingly helpful and patient and managed to help me resolve my issue. Highly recommend!!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Easy to customize, flexible, and packed with features</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"4 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"4\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/ajkastner77/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/3e5633850e3fbf8b84a905eeafa1d20992c519c81fdc745491336550247667ac?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/3e5633850e3fbf8b84a905eeafa1d20992c519c81fdc745491336550247667ac?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ajkastner77/\" class=\"reviewer-name\">ajkastner77</a> le <span class=\"review-date\">novembre 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>WooCommerce has been an excellent ecommerce solution for my WordPress site—easy to customize, flexible, and packed with features that make managing products and orders simple. The community and official support have also been really helpful whenever I needed guidance. The only downside is that some useful features require paid extensions, which can add up, and managing multiple add-ons can get a bit complex. Still, for full control and reliable support, it’s one of the best tools I’ve used.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Awesome E-Commerce Solution</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/jhahiten/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/0425ebc0c163879cfc098eca9eeb8516f568b2d4d7099265b2817b4e426ed030?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/0425ebc0c163879cfc098eca9eeb8516f568b2d4d7099265b2817b4e426ed030?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/jhahiten/\" class=\"reviewer-name\">jhahiten</a> le <span class=\"review-date\">novembre 17, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Woocommerce provides E2E solution from the perspective of End Users, Back-office and analytics. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Woocommerce, what else? :)</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/barthdesigns/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/2c390d42a93a35536ed296f2e1012f4f7df5fed93a408eca5ba2db17797c0424?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/2c390d42a93a35536ed296f2e1012f4f7df5fed93a408eca5ba2db17797c0424?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/barthdesigns/\" class=\"reviewer-name\">barthdesigns</a> le <span class=\"review-date\">novembre 14, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Great plugin with many functions and extensions. Support Tem is also very kind and helpful. Thank you!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Liberated Commerce Engine</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/fasolas/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d23d60bc942ee8e31a10dc921526d7b6dc05f28f6acd8701b3c661815e747c3d?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d23d60bc942ee8e31a10dc921526d7b6dc05f28f6acd8701b3c661815e747c3d?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/fasolas/\" class=\"reviewer-name\">fasolas</a> le <span class=\"review-date\">novembre 13, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Thanks for continuously improving WooCommerce. It feels lighter and the frontend experience keeps getting better with each release. Keep going!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Perfetto</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/mattiabortoli/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/7b6ed7ee4c185a52870d558401dd8c4eb39942abb96ff38c45f21d91ba3fe7e4?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/7b6ed7ee4c185a52870d558401dd8c4eb39942abb96ff38c45f21d91ba3fe7e4?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/mattiabortoli/\" class=\"reviewer-name\">mattiabortoli</a> le <span class=\"review-date\">novembre 13, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>ottimo</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Does the job</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 sur 5 étoiles\" data-title-template=\"%s sur 5 étoiles\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Par <a href=\"https://profiles.wordpress.org/javnation/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/8c59b0c54bdd35ae7cd75e66c2588a2aae8fb7d1e967ebf5c4f0993dc8742e96?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/8c59b0c54bdd35ae7cd75e66c2588a2aae8fb7d1e967ebf5c4f0993dc8742e96?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/javnation/\" class=\"reviewer-name\">Javnation</a> le <span class=\"review-date\">novembre 13, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I like the control WooCommerce gives users over their store. That i am not locked into some corporations infrastructure with no control over costs. Managing plugins can be a pain, as can all the research to see what works and optimizing your site. But overall, it works very well, is affordable and has been quite reliable.</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:227:\"Tout ce dont vous avez besoin pour créer une boutique en ligne en quelques jours et la faire prospérer des années. Woo vous accompagne, de votre toute première vente au développement colossal de votre chiffre d’affaires.\";s:13:\"download_link\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.5.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:2;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:3;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:4;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=3235205\";s:7:\"caption\";s:0:\"\";}i:5;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:6;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}}s:4:\"tags\";a:5:{s:9:\"ecommerce\";s:9:\"ecommerce\";s:12:\"online-store\";s:12:\"online store\";s:11:\"sell-online\";s:11:\"sell online\";s:4:\"shop\";s:4:\"shop\";s:13:\"shopping-cart\";s:13:\"shopping cart\";}s:8:\"versions\";a:522:{s:6:\"10.0.0\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.0.zip\";s:11:\"10.0.0-rc.1\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.0-rc.1.zip\";s:11:\"10.0.0-rc.2\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.0-rc.2.zip\";s:6:\"10.0.1\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.1.zip\";s:6:\"10.0.2\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.2.zip\";s:6:\"10.0.3\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.3.zip\";s:6:\"10.0.4\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.4.zip\";s:6:\"10.1.0\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.0.zip\";s:11:\"10.1.0-rc.1\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.0-rc.1.zip\";s:11:\"10.1.0-rc.2\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.0-rc.2.zip\";s:11:\"10.1.0-rc.3\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.0-rc.3.zip\";s:11:\"10.1.0-rc.4\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.0-rc.4.zip\";s:6:\"10.1.1\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.1.zip\";s:6:\"10.1.2\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.1.2.zip\";s:6:\"10.2.0\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.0.zip\";s:13:\"10.2.0-beta.1\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.0-beta.1.zip\";s:13:\"10.2.0-beta.2\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.0-beta.2.zip\";s:11:\"10.2.0-rc.1\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.0-rc.1.zip\";s:6:\"10.2.1\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.1.zip\";s:6:\"10.2.2\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.2.zip\";s:6:\"10.3.0\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.0.zip\";s:13:\"10.3.0-beta.1\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.0-beta.1.zip\";s:13:\"10.3.0-beta.2\";s:68:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.0-beta.2.zip\";s:11:\"10.3.0-rc.1\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.0-rc.1.zip\";s:11:\"10.3.0-rc.2\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.0-rc.2.zip\";s:6:\"10.3.1\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.1.zip\";s:6:\"10.3.2\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.2.zip\";s:6:\"10.3.3\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.3.zip\";s:6:\"10.3.4\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.4.zip\";s:6:\"10.3.5\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.3.5.zip\";s:5:\"3.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.0.zip\";s:5:\"3.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.1.zip\";s:5:\"3.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.2.zip\";s:5:\"3.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.3.zip\";s:5:\"3.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.4.zip\";s:5:\"3.0.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.5.zip\";s:5:\"3.0.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.6.zip\";s:5:\"3.0.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.7.zip\";s:5:\"3.0.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.8.zip\";s:5:\"3.0.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.9.zip\";s:5:\"3.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.0.zip\";s:5:\"3.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.1.zip\";s:5:\"3.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.2.zip\";s:5:\"3.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.0.zip\";s:5:\"3.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.1.zip\";s:5:\"3.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.2.zip\";s:5:\"3.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.3.zip\";s:5:\"3.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.4.zip\";s:5:\"3.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.5.zip\";s:5:\"3.2.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.6.zip\";s:5:\"3.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.0.zip\";s:5:\"3.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.1.zip\";s:5:\"3.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2.zip\";s:10:\"3.3.2-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2-rc.1.zip\";s:5:\"3.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.3.zip\";s:5:\"3.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.4.zip\";s:5:\"3.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.5.zip\";s:5:\"3.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.6.zip\";s:5:\"3.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0.zip\";s:12:\"3.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-beta.1.zip\";s:10:\"3.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-rc.2.zip\";s:5:\"3.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.1.zip\";s:5:\"3.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.2.zip\";s:5:\"3.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.3.zip\";s:5:\"3.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.4.zip\";s:5:\"3.4.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.5.zip\";s:5:\"3.4.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.6.zip\";s:5:\"3.4.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.7.zip\";s:5:\"3.4.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.8.zip\";s:5:\"3.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0.zip\";s:12:\"3.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-beta.1.zip\";s:10:\"3.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.1.zip\";s:10:\"3.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.2.zip\";s:5:\"3.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.1.zip\";s:6:\"3.5.10\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.10.zip\";s:5:\"3.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.2.zip\";s:5:\"3.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.3.zip\";s:5:\"3.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.4.zip\";s:5:\"3.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.5.zip\";s:5:\"3.5.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.6.zip\";s:5:\"3.5.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.7.zip\";s:5:\"3.5.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.8.zip\";s:5:\"3.5.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.9.zip\";s:5:\"3.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0.zip\";s:12:\"3.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-beta.1.zip\";s:10:\"3.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.1.zip\";s:10:\"3.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.2.zip\";s:10:\"3.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.3.zip\";s:5:\"3.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.1.zip\";s:5:\"3.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.2.zip\";s:5:\"3.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.3.zip\";s:5:\"3.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.4.zip\";s:5:\"3.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.5.zip\";s:5:\"3.6.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.6.zip\";s:5:\"3.6.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.7.zip\";s:5:\"3.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0.zip\";s:12:\"3.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-beta.1.zip\";s:10:\"3.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.1.zip\";s:10:\"3.7.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.2.zip\";s:5:\"3.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.1.zip\";s:5:\"3.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.2.zip\";s:5:\"3.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.3.zip\";s:5:\"3.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0.zip\";s:12:\"3.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-beta.1.zip\";s:10:\"3.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.1.zip\";s:10:\"3.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.2.zip\";s:5:\"3.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.1.zip\";s:5:\"3.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.2.zip\";s:5:\"3.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.3.zip\";s:5:\"3.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0.zip\";s:12:\"3.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.1.zip\";s:12:\"3.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.2.zip\";s:10:\"3.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.1.zip\";s:10:\"3.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.2.zip\";s:10:\"3.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.3.zip\";s:10:\"3.9.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.4.zip\";s:5:\"3.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.1.zip\";s:5:\"3.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.2.zip\";s:5:\"3.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.3.zip\";s:5:\"3.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.4.zip\";s:5:\"3.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.5.zip\";s:5:\"4.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0.zip\";s:12:\"4.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-beta.1.zip\";s:10:\"4.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.1.zip\";s:10:\"4.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.2.zip\";s:5:\"4.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.1.zip\";s:5:\"4.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.2.zip\";s:5:\"4.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.3.zip\";s:5:\"4.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.4.zip\";s:5:\"4.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0.zip\";s:12:\"4.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.1.zip\";s:12:\"4.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.2.zip\";s:10:\"4.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.1.zip\";s:10:\"4.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.2.zip\";s:5:\"4.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.1.zip\";s:5:\"4.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.2.zip\";s:5:\"4.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.3.zip\";s:5:\"4.1.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.4.zip\";s:5:\"4.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0.zip\";s:10:\"4.2.0-RC.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.1.zip\";s:10:\"4.2.0-RC.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.2.zip\";s:12:\"4.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-beta.1.zip\";s:5:\"4.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.1.zip\";s:5:\"4.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.2.zip\";s:5:\"4.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.3.zip\";s:5:\"4.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.4.zip\";s:5:\"4.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.5.zip\";s:5:\"4.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0.zip\";s:12:\"4.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-beta.1.zip\";s:10:\"4.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.1.zip\";s:10:\"4.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.2.zip\";s:10:\"4.3.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.3.zip\";s:5:\"4.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.1.zip\";s:5:\"4.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.2.zip\";s:5:\"4.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.3.zip\";s:5:\"4.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.4.zip\";s:5:\"4.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.5.zip\";s:5:\"4.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.6.zip\";s:5:\"4.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0.zip\";s:12:\"4.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-beta.1.zip\";s:10:\"4.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-rc.1.zip\";s:5:\"4.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.1.zip\";s:5:\"4.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.2.zip\";s:5:\"4.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.3.zip\";s:5:\"4.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.4.zip\";s:5:\"4.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0.zip\";s:12:\"4.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-beta.1.zip\";s:10:\"4.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.1.zip\";s:10:\"4.5.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.3.zip\";s:5:\"4.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.1.zip\";s:5:\"4.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.2.zip\";s:5:\"4.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.3.zip\";s:5:\"4.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.4.zip\";s:5:\"4.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.5.zip\";s:5:\"4.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0.zip\";s:12:\"4.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-beta.1.zip\";s:10:\"4.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-rc.1.zip\";s:5:\"4.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.1.zip\";s:5:\"4.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.2.zip\";s:5:\"4.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.3.zip\";s:5:\"4.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.4.zip\";s:5:\"4.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.5.zip\";s:5:\"4.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0.zip\";s:12:\"4.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.1.zip\";s:12:\"4.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.2.zip\";s:10:\"4.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-rc.1.zip\";s:5:\"4.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1.zip\";s:12:\"4.7.1-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1-beta.1.zip\";s:5:\"4.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.2.zip\";s:5:\"4.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.3.zip\";s:5:\"4.7.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.4.zip\";s:5:\"4.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0.zip\";s:12:\"4.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-beta.1.zip\";s:10:\"4.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.1.zip\";s:10:\"4.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.2.zip\";s:5:\"4.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.1.zip\";s:5:\"4.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.2.zip\";s:5:\"4.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.3.zip\";s:5:\"4.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0.zip\";s:12:\"4.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-beta.1.zip\";s:10:\"4.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.1.zip\";s:10:\"4.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.2.zip\";s:5:\"4.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.1.zip\";s:5:\"4.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.2.zip\";s:5:\"4.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.3.zip\";s:5:\"4.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.4.zip\";s:5:\"4.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.5.zip\";s:5:\"5.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0.zip\";s:12:\"5.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.1.zip\";s:12:\"5.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.2.zip\";s:10:\"5.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.1.zip\";s:10:\"5.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.2.zip\";s:10:\"5.0.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.3.zip\";s:5:\"5.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.1.zip\";s:5:\"5.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.2.zip\";s:5:\"5.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.3.zip\";s:5:\"5.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0.zip\";s:12:\"5.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-beta.1.zip\";s:10:\"5.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-rc.1.zip\";s:5:\"5.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.1.zip\";s:5:\"5.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.2.zip\";s:5:\"5.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.3.zip\";s:5:\"5.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0.zip\";s:12:\"5.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-beta.1.zip\";s:10:\"5.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.1.zip\";s:10:\"5.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.2.zip\";s:5:\"5.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.1.zip\";s:5:\"5.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.2.zip\";s:5:\"5.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.3.zip\";s:5:\"5.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.4.zip\";s:5:\"5.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.5.zip\";s:5:\"5.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0.zip\";s:12:\"5.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-beta.1.zip\";s:10:\"5.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.1.zip\";s:10:\"5.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.2.zip\";s:5:\"5.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.1.zip\";s:5:\"5.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.2.zip\";s:5:\"5.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.3.zip\";s:5:\"5.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0.zip\";s:12:\"5.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-beta.1.zip\";s:10:\"5.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-rc.1.zip\";s:5:\"5.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.1.zip\";s:5:\"5.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.2.zip\";s:5:\"5.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.3.zip\";s:5:\"5.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.4.zip\";s:5:\"5.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0.zip\";s:12:\"5.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-beta.1.zip\";s:10:\"5.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.1.zip\";s:10:\"5.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.2.zip\";s:5:\"5.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.1.zip\";s:5:\"5.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.2.zip\";s:5:\"5.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.3.zip\";s:5:\"5.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.4.zip\";s:5:\"5.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0.zip\";s:12:\"5.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-beta.1.zip\";s:10:\"5.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.1.zip\";s:10:\"5.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.2.zip\";s:5:\"5.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.1.zip\";s:5:\"5.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.2.zip\";s:5:\"5.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0.zip\";s:12:\"5.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-beta.1.zip\";s:10:\"5.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-rc.1.zip\";s:5:\"5.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.1.zip\";s:5:\"5.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.2.zip\";s:5:\"5.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0.zip\";s:12:\"5.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.1.zip\";s:12:\"5.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.2.zip\";s:10:\"5.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-rc.1.zip\";s:5:\"5.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.1.zip\";s:5:\"5.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0.zip\";s:12:\"5.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-beta.1.zip\";s:10:\"5.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.1.zip\";s:10:\"5.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.2.zip\";s:5:\"5.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.1.zip\";s:5:\"6.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0.zip\";s:12:\"6.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-beta.1.zip\";s:10:\"6.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-rc.1.zip\";s:5:\"6.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.1.zip\";s:5:\"6.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0.zip\";s:12:\"6.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-beta.1.zip\";s:10:\"6.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.1.zip\";s:10:\"6.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.2.zip\";s:5:\"6.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.1.zip\";s:5:\"6.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.2.zip\";s:5:\"6.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0.zip\";s:12:\"6.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-beta.1.zip\";s:10:\"6.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.1.zip\";s:10:\"6.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.2.zip\";s:5:\"6.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.1.zip\";s:5:\"6.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.2.zip\";s:5:\"6.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0.zip\";s:12:\"6.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-beta.1.zip\";s:10:\"6.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.1.zip\";s:10:\"6.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.2.zip\";s:5:\"6.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.1.zip\";s:5:\"6.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0.zip\";s:12:\"6.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-beta.1.zip\";s:10:\"6.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-rc.1.zip\";s:5:\"6.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.1.zip\";s:5:\"6.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0.zip\";s:12:\"6.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-beta.1.zip\";s:10:\"6.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.1.zip\";s:10:\"6.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.2.zip\";s:5:\"6.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.1.zip\";s:5:\"6.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0.zip\";s:12:\"6.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-beta.1.zip\";s:10:\"6.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.1.zip\";s:10:\"6.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.2.zip\";s:5:\"6.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.1.zip\";s:5:\"6.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0.zip\";s:12:\"6.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.1.zip\";s:12:\"6.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.2.zip\";s:10:\"6.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-rc.1.zip\";s:5:\"6.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0.zip\";s:12:\"6.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.1.zip\";s:12:\"6.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.2.zip\";s:10:\"6.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-rc.1.zip\";s:5:\"6.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.1.zip\";s:5:\"6.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.2.zip\";s:5:\"6.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0.zip\";s:12:\"6.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.1.zip\";s:12:\"6.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.2.zip\";s:10:\"6.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-rc.1.zip\";s:5:\"6.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.1.zip\";s:5:\"6.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.2.zip\";s:5:\"6.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.3.zip\";s:5:\"6.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.4.zip\";s:5:\"7.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0.zip\";s:12:\"7.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.1.zip\";s:12:\"7.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.2.zip\";s:12:\"7.0.0-beta.3\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.3.zip\";s:10:\"7.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.1.zip\";s:10:\"7.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.2.zip\";s:5:\"7.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.1.zip\";s:5:\"7.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0.zip\";s:12:\"7.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.1.zip\";s:12:\"7.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.2.zip\";s:10:\"7.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.1.zip\";s:10:\"7.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.2.zip\";s:5:\"7.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.1.zip\";s:5:\"7.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0.zip\";s:12:\"7.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.1.zip\";s:12:\"7.2.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.2.zip\";s:10:\"7.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.1.zip\";s:10:\"7.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.2.zip\";s:5:\"7.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.1.zip\";s:5:\"7.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.2.zip\";s:5:\"7.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.3.zip\";s:5:\"7.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0.zip\";s:12:\"7.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.1.zip\";s:12:\"7.3.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.2.zip\";s:10:\"7.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.1.zip\";s:10:\"7.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.2.zip\";s:5:\"7.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0.zip\";s:12:\"7.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.1.zip\";s:12:\"7.4.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.2.zip\";s:10:\"7.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.1.zip\";s:10:\"7.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.2.zip\";s:5:\"7.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.1.zip\";s:5:\"7.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0.zip\";s:12:\"7.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.1.zip\";s:12:\"7.5.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.2.zip\";s:10:\"7.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-rc.1.zip\";s:5:\"7.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.1.zip\";s:5:\"7.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0.zip\";s:12:\"7.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.1.zip\";s:12:\"7.6.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.2.zip\";s:10:\"7.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.1.zip\";s:10:\"7.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.2.zip\";s:10:\"7.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.3.zip\";s:5:\"7.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.1.zip\";s:5:\"7.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0.zip\";s:12:\"7.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.1.zip\";s:12:\"7.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.2.zip\";s:10:\"7.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-rc.1.zip\";s:5:\"7.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.1.zip\";s:5:\"7.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.2.zip\";s:5:\"7.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0.zip\";s:12:\"7.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.1.zip\";s:12:\"7.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.2.zip\";s:10:\"7.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.1.zip\";s:10:\"7.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.2.zip\";s:5:\"7.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.1.zip\";s:5:\"7.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.2.zip\";s:5:\"7.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.3.zip\";s:5:\"7.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0.zip\";s:12:\"7.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.1.zip\";s:12:\"7.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.2.zip\";s:10:\"7.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.2.zip\";s:10:\"7.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.3.zip\";s:5:\"7.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.1.zip\";s:5:\"8.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0.zip\";s:12:\"8.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.1.zip\";s:12:\"8.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.2.zip\";s:10:\"8.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.1.zip\";s:10:\"8.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.2.zip\";s:5:\"8.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.1.zip\";s:5:\"8.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.2.zip\";s:5:\"8.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.3.zip\";s:5:\"8.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.4.zip\";s:5:\"8.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0.zip\";s:12:\"8.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-beta.1.zip\";s:10:\"8.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.1.zip\";s:10:\"8.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.2.zip\";s:5:\"8.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.1.zip\";s:5:\"8.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.2.zip\";s:5:\"8.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0.zip\";s:12:\"8.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-beta.1.zip\";s:10:\"8.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-rc.1.zip\";s:10:\"8.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-rc.2.zip\";s:5:\"8.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.1.zip\";s:5:\"8.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.2.zip\";s:5:\"8.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.3.zip\";s:5:\"8.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0.zip\";s:12:\"8.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-beta.1.zip\";s:10:\"8.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-rc.1.zip\";s:10:\"8.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-rc.2.zip\";s:5:\"8.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.1.zip\";s:5:\"8.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.2.zip\";s:5:\"8.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0.zip\";s:12:\"8.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0-beta.1.zip\";s:10:\"8.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0-rc.1.zip\";s:5:\"8.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.1.zip\";s:5:\"8.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0.zip\";s:12:\"8.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0-beta.1.zip\";s:10:\"8.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0-rc.1.zip\";s:5:\"8.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.1.zip\";s:5:\"8.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.2.zip\";s:5:\"8.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.3.zip\";s:5:\"8.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0.zip\";s:12:\"8.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0-beta.1.zip\";s:10:\"8.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0-rc.1.zip\";s:5:\"8.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.1.zip\";s:5:\"8.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.2.zip\";s:5:\"8.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0.zip\";s:12:\"8.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-beta.1.zip\";s:12:\"8.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-beta.2.zip\";s:10:\"8.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-rc.1.zip\";s:5:\"8.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.1.zip\";s:5:\"8.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0.zip\";s:12:\"8.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0-beta.1.zip\";s:10:\"8.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0-rc.1.zip\";s:5:\"8.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.1.zip\";s:5:\"8.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.2.zip\";s:5:\"8.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.3.zip\";s:5:\"8.8.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.4.zip\";s:5:\"8.8.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.5.zip\";s:5:\"8.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0.zip\";s:12:\"8.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0-beta.1.zip\";s:10:\"8.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0-rc.1.zip\";s:5:\"8.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.1.zip\";s:5:\"8.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.2.zip\";s:5:\"8.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.3.zip\";s:5:\"9.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0.zip\";s:12:\"9.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-beta.1.zip\";s:12:\"9.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-beta.2.zip\";s:10:\"9.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-rc.1.zip\";s:5:\"9.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.1.zip\";s:5:\"9.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.2.zip\";s:5:\"9.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0.zip\";s:12:\"9.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0-beta.1.zip\";s:10:\"9.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0-rc.1.zip\";s:5:\"9.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.1.zip\";s:5:\"9.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.2.zip\";s:5:\"9.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.3.zip\";s:5:\"9.1.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.4.zip\";s:5:\"9.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0.zip\";s:12:\"9.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0-beta.1.zip\";s:10:\"9.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0-rc.1.zip\";s:5:\"9.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.1.zip\";s:5:\"9.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.2.zip\";s:5:\"9.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.3.zip\";s:5:\"9.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0.zip\";s:12:\"9.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0-beta.1.zip\";s:10:\"9.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0-rc.1.zip\";s:5:\"9.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.1.zip\";s:5:\"9.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.2.zip\";s:5:\"9.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.3.zip\";s:5:\"9.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.4.zip\";s:5:\"9.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0.zip\";s:12:\"9.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-beta.1.zip\";s:12:\"9.4.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-beta.2.zip\";s:10:\"9.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.1.zip\";s:10:\"9.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.2.zip\";s:10:\"9.4.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.3.zip\";s:10:\"9.4.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.4.zip\";s:5:\"9.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.1.zip\";s:5:\"9.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.2.zip\";s:5:\"9.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.3.zip\";s:5:\"9.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0.zip\";s:12:\"9.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-beta.1.zip\";s:12:\"9.5.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-beta.2.zip\";s:10:\"9.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-rc.1.zip\";s:5:\"9.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.1.zip\";s:5:\"9.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.2.zip\";s:5:\"9.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0.zip\";s:12:\"9.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0-beta.1.zip\";s:12:\"9.6.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0-beta.2.zip\";s:10:\"9.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0-rc.1.zip\";s:5:\"9.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.1.zip\";s:5:\"9.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.2.zip\";s:5:\"9.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.0.zip\";s:12:\"9.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.0-beta.1.zip\";s:10:\"9.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.0-rc.1.zip\";s:5:\"9.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.1.zip\";s:5:\"9.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.0.zip\";s:12:\"9.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.0-beta.1.zip\";s:10:\"9.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.0-rc.1.zip\";s:5:\"9.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.1.zip\";s:5:\"9.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.2.zip\";s:5:\"9.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.3.zip\";s:5:\"9.8.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.4.zip\";s:5:\"9.8.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.5.zip\";s:5:\"9.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.0.zip\";s:12:\"9.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.0-beta.1.zip\";s:10:\"9.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.0-rc.1.zip\";s:5:\"9.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.1.zip\";s:5:\"9.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.2.zip\";s:5:\"9.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.3.zip\";s:5:\"9.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.4.zip\";s:5:\"9.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.5.zip\";s:5:\"trunk\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:0:\"\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3234504\";s:4:\"high\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3234504\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";s:3:\"svg\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:11:\"WooCommerce\";}}", "off");
INSERT INTO `wp_options` VALUES("162", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("165", "elementor_active_kit", "6", "auto");
INSERT INTO `wp_options` VALUES("166", "elementor_font_display", "swap", "auto");
INSERT INTO `wp_options` VALUES("169", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("170", "elementor_checklist", "{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}", "auto");
INSERT INTO `wp_options` VALUES("171", "elementor_version", "3.28.1", "auto");
INSERT INTO `wp_options` VALUES("172", "elementor_install_history", "a:2:{s:6:\"3.27.6\";i:1741367562;s:6:\"3.28.1\";i:1742942173;}", "auto");
INSERT INTO `wp_options` VALUES("173", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wp_options` VALUES("175", "elementor_onboarded", "1", "auto");
INSERT INTO `wp_options` VALUES("176", "elementor_connect_site_key", "7de43fe47f4533648e4c38d0837fcc20", "auto");
INSERT INTO `wp_options` VALUES("177", "elementor_allow_tracking", "yes", "auto");
INSERT INTO `wp_options` VALUES("178", "elementor_tracker_last_send", "1763448733", "auto");
INSERT INTO `wp_options` VALUES("181", "_elementor_installed_time", "1741367609", "auto");
INSERT INTO `wp_options` VALUES("182", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("183", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("189", "current_theme", "Twenty Twenty-Four", "auto");
INSERT INTO `wp_options` VALUES("190", "theme_mods_hello-elementor", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1742675358;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("191", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("194", "hello_theme_version", "3.3.0", "auto");
INSERT INTO `wp_options` VALUES("195", "_hello-elementor_notifications", "a:2:{s:7:\"timeout\";i:1742717711;s:5:\"value\";s:6499:\"[{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t<li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}", "off");
INSERT INTO `wp_options` VALUES("196", "_elementor_onboarding_features", "a:2:{s:9:\"essential\";a:1:{i:0;s:29:\"Templates &amp; Theme Builder\";}s:8:\"advanced\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("198", "e_editor_counter", "123", "auto");
INSERT INTO `wp_options` VALUES("199", "_elementor_free_to_pro_upsell", "a:2:{s:7:\"timeout\";i:1760294793;s:5:\"value\";s:723:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"},{\"id\":\"connect-pro-upgrade\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/connect-pro-upgrade.jpg\"}]\";}", "off");
INSERT INTO `wp_options` VALUES("200", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1760294793;s:5:\"value\";s:15038:\"[{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"send-notification-august\",\"title\":\"All Your Assets, One Library\",\"description\":\"Save time and skip the re-uploads - now you can pull images straight from your WordPress Media Library into Send. Faster, simpler, and built for WordPress.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aug_send.png\",\"chipTags\":[\"Cart abandonment\"],\"cta\":\"Upload Your Assets\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/ML_WN\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"classes-3.30\",\"title\":\"Better class control\",\"description\":\"Get popovers with your class name, breakpoint, state and possible conflicts. Plus, the exact class names you define are now reflected in the code, making debugging and working with external tools easier!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/classes-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"youtube-3.30\",\"title\":\"YouTube Element\",\"description\":\"The new YouTube Element is purpose-built to support V4 capabilities with faster rendering, better performance, and familiar controls like autoplay, loop, mute, and aspect ratio.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/youtube-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `wp_options` VALUES("203", "elementor_log", "a:13:{s:32:\"150408be53bf4bb124d6966f90e8f9a0\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:4:\"1692\";s:7:\"\0*\0file\";s:110:\"http://localhost/nellboulanger/wp-content/plugins/elementor/assets/js/packages/editor/editor.min.js?ver=3.27.6\";s:7:\"\0*\0line\";s:1:\"1\";s:7:\"\0*\0date\";s:19:\"2025-03-07 17:13:53\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:71:\"undefined is not an object (evaluating &#039;u.createQueryClient&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2025-03-07 17:13:53\";i:1;s:19:\"2025-03-07 17:15:25\";i:2;s:19:\"2025-03-07 17:17:07\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1741367633\";s:7:\"message\";s:61:\"undefined is not an object (evaluating \'u.createQueryClient\')\";s:3:\"url\";s:110:\"http://localhost/nellboulanger/wp-content/plugins/elementor/assets/js/packages/editor/editor.min.js?ver=3.27.6\";s:4:\"line\";s:1:\"1\";s:6:\"column\";s:4:\"1692\";}}s:32:\"8b940f8cfd06ce2af827f77dc96fed30\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:102:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/plugins/elementor/modules/ai/module.php\";s:7:\"\0*\0line\";i:730;s:7:\"\0*\0date\";s:19:\"2025-03-22 21:42:54\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:46:\"Undefined array key &quot;editor_post_id&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:8;s:14:\"\0*\0times_dates\";a:8:{i:0;s:19:\"2025-03-22 21:42:54\";i:1;s:19:\"2025-05-04 00:13:11\";i:2;s:19:\"2025-05-05 23:00:55\";i:3;s:19:\"2025-05-09 18:36:37\";i:4;s:19:\"2025-05-09 19:15:14\";i:5;s:19:\"2025-05-11 22:01:42\";i:6;s:19:\"2025-06-08 18:23:15\";i:7;s:19:\"2025-08-07 23:36:23\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:36:\"Undefined array key \"editor_post_id\"\";s:4:\"file\";s:102:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/plugins/elementor/modules/ai/module.php\";s:4:\"line\";i:730;s:5:\"trace\";b:1;}}s:32:\"bb47d412777b429b9ebb9d9eadb9e67a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-25 22:36:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-25 22:36:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"85769ecc35be1f3374bc0165bcbbdbaa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-25 22:36:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-03-25 22:36:13\";i:1;s:19:\"2025-03-25 22:36:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"ccac4396f8752f545ca105ab2ae06cde\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-25 22:36:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-03-25 22:36:13\";i:1;s:19:\"2025-03-25 22:36:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"6fd1f6264f8ad904d19032f01a5cdb31\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-25 22:36:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-25 22:36:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ddff198f5f7e10198835d565cd5e869d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-25 22:36:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-25 22:36:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"016ea5926de010a066b9ca9fe7620f94\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:4:\"6762\";s:7:\"\0*\0file\";s:104:\"http://localhost/nellboulanger/wp-content/plugins/elementor/assets/js/frontend-modules.min.js?ver=3.28.1\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2025-03-25 22:56:36\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:64:\"Cannot read properties of undefined (reading &#039;params&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:6;s:14:\"\0*\0times_dates\";a:6:{i:0;s:19:\"2025-03-25 22:56:36\";i:1;s:19:\"2025-03-25 22:56:37\";i:2;s:19:\"2025-05-16 18:20:55\";i:3;s:19:\"2025-05-16 18:20:58\";i:4;s:19:\"2025-05-16 18:25:45\";i:5;s:19:\"2025-05-16 18:25:49\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1742943396\";s:7:\"message\";s:54:\"Cannot read properties of undefined (reading \'params\')\";s:3:\"url\";s:104:\"http://localhost/nellboulanger/wp-content/plugins/elementor/assets/js/frontend-modules.min.js?ver=3.28.1\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:4:\"6762\";}}s:32:\"58fb37337126433428b9342b4ff6938d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"28760\";s:7:\"\0*\0file\";s:149:\"http://localhost/nellboulanger/wp-admin/load-scripts.php?c=1&amp;loadchunk_0=wp-hooks,jquery-core,jquery-migrate,utils,moxiejs,plupload&amp;ver=6.7.2\";s:7:\"\0*\0line\";s:1:\"4\";s:7:\"\0*\0date\";s:19:\"2025-03-28 23:58:49\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:63:\"Cannot read properties of undefined (reading &#039;value&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:6;s:14:\"\0*\0times_dates\";a:6:{i:0;s:19:\"2025-03-28 23:58:49\";i:1;s:19:\"2025-05-04 00:05:23\";i:2;s:19:\"2025-05-04 00:05:35\";i:3;s:19:\"2025-05-04 00:13:45\";i:4;s:19:\"2025-05-04 00:14:22\";i:5;s:19:\"2025-05-09 18:12:03\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1743206329\";s:7:\"message\";s:53:\"Cannot read properties of undefined (reading \'value\')\";s:3:\"url\";s:149:\"http://localhost/nellboulanger/wp-admin/load-scripts.php?c=1&amp;loadchunk_0=wp-hooks,jquery-core,jquery-migrate,utils,moxiejs,plupload&amp;ver=6.7.2\";s:4:\"line\";s:1:\"4\";s:6:\"column\";s:5:\"28760\";}}s:32:\"9149354e6021d5073c54f40f13f63e0a\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:109:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/plugins/elementor/modules/gutenberg/module.php\";s:7:\"\0*\0line\";i:43;s:7:\"\0*\0date\";s:19:\"2025-05-09 15:41:25\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:42:\"Undefined property: WP_Block_Template::$ID\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-09 15:41:25\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:42:\"Undefined property: WP_Block_Template::$ID\";s:4:\"file\";s:109:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/plugins/elementor/modules/gutenberg/module.php\";s:4:\"line\";i:43;s:5:\"trace\";b:1;}}s:32:\"20176940ae701dbf14a5ea3ef67073e8\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"14799\";s:7:\"\0*\0file\";s:99:\"http://localhost/nellboulanger/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2025-05-16 20:20:27\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:58:\"Cannot read properties of null (reading &#039;clone&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:245764;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-10-04 13:58:04\";i:1;s:19:\"2025-10-04 13:58:04\";i:2;s:19:\"2025-10-04 13:58:04\";i:3;s:19:\"2025-10-04 13:58:07\";i:4;s:19:\"2025-10-04 13:58:07\";i:5;s:19:\"2025-10-04 13:58:07\";i:6;s:19:\"2025-10-04 13:58:07\";i:7;s:19:\"2025-10-04 13:58:07\";i:8;s:19:\"2025-10-04 13:58:08\";i:9;s:19:\"2025-10-04 13:58:08\";i:10;s:19:\"2025-10-04 13:58:22\";i:11;s:19:\"2025-10-04 13:58:22\";i:12;s:19:\"2025-10-04 13:58:22\";i:13;s:19:\"2025-10-04 13:58:22\";i:14;s:19:\"2025-10-04 13:58:22\";i:15;s:19:\"2025-10-04 13:58:22\";i:16;s:19:\"2025-10-04 13:58:22\";i:17;s:19:\"2025-10-04 13:58:22\";i:18;s:19:\"2025-10-04 13:58:22\";i:19;s:19:\"2025-10-04 13:58:22\";i:20;s:19:\"2025-10-04 13:58:22\";i:21;s:19:\"2025-10-04 13:58:22\";i:22;s:19:\"2025-10-04 13:58:22\";i:23;s:19:\"2025-10-04 13:58:22\";i:24;s:19:\"2025-10-04 13:58:22\";i:25;s:19:\"2025-10-04 13:58:22\";i:26;s:19:\"2025-10-04 13:58:22\";i:27;s:19:\"2025-10-04 13:58:22\";i:28;s:19:\"2025-10-04 13:58:22\";i:29;s:19:\"2025-10-04 13:58:22\";i:30;s:19:\"2025-10-04 13:58:22\";i:31;s:19:\"2025-10-04 13:58:22\";i:32;s:19:\"2025-10-04 13:58:22\";i:33;s:19:\"2025-10-04 13:58:22\";i:34;s:19:\"2025-10-04 13:58:22\";i:35;s:19:\"2025-10-04 13:58:22\";i:36;s:19:\"2025-10-04 13:58:22\";i:37;s:19:\"2025-10-04 13:58:22\";i:38;s:19:\"2025-10-04 13:58:22\";i:39;s:19:\"2025-10-04 13:58:22\";i:40;s:19:\"2025-10-04 13:58:22\";i:41;s:19:\"2025-10-04 13:58:22\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1747426827\";s:7:\"message\";s:48:\"Cannot read properties of null (reading \'clone\')\";s:3:\"url\";s:99:\"http://localhost/nellboulanger/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"14799\";}}s:32:\"0a997826a2fbc91e2cea3d61324d249d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"19552\";s:7:\"\0*\0file\";s:99:\"http://localhost/nellboulanger/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2025-05-16 20:20:28\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:63:\"Cannot read properties of null (reading &#039;changestop&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:3874;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-09-25 17:28:51\";i:1;s:19:\"2025-09-25 17:28:51\";i:2;s:19:\"2025-09-25 17:28:51\";i:3;s:19:\"2025-09-25 17:28:51\";i:4;s:19:\"2025-09-25 17:28:51\";i:5;s:19:\"2025-09-25 17:28:51\";i:6;s:19:\"2025-09-25 17:28:51\";i:7;s:19:\"2025-09-25 17:28:58\";i:8;s:19:\"2025-09-25 17:28:58\";i:9;s:19:\"2025-09-25 17:28:58\";i:10;s:19:\"2025-09-25 17:28:58\";i:11;s:19:\"2025-09-25 17:28:58\";i:12;s:19:\"2025-09-25 17:28:58\";i:13;s:19:\"2025-09-25 17:28:58\";i:14;s:19:\"2025-09-25 17:28:58\";i:15;s:19:\"2025-09-25 17:28:58\";i:16;s:19:\"2025-09-25 17:28:58\";i:17;s:19:\"2025-09-25 17:28:58\";i:18;s:19:\"2025-09-25 17:28:58\";i:19;s:19:\"2025-09-25 17:28:58\";i:20;s:19:\"2025-09-25 17:28:58\";i:21;s:19:\"2025-09-28 09:34:55\";i:22;s:19:\"2025-09-28 09:35:00\";i:23;s:19:\"2025-09-28 09:35:07\";i:24;s:19:\"2025-09-28 09:35:08\";i:25;s:19:\"2025-09-28 09:35:09\";i:26;s:19:\"2025-09-28 09:36:19\";i:27;s:19:\"2025-09-28 09:37:31\";i:28;s:19:\"2025-09-28 09:37:31\";i:29;s:19:\"2025-09-28 09:37:32\";i:30;s:19:\"2025-09-28 09:37:34\";i:31;s:19:\"2025-09-28 09:37:35\";i:32;s:19:\"2025-09-28 09:37:36\";i:33;s:19:\"2025-09-28 09:37:37\";i:34;s:19:\"2025-09-28 09:38:31\";i:35;s:19:\"2025-09-28 09:38:32\";i:36;s:19:\"2025-09-28 09:40:11\";i:37;s:19:\"2025-09-28 09:40:13\";i:38;s:19:\"2025-09-28 09:40:18\";i:39;s:19:\"2025-10-04 13:57:59\";i:40;s:19:\"2025-10-04 13:58:05\";i:41;s:19:\"2025-10-04 13:58:23\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1747426828\";s:7:\"message\";s:53:\"Cannot read properties of null (reading \'changestop\')\";s:3:\"url\";s:99:\"http://localhost/nellboulanger/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"19552\";}}s:32:\"d45737fd4aff3db0c00260efe66d57d2\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:105:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/plugins/elementor/core/logger/items/js.php\";s:7:\"\0*\0line\";i:17;s:7:\"\0*\0date\";s:19:\"2025-05-16 20:27:18\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:35:\"Undefined array key &quot;url&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:956;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-09-25 17:21:39\";i:1;s:19:\"2025-09-25 17:21:45\";i:2;s:19:\"2025-09-25 17:21:50\";i:3;s:19:\"2025-09-25 17:21:58\";i:4;s:19:\"2025-09-25 17:22:01\";i:5;s:19:\"2025-09-25 17:22:04\";i:6;s:19:\"2025-09-25 17:22:07\";i:7;s:19:\"2025-09-25 17:22:09\";i:8;s:19:\"2025-09-25 17:22:13\";i:9;s:19:\"2025-09-25 17:22:16\";i:10;s:19:\"2025-09-25 17:22:57\";i:11;s:19:\"2025-09-25 17:23:00\";i:12;s:19:\"2025-09-25 17:23:12\";i:13;s:19:\"2025-09-25 17:24:04\";i:14;s:19:\"2025-09-25 17:24:12\";i:15;s:19:\"2025-09-25 17:24:42\";i:16;s:19:\"2025-09-25 17:24:52\";i:17;s:19:\"2025-09-25 17:25:38\";i:18;s:19:\"2025-09-25 17:25:54\";i:19;s:19:\"2025-09-25 17:26:21\";i:20;s:19:\"2025-09-25 17:26:51\";i:21;s:19:\"2025-09-25 17:26:57\";i:22;s:19:\"2025-09-25 17:27:01\";i:23;s:19:\"2025-09-25 17:27:20\";i:24;s:19:\"2025-09-25 17:27:23\";i:25;s:19:\"2025-09-25 17:27:25\";i:26;s:19:\"2025-09-25 17:27:27\";i:27;s:19:\"2025-09-25 17:28:36\";i:28;s:19:\"2025-09-25 17:28:43\";i:29;s:19:\"2025-09-25 17:28:50\";i:30;s:19:\"2025-09-25 17:28:55\";i:31;s:19:\"2025-09-25 17:28:57\";i:32;s:19:\"2025-09-25 17:29:57\";i:33;s:19:\"2025-09-25 17:30:00\";i:34;s:19:\"2025-09-25 17:30:06\";i:35;s:19:\"2025-09-25 17:30:08\";i:36;s:19:\"2025-09-25 17:30:10\";i:37;s:19:\"2025-09-25 17:30:12\";i:38;s:19:\"2025-09-25 17:30:15\";i:39;s:19:\"2025-09-25 17:30:21\";i:40;s:19:\"2025-09-28 09:37:47\";i:41;s:19:\"2025-09-28 09:40:17\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:25:\"Undefined array key \"url\"\";s:4:\"file\";s:105:\"/Applications/XAMPP/xamppfiles/htdocs/nellboulanger/wp-content/plugins/elementor/core/logger/items/js.php\";s:4:\"line\";i:17;s:5:\"trace\";b:1;}}}", "off");
INSERT INTO `wp_options` VALUES("204", "_elementor_home_screen_data", "a:2:{s:7:\"timeout\";i:1741371315;s:5:\"value\";s:10294:\"{\"top_with_licences\":[{\"license\":[\"free\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Start building your website with Elementor\'s no code drag & drop editor.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},{\"license\":[\"pro\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"}],\"get_started\":[{\"license\":[\"free\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&page=popup_templates\",\"is_relative_url\":true,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\",\"title_small_color\":\"text.tertiary\"}]},{\"license\":[\"pro\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]}],\"add_ons\":{\"header\":{\"title\":\"Expand your design toolkit\",\"description\":\"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity.\"},\"repeater\":[{\"file_path\":\"site-mailer\\/site-mailer.php\",\"title\":\"Site Mailer\",\"url\":\"\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-mailer.svg\",\"type\":\"wporg\"},{\"file_path\":\"image-optimization\\/image-optimization.php\",\"title\":\"Image Optimizer\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/\",\"description\":\"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg\",\"type\":\"wporg\"},{\"title\":\"Elementor AI\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/\",\"description\":\"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.\",\"button_label\":\"Let\'s go\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg\",\"type\":\"link\",\"condition\":{\"key\":\"introduction_meta\",\"value\":\"ai_get_started\"}}],\"footer\":{\"label\":\"Explore more add-ons\",\"file_path\":\"wp-admin\\/admin.php?page=elementor-apps\"}},\"sidebar_upgrade\":[{\"license\":[\"free\"],\"show\":\"true\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]},{\"license\":[\"pro\"],\"show\":\"false\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}],\"sidebar_promotion_variants\":[{\"license\":[\"essential\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/essential-upgrade.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-advanced-home-sidebar-upgrade\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}},{\"license\":[\"pro\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}}],\"external_links\":[{\"label\":\"Help Center\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg\",\"url\":\"https:\\/\\/elementor.com\\/help\\/\"},{\"label\":\"Youtube\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg\",\"url\":\"https:\\/\\/www.youtube.com\\/@Elementor\"},{\"label\":\"Facebook Community\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg\",\"url\":\"https:\\/\\/www.facebook.com\\/groups\\/Elementors\"},{\"label\":\"Blog\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg\",\"url\":\"https:\\/\\/elementor.com\\/blog\\/\"}]}\";}", "off");
INSERT INTO `wp_options` VALUES("219", "https_detection_errors", "a:1:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:24:\"SSL verification failed.\";}}", "auto");
INSERT INTO `wp_options` VALUES("220", "_transient_health-check-site-status-result", "{\"good\":12,\"recommended\":8,\"critical\":3}", "on");
INSERT INTO `wp_options` VALUES("241", "WPLANG", "fr_FR", "auto");
INSERT INTO `wp_options` VALUES("242", "new_admin_email", "nellboulanger07@gmail.com", "auto");
INSERT INTO `wp_options` VALUES("266", "theme_mods_variations", "a:9:{i:0;b:0;s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:13:\"ogf_body_font\";s:7:\"default\";s:17:\"ogf_headings_font\";s:7:\"sniglet\";s:15:\"ogf_inputs_font\";s:6:\"lexend\";s:26:\"ogf_post_page_content_font\";s:8:\"hubballi\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1743027642;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("398", "action_scheduler_hybrid_store_demarkation", "146", "auto");
INSERT INTO `wp_options` VALUES("399", "schema-ActionScheduler_StoreSchema", "7.0.1742942131", "auto");
INSERT INTO `wp_options` VALUES("400", "schema-ActionScheduler_LoggerSchema", "3.0.1742942131", "auto");
INSERT INTO `wp_options` VALUES("404", "image_optimizer_migrations", "a:3:{s:8:\"last_run\";N;s:19:\"last_wp_version_run\";N;s:17:\"migrations_passed\";a:3:{i:0;s:23:\"fix_optimized_size_keys\";i:1;s:13:\"fix_mime_type\";i:2;s:29:\"fix_avif_with_zero_dimensions\";}}", "off");
INSERT INTO `wp_options` VALUES("405", "image_optimizer_compression_level", "lossy", "auto");
INSERT INTO `wp_options` VALUES("406", "image_optimizer_optimize_on_upload", "1", "auto");
INSERT INTO `wp_options` VALUES("407", "image_optimizer_resize_larger_images", "1", "auto");
INSERT INTO `wp_options` VALUES("408", "image_optimizer_resize_larger_images_size", "1920", "auto");
INSERT INTO `wp_options` VALUES("409", "image_optimizer_exif_metadata", "1", "auto");
INSERT INTO `wp_options` VALUES("410", "image_optimizer_original_images", "1", "auto");
INSERT INTO `wp_options` VALUES("411", "image_optimizer_convert_to_format", "webp", "auto");
INSERT INTO `wp_options` VALUES("412", "image_optimizer_custom_sizes", "all", "auto");
INSERT INTO `wp_options` VALUES("415", "action_scheduler_lock_async-request-runner", "692200d8d49767.57287979|1763836180", "no");
INSERT INTO `wp_options` VALUES("423", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wp_options` VALUES("453", "_elementor_local_google_fonts", "a:2:{s:6:\"roboto\";a:2:{s:3:\"url\";s:87:\"http://localhost/nellboulanger/wp-content/uploads/elementor/google-fonts/css/roboto.css\";s:7:\"version\";i:1742942191;}s:10:\"robotoslab\";a:2:{s:3:\"url\";s:91:\"http://localhost/nellboulanger/wp-content/uploads/elementor/google-fonts/css/robotoslab.css\";s:7:\"version\";i:1742942198;}}", "auto");
INSERT INTO `wp_options` VALUES("456", "action_scheduler_migration_status", "complete", "auto");
INSERT INTO `wp_options` VALUES("457", "as_has_wp_comment_logs", "no", "on");
INSERT INTO `wp_options` VALUES("614", "elementor_controls_usage", "a:2:{s:7:\"wp-post\";a:10:{s:11:\"text-editor\";a:2:{s:5:\"count\";i:192;s:8:\"controls\";a:3:{s:7:\"content\";a:2:{s:14:\"section_editor\";a:2:{s:6:\"editor\";i:191;s:10:\"column_gap\";i:10;}s:19:\"_section_background\";a:0:{}}s:5:\"style\";a:1:{s:13:\"section_style\";a:7:{s:17:\"paragraph_spacing\";i:14;s:5:\"align\";i:11;s:10:\"text_color\";i:163;s:21:\"typography_typography\";i:4;s:22:\"typography_font_family\";i:4;s:20:\"typography_font_size\";i:4;s:22:\"typography_font_weight\";i:4;}}s:8:\"advanced\";a:2:{s:14:\"_section_style\";a:2:{s:7:\"_margin\";i:10;s:16:\"_flex_align_self\";i:10;}s:19:\"_section_background\";a:9:{s:22:\"_background_background\";i:10;s:19:\"_background_color_b\";i:10;s:17:\"_background_image\";i:10;s:20:\"_background_position\";i:10;s:22:\"_background_attachment\";i:10;s:16:\"_background_size\";i:10;s:28:\"_background_hover_background\";i:10;s:28:\"_background_hover_color_stop\";i:10;s:25:\"_background_hover_color_b\";i:10;}}}}s:9:\"container\";a:2:{s:5:\"count\";i:39;s:8:\"controls\";a:3:{s:6:\"layout\";a:1:{s:24:\"section_layout_container\";a:2:{s:13:\"content_width\";i:3;s:5:\"width\";i:3;}}s:8:\"advanced\";a:1:{s:14:\"section_layout\";a:1:{s:10:\"_flex_size\";i:3;}}s:7:\"content\";a:1:{s:24:\"section_layout_container\";a:0:{}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:69;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:5:\"title\";i:69;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:6:{s:11:\"title_color\";i:69;s:21:\"typography_typography\";i:13;s:22:\"typography_font_family\";i:13;s:20:\"typography_font_size\";i:9;s:22:\"typography_font_weight\";i:13;s:28:\"text_stroke_text_stroke_type\";i:1;}}}}s:13:\"image-gallery\";a:2:{s:5:\"count\";i:29;s:8:\"controls\";a:3:{s:7:\"content\";a:2:{s:15:\"section_gallery\";a:3:{s:10:\"wp_gallery\";i:28;s:14:\"thumbnail_size\";i:28;s:15:\"gallery_columns\";i:21;}s:14:\"_section_style\";a:0:{}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:6:{s:7:\"_margin\";i:3;s:8:\"_padding\";i:2;s:14:\"_element_width\";i:1;s:21:\"_element_custom_width\";i:1;s:11:\"_flex_order\";i:1;s:10:\"_flex_size\";i:1;}}s:5:\"style\";a:1:{s:22:\"section_gallery_images\";a:1:{s:19:\"image_border_radius\";i:2;}}}}s:14:\"image-carousel\";a:2:{s:5:\"count\";i:74;s:8:\"controls\";a:3:{s:7:\"content\";a:3:{s:22:\"section_image_carousel\";a:5:{s:8:\"carousel\";i:74;s:14:\"thumbnail_size\";i:74;s:14:\"slides_to_show\";i:10;s:16:\"slides_to_scroll\";i:3;s:13:\"image_stretch\";i:15;}s:24:\"section_style_navigation\";a:0:{}s:14:\"_section_style\";a:0:{}}s:5:\"style\";a:1:{s:24:\"section_style_navigation\";a:4:{s:11:\"arrows_size\";i:10;s:13:\"dots_position\";i:3;s:8:\"dots_gap\";i:7;s:9:\"dots_size\";i:9;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:5:{s:7:\"_margin\";i:3;s:8:\"_padding\";i:5;s:14:\"_element_width\";i:2;s:10:\"_flex_size\";i:4;s:11:\"_flex_order\";i:2;}}}}s:7:\"divider\";a:2:{s:5:\"count\";i:7;s:8:\"controls\";a:0:{}}s:12:\"social-icons\";a:2:{s:5:\"count\";i:11;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:19:\"section_social_icon\";a:1:{s:16:\"social_icon_list\";i:11;}}s:5:\"style\";a:1:{s:20:\"section_social_style\";a:2:{s:9:\"icon_size\";i:6;s:12:\"icon_padding\";i:6;}}}}s:5:\"image\";a:2:{s:5:\"count\";i:20;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:4:{s:5:\"image\";i:20;s:10:\"image_size\";i:13;s:14:\"caption_source\";i:1;s:7:\"caption\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:4:{s:5:\"width\";i:6;s:5:\"space\";i:7;s:6:\"height\";i:5;s:7:\"opacity\";i:1;}}}}s:11:\"google_maps\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:11:\"section_map\";a:3:{s:7:\"address\";i:5;s:4:\"zoom\";i:4;s:6:\"height\";i:4;}}}}s:6:\"spacer\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:0:{}}}s:4:\"page\";a:8:{s:11:\"text-editor\";a:2:{s:5:\"count\";i:14;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:2:{s:6:\"editor\";i:14;s:10:\"column_gap\";i:1;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:3:{s:17:\"paragraph_spacing\";i:1;s:5:\"align\";i:1;s:10:\"text_color\";i:2;}}s:8:\"advanced\";a:2:{s:14:\"_section_style\";a:2:{s:7:\"_margin\";i:1;s:16:\"_flex_align_self\";i:1;}s:19:\"_section_background\";a:9:{s:22:\"_background_background\";i:1;s:19:\"_background_color_b\";i:1;s:17:\"_background_image\";i:1;s:20:\"_background_position\";i:1;s:22:\"_background_attachment\";i:1;s:16:\"_background_size\";i:1;s:28:\"_background_hover_background\";i:1;s:28:\"_background_hover_color